#include "BL210x_wdt.h"
#ifdef IC_BL2102
#include "BL2102.h"
#else
#include "BL2101.h"
#endif

#ifdef IC_BL2102
/****************************************************************************************************************************************** 
* :	IWDT_Init()
* ˵:	IWDTŹʼ
*     : IWDT_InitTypeDef * IWDT_InitStruct
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void IWDT_Init(IWDT_InitTypeDef * IWDT_InitStruct)
{
//	assert_param(IS_IWDT_RST(IWDT_InitStruct->RstEn));                 //ĲRstEnǷϷ      
//	
//	assert_param(IS_IWDT_LOAD(IWDT_InitStruct->Load));                 //ĲLoadǷϷ   
	
	SYS->CLKEN |= 0x01 << SYS_CLKEN_IWDT_POS;                           //IWDTʱʹ
	
	IWDT_Stop();                                                       //رIWDT
	
	IWDT->CTRL &= ~(0x01 << IWDT_CTRL_RSTEN_POS);
	IWDT->CTRL |= (IWDT_InitStruct->RstEn << IWDT_CTRL_RSTEN_POS);     //ʹܸλѡ
	
	IWDT->LOAD = IWDT_InitStruct->Load;                                //IWDTʼֵ

	NVIC_EnableIRQ(IWDT_IRQn);                                         //IWDTж
}


/****************************************************************************************************************************************** 
* :	IWDT_Start()
* ˵:	ָIWDTʼʱ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void IWDT_Start(void)
{
	IWDT->CTRL |= (0x01 << IWDT_CTRL_EN_POS);
}

/****************************************************************************************************************************************** 
* :	IWDT_Stop()
* ˵:	رָIWDTֹͣʱ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void IWDT_Stop(void)
{
	IWDT->CTRL &= ~(0x01 << IWDT_CTRL_EN_POS);
}


/****************************************************************************************************************************************** 
* :	IWDT_FEED()
* ˵:	ι
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void IWDT_FEED(void)
{
	IWDT->FEED = 0x55;
}


/****************************************************************************************************************************************** 
* :	IWDT_INTStat()
* ˵:	ж״̬ѯ
*     : 
*     : uint8_t		1 ж    0 δж
* ע: 
******************************************************************************************************************************************/
uint8_t IWDT_INTStat(void)
{
	return IWDT->IF;
}


/****************************************************************************************************************************************** 
* :	IWDT_INTClr()
* ˵:	жϱ־
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void IWDT_INTClr(void)
{
	IWDT->IF = 0;
}

#else
/****************************************************************************************************************************************** 
* :	WDT_Init()
* ˵:	WDTŹʼ
*     : WDT_InitTypeDef * WDT_InitStruct
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void WDT_Init(WDT_InitTypeDef * WDT_InitStruct)
{
	SYS->CLKSEL &= ~(0x01 << SYS_CLKSEL_WDT_POS);
	SYS->CLKSEL |= (WDT_InitStruct->ClkSel << SYS_CLKSEL_WDT_POS);   //ʱѡ
	
	SYS->CLKEN |= 0x01 << SYS_CLKEN_WDT_POS;                         //WDTʱʹ
	
	WDT_Stop();                                                      //رWDT
	
	WDT->CTRL &= ~(0x01 << WDT_CTRL_RSTEN_POS);
	WDT->CTRL |= (WDT_InitStruct->RstEn << WDT_CTRL_RSTEN_POS);     //ʹܸλѡ
	
	WDT->LOAD = WDT_InitStruct->Load;                               //WDTʼֵ

	NVIC_EnableIRQ(WDT_IRQn);                                       //WDTж
}


/****************************************************************************************************************************************** 
* :	WDT_Start()
* ˵:	ָWDTʼʱ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void WDT_Start(void)
{
	WDT->CTRL |= (0x01 << WDT_CTRL_EN_POS);
}

/****************************************************************************************************************************************** 
* :	WDT_Stop()
* ˵:	رָWDTֹͣʱ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void WDT_Stop(void)
{
	WDT->CTRL &= ~(0x01 << WDT_CTRL_EN_POS);
}


/****************************************************************************************************************************************** 
* :	WDT_FEED()
* ˵:	ι
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void WDT_FEED(void)
{
	WDT->FEED = 0x55;
}



/****************************************************************************************************************************************** 
* :	WDT_INTStat()
* ˵:	ж״̬ѯ
*     : 
*     : uint8_t		1 ж    0 δж
* ע: 
******************************************************************************************************************************************/
uint8_t WDT_INTStat(void)
{
	return WDT->IF;
}


/****************************************************************************************************************************************** 
* :	WDT_INTClr()
* ˵:	жϱ־
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void WDT_INTClr(void)
{
	WDT->IF = 0;
}

#endif
