/************************************************************************************************/
/**
* @file               ciu32f003_std_crc.h
* @author             MCU Ecosystem Development Team
* @brief              CRC STDͷļ
*                     ṩCRCصSTDԼĶ塣                         
*                     
*
**************************************************************************************************
* @attention
* Copyright (c) CEC Huada Electronic Design Co.,Ltd. All rights reserved.
*
**************************************************************************************************
*/

/* ͷļظ */
#ifndef CIU32F003_STD_CRC_H
#define CIU32F003_STD_CRC_H

/************************************************************************************************/
/** 
* @addtogroup CIU32F003_STD_Driver
* @{
*/

/**
* @defgroup CRC CRC
* @brief ѭУSTD
* @{
*/
/************************************************************************************************/


#ifdef __cplusplus
 extern "C" {
#endif

/*------------------------------------------includes--------------------------------------------*/
#include "ciu32F003_std_common.h"


/*--------------------------------------------define--------------------------------------------*/

/************************************************************************************************/
/**
* @defgroup CRC_Constants CRC Constants 
* @brief    CRC弰궨
* @{
*
*/
/************************************************************************************************/
/* CRCʽѡ */
#define CRC_POLY_16                           CRC_CSR_POLY_SIZE_16     /**< 16λʽ       */
#define CRC_POLY_32                           CRC_CSR_POLY_SIZE_32     /**< 32λʽ       */

/* CRCĬϳʼֵ */
#define CRC_DEFAULT_INIT_VALUE                (0xFFFFFFFFU)            /**< CRCĬϳʼֵ    */

/** 
* @} 
*/

/*-------------------------------------------functions------------------------------------------*/

/************************************************************************************************/
/**
* @defgroup CRC_External_Functions CRC External Functions
* @brief    CRC⺯
* @{
*
*/
/************************************************************************************************/
/** 
* @brief  CRCʽ
* @param  poly_size ʽѡ
*             @arg CRC_POLY_1616λʽ
*             @arg CRC_POLY_3232λʽ
* @retval 
*/
__STATIC_INLINE void std_crc_set_poly_size(uint32_t poly_size)
{
    CRC->CSR = poly_size;
}

/**
* @brief  CRCʼֵδзתֱдĴ
* @param  init_value CRCĳʼֵ
* @retval 
*/
__STATIC_INLINE void std_crc_set_init_value(uint32_t init_value)
{
    CRC->RDR = init_value;
}

/**
* @brief  ȡCRC
* @retval uint32_t CRC
*/
__STATIC_INLINE uint32_t std_crc_get_value(void)
{
    return(CRC->RDR);
}

/**
* @brief  ݼĴд1ֽ
* @param  input_data ҪCRCԭʼ
* @retval 
*/
__STATIC_INLINE void std_crc_set_byte(uint8_t input_data)
{
    CRC->DR = (uint32_t)input_data;
}


void std_crc_deinit(void);
void std_crc_set_init_value_invert(uint32_t poly_sel, uint32_t init_value);

/** 
* @} 
*/

#ifdef __cplusplus
}
#endif

/**
* @}
*/  

/**
* @}
*/

#endif /* CIU32F003_STD_CRC_H */
