/************************************************************************************************/
/**
* @file               ciu32f003_std_lptim.h
* @author             MCU Ecosystem Development Team
* @brief              LPTIM STDͷļ
*                     ṩLPTIMصSTDԼĶ塣
*
*
**************************************************************************************************
* @attention
* Copyright (c) CEC Huada Electronic Design Co.,Ltd. All rights reserved.
*
**************************************************************************************************
*/

/*ͷļظ*/
#ifndef CIU32F003_STD_LPTIM_H
#define CIU32F003_STD_LPTIM_H

/************************************************************************************************/
/** 
* @addtogroup CIU32F003_STD_Driver
* @{
*/

/**
* @defgroup LPTIM LPTIM
* @brief ͹ĶʱSTD
* @{
*/
/************************************************************************************************/



#ifdef __cplusplus
 extern "C" {
#endif
     
/*------------------------------------------includes--------------------------------------------*/
#include "ciu32f003_std_common.h"

/*--------------------------------------------define--------------------------------------------*/

/************************************************************************************************/
/**
* @defgroup LPTIM_Constants LPTIM Constants
* @brief    LPTIM弰궨
* @{
*
*/
/************************************************************************************************/
/* ģʽ */
#define LPTIM_COUNT_CONTINUOUS          LPTIM_CR_CNTSTRT            /**< ģʽ    */
#define LPTIM_COUNT_SINGLE              LPTIM_CR_SNGSTRT            /**< μģʽ    */

/* LPTIM PSCԤƵƵϵѡ */
#define LPTIM_PRESCALER_DIV1            LPTIM_CFG_PRESC_1           /**< PSCԤƵ1Ƶ   */
#define LPTIM_PRESCALER_DIV2            LPTIM_CFG_PRESC_2           /**< PSCԤƵ2Ƶ   */
#define LPTIM_PRESCALER_DIV4            LPTIM_CFG_PRESC_4           /**< PSCԤƵ4Ƶ   */
#define LPTIM_PRESCALER_DIV8            LPTIM_CFG_PRESC_8           /**< PSCԤƵ8Ƶ   */
#define LPTIM_PRESCALER_DIV16           LPTIM_CFG_PRESC_16          /**< PSCԤƵ16Ƶ  */
#define LPTIM_PRESCALER_DIV32           LPTIM_CFG_PRESC_32          /**< PSCԤƵ32Ƶ  */
#define LPTIM_PRESCALER_DIV64           LPTIM_CFG_PRESC_64          /**< PSCԤƵ64Ƶ  */
#define LPTIM_PRESCALER_DIV128          LPTIM_CFG_PRESC_128         /**< PSCԤƵ128Ƶ */

/* LPTIMжԴ */
#define LPTIM_INTERRUPT_ARRM            LPTIM_IER_ARRM_IE           /**< Զƥжʹ */
#define LPTIM_INTERRUPT_ITRF            LPTIM_IER_ITRF_IE           /**< жʹ     */

/* LPTIMж״̬־ */
#define LPTIM_FLAG_ARRM                 LPTIM_ISR_ARRM              /**< Զƥ־     */
#define LPTIM_FLAG_ITRF                 LPTIM_ISR_ITRF              /**< ־         */

/* LPTIMж־ */
#define LPTIM_CLEAR_ARRM                LPTIM_ICR_ARRM_CF           /**< Զƥ־ */
#define LPTIM_CLEAR_ITRF                LPTIM_ICR_ITRF_CF           /**< ־     */

/** 
* @} 
*/

/*-------------------------------------------functions------------------------------------------*/
/************************************************************************************************/
/**
* @defgroup LPTIM_External_Functions LPTIM External Functions
* @brief    LPTIM⺯
* @{
*
*/
/************************************************************************************************/


/** 
* @brief  ʹLPTIM
* @note   LPTIMʹλλҪںЧ
* @retval 
*/
__STATIC_INLINE void std_lptim_enable(void)
{
    LPTIM1->CR |= LPTIM_CR_ENABLE;
}


/** 
* @brief  ֹLPTIM
* @retval 
*/
__STATIC_INLINE void std_lptim_disable(void)
{
    LPTIM1->CR &= (~LPTIM_CR_ENABLE);
}


/** 
* @brief  LPTIMԤģʽʼ
* @param  operate_mode ģʽѡ
*             @arg LPTIM_COUNT_CONTINUOUS:    ģʽ
*             @arg LPTIM_COUNT_SINGLE:        μģʽ
* @note   ʹLPTIM
* @retval 
*/
__STATIC_INLINE void std_lptim_start_counter(uint32_t operate_mode)
{
    MODIFY_REG(LPTIM1->CR, (LPTIM_CR_CNTSTRT | LPTIM_CR_SNGSTRT), operate_mode);
}


/** 
* @brief  LPTIMԶװֵ
* @param  auto_reload ԶװֵñķΧΪ0x0~0xFFFF
* @retval 
*/
__STATIC_INLINE void std_lptim_set_auto_reload(uint32_t auto_reload)
{
    LPTIM1->ARR = auto_reload;
}


/** 
* @brief  ȡLPTIMԶװֵ
* @retval uint32_t ԶװֵñķΧΪ0x0~0xFFFF
*/
__STATIC_INLINE uint32_t std_lptim_get_auto_reload(void)
{
    return (LPTIM1->ARR);
}


/** 
* @brief  ȡLPTIMֵ
* @note   LPTIMΪ첽ʱӼʱΪȷȡȷļֵҪȷζȡļֵһ¡
* @retval uint32_t LPTIMֵñķΧΪ0x0~0xFFFF
*/
__STATIC_INLINE uint32_t std_lptim_get_count(void)
{
    return (LPTIM1->CNT);
}


/** 
* @brief  LPTIMԤƵƵϵ
* @param  prescaler ԤƵϵѡ
*             @arg LPTIM_PRESCALER_DIV1
*             @arg LPTIM_PRESCALER_DIV2
*             @arg LPTIM_PRESCALER_DIV4
*             @arg ...
*             @arg LPTIM_PRESCALER_DIV128
* @retval 
*/
__STATIC_INLINE void std_lptim_set_prescaler(uint32_t prescaler)
{
    MODIFY_REG(LPTIM1->CFG, LPTIM_CFG_PRESC, prescaler);
}


/** 
* @brief  ȡLPTIMԤƵƵϵ
* @retval uint32_t ԤƵϵѡ
*             @arg LPTIM_PRESCALER_DIV1
*             @arg LPTIM_PRESCALER_DIV2
*             @arg LPTIM_PRESCALER_DIV4
*             @arg ...
*             @arg LPTIM_PRESCALER_DIV128
*/
__STATIC_INLINE uint32_t std_lptim_get_prescaler(void)
{
    return (LPTIM1->CFG & LPTIM_CFG_PRESC);
}


/** 
* @brief  ʹLPTIM
* @retval 
*/
__STATIC_INLINE void std_lptim_internal_trigger_enable(void)
{
    LPTIM1->CFG |= LPTIM_CFG_ITREN;
}


/** 
* @brief  ֹLPTIM
* @retval 
*/
__STATIC_INLINE void std_lptim_internal_trigger_disable(void)
{
    LPTIM1->CFG &= ~LPTIM_CFG_ITREN;
}


/** 
* @brief  ʹLPTIMж
* @param  interrupt LPTIMжԴ
*             @arg LPTIM_INTERRUPT_ARRM:      Զƥж
*             @arg LPTIM_INTERRUPT_ITRF:      жʹ
* @retval 
*/
__STATIC_INLINE void std_lptim_interrupt_enable(uint32_t interrupt)
{
    LPTIM1->IER |= interrupt;
}


/** 
* @brief  ֹLPTIMж
* @param  interrupt LPTIMжԴ
*             @arg LPTIM_INTERRUPT_ARRM:      Զƥж
*             @arg LPTIM_INTERRUPT_ITRF:      жʹ
* @retval 
*/
__STATIC_INLINE void std_lptim_interrupt_disable(uint32_t interrupt)
{
    LPTIM1->IER &= (~interrupt);
}


/** 
* @brief  ȡLPTIMж״̬
* @param  interrupt LPTIMжԴ
*             @arg LPTIM_INTERRUPT_ARRM:      Զƥж
*             @arg LPTIM_INTERRUPT_ITRF:      жʹ
* @retval uint32_t LPTIMжԴʹ״̬
*             @arg 0: ʹ
*             @arg 0:   ֹ
*/
__STATIC_INLINE uint32_t std_lptim_get_interrupt_status(uint32_t interrupt)
{
    return (LPTIM1->IER & interrupt);
}


/** 
* @brief  ȡLPTIM״̬־λ
* @param  flag LPTIM״̬־λ
*             @arg LPTIM_FLAG_ARRM:        Զƥ־
*             @arg LPTIM_FLAG_ITRF:        ־
* @retval uint32_t LPTIM־λ״̬
*             @arg 0: ־λλ
*             @arg 0:   ־λ
*/
__STATIC_INLINE uint32_t std_lptim_get_flag(uint32_t flag)
{
    return (LPTIM1->ISR & flag);
}


/** 
* @brief  LPTIM״̬־λ
* @param  flag LPTIM״̬־λ
*             @arg LPTIM_CLEAR_ARRM:        Զƥ־
*             @arg LPTIM_CLEAR_ITRF:        ־
* @retval 
*/
__STATIC_INLINE void std_lptim_clear_flag(uint32_t flag)
{
    LPTIM1->ICR = flag;
}


/* LPTIMȥʼ */
void std_lptim_deinit(void);

/** 
* @} 
*/



#ifdef __cplusplus
}
#endif

/** 
* @}
*/

/** 
* @}
*/
     
#endif /* CIU32F003_STD_LPTIM_H */
