/************************************************************************************************/
/**
* @file               ciu32f003_std_rcc.h
* @author             MCU Ecosystem Development Team
* @brief              RCC STDͷļ
*                     ṩRCCصSTDԼĶ塣                         
*                     
*
**************************************************************************************************
* @attention
* Copyright (c) CEC Huada Electronic Design Co.,Ltd. All rights reserved.
*
**************************************************************************************************
*/

/*ͷļظ*/
#ifndef CIU32F003_STD_RCC_H
#define CIU32F003_STD_RCC_H

/************************************************************************************************/
/** 
* @addtogroup CIU32F003_STD_Driver
* @{
*/

/**
* @defgroup RCC RCC
* @brief λʱӿSTD
* @{
*/
/************************************************************************************************/


#ifdef __cplusplus
 extern "C" {
#endif

/*------------------------------------------includes--------------------------------------------*/
#include "ciu32f003_std_common.h"


/*--------------------------------------------define--------------------------------------------*/

/************************************************************************************************/
/**
* @defgroup RCC_Constants RCC Constants 
* @brief  RCC弰궨
* @{
*
*/
/************************************************************************************************/
/* ϵͳʱԴѡ */
#define RCC_SYSCLK_SRC_RCHDIV6         RCC_CFG_SYSW_RCHDIV6                         /**< ѡRCHDIV6ΪϵͳʱԴ   */
#define RCC_SYSCLK_SRC_RCHDIV3         RCC_CFG_SYSW_RCHDIV3                         /**< ѡRCHDIV3ΪϵͳʱԴ   */
#define RCC_SYSCLK_SRC_RCH             RCC_CFG_SYSW_RCH                             /**< ѡRCHΪϵͳʱԴ       */
#define RCC_SYSCLK_SRC_RCL             RCC_CFG_SYSW_RCL                             /**< ѡRCLΪϵͳʱԴ       */
#define RCC_SYSCLK_SRC_EXTCLK          RCC_CFG_SYSW_EXTCLK                          /**< ѡEXTCLKΪϵͳʱԴ    */

/* ϵͳʱԴ״̬ */
#define RCC_SYSCLK_SRC_STATUS_RCHDIV6      RCC_CFG_SYSWS_RCHDIV6                    /**< ϵͳʱΪRCHDIV6  */
#define RCC_SYSCLK_SRC_STATUS_RCHDIV3      RCC_CFG_SYSWS_RCHDIV3                    /**< ϵͳʱΪRCHDIV3  */
#define RCC_SYSCLK_SRC_STATUS_RCH          RCC_CFG_SYSWS_RCH                        /**< ϵͳʱΪRCH      */
#define RCC_SYSCLK_SRC_STATUS_RCL          RCC_CFG_SYSWS_RCL                        /**< ϵͳʱΪRCL      */
#define RCC_SYSCLK_SRC_STATUS_EXTCLK       RCC_CFG_SYSWS_EXTCLK                     /**< ϵͳʱΪEXTCLK   */

/* AHBʱӷƵ */
#define RCC_HCLK_DIV1                      RCC_CFG_HPRE_1                           /**< HCLKƵ         */
#define RCC_HCLK_DIV2                      RCC_CFG_HPRE_2                           /**< HCLKƵ = 2   */
#define RCC_HCLK_DIV4                      RCC_CFG_HPRE_4                           /**< HCLKƵ = 4   */
#define RCC_HCLK_DIV8                      RCC_CFG_HPRE_8                           /**< HCLKƵ = 8   */
#define RCC_HCLK_DIV16                     RCC_CFG_HPRE_16                          /**< HCLKƵ = 16  */
#define RCC_HCLK_DIV32                     RCC_CFG_HPRE_32                          /**< HCLKƵ = 32  */
#define RCC_HCLK_DIV64                     RCC_CFG_HPRE_64                          /**< HCLKƵ = 64  */
#define RCC_HCLK_DIV128                    RCC_CFG_HPRE_128                         /**< HCLKƵ = 128 */

/* APBʱӷƵ */
#define RCC_PCLK_DIV1                      RCC_CFG_PPRE_1                           /**< APBʱӲƵ        */
#define RCC_PCLK_DIV2                      RCC_CFG_PPRE_2                           /**< APBʱӷƵ = 2  */
#define RCC_PCLK_DIV4                      RCC_CFG_PPRE_4                           /**< APBʱӷƵ = 4  */
#define RCC_PCLK_DIV8                      RCC_CFG_PPRE_8                           /**< APBʱӷƵ = 8  */
#define RCC_PCLK_DIV16                     RCC_CFG_PPRE_16                          /**< APBʱӷƵ = 16 */
        
/* MCOʱԴ */                                                                            
#define RCC_MCO_SRC_DISABLE                RCC_CFG_MCOSEL_DISABLE                   /**< MCOЧ         */
#define RCC_MCO_SRC_SYSCLK                 RCC_CFG_MCOSEL_SYSCLK                    /**< MCOѡSYSCLK   */
#define RCC_MCO_SRC_RCHDIV6                RCC_CFG_MCOSEL_RCHDIV6                   /**< MCOѡRCHDIV6  */
#define RCC_MCO_SRC_EXTCLK                 RCC_CFG_MCOSEL_EXTCLK                    /**< MCOѡEXTCLK   */
#define RCC_MCO_SRC_RCL                    RCC_CFG_MCOSEL_RCL                       /**< MCOѡRCL      */

/* MCOʱӷƵ */
#define RCC_MCO_DIV1                       RCC_CFG_MCOPRE_DIV1                      /**< MCOƵ         */
#define RCC_MCO_DIV2                       RCC_CFG_MCOPRE_DIV2                      /**< MCOƵ = 2   */
#define RCC_MCO_DIV4                       RCC_CFG_MCOPRE_DIV4                      /**< MCOƵ = 4   */
#define RCC_MCO_DIV8                       RCC_CFG_MCOPRE_DIV8                      /**< MCOƵ = 8   */
#define RCC_MCO_DIV16                      RCC_CFG_MCOPRE_DIV16                     /**< MCOƵ = 16  */
#define RCC_MCO_DIV32                      RCC_CFG_MCOPRE_DIV32                     /**< MCOƵ = 32  */
#define RCC_MCO_DIV64                      RCC_CFG_MCOPRE_DIV64                     /**< MCOƵ = 64  */
#define RCC_MCO_DIV128                     RCC_CFG_MCOPRE_DIV128                    /**< MCOƵ = 128 */

/* RCCжϿλ */
#define RCC_INTERRUPT_RCL_READY            RCC_IER_RCL_RDYIE                        /**< RCL ReadyжϿλ   */
#define RCC_INTERRUPT_RCH_READY            RCC_IER_RCH_RDYIE                        /**< RCH ReadyжϿλ   */

/* RCCжϱ־λ */
#define RCC_FLAG_RCL_READY                 RCC_ISR_RCL_RDYF                         /**< RCL Readyжϱ־λ   */
#define RCC_FLAG_RCH_READY                 RCC_ISR_RCH_RDYF                         /**< RCH Readyжϱ־λ   */

/* RCCλ */
#define RCC_CLEAR_RCL_READY                RCC_ICR_RCL_RDYC                         /**< RCL Readyλ   */
#define RCC_CLEAR_RCH_READY                RCC_ICR_RCH_RDYC                         /**< RCH Readyλ   */

/* IO˿ʱѡ */
#define RCC_PERIPH_CLK_GPIOA              RCC_IOPEN_GPIOAEN                        /**< GPIOA ʱӿλ  */
#define RCC_PERIPH_CLK_GPIOB              RCC_IOPEN_GPIOBEN                        /**< GPIOB ʱӿλ  */
#define RCC_PERIPH_CLK_GPIOC              RCC_IOPEN_GPIOCEN                        /**< GPIOC ʱӿλ  */

/* IO˿ڸλѡ */
#define RCC_PERIPH_RESET_GPIOA            RCC_IOPRST_GPIOA_RST                            /**< GPIOA˿ڸλλ  */
#define RCC_PERIPH_RESET_GPIOB            RCC_IOPRST_GPIOB_RST                            /**< GPIOB˿ڸλλ  */
#define RCC_PERIPH_RESET_GPIOC            RCC_IOPRST_GPIOC_RST                            /**< GPIOC˿ڸλλ  */

/* AHBʱѡ */
#define RCC_PERIPH_CLK_CRC                RCC_AHBEN_CRCEN                                 /**< AHBCRCʱӿλ  */

/* AHB踴λѡ */
#define RCC_PERIPH_RESET_CRC              RCC_AHBRST_CRC_RST                              /**< AHBCRCλλ  */

/* APBʱѡ */
#define RCC_PERIPH_CLK_TIM3               RCC_APBEN1_TIM3EN                               /**< APBTIM3ʱӿλ    */
#define RCC_PERIPH_CLK_UART2              RCC_APBEN1_UART2EN                              /**< APBUART2ʱӿλ   */
#define RCC_PERIPH_CLK_I2C1               RCC_APBEN1_I2C1EN                               /**< APBI2C1ʱӿλ    */
#define RCC_PERIPH_CLK_PMU                RCC_APBEN1_PMUEN                                /**< APBPMUʱӿλ     */
#define RCC_PERIPH_CLK_LPTIM1             RCC_APBEN1_LPTIM1EN                             /**< APBLPTIM1ʱӿλ  */

#define RCC_PERIPH_CLK_COMP               RCC_APBEN2_COMPEN                               /**< APBCOMPʱӿλ    */
#define RCC_PERIPH_CLK_TIM1               RCC_APBEN2_TIM1EN                               /**< APBTIM1ʱӿλ    */
#define RCC_PERIPH_CLK_SPI1               RCC_APBEN2_SPI1EN                               /**< APBSPI1ʱӿλ    */
#define RCC_PERIPH_CLK_UART1              RCC_APBEN2_UART1EN                              /**< APBUART1ʱӿλ   */
#define RCC_PERIPH_CLK_ADC                RCC_APBEN2_ADCEN                                /**< APBADCʱӿλ     */
#define RCC_PERIPH_CLK_DBG                RCC_APBEN2_DBGEN                                /**< APBDBGʱӿλ     */

/* APB踴λѡ */
#define RCC_PERIPH_RESET_TIM3             RCC_APBRST1_TIM3_RST                            /**< APBTIM3λλ    */
#define RCC_PERIPH_RESET_UART2            RCC_APBRST1_UART2_RST                           /**< APBUART2λλ   */
#define RCC_PERIPH_RESET_I2C1             RCC_APBRST1_I2C1_RST                            /**< APBI2C1λλ    */
#define RCC_PERIPH_RESET_LPTIM1           RCC_APBRST1_LPTIM1_RST                          /**< APBLPTIM1λλ  */
                                                                                                                                                                  
#define RCC_PERIPH_RESET_COMP             RCC_APBRST2_COMP_RST                            /**< APBCOMPλλ      */
#define RCC_PERIPH_RESET_TIM1             RCC_APBRST2_TIM1_RST                            /**< APBTIM1λλ    */
#define RCC_PERIPH_RESET_SPI1             RCC_APBRST2_SPI1_RST                            /**< APBSPI1λλ    */
#define RCC_PERIPH_RESET_UART1            RCC_APBRST2_UART1_RST                           /**< APBUARTλλ    */
#define RCC_PERIPH_RESET_ADC              RCC_APBRST2_ADC_RST                             /**< APBADCλλ     */
#define RCC_PERIPH_RESET_DBG              RCC_APBRST2_DBG_RST                             /**< APBDBGλλ     */

/* LPTIM1첽ʱԴѡ */
#define RCC_LPTIM1_ASYNC_CLK_SRC_PCLK         RCC_CLKSEL_LPTIM1_SEL_PCLK             /**< PCLKʱΪLPTIM1ʱ      */
#define RCC_LPTIM1_ASYNC_CLK_SRC_RCL          RCC_CLKSEL_LPTIM1_SEL_RCL              /**< RCLʱΪLPTIM1ʱ       */
#define RCC_LPTIM1_ASYNC_CLK_SRC_MCO          RCC_CLKSEL_LPTIM1_SEL_MCO              /**< MCOʱΪLPTIM1ʱ       */

/* COMP1첽ʱԴѡ */
#define RCC_COMP1_ASYNC_CLK_SRC_PCLK          RCC_CLKSEL_COMP1_SEL_PCLK             /**< PCLKʱΪCOMP1ʱ      */
#define RCC_COMP1_ASYNC_CLK_SRC_RCL           RCC_CLKSEL_COMP1_SEL_RCL              /**< RCLʱΪCOMP1ʱ       */

/* COMP2첽ʱԴѡ */
#define RCC_COMP2_ASYNC_CLK_SRC_PCLK          RCC_CLKSEL_COMP2_SEL_PCLK             /**< PCLKʱΪCOMP2ʱ      */
#define RCC_COMP2_ASYNC_CLK_SRC_RCL           RCC_CLKSEL_COMP2_SEL_RCL              /**< RCLʱΪCOMP2ʱ       */

/* λ־ */
#define RCC_RESET_FLAG_LOCKUP                   RCC_CSR2_LOCKUP_RSTF                  /**< LOCKUPλ־           */
#define RCC_RESET_FLAG_NRST                     RCC_CSR2_NRST_RSTF                    /**< NRSTŸλ־         */
#define RCC_RESET_FLAG_PMU                      RCC_CSR2_PMU_RSTF                     /**< POR/PDRBORλ־     */
#define RCC_RESET_FLAG_SW                       RCC_CSR2_SW_RSTF                      /**< λ־             */
#define RCC_RESET_FLAG_IWDG                     RCC_CSR2_IWDG_RSTF                    /**< IWDGλ־             */
#define RCC_RESET_FLAG_LPM                      RCC_CSR2_LPM_RSTF                     /**< ͹ĸλ־           */
#define RCC_RESET_FLAG_ALL                     (0xFFUL<<RCC_CSR2_LOCKUP_RSTF_POS)     /**< иλ־             */


/** 
* @} 
*/

/*-------------------------------------------functions------------------------------------------*/

/************************************************************************************************/
/**
* @defgroup RCC_External_Functions RCC External Functions
* @brief    RCC⺯
* @{
*
*/
/************************************************************************************************/
/** 
* @brief  ʹRCHʱ
* @note   ʹRCHӦȴRCHRDY־λʹøʱ
* @retval 
*/
__STATIC_INLINE void std_rcc_rch_enable(void)
{
    RCC->CSR1 |= RCC_CSR1_RCHON;
} 

/** 
* @brief  رRCHʱ
* @note   RCHΪϵͳʱԴ䲻ֹܱͣʱûӦȽϵͳʱԴлΪʱӣٹرոʱԴ
* @note   رRCHʱȴRCHRDY־
* @retval 
*/
__STATIC_INLINE void std_rcc_rch_disable(void)
{
    RCC->CSR1 &= (~RCC_CSR1_RCHON);
}

/** 
* @brief  ȡRCH ready־
* @retval uint32_t RCH RDY־״̬
*             @arg 0 ʾRCH readyλ
*             @arg 0ʾRCH readyδλ
*/
__STATIC_INLINE uint32_t std_rcc_get_rch_ready(void) 
{
    return(RCC->CSR1 & RCC_CSR1_RCHRDY);
}        

/** 
* @brief  ϵͳʱԴ
* @param  clocksource ϵͳʱԴ
*             @arg RCC_SYSCLK_SRC_RCHDIV6
*             @arg RCC_SYSCLK_SRC_RCHDIV3   
*             @arg RCC_SYSCLK_SRC_RCH    
*             @arg RCC_SYSCLK_SRC_RCL     
*             @arg RCC_SYSCLK_SRC_EXTCLK
* @retval 
*/
__STATIC_INLINE void std_rcc_set_sysclk_source(uint32_t clocksource)
{
    MODIFY_REG(RCC->CFG, RCC_CFG_SYSW, clocksource);
}    

/** 
* @brief  ȡϵͳʱԴϢ
* @retval uint32_t ϵͳʱԴ
*             @arg RCC_SYSCLK_SRC_STATUS_RCHDIV6  
*             @arg RCC_SYSCLK_SRC_STATUS_RCHDIV3   
*             @arg RCC_SYSCLK_SRC_STATUS_RCH    
*             @arg RCC_SYSCLK_SRC_STATUS_RCL    
*             @arg RCC_SYSCLK_SRC_STATUS_EXTCLK 
*/
__STATIC_INLINE uint32_t std_rcc_get_sysclk_source(void)
{
    return(RCC->CFG & RCC_CFG_SYSWS);
}    

/** 
* @brief  AHBʱӷƵ
* @param  ahb_div AHBƵ
*             @arg RCC_HCLK_DIV1   
*             @arg RCC_HCLK_DIV2     
*             @arg ...   
*             @arg RCC_HCLK_DIV128
* @retval 
*/
__STATIC_INLINE void std_rcc_set_ahbdiv(uint32_t ahb_div)
{
    MODIFY_REG(RCC->CFG, RCC_CFG_HPRE, ahb_div);
}    

/** 
* @brief  ȡAHBʱӷƵ
* @retval uint32_t HCLKʱӷƵ
*             @arg RCC_HCLK_DIV1   
*             @arg RCC_HCLK_DIV2     
*             @arg ...   
*             @arg RCC_HCLK_DIV128
*/
__STATIC_INLINE uint32_t std_rcc_get_ahbdiv(void)
{
    return(RCC->CFG & RCC_CFG_HPRE);
} 

/** 
* @brief  APBʱӷƵ
* @param  apb_div APBƵ
*             @arg RCC_PCLK_DIV1   
*             @arg RCC_PCLK_DIV2     
*             @arg ...   
*             @arg RCC_PCLK_DIV16
* @retval 
*/
__STATIC_INLINE void std_rcc_set_apbdiv(uint32_t apb_div)
{
    MODIFY_REG(RCC->CFG, RCC_CFG_PPRE, apb_div);
}    

/** 
* @brief  ȡAPBʱӷƵ
* @retval uint32_t PCLK1ʱӷƵ
*             @arg RCC_PCLK_DIV1   
*             @arg RCC_PCLK_DIV2     
*             @arg ...   
*             @arg RCC_PCLK_DIV16
*/
__STATIC_INLINE uint32_t std_rcc_get_apbdiv(void)
{
    return(RCC->CFG & RCC_CFG_PPRE);
} 

/**
* @brief  MCOϢ
* @param  mco_source MCOԴѡ
*             @arg RCC_MCO_SRC_SYSCLK
*             @arg RCC_MCO_SRC_RCHDIV6
*             @arg RCC_MCO_SRC_EXTCLK
*             @arg RCC_MCO_SRC_RCL
* @param  mco_psc MCOƵ
*             @arg RCC_MCO_DIV1
*             @arg RCC_MCO_DIV2
*             @arg ...
*             @arg RCC_MCO_DIV128
* @retval 
*/
__STATIC_INLINE void std_rcc_mco_config(uint32_t mco_source, uint32_t mco_psc)
{
    MODIFY_REG(RCC->CFG, RCC_CFG_MCOSEL | RCC_CFG_MCOPRE, mco_source | mco_psc);
}

/** 
* @brief  ʹEXTCLKʱ
* @retval 
*/
__STATIC_INLINE void std_rcc_extclk_enable(void) 
{
    RCC->CSR1 |= RCC_CSR1_EXTCLKON;     
}

/** 
* @brief  رEXTCLKʱ
* @retval 
*/
__STATIC_INLINE void std_rcc_extclk_disable(void)
{
    RCC->CSR1 &= (~RCC_CSR1_EXTCLKON);
} 

/** 
* @brief  ʹRCCж
* @param  interrupt ʹRCCжԴϢ
*             @arg  RCC_INTERRUPT_RCL_READY
*             @arg  RCC_INTERRUPT_RCH_READY
* @retval 
*/
__STATIC_INLINE void std_rcc_interrupt_enable(uint32_t interrupt)     
{
    RCC->IER |= (interrupt);
}

/** 
* @brief  رRCCж
* @param  interrupt رRCCжԴϢ
*             @arg  RCC_INTERRUPT_RCL_READY
*             @arg  RCC_INTERRUPT_RCH_READY
* @retval 
*/
__STATIC_INLINE void std_rcc_interrupt_disable(uint32_t interrupt)    
{
    RCC->IER &= (~(interrupt));
} 

/**
* @brief  ȡRCCжʹ״̬
* @param  interrupt RCCжԴϢ
*             @arg  RCC_INTERRUPT_RCL_READY
*             @arg  RCC_INTERRUPT_RCH_READY
* @retval uint32_t жϱ־λ״̬
*             @arg 0 ʾָжϴʹ״̬
*             @arg 0ʾָжϴڽֹ״̬
*/
__STATIC_INLINE uint32_t std_rcc_get_interrupt_enable(uint32_t interrupt)    
{
    return(RCC->IER & (interrupt));
}

/**
* @brief  ȡRCCжϱ־״̬
* @param  flag RCCжϱ־Ϣ
*             @arg  RCC_FLAG_RCL_READY
*             @arg  RCC_FLAG_RCH_READY
* @retval uint32_t жϱ־λ״̬
*             @arg 0 ʾָжλ
*             @arg 0ʾָжδλ
*/
__STATIC_INLINE uint32_t std_rcc_get_flag(uint32_t flag) 
{
    return(RCC->ISR & (flag));
}

/** 
* @brief  RCC־
* @param  flags ־λ
*             @arg  RCC_CLEAR_RCL_READY
*             @arg  RCC_CLEAR_RCH_READY
* @retval 
*/
__STATIC_INLINE void std_rcc_clear_flag(uint32_t flags)   
{
    RCC->ICR = (flags);
}

/** 
* @brief  ʹRCLʱ
* @note   ʹRCLӦȴRCLRDY־λʹøʱ
* @retval 
*/
__STATIC_INLINE void std_rcc_rcl_enable(void)
{
    RCC->CSR2 |= RCC_CSR2_RCLON;
}          

/** 
* @brief  رRCLʱ
* @note   RCLΪϵͳʱԴ䲻ֹܱͣʱûӦȽϵͳʱԴлΪʱӣٹرոʱԴ
* @note   رRCLʱRCLRDY־RCLرպԶ
* @retval 
*/
__STATIC_INLINE void std_rcc_rcl_disable(void) 
{
    RCC->CSR2 &= (~RCC_CSR2_RCLON);
}        

/** 
* @brief  ȡRCL ready־
* @retval uint32_t RCL RDY־״̬
*             @arg 0 ʾRCL readyλ
*             @arg 0ʾRCL readyδλ
*/
__STATIC_INLINE uint32_t std_rcc_get_rcl_ready(void)          
{
    return(RCC->CSR2 & RCC_CSR2_RCLRDY);
}

/** 
* @brief  ȡλ־
* @param  reset_flag ָҪȡĸλ־
*             @arg RCC_RESET_FLAG_LOCKUP
*             @arg RCC_RESET_FLAG_NRST  
*             @arg RCC_RESET_FLAG_PMU   
*             @arg RCC_RESET_FLAG_SW    
*             @arg RCC_RESET_FLAG_IWDG  
*             @arg RCC_RESET_FLAG_LPM   
*             @arg RCC_RESET_FLAG_ALL   
* @retval uint32_t ״̬־
*             @arg 0 ʾָĸλ־λ
*             @arg 0ʾָĸλ־δλ
*/
__STATIC_INLINE uint32_t std_rcc_get_reset_flag(uint32_t reset_flag)            
{
    return(RCC->CSR2 & (reset_flag));
} 

/** 
* @brief  λ־
* @note   úиλ־
* @retval 
*/
__STATIC_INLINE void std_rcc_clear_reset_flags(void)           
{
    RCC->CSR2 |= RCC_CSR2_RMVF;
}

/** 
* @brief  GPIO˿ʱʹ
* @param  gpiox_clock ָʹܵGPIOʱ
*             @arg RCC_PERIPH_CLK_GPIOA
*             @arg RCC_PERIPH_CLK_GPIOB
*             @arg RCC_PERIPH_CLK_GPIOC
* @retval 
*/
__STATIC_INLINE void std_rcc_gpio_clk_enable(uint32_t gpiox_clock)
{
    RCC->IOPEN |= gpiox_clock; 
    
    /* RCCΧʱúӳ */  
    __NOP(); __NOP(); __NOP(); 
}

/** 
* @brief  GPIO˿ʱӽֹ
* @param  gpiox_clock ָֹGPIOʱ
*             @arg RCC_PERIPH_CLK_GPIOA
*             @arg RCC_PERIPH_CLK_GPIOB
*             @arg RCC_PERIPH_CLK_GPIOC
* @retval 
*/
__STATIC_INLINE void std_rcc_gpio_clk_disable(uint32_t gpiox_clock) 
{
    RCC->IOPEN &= (~(gpiox_clock)); 
    
    /* RCCΧʱúӳ */  
    __NOP(); __NOP(); __NOP(); 
}

/** 
* @brief  GPIO˿ڸλ
* @param  gpiox_rst ָλGPIO˿
*             @arg RCC_PERIPH_RESET_GPIOA
*             @arg RCC_PERIPH_RESET_GPIOB
*             @arg RCC_PERIPH_RESET_GPIOC
* @retval 
*/
__STATIC_INLINE void std_rcc_gpio_reset(uint32_t gpiox_rst)
{
    RCC->IOPRST |= (gpiox_rst);
    RCC->IOPRST &= (~(gpiox_rst));
}         

/** 
* @brief  AHBʱʹ
* @param  periph_clock ָʹܵAHBʱ
*             @arg RCC_PERIPH_CLK_CRC  
* @retval 
*/
__STATIC_INLINE void std_rcc_ahb_clk_enable(uint32_t periph_clock)
{
    RCC->AHBEN |= periph_clock;
    
    /* RCCΧʱúӳ */    
    __NOP(); __NOP(); __NOP(); 
}   

/** 
* @brief  AHBʱӽֹ
* @param  periph_clock ָֹAHBʱ
*             @arg RCC_PERIPH_CLK_CRC  
* @retval 
*/
__STATIC_INLINE void std_rcc_ahb_clk_disable(uint32_t periph_clock)            
{
    RCC->AHBEN &= (~(periph_clock));
}

/** 
* @brief  AHB踴λ
* @param  periph_rst ָλAHB
*             @arg RCC_PERIPH_RESET_CRC
* @retval 
*/
__STATIC_INLINE void std_rcc_ahb_reset(uint32_t periph_rst)
{
    RCC->AHBRST |= (periph_rst);
    RCC->AHBRST &= (~(periph_rst));
}       

/** 
* @brief  APB1ʱʹ
* @param  periph_clock ָʹܵAPB1ʱ
*             @arg RCC_PERIPH_CLK_TIM3   
*             @arg RCC_PERIPH_CLK_UART2 
*             @arg RCC_PERIPH_CLK_I2C1   
*             @arg RCC_PERIPH_CLK_PMU       
*             @arg RCC_PERIPH_CLK_LPTIM1 
* @retval 
*/
__STATIC_INLINE void std_rcc_apb1_clk_enable(uint32_t periph_clock)
{
    RCC->APBEN1 |= periph_clock;
    
    /* RCCΧʱúӳ */    
    __NOP(); __NOP(); __NOP(); 
}

/** 
* @brief  APB1ʱӽֹ
* @param  periph_clock ָֹAPB1ʱ
*             @arg RCC_PERIPH_CLK_TIM3      
*             @arg RCC_PERIPH_CLK_UART2 
*             @arg RCC_PERIPH_CLK_I2C1   
*             @arg RCC_PERIPH_CLK_PMU      
*             @arg RCC_PERIPH_CLK_LPTIM1 
* @retval 
*/
__STATIC_INLINE void std_rcc_apb1_clk_disable(uint32_t periph_clock)            
{
    RCC->APBEN1 &= (~(periph_clock));
}

/** 
* @brief  APB1λ
* @param  periph_rst ָλAPB1
*             @arg RCC_PERIPH_RESET_TIM3     
*             @arg RCC_PERIPH_RESET_UART2 
*             @arg RCC_PERIPH_RESET_I2C1   
*             @arg RCC_PERIPH_RESET_LPTIM1 
* @retval 
*/
__STATIC_INLINE void std_rcc_apb1_reset(uint32_t periph_rst)
{
    RCC->APBRST1 |= (periph_rst);
    RCC->APBRST1 &= (~(periph_rst));
}       

/** 
* @brief  APB2ʱʹ
* @param  periph_clock ָʹܵAPB2ʱ
*             @arg RCC_PERIPH_CLK_COMP
*             @arg RCC_PERIPH_CLK_TIM1   
*             @arg RCC_PERIPH_CLK_SPI1   
*             @arg RCC_PERIPH_CLK_UART1 
*             @arg RCC_PERIPH_CLK_ADC    
*             @arg RCC_PERIPH_CLK_DBG
* @retval 
*/
__STATIC_INLINE void std_rcc_apb2_clk_enable(uint32_t periph_clock)
{
    RCC->APBEN2 |= periph_clock;
    
    /* RCCΧʱúӳ */    
    __NOP(); __NOP(); __NOP(); 
}

/** 
* @brief  APB2ʱӽֹ
* @param  periph_clock ָֹAPB2ʱ
*             @arg RCC_PERIPH_CLK_COMP
*             @arg RCC_PERIPH_CLK_TIM1   
*             @arg RCC_PERIPH_CLK_SPI1   
*             @arg RCC_PERIPH_CLK_UART1 
*             @arg RCC_PERIPH_CLK_ADC    
*             @arg RCC_PERIPH_CLK_DBG
* @retval 
*/
__STATIC_INLINE void std_rcc_apb2_clk_disable(uint32_t periph_clock)            
{
    RCC->APBEN2 &= (~(periph_clock));
}

/** 
* @brief  APB2λ
* @param  periph_rst ָλAPB2
*             @arg RCC_PERIPH_RESET_COMP   
*             @arg RCC_PERIPH_RESET_TIM1   
*             @arg RCC_PERIPH_RESET_SPI1   
*             @arg RCC_PERIPH_RESET_UART1 
*             @arg RCC_PERIPH_RESET_ADC    
*             @arg RCC_PERIPH_RESET_DBG  
* @retval 
*/
__STATIC_INLINE void std_rcc_apb2_reset(uint32_t periph_rst)
{
    RCC->APBRST2 |= (periph_rst);
    RCC->APBRST2 &= (~(periph_rst));
}       

/** 
* @brief  ʹLOCKUPλ
* @retval 
*/
__STATIC_INLINE void std_rcc_lockup_reset_enable(void)
{
    RCC->CSR2 |= RCC_CSR2_LOCKUP_RSTEN;
}

/** 
* @brief  ֹLOCKUPλ
* @retval 
*/
__STATIC_INLINE void std_rcc_lockup_reset_disable(void)
{
    RCC->CSR2 &= (~RCC_CSR2_LOCKUP_RSTEN);
}

/** 
* @brief  LPTIM1ʱԴѡ
* @param  lptim1clk_select LPTIM1ʱԴ
*             @arg RCC_LPTIM1_ASYNC_CLK_SRC_PCLK
*             @arg RCC_LPTIM1_ASYNC_CLK_SRC_RCL
*             @arg RCC_LPTIM1_ASYNC_CLK_SRC_MCO
* @retval 
*/
__STATIC_INLINE void std_rcc_set_lptim1clk_source(uint32_t lptim1clk_select)
{
    MODIFY_REG(RCC->CLKSEL, RCC_CLKSEL_LPTIM1_SEL, (lptim1clk_select));
}       

/** 
* @brief  ȡLPTIM1ʱԴ
* @retval uint32_t LPTIM1ʱԴϢ
*             @arg RCC_LPTIM1_ASYNC_CLK_SRC_PCLK1
*             @arg RCC_LPTIM1_ASYNC_CLK_SRC_RCL
*             @arg RCC_LPTIM1_ASYNC_CLK_SRC_MCO
*/
__STATIC_INLINE uint32_t std_rcc_get_lptim1clk_source(void)
{
    return(RCC->CLKSEL & RCC_CLKSEL_LPTIM1_SEL);
} 

/** 
* @brief  COMP1ʱԴѡ
* @param  comp1clk_select COMP1ʱԴ
*             @arg RCC_COMP1_ASYNC_CLK_SRC_PCLK
*             @arg RCC_COMP1_ASYNC_CLK_SRC_RCL
* @retval 
*/
__STATIC_INLINE void std_rcc_set_comp1clk_source(uint32_t comp1clk_select)
{
    MODIFY_REG(RCC->CLKSEL, RCC_CLKSEL_COMP1_SEL, (comp1clk_select));
}       

/** 
* @brief  ȡCOMP1ʱԴ
* @retval uint32_t COMP1ʱԴϢ
*             @arg RCC_COMP1_ASYNC_CLK_SRC_PCLK
*             @arg RCC_COMP1_ASYNC_CLK_SRC_RCL
*/
__STATIC_INLINE uint32_t std_rcc_get_comp1clk_source(void)
{
    return(RCC->CLKSEL & RCC_CLKSEL_COMP1_SEL);
} 

/** 
* @brief  COMP2ʱԴѡ
* @param  comp2clk_select COMP2ʱԴ
*             @arg RCC_COMP2_ASYNC_CLK_SRC_PCLK
*             @arg RCC_COMP2_ASYNC_CLK_SRC_RCL
* @retval 
*/
__STATIC_INLINE void std_rcc_set_comp2clk_source(uint32_t comp2clk_select)
{
    MODIFY_REG(RCC->CLKSEL, RCC_CLKSEL_COMP2_SEL, (comp2clk_select));
}       

/** 
* @brief  ȡCOMP2ʱԴ
* @retval uint32_t COMP2ʱԴϢ
*             @arg RCC_COMP2_ASYNC_CLK_SRC_PCLK
*             @arg RCC_COMP2_ASYNC_CLK_SRC_RCL
*/
__STATIC_INLINE uint32_t std_rcc_get_comp2clk_source(void)
{
    return(RCC->CLKSEL & RCC_CLKSEL_COMP2_SEL);
} 

/** 
* @brief  дRCLУ׼ֵ
* @param  cal_value RCLУ׼ֵ
* @retval 
*/
__STATIC_INLINE void std_rcc_write_rcl_calibration(uint32_t cal_value)
{
    RCC->RCLCAL = cal_value;
}

/** 
* @brief  ȡRCLУ׼ֵ
* @retval uint32_t RCLУ׼ֵ
*/
__STATIC_INLINE uint32_t std_rcc_read_rcl_calibration(void)
{
    return(RCC->RCLCAL);
}

/** 
* @brief  дRCHʱӴֵֵ
* @param  cal_value RCHʱӴֵֵ
* @retval 
*/
__STATIC_INLINE void std_rcc_write_rch_coarse_calibration(uint32_t cal_value)
{
    MODIFY_REG(RCC->RCHCAL, RCC_RCHCAL_RCH_CAL_COARSE, cal_value << RCC_RCHCAL_RCH_CAL_COARSE_POS);
}

/** 
* @brief  ȡRCHʱӴֵֵ
* @retval uint32_t RCHʱӴֵֵ
*/
__STATIC_INLINE uint32_t std_rcc_read_rch_coarse_calibration(void)
{
    return((RCC->RCHCAL & RCC_RCHCAL_RCH_CAL_COARSE) >> RCC_RCHCAL_RCH_CAL_COARSE_POS);
}

/** 
* @brief  дRCHʱ΢ֵ
* @param  trim_value  RCHʱ΢ֵ
* @retval 
*/
__STATIC_INLINE void std_rcc_write_rch_fine_calibration(uint32_t trim_value)
{
    MODIFY_REG(RCC->RCHCAL, RCC_RCHCAL_RCH_CAL_FINE, trim_value);
}

/** 
* @brief  ȡRCHʱ΢ֵ
* @retval uint32_t RCHʱ΢ֵ
*/
__STATIC_INLINE uint32_t std_rcc_read_rch_fine_calibration(void)
{
    return(RCC->RCHCAL & RCC_RCHCAL_RCH_CAL_FINE);
}


/* ȡʱƵʺ */
uint32_t std_rcc_get_sysclkfreq(void);
uint32_t std_rcc_get_hclkfreq(void);
uint32_t std_rcc_get_pclkfreq(void); 


/** 
* @} 
*/


#ifdef __cplusplus
}
#endif

/**
* @} 
*/  

/**
* @}
*/

#endif /* CIU32F003_STD_RCC_H */
