/************************************************************************************************/
/**
* @file               uart_bsp.c
* @author             MCU Ecosystem Development Team
* @brief              UART BSPʵUARTжϷ
*
*
**************************************************************************************************
* @attention
* Copyright (c) CEC Huada Electronic Design Co.,Ltd. All rights reserved.
*
**************************************************************************************************
*/

/*------------------------------------------includes--------------------------------------------*/
#include "uart_bsp.h"


/*--------------------------------------------define-------------------------------------------*/
/* BUFĳ*/
#define BUF_LEN  8

/*--------------------------------------------variables-----------------------------------------*/

/* ݻBUF*/
static uint8_t g_buffer[BUF_LEN];

/* UART ǰշݵĸ */
static __IO uint8_t g_cur_count ;

extern __IO uint8_t g_uart_ready ; 
/*-------------------------------------------functions------------------------------------------*/

/**
* @brief  UART1 жϷ
* @retval 
*/
void UART1_IRQHandler(void)
{
     /*  */
    if((std_uart_get_cr3_interrupt_err_enable(UART1)                          \
        || std_uart_get_cr1_interrupt_enable(UART1,UART_CR1_INTERRUPT_RXNE))  \
        && std_uart_get_flag(UART1,UART_FLAG_ORE))
    {
        /* ־ */
        std_uart_clear_flag(UART1,UART_CLEAR_ORE);
        /* ûɸʵʹóԶ */
    }
    
    /* 鵽ռĴǿձ־ ȡ */    
    if(std_uart_get_cr1_interrupt_enable(UART1,UART_CR1_INTERRUPT_RXNE)     \
         && std_uart_get_flag(UART1,UART_FLAG_RXNE))
    {
        g_buffer[g_cur_count++] = std_uart_rx_read_data(UART1);
        
        if(g_cur_count == BUF_LEN)
        {
            std_uart_cr1_interrupt_disable(UART1,UART_CR1_INTERRUPT_RXNE);
            g_cur_count = 0;
            g_uart_ready = 1;
        }
    }
    /* 鷢ͼĴΪձ־1ʱд뷢 */    
    if( std_uart_get_cr1_interrupt_enable(UART1,UART_CR1_INTERRUPT_TXE)        \
         && std_uart_get_flag(UART1,UART_FLAG_TXE))
    {
        std_uart_tx_write_data(UART1, g_buffer[g_cur_count++]);
  
        if(g_cur_count == BUF_LEN)
        {
            /* ɷͺ󣬹رTXEжϣж */    
            std_uart_cr1_interrupt_disable(UART1,UART_CR1_INTERRUPT_TXE);
            std_uart_cr1_interrupt_enable(UART1,UART_CR1_INTERRUPT_TC);
        }
    }
    /* ⵽ɱ־1ȫֱ־1 */    
    if(std_uart_get_cr1_interrupt_enable(UART1,UART_CR1_INTERRUPT_TC)         \
        && std_uart_get_flag(UART1,UART_FLAG_TC))
    {
        std_uart_clear_flag(UART1,UART_FLAG_TC);
        std_uart_cr1_interrupt_disable(UART1,UART_CR1_INTERRUPT_TC);
        g_cur_count = 0;
        g_uart_ready = 1;  
    }
}





