#ifndef __SN8P1937__H
#define __SN8P1937__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	RBANK	(*((__RAM unsigned int*)0x87))
#define	FRBNKS0	((*((__RAM struct specialRegister *)0x87)).bit0)
#define	FRBNKS1	((*((__RAM struct specialRegister *)0x87)).bit1)
#define	FRBNKS2	((*((__RAM struct specialRegister *)0x87)).bit2)
#define	FRBNKS3	((*((__RAM struct specialRegister *)0x87)).bit3)
#if ICE_Mode == 1
#define	LCDM1	(*((__RAM unsigned int*)0XCB))
#define	FLCDBNK	((*((__RAM struct specialRegister *)0XCB)).bit5)
#define	FLCDENB	((*((__RAM struct specialRegister *)0XCB)).bit3)
#define	Dummy	(*((__RAM unsigned int*)0X8F))
#define	FLCDREF1	((*((__RAM struct specialRegister *)0X8F)).bit7)
#define	FLCDREF0	((*((__RAM struct specialRegister *)0X8F)).bit6)
#define	FLCDTYPE	((*((__RAM struct specialRegister *)0X8F)).bit4)
#define	FLCDBIAS	((*((__RAM struct specialRegister *)0X8F)).bit2)
#define	FLCDRATE	((*((__RAM struct specialRegister *)0X8F)).bit1)
#define	FLCDCLK	((*((__RAM struct specialRegister *)0X8F)).bit0)
#define	LCDM2	(*((__RAM unsigned int*)0XC6))
#define	FBGM	((*((__RAM struct specialRegister *)0XC6)).bit5)
#define	FLCDCPK1	((*((__RAM struct specialRegister *)0XC6)).bit4)
#define	FLCDCPK0	((*((__RAM struct specialRegister *)0XC6)).bit3)
#define	FVCP2	((*((__RAM struct specialRegister *)0XC6)).bit2)
#define	FVCP1	((*((__RAM struct specialRegister *)0XC6)).bit1)
#define	FVCP0	((*((__RAM struct specialRegister *)0XC6)).bit0)
#else
#define	LCDM1	(*((__RAM unsigned int*)0x89))
#define	FLCDREF1	((*((__RAM struct specialRegister *)0x89)).bit7)
#define	FLCDREF0	((*((__RAM struct specialRegister *)0x89)).bit6)
#define	FLCDBNK	((*((__RAM struct specialRegister *)0x89)).bit5)
#define	FLCDTYPE	((*((__RAM struct specialRegister *)0x89)).bit4)
#define	FLCDENB	((*((__RAM struct specialRegister *)0x89)).bit3)
#define	FLCDBIAS	((*((__RAM struct specialRegister *)0x89)).bit2)
#define	FLCDRATE	((*((__RAM struct specialRegister *)0x89)).bit1)
#define	FLCDCLK	((*((__RAM struct specialRegister *)0x89)).bit0)
#define	LCDM2	(*((__RAM unsigned int*)0x8A))
#define	FBGM	((*((__RAM struct specialRegister *)0x8A)).bit5)
#define	FLCDCPK1	((*((__RAM struct specialRegister *)0x8A)).bit4)
#define	FLCDCPK0	((*((__RAM struct specialRegister *)0x8A)).bit3)
#define	FVCP2	((*((__RAM struct specialRegister *)0x8A)).bit2)
#define	FVCP1	((*((__RAM struct specialRegister *)0x8A)).bit1)
#define	FVCP0	((*((__RAM struct specialRegister *)0x8A)).bit0)
#endif
#define	AMPM	(*((__RAM unsigned int*)0x90))
#define	FCHPENB	((*((__RAM struct specialRegister *)0x90)).bit7)
#define	FBGRENB	((*((__RAM struct specialRegister *)0x90)).bit6)
#define	FFDS1	((*((__RAM struct specialRegister *)0x90)).bit5)
#define	FFDS0	((*((__RAM struct specialRegister *)0x90)).bit4)
#define	FGS2	((*((__RAM struct specialRegister *)0x90)).bit3)
#define	FGS1	((*((__RAM struct specialRegister *)0x90)).bit2)
#define	FGS0	((*((__RAM struct specialRegister *)0x90)).bit1)
#define	FAMPENB	((*((__RAM struct specialRegister *)0x90)).bit0)
#define	AMPCHS	(*((__RAM unsigned int*)0x91))
#define	FCHS2	((*((__RAM struct specialRegister *)0x91)).bit2)
#define	FCHS1	((*((__RAM struct specialRegister *)0x91)).bit1)
#define	FCHS0	((*((__RAM struct specialRegister *)0x91)).bit0)
#define	AMPCKS	(*((__RAM unsigned int*)0x92))
#define	FAMPCKS2	((*((__RAM struct specialRegister *)0x92)).bit2)
#define	FAMPCKS1	((*((__RAM struct specialRegister *)0x92)).bit1)
#define	FAMPCKS0	((*((__RAM struct specialRegister *)0x92)).bit0)
#define	ADCM	(*((__RAM unsigned int*)0x93))
#define	FADG2	((*((__RAM struct specialRegister *)0x93)).bit7)
#define	FADG1	((*((__RAM struct specialRegister *)0x93)).bit6)
#define	FADG0	((*((__RAM struct specialRegister *)0x93)).bit5)
#define	FRVS	((*((__RAM struct specialRegister *)0x93)).bit4)
#define	FIRVS	((*((__RAM struct specialRegister *)0x93)).bit3)
#define	FDTENB	((*((__RAM struct specialRegister *)0x93)).bit2)
#define	FDTSEL	((*((__RAM struct specialRegister *)0x93)).bit1)
#define	FADCENB	((*((__RAM struct specialRegister *)0x93)).bit0)
#define	ADCKS	(*((__RAM unsigned int*)0X94))
#define	CPM	(*((__RAM unsigned int*)0x95))
#define	FACMENB	((*((__RAM struct specialRegister *)0x95)).bit7)
#define	FAVDDRENB	((*((__RAM struct specialRegister *)0x95)).bit6)
#define	FAVESEL	((*((__RAM struct specialRegister *)0x95)).bit5)
#define	FAVENB	((*((__RAM struct specialRegister *)0x95)).bit4)
#define	FACMSEL	((*((__RAM struct specialRegister *)0x95)).bit3)
#define	ADCDLL	(*((__RAM unsigned int*)0x96))
#define	DFM	(*((__RAM unsigned int*)0x97))
#define	FOSR2	((*((__RAM struct specialRegister *)0x97)).bit7)
#define	FOSR1	((*((__RAM struct specialRegister *)0x97)).bit6)
#define	FOSR0	((*((__RAM struct specialRegister *)0x97)).bit5)
#define	FADCHPENB	((*((__RAM struct specialRegister *)0x97)).bit4)
#define	FDRDY	((*((__RAM struct specialRegister *)0x97)).bit0)
#define	ADCDL	(*((__RAM unsigned int*)0x98))
#define	ADCDH	(*((__RAM unsigned int*)0x99))
#define	LBTM	(*((__RAM unsigned int*)0x9A))
#define	FLBTO	((*((__RAM struct specialRegister *)0x9A)).bit2)
#define	FP51IO	((*((__RAM struct specialRegister *)0x9A)).bit1)
#define	FLBTENB	((*((__RAM struct specialRegister *)0x9A)).bit0)
#define	CPMTEST	(*((__RAM unsigned int*)0x9B))
#define	FGX	((*((__RAM struct specialRegister *)0x9B)).bit2)
#define	FGR	((*((__RAM struct specialRegister *)0x9B)).bit1)
#define	FTSENB	((*((__RAM struct specialRegister *)0x9B)).bit0)
#define	MTAP	(*((__RAM unsigned int*)0x9C))
#define	TST37	(*((__RAM unsigned int*)0x9D))
#if ICE_Mode == 1
#define	ROMADRH	(*((__RAM unsigned int*)0XB4))
#define	FVPPCHK	((*((__RAM struct specialRegister *)0XB4)).bit7)
#define	FROMADR14	((*((__RAM struct specialRegister *)0XB4)).bit6)
#define	FROMADR13	((*((__RAM struct specialRegister *)0XB4)).bit5)
#define	FROMADR12	((*((__RAM struct specialRegister *)0XB4)).bit4)
#define	FROMADR11	((*((__RAM struct specialRegister *)0XB4)).bit3)
#define	FROMADR10	((*((__RAM struct specialRegister *)0XB4)).bit2)
#define	FROMADR9	((*((__RAM struct specialRegister *)0XB4)).bit1)
#define	FROMADR8	((*((__RAM struct specialRegister *)0XB4)).bit0)
#define	ROMADRL	(*((__RAM unsigned int*)0XB6))
#define	FROMADR7	((*((__RAM struct specialRegister *)0XB6)).bit7)
#define	FROMADR6	((*((__RAM struct specialRegister *)0XB6)).bit6)
#define	FROMADR5	((*((__RAM struct specialRegister *)0XB6)).bit5)
#define	FROMADR4	((*((__RAM struct specialRegister *)0XB6)).bit4)
#define	FROMADR3	((*((__RAM struct specialRegister *)0XB6)).bit3)
#define	FROMADR2	((*((__RAM struct specialRegister *)0XB6)).bit2)
#define	FROMADR1	((*((__RAM struct specialRegister *)0XB6)).bit1)
#define	FROMADR0	((*((__RAM struct specialRegister *)0XB6)).bit0)
#define	ROMDAH	(*((__RAM unsigned int*)0XC7))
#define	FROMDA15	((*((__RAM struct specialRegister *)0XC7)).bit7)
#define	FROMDA14	((*((__RAM struct specialRegister *)0XC7)).bit6)
#define	FROMDA13	((*((__RAM struct specialRegister *)0XC7)).bit5)
#define	FROMDA12	((*((__RAM struct specialRegister *)0XC7)).bit4)
#define	FROMDA11	((*((__RAM struct specialRegister *)0XC7)).bit3)
#define	FROMDA10	((*((__RAM struct specialRegister *)0XC7)).bit2)
#define	FROMDA9	((*((__RAM struct specialRegister *)0XC7)).bit1)
#define	FROMDA8	((*((__RAM struct specialRegister *)0XC7)).bit0)
#define	ROMDAL	(*((__RAM unsigned int*)0XB0))
#define	FROMDA7	((*((__RAM struct specialRegister *)0XB0)).bit7)
#define	FROMDA6	((*((__RAM struct specialRegister *)0XB0)).bit6)
#define	FROMDA5	((*((__RAM struct specialRegister *)0XB0)).bit5)
#define	FROMDA4	((*((__RAM struct specialRegister *)0XB0)).bit4)
#define	FROMDA3	((*((__RAM struct specialRegister *)0XB0)).bit3)
#define	FROMDA2	((*((__RAM struct specialRegister *)0XB0)).bit2)
#define	FROMDA1	((*((__RAM struct specialRegister *)0XB0)).bit1)
#define	FROMDA0	((*((__RAM struct specialRegister *)0XB0)).bit0)
#define	ROMCNT	(*((__RAM unsigned int*)0XB5))
#else
#define	ROMADRH	(*((__RAM unsigned int*)0XA0))
#define	FVPPCHK	((*((__RAM struct specialRegister *)0XA0)).bit7)
#define	FROMADR14	((*((__RAM struct specialRegister *)0XA0)).bit6)
#define	FROMADR13	((*((__RAM struct specialRegister *)0XA0)).bit5)
#define	FROMADR12	((*((__RAM struct specialRegister *)0XA0)).bit4)
#define	FROMADR11	((*((__RAM struct specialRegister *)0XA0)).bit3)
#define	FROMADR10	((*((__RAM struct specialRegister *)0XA0)).bit2)
#define	FROMADR9	((*((__RAM struct specialRegister *)0XA0)).bit1)
#define	FROMADR8	((*((__RAM struct specialRegister *)0XA0)).bit0)
#define	ROMADRL	(*((__RAM unsigned int*)0XA1))
#define	FROMADR7	((*((__RAM struct specialRegister *)0XA1)).bit7)
#define	FROMADR6	((*((__RAM struct specialRegister *)0XA1)).bit6)
#define	FROMADR5	((*((__RAM struct specialRegister *)0XA1)).bit5)
#define	FROMADR4	((*((__RAM struct specialRegister *)0XA1)).bit4)
#define	FROMADR3	((*((__RAM struct specialRegister *)0XA1)).bit3)
#define	FROMADR2	((*((__RAM struct specialRegister *)0XA1)).bit2)
#define	FROMADR1	((*((__RAM struct specialRegister *)0XA1)).bit1)
#define	FROMADR0	((*((__RAM struct specialRegister *)0XA1)).bit0)
#define	ROMDAH	(*((__RAM unsigned int*)0XA2))
#define	FROMDA15	((*((__RAM struct specialRegister *)0XA2)).bit7)
#define	FROMDA14	((*((__RAM struct specialRegister *)0XA2)).bit6)
#define	FROMDA13	((*((__RAM struct specialRegister *)0XA2)).bit5)
#define	FROMDA12	((*((__RAM struct specialRegister *)0XA2)).bit4)
#define	FROMDA11	((*((__RAM struct specialRegister *)0XA2)).bit3)
#define	FROMDA10	((*((__RAM struct specialRegister *)0XA2)).bit2)
#define	FROMDA9	((*((__RAM struct specialRegister *)0XA2)).bit1)
#define	FROMDA8	((*((__RAM struct specialRegister *)0XA2)).bit0)
#define	ROMDAL	(*((__RAM unsigned int*)0XA3))
#define	FROMDA7	((*((__RAM struct specialRegister *)0XA3)).bit7)
#define	FROMDA6	((*((__RAM struct specialRegister *)0XA3)).bit6)
#define	FROMDA5	((*((__RAM struct specialRegister *)0XA3)).bit5)
#define	FROMDA4	((*((__RAM struct specialRegister *)0XA3)).bit4)
#define	FROMDA3	((*((__RAM struct specialRegister *)0XA3)).bit3)
#define	FROMDA2	((*((__RAM struct specialRegister *)0XA3)).bit2)
#define	FROMDA1	((*((__RAM struct specialRegister *)0XA3)).bit1)
#define	FROMDA0	((*((__RAM struct specialRegister *)0XA3)).bit0)
#define	ROMCNT	(*((__RAM unsigned int*)0XA4))
#endif
#define	PEDGE	(*((__RAM unsigned int*)0xBF))
#define	FPEDGEN	((*((__RAM struct specialRegister *)0xBF)).bit7)
#define	FP00G1	((*((__RAM struct specialRegister *)0xBF)).bit4)
#define	FP00G0	((*((__RAM struct specialRegister *)0xBF)).bit3)
#define	P1M	(*((__RAM unsigned int*)0xC1))
#define	FP13M	((*((__RAM struct specialRegister *)0xC1)).bit3)
#define	FP12M	((*((__RAM struct specialRegister *)0xC1)).bit2)
#define	FP11M	((*((__RAM struct specialRegister *)0xC1)).bit1)
#define	FP10M	((*((__RAM struct specialRegister *)0xC1)).bit0)
#define	P2M	(*((__RAM unsigned int*)0xC2))
#define	FP21M	((*((__RAM struct specialRegister *)0xC2)).bit1)
#define	FP20M	((*((__RAM struct specialRegister *)0xC2)).bit0)
#define	P5M	(*((__RAM unsigned int*)0xC5))
#define	FP55M	((*((__RAM struct specialRegister *)0xC5)).bit5)
#define	FP54M	((*((__RAM struct specialRegister *)0xC5)).bit4)
#define	FP53M	((*((__RAM struct specialRegister *)0xC5)).bit3)
#define	FP52M	((*((__RAM struct specialRegister *)0xC5)).bit2)
#define	FP51M	((*((__RAM struct specialRegister *)0xC5)).bit1)
#define	FP50M	((*((__RAM struct specialRegister *)0xC5)).bit0)
#define	INTRQ	(*((__RAM unsigned int*)0xc8))
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit5)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	INTEN	(*((__RAM unsigned int*)0xc9))
#define	FTC0IEN	((*((__RAM struct specialRegister *)0xc9)).bit5)
#define	FT0IEN	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	FP00IEN	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	OSCM	(*((__RAM unsigned int*)0xCA))
#define	FWTCKS	((*((__RAM struct specialRegister *)0xCA)).bit7)
#define	FWDRST	((*((__RAM struct specialRegister *)0xCA)).bit6)
#define	FWDRATE	((*((__RAM struct specialRegister *)0xCA)).bit5)
#define	FCPUM1	((*((__RAM struct specialRegister *)0xCA)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xCA)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xCA)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0xCA)).bit1)
#define	TC0R	(*((__RAM unsigned int*)0xCD))
#define	PCL	(*((__RAM unsigned int*)0xCE))
#define	PCH	(*((__RAM unsigned int*)0xCF))
#define	P0	(*((__RAM unsigned int*)0xd0))
#define	FP00	((*((__RAM struct specialRegister *)0xd0)).bit0)
#define	P1	(*((__RAM unsigned int*)0xD1))
#define	FP13	((*((__RAM struct specialRegister *)0xD1)).bit3)
#define	FP12	((*((__RAM struct specialRegister *)0xD1)).bit2)
#define	FP11	((*((__RAM struct specialRegister *)0xD1)).bit1)
#define	FP10	((*((__RAM struct specialRegister *)0xD1)).bit0)
#define	P2	(*((__RAM unsigned int*)0xD2))
#define	FP21	((*((__RAM struct specialRegister *)0xD2)).bit1)
#define	FP20	((*((__RAM struct specialRegister *)0xD2)).bit0)
#define	P5	(*((__RAM unsigned int*)0xD5))
#define	FP55	((*((__RAM struct specialRegister *)0xD5)).bit5)
#define	FP54	((*((__RAM struct specialRegister *)0xD5)).bit4)
#define	FP53	((*((__RAM struct specialRegister *)0xD5)).bit3)
#define	FP52	((*((__RAM struct specialRegister *)0xD5)).bit2)
#define	FP51	((*((__RAM struct specialRegister *)0xD5)).bit1)
#define	FP50	((*((__RAM struct specialRegister *)0xD5)).bit0)
#define	T0M	(*((__RAM unsigned int*)0xD8))
#define	FT0ENB	((*((__RAM struct specialRegister *)0xD8)).bit7)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xD8)).bit6)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xD8)).bit5)
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xD8)).bit4)
#define	FTC0GN	((*((__RAM struct specialRegister *)0xD8)).bit1)
#define	FT0TB	((*((__RAM struct specialRegister *)0xD8)).bit0)
#define	T0C	(*((__RAM unsigned int*)0xD9))
#define	TC0M	(*((__RAM unsigned int*)0xDA))
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xDA)).bit7)
#define	FTC0RATE2	((*((__RAM struct specialRegister *)0xDA)).bit6)
#define	FTC0RATE1	((*((__RAM struct specialRegister *)0xDA)).bit5)
#define	FTC0RATE0	((*((__RAM struct specialRegister *)0xDA)).bit4)
#define	FTC0CKS	((*((__RAM struct specialRegister *)0xDA)).bit3)
#define	FALOAD0	((*((__RAM struct specialRegister *)0xDA)).bit2)
#define	FTC0OUT	((*((__RAM struct specialRegister *)0xDA)).bit1)
#define	FPWM0OUT	((*((__RAM struct specialRegister *)0xDA)).bit0)
#define	TC0C	(*((__RAM unsigned int*)0xDB))
#define	STKP	(*((__RAM unsigned int*)0xDF))
#define	FGIE	((*((__RAM struct specialRegister *)0xDF)).bit7)
#define	FSTKPB3	((*((__RAM struct specialRegister *)0xDF)).bit3)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xDF)).bit2)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xDF)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xDF)).bit0)
#define	P1UR	(*((__RAM unsigned int*)0xE1))
#define	FP13R	((*((__RAM struct specialRegister *)0xE1)).bit3)
#define	FP12R	((*((__RAM struct specialRegister *)0xE1)).bit2)
#define	FP11R	((*((__RAM struct specialRegister *)0xE1)).bit1)
#define	FP10R	((*((__RAM struct specialRegister *)0xE1)).bit0)
#define	P2UR	(*((__RAM unsigned int*)0xE2))
#define	FP21R	((*((__RAM struct specialRegister *)0xE2)).bit1)
#define	FP20R	((*((__RAM struct specialRegister *)0xE2)).bit0)
#define	P5UR	(*((__RAM unsigned int*)0xE5))
#define	FP55R	((*((__RAM struct specialRegister *)0xE5)).bit5)
#define	FP54R	((*((__RAM struct specialRegister *)0xE5)).bit4)
#define	FP53R	((*((__RAM struct specialRegister *)0xE5)).bit3)
#define	FP52R	((*((__RAM struct specialRegister *)0xE5)).bit2)
#define	FP51R	((*((__RAM struct specialRegister *)0xE5)).bit1)
#define	FP50R	((*((__RAM struct specialRegister *)0xE5)).bit0)
#define	_YZ	(*((__RAM unsigned int*)0xE7))
#define	DP1X	(*((__RAM unsigned int*)0xE7))
#define	STK7L	(*((__RAM unsigned int*)0xf0))
#define	STK7H	(*((__RAM unsigned int*)0xf1))
#define	STK6L	(*((__RAM unsigned int*)0xf2))
#define	STK6H	(*((__RAM unsigned int*)0xf3))
#define	STK5L	(*((__RAM unsigned int*)0xf4))
#define	STK5H	(*((__RAM unsigned int*)0xf5))
#define	STK4L	(*((__RAM unsigned int*)0xf6))
#define	STK4H	(*((__RAM unsigned int*)0xf7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#if ICE_Mode == 1
#define	P3M	(*((__RAM unsigned int*)0xC3))
#define	FP37M	((*((__RAM struct specialRegister *)0xC3)).bit7)
#define	FP36M	((*((__RAM struct specialRegister *)0xC3)).bit6)
#define	FP35M	((*((__RAM struct specialRegister *)0xC3)).bit5)
#define	FP34M	((*((__RAM struct specialRegister *)0xC3)).bit4)
#define	FP33M	((*((__RAM struct specialRegister *)0xC3)).bit3)
#define	FP32M	((*((__RAM struct specialRegister *)0xC3)).bit2)
#define	FP31M	((*((__RAM struct specialRegister *)0xC3)).bit1)
#define	FP30M	((*((__RAM struct specialRegister *)0xC3)).bit0)
#define	P4M	(*((__RAM unsigned int*)0xC4))
#define	FP47M	((*((__RAM struct specialRegister *)0xC4)).bit7)
#define	FP46M	((*((__RAM struct specialRegister *)0xC4)).bit6)
#define	FP45M	((*((__RAM struct specialRegister *)0xC4)).bit5)
#define	FP44M	((*((__RAM struct specialRegister *)0xC4)).bit4)
#define	FP43M	((*((__RAM struct specialRegister *)0xC4)).bit3)
#define	FP42M	((*((__RAM struct specialRegister *)0xC4)).bit2)
#define	FP41M	((*((__RAM struct specialRegister *)0xC4)).bit1)
#define	FP40M	((*((__RAM struct specialRegister *)0xC4)).bit0)
#define	P3	(*((__RAM unsigned int*)0xD3))
#define	FP37	((*((__RAM struct specialRegister *)0xD3)).bit7)
#define	FP36	((*((__RAM struct specialRegister *)0xD3)).bit6)
#define	FP35	((*((__RAM struct specialRegister *)0xD3)).bit5)
#define	FP34	((*((__RAM struct specialRegister *)0xD3)).bit4)
#define	FP33	((*((__RAM struct specialRegister *)0xD3)).bit3)
#define	FP32	((*((__RAM struct specialRegister *)0xD3)).bit2)
#define	FP31	((*((__RAM struct specialRegister *)0xD3)).bit1)
#define	FP30	((*((__RAM struct specialRegister *)0xD3)).bit0)
#define	P4	(*((__RAM unsigned int*)0xD4))
#define	FP47	((*((__RAM struct specialRegister *)0xD4)).bit7)
#define	FP46	((*((__RAM struct specialRegister *)0xD4)).bit6)
#define	FP45	((*((__RAM struct specialRegister *)0xD4)).bit5)
#define	FP44	((*((__RAM struct specialRegister *)0xD4)).bit4)
#define	FP43	((*((__RAM struct specialRegister *)0xD4)).bit3)
#define	FP42	((*((__RAM struct specialRegister *)0xD4)).bit2)
#define	FP41	((*((__RAM struct specialRegister *)0xD4)).bit1)
#define	FP40	((*((__RAM struct specialRegister *)0xD4)).bit0)
#define	P3UR	(*((__RAM unsigned int*)0xE3))
#define	FP37R	((*((__RAM struct specialRegister *)0xE3)).bit7)
#define	FP36R	((*((__RAM struct specialRegister *)0xE3)).bit6)
#define	FP35R	((*((__RAM struct specialRegister *)0xE3)).bit5)
#define	FP34R	((*((__RAM struct specialRegister *)0xE3)).bit4)
#define	FP33R	((*((__RAM struct specialRegister *)0xE3)).bit3)
#define	FP32R	((*((__RAM struct specialRegister *)0xE3)).bit2)
#define	FP31R	((*((__RAM struct specialRegister *)0xE3)).bit1)
#define	FP30R	((*((__RAM struct specialRegister *)0xE3)).bit0)
#define	P4UR	(*((__RAM unsigned int*)0xE4))
#define	FP47R	((*((__RAM struct specialRegister *)0xE4)).bit7)
#define	FP46R	((*((__RAM struct specialRegister *)0xE4)).bit6)
#define	FP45R	((*((__RAM struct specialRegister *)0xE4)).bit5)
#define	FP44R	((*((__RAM struct specialRegister *)0xE4)).bit4)
#define	FP43R	((*((__RAM struct specialRegister *)0xE4)).bit3)
#define	FP42R	((*((__RAM struct specialRegister *)0xE4)).bit2)
#define	FP41R	((*((__RAM struct specialRegister *)0xE4)).bit1)
#define	FP40R	((*((__RAM struct specialRegister *)0xE4)).bit0)
#endif
#endif
