include chip.h
DECLARE_STORE2_ICEMode EQU 1
include sn8cc_macros.asm
include 1909EV.h

INCLUDESTD	MACRO1.H

PUBLIC __STORE2_ICEMode_isr

; Store 2 bytes to @YZ points
; A: low byte
; R: high byte
; T: low byte backup
; Note: Only low byte will be written to SFRs

IF ICE_Mode==1
	extern code @@delayTime_isr;
	IF SO_1937==1
		extern code Parallel_Write_isr;  //Sol add this for support  xmov 2007.01.03
		extern code Parallel_Read_isr;  //Sol add this for support  xmov 2007.01.03
	ELSE
		extern code SIO_isr;  //Sol add this for support  xmov 2007.01.03
	ENDIF
ENDIF

_x_c__STORE2_ICEMode_isr segment CODE INBANK
__STORE2_ICEMode_isr:

	;bankup the low byte
	B0MOV T, A

	;check bank, if is not 0, it does not point to SFR
	B0MOV A, Y
	CMPRS A, #0
	JMP _STORE_ATYZ
/*********************************************************/
;judge rang is between 0x90 ~ 0x9f?	
	B0MOV A, Z
	SUB A,#0x90
	B0BTS1 FC
	JMP _STORE_ATYZ

  B0MOV A, Z
	CMPRS A, #0xa0
	B0BTS0 FC
	JMP _STORE_ATYZ

/********************************************************/ 
  ;Z store addr, T store value
  ;XB0MOV   MACRO	REG,VAL 	
  B0MOV A, T
  
	b0mov	R_Temp2_isr,a	; save a value
	b0mov	a, Z			; get address value
	b0mov	R_Temp0_isr,a	; save value in R_tamp0

IF RBANK != 0					
	B0mov	a,RBANK			; 
	B0mov	R_Temp3_isr,a	; Save RBANK data to R_Temp3						
	mov	a,#00H		; 
	b0mov	RBANK,a			; Change to RBANK0
ENDIF
	
	b0bclr	R_Temp0_isr.7	; use bit7 mark to write mode flag.
	
	IF SO_1937==1	
		call	Parallel_Write_isr	; sned write address to emulation board
		;call	@@delayTime	; waiting for emulation board procrss command & address
		b0mov	a,R_Temp2_isr	; load data to SIO buffer
		b0mov	R_Temp0_isr,a	;	
		call	Parallel_Write_isr	; send data into emulation board address 
	ELSE
		call	SIO_isr		; sned write address to emulation board
		call	@@delayTime_isr	; waiting for emulation board procrss command & address
		b0mov	a,R_Temp2_isr	; load data to SIO buffer
		b0mov	R_Temp0_isr,a	;	
		call	SIO_isr		; send data into emulation board address 
	ENDIF	

IF RBANK != 0		
	b0mov	a,R_Temp3_isr		; 
	b0mov	RBANK,a			; Re-Load RBANK data from R_Temp3				
ENDIF
	
	b0mov	a,R_Temp2_isr	; for keep "Acc" value
/********************************************************/
JMP _RET

_STORE_ATYZ:
	;write low byte
	B0MOV A, T
	B0MOV @YZ, A
	//2006-12-06 HY modified for run-time library optimization
	;MOV A, #1
	;B0ADD Z, A
	__SelectBANKCNST 0
	INCMS Z
	;write high byte
	B0MOV A, R
	B0MOV @YZ, A
_RET:	
	RET
