#ifndef __SN8PC20__H
#define __SN8PC20__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	L	(*((__RAM unsigned int*)0x80))
#define	H	(*((__RAM unsigned int*)0x81))
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FGG	((*((__RAM struct specialRegister *)0x86)).bit3)
#define	FNPD	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FNT0	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	P0M	(*((__RAM unsigned int*)0xb8))
#define	FP00M	((*((__RAM struct specialRegister *)0xb8)).bit0)
#define	FP01M	((*((__RAM struct specialRegister *)0xb8)).bit1)
#define	FP03M	((*((__RAM struct specialRegister *)0xb8)).bit3)
#define	FP04M	((*((__RAM struct specialRegister *)0xb8)).bit4)
#define	FP05M	((*((__RAM struct specialRegister *)0xb8)).bit5)
#define	FP06M	((*((__RAM struct specialRegister *)0xb8)).bit6)
#define	FP07M	((*((__RAM struct specialRegister *)0xb8)).bit7)
#define	PEDGE	(*((__RAM unsigned int*)0xbf))
#define	FP00G1	((*((__RAM struct specialRegister *)0xbf)).bit4)
#define	FP00G0	((*((__RAM struct specialRegister *)0xbf)).bit3)
#define	P1W	(*((__RAM unsigned int*)0xc0))
#define	P1M	(*((__RAM unsigned int*)0xc1))
#define	FP10M	((*((__RAM struct specialRegister *)0xc1)).bit0)
#define	FP11M	((*((__RAM struct specialRegister *)0xc1)).bit1)
#define	FP12M	((*((__RAM struct specialRegister *)0xc1)).bit2)
#define	FP13M	((*((__RAM struct specialRegister *)0xc1)).bit3)
#define	FP14M	((*((__RAM struct specialRegister *)0xc1)).bit4)
#define	FP15M	((*((__RAM struct specialRegister *)0xc1)).bit5)
#define	FP16M	((*((__RAM struct specialRegister *)0xc1)).bit6)
#define	FP17M	((*((__RAM struct specialRegister *)0xc1)).bit7)
#define	P5M	(*((__RAM unsigned int*)0xc5))
#define	FP50M	((*((__RAM struct specialRegister *)0xc5)).bit0)
#define	FP54M	((*((__RAM struct specialRegister *)0xc5)).bit4)
#define	INTRQ	(*((__RAM unsigned int*)0xc8))
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	INTEN	(*((__RAM unsigned int*)0xc9))
#define	FP00IEN	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	FT0IEN	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	OSCM	(*((__RAM unsigned int*)0xca))
#define	FCPUM1	((*((__RAM struct specialRegister *)0xca)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xca)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xca)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0xca)).bit1)
#define	WDTR	(*((__RAM unsigned int*)0xcc))
#define	IRR	(*((__RAM unsigned int*)0xcd))
#define	PCL	(*((__RAM unsigned int*)0xce))
#define	PCH	(*((__RAM unsigned int*)0xcf))
#define	P0	(*((__RAM unsigned int*)0xd0))
#define	FP00	((*((__RAM struct specialRegister *)0xd0)).bit0)
#define	FP01	((*((__RAM struct specialRegister *)0xd0)).bit1)
#define	FP02	((*((__RAM struct specialRegister *)0xd0)).bit2)
#define	FP03	((*((__RAM struct specialRegister *)0xd0)).bit3)
#define	FP04	((*((__RAM struct specialRegister *)0xd0)).bit4)
#define	FP05	((*((__RAM struct specialRegister *)0xd0)).bit5)
#define	FP06	((*((__RAM struct specialRegister *)0xd0)).bit6)
#define	FP07	((*((__RAM struct specialRegister *)0xd0)).bit7)
#define	P1	(*((__RAM unsigned int*)0xd1))
#define	FP10	((*((__RAM struct specialRegister *)0xd1)).bit0)
#define	FP11	((*((__RAM struct specialRegister *)0xd1)).bit1)
#define	FP12	((*((__RAM struct specialRegister *)0xd1)).bit2)
#define	FP13	((*((__RAM struct specialRegister *)0xd1)).bit3)
#define	FP14	((*((__RAM struct specialRegister *)0xd1)).bit4)
#define	FP15	((*((__RAM struct specialRegister *)0xd1)).bit5)
#define	FP16	((*((__RAM struct specialRegister *)0xd1)).bit6)
#define	FP17	((*((__RAM struct specialRegister *)0xd1)).bit7)
#define	P5	(*((__RAM unsigned int*)0xd5))
#define	FP50	((*((__RAM struct specialRegister *)0xd5)).bit0)
#define	FP54	((*((__RAM struct specialRegister *)0xd5)).bit4)
#define	T0M	(*((__RAM unsigned int*)0xd8))
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xd8)).bit4)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xd8)).bit5)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xd8)).bit6)
#define	FT0ENB	((*((__RAM struct specialRegister *)0xd8)).bit7)
#define	T0C	(*((__RAM unsigned int*)0xd9))
#define	IRM	(*((__RAM unsigned int*)0xda))
#define	FCREN	((*((__RAM struct specialRegister *)0xda)).bit0)
#define	FIREN	((*((__RAM struct specialRegister *)0xda)).bit1)
#define	IRC	(*((__RAM unsigned int*)0xdb))
#define	STKP	(*((__RAM unsigned int*)0xdf))
#define	FGIE	((*((__RAM struct specialRegister *)0xdf)).bit7)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xdf)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xdf)).bit0)
#define	P0UR	(*((__RAM unsigned int*)0xe0))
#define	P1UR	(*((__RAM unsigned int*)0xe1))
#define	P5UR	(*((__RAM unsigned int*)0xe5))
#define	_HL	(*((__RAM unsigned int*)0xe6))
#define	_YZ	(*((__RAM unsigned int*)0xe7))
#define	IRD	(*((__RAM unsigned int*)0xe8))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#endif
