
;------------------------------------------------------------------------------
;  CHIP: SN8A1604A, MASK Only
;  Revision History:
;  V1.0  09/01/2002  First issue
;
;  V3.0  03/12/2004  Change Stack level from "4" to "8"
;  V4.0   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Asse0mbly	INC_VER		4
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	80h

.Assembly	INSTRUMENT	SN8A1604A

.Assembly	MASK_BODY_SIZE	0x1200
;.Assembly	OTP_BODY_SIZE
.Assembly	USER_ROM_SIZE	0x1000
;.Assembly	OTP_TEST_SIZE

.Assembly	MASK_TEST_FILE	SN8A1604A
;.Assembly	OTP_TEST_FILE
.Assembly	MASK_TEST_CODE	0x3600, 0x9003, 0x0000, 0x908B
.Assembly	Port_Pins	4, 8, 8, 0, 0, 4
.Assembly	COMMAND		RETLW

.Assembly	OPTION		0		Watch_Dog	Enable	Disable
.Assembly	OPTION		1		Pull_Up		Enable	By_PUR
.Assembly	OPTION		2		Int_16K_RC	Always_ON	By_CPUM
.Assembly	OPTION		3		Fix_High
.Assembly	OPTION		4		High_Clk/2	Enable	Disable
.Assembly	OPTION		5		High_Clk	RC	32K_X'tal	12M_X'tal	4M_X'tal
.Assembly	OPTION		7		OSG		Enable	Disable
.Assembly	OPTION		8		Rst_P03		P03	RST
.Assembly	OPTION		9 : 15	Fix_High
.Assembly	OPTION		2ffh

	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
	PFLAG		EQU		0x86
		FZ		EQU		0x86.0
		FDC		EQU		0x86.1
		FC		EQU		0x86.2
;		FNPD	EQU_R	0x86.6
;		FNT0	EQU_R	0x86.7

	PUR			EQU_W	0BEH
		FPUR5	EQU_W	PUR.5
		FPUR2	EQU_W	PUR.2
		FPUR1	EQU_W	PUR.1
		FPUR0	EQU_W	PUR.0

	PEDGE		EQU		0BFH
		FPEDGEN	EQU		PEDGE.7
		FP00G1	EQU		PEDGE.4
		FP00G0	EQU		PEDGE.3

	P1W			EQU_W	0C0H
		FP17W	EQU_W	P1W.7
		FP16W	EQU_W	P1W.6
		FP15W	EQU_W	P1W.5
		FP14W	EQU_W	P1W.4
		FP13W	EQU_W	P1W.3
		FP12W	EQU_W	P1W.2
		FP11W	EQU_W	P1W.1
		FP10W	EQU_W	P1W.0

	P1M			EQU		0C1H
		FP17M	EQU		P1M.7
		FP16M	EQU		P1M.6
		FP15M	EQU		P1M.5
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0

	P2M			EQU		0C2H
		FP27M	EQU		P2M.7
		FP26M	EQU		P2M.6
		FP25M	EQU		P2M.5
		FP24M	EQU		P2M.4
		FP23M	EQU		P2M.3
		FP22M	EQU		P2M.2
		FP21M	EQU		P2M.1
		FP20M	EQU		P2M.0

	P5M			EQU		0C5H
		FP53M	EQU		P5M.3
		FP52M	EQU		P5M.2
		FP51M	EQU		P5M.1
		FP50M	EQU		P5M.0

	INTRQ		EQU		0C8H
		FTC1IRQ	EQU	INTRQ.6
		FP00IRQ	EQU	INTRQ.0

	INTEN		EQU		0C9H
		FTC1IEN	EQU	INTEN.6
		FP00IEN	EQU	INTEN.0

	OSCM		EQU		0CAH
;		FWTCKS	EQU	OSCM.7
		FWDRST	EQU	OSCM.6
		FCPUM0	EQU	OSCM.3
		FCLKMD	EQU	OSCM.2
		FSTPHX	EQU	OSCM.1

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU_R	0D0H
		FP03	EQU_R	P0.3
		FP02	EQU_R	P0.2
		FP01	EQU_R	P0.1
		FP00	EQU_R	P0.0

	P1			EQU		0D1H
		FP17	EQU		P1.7
		FP16	EQU		P1.6
		FP15	EQU		P1.5
		FP14	EQU		P1.4
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0

	P2			EQU		0D2H
		FP27	EQU		P2.7
		FP26	EQU		P2.6
		FP25	EQU		P2.5
		FP24	EQU		P2.4
		FP23	EQU		P2.3
		FP22	EQU		P2.2
		FP21	EQU		P2.1
		FP20	EQU		P2.0

	P5			EQU		0D5H
		FP53	EQU		P5.3
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0

	TC1M		EQU		0DCH
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
;		FTC1CKS		EQU	TC1M.3
		FALOAD1		EQU	TC1M.2
		FTC1OUT		EQU	TC1M.1
		FPWM1OUT	EQU	TC1M.0

	TC1C		EQU		0DDH
	TC1R		EQU_W	0DEH

	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
;		FSTKPB3	EQU		STKP.3
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	@YZ			EQU		0E7H
	DP1X		EQU		0E7H

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh


; @SET_PUR macro will maintain the compatibility of PUR (MASK) and PnUR (OTP).
; If you want to set pull-up register in MASK, use @SET_PUR macro to replace 
; setting PUR register.

	@SET_PUR	macro	val

		IF	val !& 0D8h
			ERROR	@SET_PUR value error, valid value is 00X0-0XXX
			exitm
		ENDIF

		mov		a, #val
		DC		0x2FBE		; B0MOV	PUR, A

		endm

.TEXT
{
	//{{SONIX_SMOV_S8KD
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	0F 08 01 8F -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 00
	-1 -1 -1 -1 -1 -1 80 00   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 00 00 -1 -1 -1   -1 -1 -1 -1 -1 -1 27 -1
	FF -1 -1 -1 -1 -1 -1 -1   -1 41 8C -1 -1 -1 -1 -1
	87 FF FF 00 00 0F 00 00   00 -1 00 -1 -1 -1 -1 00
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	87 00 DF 7F    -1
	02 E0 FF 00    02 E1 FF 00    02 E2 FF 00    02 E5 FF 00    -1
	0001  71 00 01    0004  72 10 00	0100  D0 08 00    -1
	//}}SONIX_SMOV_S8KD


	//{{SONIX_OPTION_RULE
	IF	High_Clk == RC
	{
		High_Clk/2	=	Enable
	}

	IF	High_Clk == 32K_X'tal
	{
		OSG			=	Enable
	}

	ENDP
	//}}SONIX_OPTION_RULE

	; V2.0:		11/15/2002
	;			change 0xD0 from 8F to 87,
	;			change code option to SMOV table: (0004 72 11 01) to (0004 72 10 00)
	;			add	   code option to SMOV table: (0100 D0 08 00)
}
