
;------------------------------------------------------------------------------
;  CHIP: SN8F26E68L
;  Revision History: Refer to SN8F26E68.INC
;  Version         : Refer to SN8F26E68.INC
;  01/21/2014  1. refer to SN8F26E68.inc.
;              2. remove LVD_MAX.
;------------------------------------------------------------------------------
.ASSEMBLY	RedWrt_FORMAT   1
.Assembly	INC_VER		1
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	1024

.Assembly	INSTRUMENT	SN8F26E68
.Assembly	BIT_FILE	SN8F26E68

.Assembly	OTP_BODY_SIZE	0x4000
.Assembly	USER_ROM_SIZE	0x3FF8

.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000

.Assembly	PGM_TYPE	6
.Assembly	CHIP_ID		0x3730
.Assembly	command		Enable_ORG4_7, EB_ICE, PCL_READ_LIMIT
.Assembly	Port_Pins	8, 8, 6, 8, 8, 8

; Code Option 0x3FFF
.Assembly	OPTION		0		Noise_Filter	Disable	Enable
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		High_Fcpu	Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
.Help
{
	High_Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		5		High_Clk	IHRC_16M IHRC_RTC x x Ext_RC 32K_X'tal 12M_X'tal 4M_X'tal
.Help
{	
	IHRC_16M	:	"Internal 16M RC Oscillator"
	IHRC_RTC	:	"Internal 16M RC Oscillator with RTC.\n" \
	                	"Connect 32.768K crystal to Xin/Xout"

	Ext_RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	32K_X'tal	:	"32.768K Crystal"
	12M_X'tal	:	"Crystal/Resonator: 10Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~10Mhz"
}
.Assembly	OPTION		8		Low_Fcpu	Flosc/1 Flosc/2 Flosc/4 Flosc/8
.Help
{
	Low_Fcpu		: 	"Only Effective for Low Clock"
}
.Assembly	OPTION		10		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x
.Assembly	OPTION		14		Fix_High
.Assembly	OPTION		15		Fix_High

; Code Option 0x3FFE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x3FFD
.Assembly	OPTION		32 		Fix_High
.Assembly	OPTION		33 		Fix_High
.Assembly	OPTION		34 		Fix_High
.Assembly	OPTION		35 		Fix_High
.Assembly	OPTION		36 		Fix_High
.Assembly	OPTION		37 		Fix_High
.Assembly	OPTION		38 		Fix_High
.Assembly	OPTION		39 		Fix_High
.Assembly	OPTION		40 		Fix_High
;.Assembly	OPTION		41		LVD     	LVD_Max	LVD_H	LVD_M	LVD_L
;LVD_Max		:	"3.3V Reset"	
.Assembly	OPTION		41		LVD     	x	LVD_H	LVD_M	LVD_L
.Help
{
	LVD_L		:	"1.8V Reset"
	LVD_M		:	"1.8V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
	LVD_H		:	"2.4V Reset\nEnable LVD33 bit of PFLAG for\n3.3V Low Voltage Indicator"	
}
.Assembly	OPTION		43 		Fix_High
.Assembly	OPTION		44		Reset_Pin   P22 Reset
.Assembly	OPTION		45		Fix_High
.Assembly	OPTION		46 		WDT_CLK	Flosc/4 Flosc/8 Flosc/16 Flosc/32

; Code Option 0x3FFC

.Assembly	OPTION		48		Fix_High
.Assembly	OPTION		49		Fix_Low
.Assembly	OPTION		50		Fix_Low
.Assembly	OPTION		51		Fix_Low
.Assembly	OPTION		52		Fix_High
.Assembly	OPTION		53		Fix_High
.Assembly	OPTION		54		Fix_High
.Assembly	OPTION		55		Fix_High
.Assembly	OPTION		56 		Fix_High
.Assembly	OPTION		57 		Fix_High	
.Assembly	OPTION		58 : 63 	Fix_High



.Assembly	OPTION		2ffh

	L			EQU		080H
	H			EQU		081H
	R			EQU		082H
	Z			EQU		083H
	Y			EQU		084H
	X			EQU		085H

	PFLAG		EQU		086H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FSTKOV		EQU_R		PFLAG.4
		FRST		EQU_R		PFLAG.5
		FWDT		EQU_R		PFLAG.6
		FPOR		EQU_R		PFLAG.7

	RBANK		EQU		087H
		FRBANKS0	EQU		RBANK.0
		FRBANKS1	EQU		RBANK.1
		FRBANKS2	EQU		RBANK.2

	W0			EQU		088H
	W1			EQU		089H
	W2			EQU		08AH
	W3			EQU		08BH
	W4			EQU		08CH
	W5			EQU		08DH
	W6			EQU		08EH
	W7			EQU		08FH

	@HL			EQU		090H
	@YZ			EQU		091H
	P2OC			EQU		092H
		FP20OC 	EQU  		P2OC.0
		FP21OC 	EQU  		P2OC.1
		FP24OC 	EQU  		P2OC.4
		FP25OC 	EQU  		P2OC.5
		FP05OC 	EQU  		P2OC.6
		FP06OC 	EQU  		P2OC.7
	PCL			EQU		093H
	PCH			EQU		094H

	OSCM		EQU		095H
		FCPUM1	EQU		OSCM.4
		FCPUM0	EQU		OSCM.3
		FCLKMD	EQU		OSCM.2
		FSTPHX	EQU		OSCM.1

	WDTR		EQU_W	096H

					
					
	INTRQ0		EQU		097H
		FT1IRQ	EQU		INTRQ0.6
		FTC2IRQ	EQU		INTRQ0.5
		FTC1IRQ	EQU		INTRQ0.4
		FTC0IRQ	EQU		INTRQ0.3	
		FT0IRQ  EQU		INTRQ0.2
		FP01IRQ	EQU		INTRQ0.1
		FP00IRQ	EQU		INTRQ0.0

      INTRQ1		EQU		098H
                FMSPIRQ	EQU		INTRQ1.4
		FUTXIRQ EQU             INTRQ1.3
                FURXIRQ EQU             INTRQ1.2                
		FSIOIRQ	EQU		INTRQ1.1
		FWAKEIRQ EQU		INTRQ1.0

       INTEN0		EQU		09AH
		FT1IEN	EQU		INTEN0.6
		FTC2IEN	EQU		INTEN0.5
		FTC1IEN	EQU		INTEN0.4
		FTC0IEN	EQU		INTEN0.3		
		FT0IEN  EQU	    	INTEN0.2
		FP01IEN	EQU		INTEN0.1
		FP00IEN	EQU		INTEN0.0

 
       INTEN1		EQU		09BH                 
                FMSPIEN	EQU		INTEN1.4
		FUTXIEN EQU             INTEN1.3
                FURXIEN EQU             INTEN1.2
                FSIOIEN	EQU		INTEN1.1
		FWAKEIEN EQU		INTEN1.0

	P1W		EQU		099H
		FP17W	EQU		P1W.7
		FP16W	EQU		P1W.6
		FP15W	EQU		P1W.5
		FP14W	EQU		P1W.4
		FP13W	EQU		P1W.3
		FP12W	EQU		P1W.2
		FP11W	EQU		P1W.1
		FP10W	EQU		P1W.0

	PEDGE		EQU		09FH		
		FP01G1	EQU		PEDGE.3
		FP01G0	EQU		PEDGE.2
		FP00G1	EQU		PEDGE.1
		FP00G0	EQU		PEDGE.0	  	


	P0M		EQU		0A0H
	        FP07M	EQU		P0M.7
	        FP06M	EQU		P0M.6
	        FP05M	EQU		P0M.5		
		FP04M	EQU		P0M.4
		FP03M	EQU		P0M.3
		FP02M	EQU		P0M.2
		FP01M	EQU		P0M.1
		FP00M	EQU		P0M.0


	P1M		EQU		0A1H
		FP17M	EQU		P1M.7
		FP16M	EQU		P1M.6
		FP15M	EQU		P1M.5
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0
		
	P2M		EQU		0A2H
		FP25M	EQU		P2M.5
		FP24M	EQU		P2M.4
		FP23M	EQU		P2M.3
		FP22M	EQU		P2M.2
		FP21M	EQU		P2M.1
		FP20M	EQU		P2M.0

	P3M		EQU		0A3H
		FP37M	EQU		P3M.7
		FP36M	EQU		P3M.6
		FP35M	EQU		P3M.5
		FP34M	EQU		P3M.4
		FP33M	EQU		P3M.3
		FP32M	EQU		P3M.2
		FP31M	EQU		P3M.1
		FP30M	EQU		P3M.0

	P4M		EQU		0A4H
		FP47M	EQU		P4M.7
		FP46M	EQU		P4M.6
		FP45M	EQU		P4M.5
		FP44M	EQU		P4M.4
		FP43M	EQU		P4M.3
		FP42M	EQU		P4M.2
		FP41M	EQU		P4M.1
		FP40M	EQU		P4M.0
		
	P5M		EQU		0A5H
		FP57M	EQU		P5M.7
		FP56M	EQU		P5M.6
		FP55M	EQU		P5M.5
  		FP54M	EQU		P5M.4
  		FP53M	EQU		P5M.3	  		
  		FP52M	EQU		P5M.2
  		FP51M	EQU		P5M.1
  		FP50M	EQU		P5M.0	
  		
	P0		EQU 	0A6H
	        FP07	EQU 	P0.7
	        FP06	EQU 	P0.6
	        FP05	EQU 	P0.5		
		FP04	EQU 	P0.4
		FP03	EQU 	P0.3
		FP02	EQU 	P0.2
		FP01	EQU 	P0.1
		FP00	EQU 	P0.0

	P1		EQU 	0A7H
		FP17	EQU 	P1.7
		FP16	EQU 	P1.6
		FP15	EQU 	P1.5
		FP14	EQU 	P1.4
		FP13	EQU 	P1.3
		FP12	EQU 	P1.2
		FP11	EQU 	P1.1
		FP10	EQU 	P1.0
		
	P2              EQU    0A8H
		FP25	EQU	P2.5
		FP24	EQU	P2.4
		FP23	EQU	P2.3
		FP22	EQU	P2.2
		FP21	EQU	P2.1
		FP20	EQU	P2.0	

	P3		EQU 	0A9H
		FP37	EQU 	P3.7
		FP36	EQU 	P3.6
		FP35	EQU 	P3.5
		FP34	EQU 	P3.4
		FP33	EQU 	P3.3
		FP32	EQU 	P3.2
		FP31	EQU 	P3.1
		FP30	EQU 	P3.0

	P4		EQU 	0AAH
		FP47	EQU 	P4.7
		FP46	EQU 	P4.6
		FP45	EQU 	P4.5
		FP44	EQU 	P4.4
		FP43	EQU 	P4.3
		FP42	EQU 	P4.2
		FP41	EQU 	P4.1
		FP40	EQU 	P4.0

	P5		EQU    0ABH
		FP57	EQU	P5.7
		FP56	EQU	P5.6	
		FP55	EQU	P5.5
		FP54	EQU	P5.4
		FP53	EQU	P5.3		
		FP52	EQU	P5.2
		FP51	EQU	P5.1
		FP50	EQU	P5.0	

  	P0UR        EQU     0ACH
	    	FP00R   EQU  	P0UR.0
	    	FP01R   EQU  	P0UR.1
	    	FP02R   EQU  	P0UR.2		
	    	FP03R   EQU  	P0UR.3
	    	FP04R   EQU  	P0UR.4
	    	FP05R   EQU  	P0UR.5
	    	FP06R   EQU  	P0UR.6
	    	FP07R   EQU  	P0UR.7

	P1UR        EQU     0ADH
	    	FP10R   EQU  	P1UR.0
	    	FP11R   EQU  	P1UR.1
	    	FP12R   EQU  	P1UR.2		
	    	FP13R   EQU  	P1UR.3
	    	FP14R   EQU  	P1UR.4
	    	FP15R   EQU  	P1UR.5
	    	FP16R   EQU  	P1UR.6
	    	FP17R   EQU  	P1UR.7

    	P2UR        EQU     0AEH
	    	FP20R   EQU  	P2UR.0
	    	FP21R   EQU  	P2UR.1
	    	FP22R   EQU  	P2UR.2		
	    	FP23R   EQU  	P2UR.3
	    	FP24R   EQU  	P2UR.4
	    	FP25R   EQU  	P2UR.5

	P3UR        EQU     0AFH
	    	FP30R   EQU  	P3UR.0
	    	FP31R   EQU  	P3UR.1
	    	FP32R   EQU  	P3UR.2		
	    	FP33R   EQU  	P3UR.3
	    	FP34R   EQU  	P3UR.4
	    	FP35R   EQU  	P3UR.5
	    	FP36R   EQU  	P3UR.6
	    	FP37R   EQU  	P3UR.7

	P4UR        EQU     0B0H
	    	FP40R   EQU  	P4UR.0
	    	FP41R   EQU  	P4UR.1
	    	FP42R   EQU  	P4UR.2		
	    	FP43R   EQU  	P4UR.3
	    	FP44R   EQU  	P4UR.4
	    	FP45R   EQU  	P4UR.5
	    	FP46R   EQU  	P4UR.6
	    	FP47R   EQU  	P4UR.7
    	P5UR        EQU     0B1H
	    	FP50R   EQU  	P5UR.0
	    	FP51R   EQU  	P5UR.1
	    	FP52R   EQU  	P5UR.2		
	    	FP53R   EQU  	P5UR.3
	    	FP54R   EQU  	P5UR.4
	    	FP55R   EQU  	P5UR.5
	    	FP56R   EQU  	P5UR.6
	    	FP57R   EQU  	P5UR.7

	T0M			EQU	0B2H
		FT0ENB	 	EQU  	T0M.7
		FT0RATE2 	EQU  	T0M.6
		FT0RATE1 	EQU  	T0M.5
		FT0RATE0 	EQU  	T0M.4
		FT0TB	 	EQU  	T0M.0

	T0C			EQU	0B3H

	TC0M			EQU	0B4H
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		FTC0CKS1	EQU	TC0M.3
    		FTC0CKS0 	EQU 	TC0M.2
		FTC0PO		EQU 	TC0M.1
  		FPWM0OUT  	EQU 	TC0M.0 

 	TC0C			EQU	0B5H	
	TC0R			EQU_W	0B6H
	TC0D			EQU	0B7H
		
	TC1M		EQU		0B8H
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
		FTC1CKS1	EQU	TC1M.3
    		FTC1CKS0  	EQU 	TC1M.2
		FTC1PO		EQU 	TC1M.1
    		FPWM1OUT  	EQU 	TC1M.0 
    	TC1C			EQU	0B9H	
	TC1R			EQU_W	0BAH
	TC1D			EQU	0BBH

        TC2M		EQU		0BCH
		FTC2ENB		EQU	TC2M.7
		FTC2RATE2	EQU	TC2M.6
		FTC2RATE1	EQU	TC2M.5
		FTC2RATE0	EQU	TC2M.4
		FTC2CKS1	EQU	TC2M.3
    		FTC2CKS0  	EQU 	TC2M.2
		FTC2PO		EQU 	TC2M.1
    		FPWM2OUT  	EQU 	TC2M.0 
	TC2C			EQU	0BDH	
	TC2R			EQU_W	0BEH
	TC2D			EQU	0BFH
		
	T1M		EQU	0C0H
		FT1VCOV		EQU	T1M.0
		FT1OV		EQU	T1M.1
		FCPTStart	EQU	T1M.2
		FCPTCKS		EQU	T1M.3
		FT1rate0	EQU	T1M.4
		FT1rate1	EQU	T1M.5
		FT1rate2	EQU	T1M.6
		FT1ENB		EQU	T1M.7

	T1CL		EQU	0C1H
	T1CH		EQU	0C2H
	T1VCL		EQU	0C4H
	T1VCH		EQU	0C5H

	PECMD			EQU_W		0DBH
	PEROML			EQU		0DCH	
	PEROMH			EQU		0DDH
	PERAML			EQU		0DEH
	PERAMCNT		EQU		0DFH

	SIOM			EQU		0E0H
		FSENB		EQU	SIOM.7
		FSTART		EQU	SIOM.6
		FSRATE1		EQU	SIOM.5
		FSRATE0		EQU	SIOM.4
		FMLSB		EQU	SIOM.3
		FSCKMD		EQU	SIOM.2
		FCPOL		EQU	SIOM.1
		FCPHA		EQU	SIOM.0

	SIOR			EQU_W		0E1H
	SIOB			EQU		0E2H	

        URTX	                EQU             0E4H  
                FUTXEN           EQU             URTX.7
                FUTXPEN          EQU             URTX.6
                FUTXPS           EQU             URTX.5
                FUTXBRK          EQU             URTX.4
                FURXBZ           EQU_R           URTX.3
                FUTXBZ           EQU_R           URTX.2
                FMSPMX           EQU           	 URTX.1
                FSIOMX           EQU           	 URTX.0


        URRX	                EQU             0E5H
                FURXEN           EQU             URRX.7
                FURXPEN          EQU             URRX.6
                FURXPS           EQU             URRX.5
                FURXPC           EQU             URRX.4
                FUFMER           EQU             URRX.3
                FURS2            EQU             URRX.2
                FURS1            EQU             URRX.1
                FURS0            EQU             URRX.0

        URCR                  EQU             0E6H
        UTXD                  EQU             0E7H
        URXD                  EQU             0E8H
            
;***************I2C CONTROL REGISTER*****************
MSPSTAT		EQU		0EAH
		FCKE		EQU		MSPSTAT.6
		FD_A		EQU_R		MSPSTAT.5
		FP		EQU_R		MSPSTAT.4
		FS		EQU_R		MSPSTAT.3
		FRED_WRT	EQU_R		MSPSTAT.2
		FBF		EQU_R		MSPSTAT.0
		
		MSPM1		EQU		0EBH
		FWCOL		EQU		MSPM1.7
		FMSPOV		EQU		MSPM1.6
		FMSPENB		EQU		MSPM1.5
                FCKP            EQU             MSPM1.4
                FSLRXCKP        EQU             MSPM1.3
		FMSPWK		EQU		MSPM1.2
		FMSPC		EQU		MSPM1.0
		
		MSPM2		EQU		0ECH
		FGCEN		EQU		MSPM2.7
		FACKSTAT	EQU		MSPM2.6
		FACKDT		EQU		MSPM2.5
		FACKEN		EQU		MSPM2.4
		FRCEN		EQU		MSPM2.3
		FPEN		EQU		MSPM2.2
		FRSEN		EQU		MSPM2.1
		FSEN		EQU		MSPM2.0
		
		MSPBUF		EQU		0EDH
		FMSPBUF7	EQU		MSPBUF.7
		FMSPBUF6	EQU		MSPBUF.6
		FMSPBUF5	EQU		MSPBUF.5
		FMSPBUF4	EQU		MSPBUF.4
		FMSPBUF3	EQU		MSPBUF.3
		FMSPBUF2	EQU		MSPBUF.2
		FMSPBUF1	EQU		MSPBUF.1
		FMSPBUF0	EQU		MSPBUF.0
		
		MSPADR		EQU		0EEH
		FMSPADR7	EQU		MSPADR.7
		FMSPADR6	EQU		MSPADR.6
		FMSPADR5	EQU		MSPADR.5
		FMSPADR4	EQU		MSPADR.4
		FMSPADR3	EQU		MSPADR.3
		FMSPADR2	EQU		MSPADR.2
		FMSPADR1	EQU		MSPADR.1
		FMSPADR0	EQU		MSPADR.0


	STKP		EQU		0EFH
		FGIE	EQU		STKP.7
		FLVD24	EQU_R		STKP.6
		FLVD33	EQU_R		STKP.5
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h

	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

; -----------------------------------------------------
; Clear watchdog macro. 
;  
; Total Cycle: 2

	@RST_WDT	macro
		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------		
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}			  								