
;------------------------------------------------------------------------------
;  CHIP: SN8P2213
;  Revision History
;  
;  V01	10/09/2006
;  V02  12/17/2007  "GreenMode","SleepMode","SlowMode","Slow2Normal" macro programs. 
;  V03  04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;	 V04  06/30/2010	SLowMode ---> SlowMode
;  V05  07/12/2012 	1. Add "PCL_READ_LIMIT" Key word
;  V06	08/27/2013	1. Modify the USTATUS.5 & USTATUS.6 to read only.
;			2. Modify the FUE1M1 & FUE2M1 to read only.
;			3. Modify the UPID bit0~bit2 to write only.
;			4. Add the P0UR bit0~bit4 to write only.
;			5. Add the P5UR bit0~bit2 to write only.
;			6. Add the P1OC bit0~bit3 to write only.
;			7. Add the STKnH(n=0~7) bit0~bit4 define.
;------------------------------------------------------------------------------
.Assembly	INC_VER		5
.ASSEMBLY RedWrt_FORMAT    1
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	192

.Assembly	INSTRUMENT	SN8P2213
.Assembly	BIT_FILE	SN8P2213

.Assembly	OTP_BODY_SIZE	0x1000
.Assembly	USER_ROM_SIZE	0x0FFB

;.Assembly	OTP_TEST_SIZE	0x00A0
;.Assembly	MASK_TEST_FILE	SN8A1602A
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	SN86P
.Assembly	PGM_TYPE	6
.Assembly	CHIP_ID		0x2300
.Assembly	command		Enable_ORG4_7, RBANK_LIMIT, GREEN_NOP_LIMIT, PCL_READ_LIMIT
.Assembly	Port_Pins	6, 8, 0, 0, 0, 3

.Assembly	USB_FIFO_Size	40, 40

; Code Option 0x0FFF
.Assembly	OPTION		0		Fix_Low
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 x
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		4		High_Clk	x x x 6M_X'tal
.Help
{
;	IHRC_6M		:	"Internal 6M RC Oscillator"
;	IHRC_RTC	:	"Internal 6M RC Oscillator with RTC\nConnect 32768Hz crytal to XIN/XOUT"
	6M_X'tal		:	"Crystal/Resonator: 6Mhz"
}
.Assembly	OPTION		6 : 7		Fix_High
.Assembly	OPTION		8		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x
.Assembly	OPTION		12		Reset_Pin   P05 	Reset
;.Assembly	OPTION		13		Rst_Length  No 128*ILRC
.Assembly	OPTION		13		Fix_High
.Assembly	OPTION		14		Fix_Low
;.Assembly	OPTION		15		SMODE3      Disable Enable
.Assembly	OPTION		15		Fix_Low

; Code Option 0x0FFE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x0FFD
.Assembly	OPTION		32 		Fix_low
.Assembly	OPTION		33 		Fix_low
.Assembly	OPTION		34 		Fix_High
.Assembly	OPTION		35 		Fix_High
.Assembly	OPTION		36 		Fix_High
.Assembly	OPTION		37 		Fix_High
.Assembly	OPTION		38 		Fix_low
.Assembly	OPTION		39 		Fix_low
.Assembly	OPTION		40 		Fix_High
.Assembly	OPTION		41 		Fix_High
.Assembly	OPTION		42 		Fix_High
.Assembly	OPTION		43 		Fix_High
.Assembly	OPTION		44 		Fix_High
.Assembly	OPTION		45 		Fix_High
.Assembly	OPTION		46 		Fix_low
.Assembly	OPTION		47		Fix_low

; Code Option 0x0FFC
.Assembly	OPTION		48 		Fix_low
.Assembly	OPTION		49 		Fix_High
.Assembly	OPTION		50 		Fix_low
.Assembly	OPTION		51 		Fix_low
.Assembly	OPTION		52 : 63 		Fix_High

.Assembly	OPTION		2ffh

	R			EQU		82H
	Z			EQU		83H
	Y			EQU		84H
	
	PFLAG		EQU		86H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FNPD	EQU		PFLAG.6
		FNT0	EQU		PFLAG.7

	RBANK		EQU		87H
		FRBNKS0	EQU		RBANK.0

	UDA			EQU		0A0H
		FUDE	EQU		UDA.7
		FUDA6	EQU		UDA.6
		FUDA5	EQU		UDA.5
		FUDA4	EQU		UDA.4
		FUDA3	EQU		UDA.3
		FUDA2	EQU		UDA.2
		FUDA1	EQU		UDA.1
		FUDA0	EQU		UDA.0

	USTATUS	EQU		0A1H				
		FBUSRST		EQU_R		USTATUS.6
		FUSUSPEND	EQU_R		USTATUS.5
		FUEP0SETUP	EQU		USTATUS.4
		FUEP0IN		EQU		USTATUS.3
		FUEP0OUT	EQU		USTATUS.2
		FUEP1ACK	EQU		USTATUS.1
		FUEP2ACK	EQU		USTATUS.0	
	
	UCTRL		EQU		0A2H
		FFFS2	EQU_R		UCTRL.7
		FFFS1	EQU_R		UCTRL.6
		FFFS0	EQU_R		UCTRL.5
		FUEP0OC4	EQU		UCTRL.4
		FUEP0OC3	EQU		UCTRL.3
		FUEP0OC2	EQU		UCTRL.2
		FUEP0OC1	EQU		UCTRL.1
		FUEP0OC0	EQU		UCTRL.0
	
	UE0R		EQU		0A3H
		FUE0M1	EQU		UE0R.6
		FUE0M0	EQU		UE0R.5
		FUE0C3	EQU		UE0R.3
		FUE0C2	EQU		UE0R.2
		FUE0C1	EQU		UE0R.1
		FUE0C0	EQU		UE0R.0

	UE1R		EQU		0A4H
		FUE1E	EQU		UE1R.7
		FUE1M1	EQU_R		UE1R.6
		FUE1M0	EQU		UE1R.5
		FUE1C4	EQU		UE1R.4
		FUE1C3	EQU		UE1R.3
		FUE1C2	EQU		UE1R.2
		FUE1C1	EQU		UE1R.1
		FUE1C0	EQU		UE1R.0

	UE2R		EQU		0A5H
		FUE2E	EQU		UE2R.7
		FUE2M1	EQU_R		UE2R.6
		FUE2M0	EQU		UE2R.5
		FUE2C4	EQU		UE2R.4
		FUE2C3	EQU		UE2R.3
		FUE2C2	EQU		UE2R.2
		FUE2C1	EQU		UE2R.1
		FUE2C0	EQU		UE2R.0

	UDP0		EQU		0A6H
		FUDP05	EQU		UDP0.5
		FUDP04	EQU		UDP0.4
		FUDP03	EQU		UDP0.3
		FUDP02	EQU		UDP0.2
		FUDP01	EQU		UDP0.1
		FUDP00	EQU		UDP0.0

	UDR0		EQU		0A7H
		FUDR07	EQU		UDR0.7
		FUDR06	EQU		UDR0.6
		FUDR05	EQU		UDR0.5
		FUDR04	EQU		UDR0.4
		FUDR03	EQU		UDR0.3
		FUDR02	EQU		UDR0.2
		FUDR01	EQU		UDR0.1
		FUDR00	EQU		UDR0.0

	UDP1		EQU		0A8H
		FUDP15	EQU		UDP1.5
		FUDP14	EQU		UDP1.4
		FUDP13	EQU		UDP1.3
		FUDP12	EQU		UDP1.2
		FUDP11	EQU		UDP1.1
		FUDP10	EQU		UDP1.0

	UDR1		EQU		0A9H
		FUDR17	EQU		UDR1.7
		FUDR16	EQU		UDR1.6
		FUDR15	EQU		UDR1.5
		FUDR14	EQU		UDR1.4
		FUDR13	EQU		UDR1.3
		FUDR12	EQU		UDR1.2
		FUDR11	EQU		UDR1.1
		FUDR10	EQU		UDR1.0

	UPID		EQU		0AAH
		FUBDE	EQU_W		UPID.2
		FDDP		EQU_W		UPID.1
		FDDN		EQU_W		UPID.0

	EP1OUT_CNT		EQU		0ABH
		FEP1OC4	EQU		EP1OUT_CNT.4
		FEP1OC3	EQU		EP1OUT_CNT.3
		FEP1OC2	EQU		EP1OUT_CNT.2
		FEP1OC1	EQU		EP1OUT_CNT.1
		FEP1OC0	EQU		EP1OUT_CNT.0

	EP2OUT_CNT		EQU		0ACH
		FEP2OC4	EQU		EP2OUT_CNT.4
		FEP2OC3	EQU		EP2OUT_CNT.3
		FEP2OC2	EQU		EP2OUT_CNT.2
		FEP2OC1	EQU		EP2OUT_CNT.1
		FEP2OC0	EQU		EP2OUT_CNT.0

	SIOM			EQU		0B4H
		FSENB		EQU		SIOM.7
		FSTART	EQU		SIOM.6
		FSRATE1	EQU		SIOM.5
		FSRATE0	EQU		SIOM.4
		FSCKMD	EQU		SIOM.2
		FSEDGE	EQU		SIOM.1
		FTXRX		EQU		SIOM.0

	SIOR			EQU_W		0B5H
	SIOB			EQU		0B6H

	P0M			EQU		0B8H
		FP04M	EQU		P0M.4
		FP03M	EQU		P0M.3
		FP02M	EQU		P0M.2
		FP01M	EQU		P0M.1
		FP00M	EQU		P0M.0

	PEDGE		EQU		0BFH		
		FP00G1	EQU		PEDGE.4
		FP00G0	EQU		PEDGE.3

	P1W			EQU_W		0C0H
		FP17W	EQU_W		P1W.7
		FP16W	EQU_W		P1W.6
		FP15W	EQU_W		P1W.5
		FP14W	EQU_W		P1W.4
		FP13W	EQU_W		P1W.3
		FP12W	EQU_W		P1W.2
		FP11W	EQU_W		P1W.1
		FP10W	EQU_W		P1W.0

	P1M			EQU		0C1H
		FP17M	EQU		P1M.7
		FP16M	EQU		P1M.6
		FP15M	EQU		P1M.5
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0

	P5M			EQU		0C5H  		
  		FP52M	EQU		P5M.2
  		FP51M	EQU		P5M.1
  		FP50M	EQU		P5M.0

	INTRQ		EQU		0C8H
		FUSBIRQ	EQU		INTRQ.6
		FTC0IRQ	EQU		INTRQ.5
		FT0IRQ	EQU		INTRQ.4
		FSIOIRQ	EQU		INTRQ.3	
		FWAKEIRQ EQU	INTRQ.1	
		FP00IRQ	EQU		INTRQ.0

	INTEN		EQU		0C9H
		FUSBIEN	EQU		INTEN.6
		FTC0IEN	EQU		INTEN.5
		FT0IEN	EQU		INTEN.4
		FSIOIEN	EQU		INTEN.3		
		FWAKEIEN EQU	INTEN.1
		FP00IEN	EQU		INTEN.0

	OSCM		EQU		0CAH
		FCPUM1	EQU		OSCM.4
		FCPUM0	EQU		OSCM.3
		FCLKMD	EQU		OSCM.2
		FSTPHX	EQU		OSCM.1

	WDTR		EQU_W	0CCH
    
	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU 	0D0H		
		FP05	EQU_R 	P0.5
		FP04	EQU 	P0.4
		FP03	EQU 	P0.3
		FP02	EQU 	P0.2
		FP01	EQU 	P0.1
		FP00	EQU 	P0.0

	P1			EQU 	0D1H
		FP17	EQU 	P1.7
		FP16	EQU 	P1.6
		FP15	EQU 	P1.5
		FP14	EQU 	P1.4
		FP13	EQU 	P1.3
		FP12	EQU 	P1.2
		FP11	EQU 	P1.1
		FP10	EQU 	P1.0

	P5			EQU		0D5H		
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0
		
	T0M			EQU		0D8H
		FT0ENB     EQU	T0M.7
		FT0RATE2   EQU	T0M.6
		FT0RATE1   EQU	T0M.5
		FT0RATE0   EQU	T0M.4

	T0C			EQU		0D9H

	TC0M		EQU		0DAH
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4

	TC0C		EQU		0DBH

	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

    P0UR        EQU_W     0E0H
		FP04R	EQU_W		P0UR.4
		FP03R	EQU_W		P0UR.3
		FP02R	EQU_W		P0UR.2
		FP01R	EQU_W		P0UR.1
		FP00R	EQU_W		P0UR.0

    P1UR        EQU_W     0E1H

    P5UR        EQU_W     0E5H
      		FP52R	EQU_W		P5UR.2
		FP51R	EQU_W		P5UR.1
		FP50R	EQU_W		P5UR.0 

	@YZ			EQU		0E7H

	P1OC		EQU_W	0E9H
		FP52OC	EQU_W		P1OC.3
		FP50OC	EQU_W		P1OC.2
		FP11OC	EQU_W		P1OC.1
		FP10OC	EQU_W		P1OC.0

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
		FS7PC12	EQU		STK7H.4
		FS7PC11	EQU		STK7H.3
		FS7PC10	EQU		STK7H.2
		FS7PC9	EQU		STK7H.1
		FS7PC8	EQU		STK7H.0
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
		FS6PC12	EQU		STK6H.4
		FS6PC11	EQU		STK6H.3
		FS6PC10	EQU		STK6H.2
		FS6PC9	EQU		STK6H.1
		FS6PC8	EQU		STK6H.0
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
		FS5PC12	EQU		STK5H.4
		FS5PC11	EQU		STK5H.3
		FS5PC10	EQU		STK5H.2
		FS5PC9	EQU		STK5H.1
		FS5PC8	EQU		STK5H.0
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
		FS4PC12	EQU		STK4H.4
		FS4PC11	EQU		STK4H.3
		FS4PC10	EQU		STK4H.2
		FS4PC9	EQU		STK4H.1
		FS4PC8	EQU		STK4H.0

	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
		FS3PC12	EQU		STK3H.4
		FS3PC11	EQU		STK3H.3
		FS3PC10	EQU		STK3H.2
		FS3PC9	EQU		STK3H.1
		FS3PC8	EQU		STK3H.0
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
		FS2PC12	EQU		STK2H.4
		FS2PC11	EQU		STK2H.3
		FS2PC10	EQU		STK2H.2
		FS2PC9	EQU		STK2H.1
		FS2PC8	EQU		STK2H.0
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
		FS1PC12	EQU		STK1H.4
		FS1PC11	EQU		STK1H.3
		FS1PC10	EQU		STK1H.2
		FS1PC9	EQU		STK1H.1
		FS1PC8	EQU		STK1H.0
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh
		FS0PC12	EQU		STK0H.4
		FS0PC11	EQU		STK0H.3
		FS0PC10	EQU		STK0H.2
		FS0PC9	EQU		STK0H.1
		FS0PC8	EQU		STK0H.0

; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------	
	
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}
