
;------------------------------------------------------------------------------
;  CHIP: SN8P26L34 
;  Revision History
;  
;  V01   10/16/2006  1. First issue and only for SN8ICE 2K.
;  V02   12/17/2007  1. "GreenMode","SleepMode","SlowMode","Slow2Normal" macro programs. 
;  V03   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;  V04   06/29/2010  1. modify MACRO text "SLowMode" to "SlowMode"
;  V05   05/25/2011  1. Add watchdog discription (.Help {XXXX})	
;		     2. modified LVD_H discription
;		     3. PFLAG.5 : FLVD36 >> FLVD28
;------------------------------------------------------------------------------
.ASSEMBLY	RedWrt_FORMAT	1
.Assembly	INC_VER		5
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	240

.Assembly	INSTRUMENT	SN8P26L34
.Assembly	BIT_FILE	SN8P26L34

.Assembly	OTP_BODY_SIZE	0x2000
.Assembly	USER_ROM_SIZE	0x1FFC

;.Assembly	OTP_TEST_SIZE	0x00A0
;.Assembly	MASK_TEST_FILE	SN8A1602A
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	SN86P
.Assembly	PGM_TYPE	12
.Assembly	CHIP_ID		0x3220
.Assembly	command		Enable_ORG4_7, RBANK_LIMIT, GREEN_B0BSET_LIMIT
.Assembly	Port_Pins	5, 8, 8, 0, 0, 5

; Code Option 0x1FFF
.Assembly	OPTION		0		Fix_High
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		4		Fix_High
.Assembly	OPTION		5		High_Clk	IHRC_8M IHRC_RTC x x Ext_RC  32K_X'tal  8M_X'tal  4M_X'tal
.Help
{
	IHRC_8M		:	"Internal 8M RC Oscillator"
	IHRC_RTC	:	"Internal 8M RC Oscillator with RTC\nConnect 32768Hz crytal to XIN/XOUT"
	Ext_RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	32K_X'tal	:	"32.768K Crystal"
	8M_X'tal	:	"Crystal/Resonator: 8Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~8Mhz"
}
.Assembly	OPTION		8		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen and Sleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
}
.Assembly	OPTION		12		Reset_Pin   P02 	Reset
;.Assembly	OPTION		13		Rst_Length  No 128*ILRC
.Assembly	OPTION		13		Fix_High
;.Assembly	OPTION		14		LVDB        No 2_ILRC 4_ILRC 8_ILRC
.Assembly	OPTION		14		Fix_Low
.Assembly	OPTION		15		Fix_Low

; Code Option 0x1FFE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_Low

; Code Option 0x1FFD
.Assembly	OPTION		32 : 40		Fix_High
.Assembly	OPTION		41		LVD     	x	LVD_H	LVD_M	LVD_L
.Help
{
	LVD_L		:	"1.8V Reset"
	LVD_M		:	"1.8V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
	LVD_H		:	"2.4V Reset\nEnable LVD28 bit of PFLAG for\n2.8V Low Voltage Indicator"	
} 

.Assembly	OPTION		43 : 63	Fix_High

.Assembly	OPTION		2ffh

	L			EQU		80H
	H			EQU		81H
	R			EQU		82H
	Z			EQU		83H
	Y			EQU		84H
	
	PFLAG			EQU		86H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FLVD24		EQU_R		PFLAG.4
		FLVD28		EQU_R		PFLAG.5
		FNPD		EQU		PFLAG.6
		FNT0		EQU		PFLAG.7

	RBANK			EQU		087H
		FBANKS0		EQU		RBANK.0

	CMP0M			EQU		09CH
		FCMS0		EQU		CMP0M.0
		FCMS1		EQU		CMP0M.1
		FCM0OUT		EQU		CMP0M.2
		FCM0REF		EQU		CMP0M.3
		FCM0OEN		EQU		CMP0M.4
		FCM0IRQ		EQU		CMP0M.5
		FCM0IEN		EQU		CMP0M.6
		FCM0EN		EQU		CMP0M.7

	CMP1M			EQU		09DH
		FCM1OUT		EQU		CMP1M.2
		FCM1REF		EQU		CMP1M.3
		FCM1OEN		EQU		CMP1M.4
		FCM1IRQ		EQU		CMP1M.5
		FCM1IEN		EQU		CMP1M.6
		FCM1EN		EQU		CMP1M.7

	P0M			EQU		0B8H
		FP00M		EQU		P0M.0
		FP01M		EQU		P0M.1
		FP03M		EQU		P0M.3
		FP04M		EQU		P0M.4

	PEDGE			EQU		0BFH		
		FP00G1		EQU		PEDGE.4
		FP00G0		EQU		PEDGE.3

	P1W			EQU_W		0C0H

	P1M			EQU		0C1H
		FP10M		EQU		P1M.0
		FP11M		EQU		P1M.1
		FP12M		EQU		P1M.2
		FP13M		EQU		P1M.3
		FP14M		EQU		P1M.4
		FP15M		EQU		P1M.5
		FP16M		EQU		P1M.6
		FP17M		EQU		P1M.7

	P2M			EQU		0C2H
		FP20M		EQU		P2M.0
		FP21M		EQU		P2M.1
		FP22M		EQU		P2M.2
		FP23M		EQU		P2M.3
		FP24M		EQU		P2M.4
		FP25M		EQU		P2M.5
		FP26M		EQU		P2M.6
		FP27M		EQU		P2M.7

	P5M			EQU		0C5H
  		FP50M		EQU		P5M.0
  		FP51M		EQU		P5M.1
  		FP52M		EQU		P5M.2
  		FP53M		EQU		P5M.3
  		FP54M		EQU		P5M.4

	INTRQ			EQU		0C8H
		FP00IRQ		EQU		INTRQ.0
		FP01IRQ		EQU		INTRQ.1
		FT0IRQ		EQU		INTRQ.4
		FTC1IRQ		EQU		INTRQ.6

	INTEN			EQU		0C9H
		FP00IEN		EQU		INTEN.0
		FP01IEN		EQU		INTEN.1
		FT0IEN		EQU		INTEN.4
		FTC1IEN		EQU		INTEN.6

	OSCM			EQU		0CAH
		FCPUM1		EQU		OSCM.4
		FCPUM0		EQU		OSCM.3
		FCLKMD		EQU		OSCM.2
		FSTPHX		EQU		OSCM.1

	WDTR			EQU_W		0CCH

	TC0R			EQU_W		0CDH       

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU		0D0H
		FP00		EQU 		P0.0
		FP01		EQU 		P0.1
		FP02		EQU 		P0.2
		FP03		EQU 		P0.3
		FP04		EQU 		P0.4

	P1			EQU 		0D1H
		FP10		EQU 		P1.0
		FP11		EQU 		P1.1
		FP12		EQU 		P1.2
		FP13		EQU 		P1.3
		FP14		EQU 		P1.4
		FP15		EQU 		P1.5
		FP16		EQU 		P1.6
		FP17		EQU 		P1.7

	P2			EQU		0D2H
		FP20		EQU		P2.0
		FP21		EQU		P2.1
		FP22		EQU		P2.2
		FP23		EQU		P2.3
		FP24		EQU		P2.4
		FP25		EQU		P2.5
		FP26		EQU		P2.6
		FP27		EQU		P2.7

	P5			EQU		0D5H
		FP50		EQU		P5.0
		FP51		EQU		P5.1
		FP52		EQU		P5.2
		FP53		EQU		P5.3
		FP54		EQU		P5.4
		
	T0M			EQU		0D8H
		FT0TB		EQU		T0M.0
		FT0RATE0	EQU		T0M.4
		FT0RATE1	EQU		T0M.5
		FT0RATE2	EQU		T0M.6
		FT0ENB		EQU		T0M.7

	T0C			EQU		0D9H

	TC0M			EQU		0DAH
		FCREN		EQU		TC0M.0
		FIREN		EQU		TC0M.1

	TC0C			EQU		0DBH

	TC1M			EQU		0DCH
		FTC1ENB		EQU		TC1M.7
		FTC1RATE2	EQU		TC1M.6
		FTC1RATE1	EQU		TC1M.5
		FTC1RATE0	EQU		TC1M.4
		FTC1CKS		EQU		TC1M.3
		FALOAD1    	EQU		TC1M.2
		FTC1OUT    	EQU		TC1M.1
		FPWM1OUT   	EQU		TC1M.0 

	TC1C			EQU		0DDH

	TC1R			EQU_W		0DEH


	STKP			EQU		0DFH
		FGIE		EQU		STKP.7
		FSTKPB2		EQU		STKP.2
		FSTKPB1		EQU		STKP.1
		FSTKPB0		EQU		STKP.0

	P0UR			EQU_W		0E0H

	P1UR			EQU_W		0E1H

	P2UR			EQU_W		0E2H

	P5UR			EQU_W		0E5H

	@HL			EQU		0E6H
	@YZ			EQU		0E7H

	TC0D			EQU		0E8H

	P1OC			EQU_W		0E9H
	    FP11OC		EQU_W		P1OC.1
	    FP10OC		EQU_W		P1OC.0

	STK7L			EQU		0F0h
	STK7H			EQU		0F1h
	STK6L			EQU		0F2h
	STK6H			EQU		0F3h
	STK5L			EQU		0F4h
	STK5H			EQU		0F5h
	STK4L			EQU		0F6h
	STK4H			EQU		0F7h
	STK3L			EQU		0F8h
	STK3H			EQU		0F9h
	STK2L			EQU		0FAh
	STK2H			EQU		0FBh
	STK1L			EQU		0FCh
	STK1H			EQU		0FDh
	STK0L			EQU		0FEh
	STK0H			EQU		0FFh
; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		B0BSET	0xFF.7
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------	
	
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}
