
;------------------------------------------------------------------------------
;  CHIP: SN8P2711A
;  Revision History
;  
;  V01   06/08/2007  1. First issue and only for SN8ICE 2K.
;  V02   12/17/2007  1. "GreenMode","SleepMode","SlowMode","Slow2Normal" macro programs. 
;  V03   04/23/2008  1. Limit Fcpu 1T, 2T rate when Noise_Filter enable.
;  V04   06/29/2010  1. modify MACRO text "SLowMode" to "SlowMode"
;  V05   08/27/2010  1. delect T0C register.
;  V06   08/23/2013  1. Modeify Pflag register property
;------------------------------------------------------------------------------
.Assembly	INC_VER		6
.ASSEMBLY	RedWrt_FORMAT   1
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	64

.Assembly	INSTRUMENT	SN8P2711A
.Assembly	BIT_FILE	SN8P2711A

.Assembly	OTP_BODY_SIZE	0x0400
.Assembly	USER_ROM_SIZE	0x03FC

;.Assembly	OTP_TEST_SIZE	0x00A0
;.Assembly	MASK_TEST_FILE	SN8A1602A
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	SN86P
.Assembly	PGM_TYPE	8
.Assembly	CHIP_ID		0x6110
.Assembly	command		Enable_ORG4_7, STACK_LIMIT, GREEN_NOP_LIMIT
.Assembly	Port_Pins	5, 0, 0, 0, 5, 2

; Code Option 0x03FF
.Assembly	OPTION		0		Noise_Filter	Disable Enable	
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 x x x Fosc/16
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		5		High_Clk	IHRC_16M x x x Ext_RC 32K_X'tal 12M_X'tal 4M_X'tal
.Help
{	
	IHRC_16M	:	"Internal 16M RC Oscillator"
	Ext_RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	32K_X'tal	:	"32.768K Crystal"
	12M_X'tal	:	"Crystal/Resonator: 10Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~10Mhz"
}
.Assembly	OPTION		8		Watch_Dog 	Always_On x x x x Enable x x x x Disable x x x x x 
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen and Sleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
} 
.Assembly	OPTION		12		Reset_Pin 	P04	Reset
.Assembly	OPTION   	13		Fix_High
.Assembly	OPTION   	14		Fix_High
.Assembly	OPTION   	15		Fix_High

; Code Option 0x03FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x03FD
.Assembly	OPTION		32 : 40	Fix_High
.Assembly	OPTION		41		LVD     	x LVD_H	LVD_M	LVD_L
.Help
{
	LVD_L		:	"2.0V Reset"
	LVD_M		:	"2.0V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
	LVD_H		:	"2.4V Reset\nEnable LVD36 bit of PFLAG for\n3.6V Low Voltage Indicator"	
}
.Assembly	OPTION		43	Fix_Low
.Assembly	OPTION		44	Fix_Low

.Assembly	OPTION		45 : 63	Fix_High

.Assembly	OPTION		2ffh

	R			EQU		82H
	Z			EQU		83H
	Y			EQU		84H
	
	PFLAG			EQU		86H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FLVD24	EQU_R		PFLAG.4
		FLVD36	EQU_R		PFLAG.5
		FNPD	EQU		PFLAG.6
		FNT0	EQU		PFLAG.7

	P4CON			EQU		0AEH

	VREFH 		EQU		0AFH
		FVHS0   EQU     VREFH.0
		FVHS1   EQU     VREFH.1
		FEVHENB EQU     VREFH.7

	ADM			EQU		0xB1
		FADENB	EQU		ADM.7
		FADS	EQU		ADM.6
		FEOC	EQU		ADM.5
		FGCHS	EQU		ADM.4
		FCHS2	EQU		ADM.2
		FCHS1	EQU		ADM.1
		FCHS0	EQU		ADM.0
		
	ADB			EQU_R	0B2H

	ADR			EQU	0B3H
		FADCKS1	EQU		ADR.6
		FADCKS0	EQU		ADR.4
		FADB3	EQU_R		ADR.3
		FADB2	EQU_R		ADR.2
		FADB1	EQU_R		ADR.1
		FADB0	EQU_R		ADR.0		

	P0M			EQU		0B8H
		FP00M	EQU		P0M.0
		FP01M	EQU		P0M.1
		FP02M	EQU		P0M.2
		FP03M	EQU		P0M.3

	PEDGE		EQU		0BFH		
		FP00G1	EQU		PEDGE.4
		FP00G0	EQU		PEDGE.3

	P4M			EQU		0C4H
  		FP40M	EQU		P4M.0
  		FP41M	EQU		P4M.1
  		FP42M	EQU		P4M.2
  		FP43M	EQU		P4M.3
  		FP44M	EQU		P4M.4

	P5M			EQU		0C5H
  		FP53M	EQU		P5M.3
  		FP54M	EQU		P5M.4

	INTRQ		EQU		0C8H
		FP00IRQ	EQU		INTRQ.0
		FP01IRQ	EQU		INTRQ.1
		FTC0IRQ	EQU		INTRQ.5
		FTC1IRQ	EQU		INTRQ.6
		FADCIRQ	EQU		INTRQ.7

	INTEN		EQU		0C9H
		FP00IEN	EQU		INTEN.0
		FP01IEN	EQU		INTEN.1
		FTC0IEN	EQU		INTEN.5
		FTC1IEN	EQU		INTEN.6
		FADCIEN	EQU		INTEN.7

	OSCM		EQU		0CAH
		FCPUM1	EQU		OSCM.4
		FCPUM0	EQU		OSCM.3
		FCLKMD	EQU		OSCM.2
		FSTPHX	EQU		OSCM.1

	WDTR		EQU_W	0CCH

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU 	0D0H
		FP00	EQU 	P0.0
		FP01	EQU 	P0.1
		FP02	EQU 	P0.2
		FP03	EQU 	P0.3
		FP04	EQU_R 	P0.4

	P4			EQU		0D4H
		FP40	EQU		P4.0
		FP41	EQU		P4.1
		FP42	EQU		P4.2
		FP43	EQU		P4.3
		FP44	EQU		P4.4
		
	P5			EQU		0D5H
		FP53	EQU		P5.3
		FP54	EQU		P5.4
		
	T0M			EQU		0D8H
		FTC0GN	   EQU	T0M.1
		FTC0X8	   EQU	T0M.2
		FTC1X8	   EQU	T0M.3

	TC0M		EQU		0DAH
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		FTC0CKS		EQU	TC0M.3
	       	FALOAD0    	EQU	TC0M.2
       		FTC0OUT    	EQU	TC0M.1
	       	FPWM0OUT   	EQU	TC0M.0 

	TC0C		EQU		0DBH

	TC0R		EQU_W	0CDH

	TC1M		EQU		0DCH
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
		FTC1CKS		EQU	TC1M.3
	       	FALOAD1    	EQU	TC1M.2
       		FTC1OUT    	EQU	TC1M.1
	       	FPWM1OUT   	EQU	TC1M.0 

	TC1C		EQU		0DDH

	TC1R		EQU_W		0DEH

	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	P0UR        	EQU_W     	0E0H
	P4UR        	EQU_W     	0E4H
	P5UR        	EQU_W     	0E5H


	@YZ			EQU		0E7H


	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------	
.TEXT
{
	//{{SONIX_OPTION_RULE
	IF Noise_Filter == Enable
	{
		OPTION		2		Fcpu		x x Fosc/4 Fosc/8 x x x Fosc/16
  	}
	ELSE	
	{
		OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 x x x Fosc/16
  	}      
	ENDP
	//}}SONIX_OPTION_RULE
}