
;------------------------------------------------------------------------------
;  CHIP: SN8P2947, OTP Only.
;  Revision History:
;  V1.0  06/10/2010  First issue - Modified from 1937T
;  V1.1  09/10/2010  Add P11IO and LBTSEL2 @95H
;  V1.2  10/01/2010  1. Add RedWrt_FORMAT key word 
;		     2. Add PullUp_P0 key word 
;  V1.3  10/11/2010  Add LCDM1.7 = FLCDREF 
;  V1.4  12/27/2010  1. Add LCDM2.3 = FVCP3, LCDM2.4=FVPPINTL
;		     2. ChIP_ID=9791 
;		     3. Cancel control bit of FPGIAH.
;		     4. Add Macro "RomwrtVpp" 	 
;  V1.5	 02/08/2011  1. Modify RomwrtVpp Macro; 1/2-Bias selected for 6.5V geration 	
;		     2. Modify USER_ROM_SIZE to "0x07FB"; 0x07FC for VPP drop ISP	
;		     3. ISP VPP fast down via dummy ROMWRT "0000" @0x07FCH 
;  V1.6	 02/28/2011  1. SU89P79C Version. Chip_ID=9792, Add Code_option Bit3 for High_clk_div 
;  V1.7	 06/20/2011  1. SU89P79D Version. Chip_ID=9793, Cancel Code_option Bit3 for High_clk_div
;  V1.8  12/09/2011  1. Modify ISP Macro, add ISP Pass/fail indication. 
;  V1.9	 05/02/2012  1. Modify address:0xXX to XXh
;------------------------------------------------------------------------------
.Assembly	INC_VER		1
.Assembly       RedWrt_FORMAT   1
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	80h

.Assembly	INSTRUMENT	SN8P2947
.Assembly	BIT_FILE	SN8P2947

.Assembly	OTP_BODY_SIZE	0x0800
.Assembly	USER_ROM_SIZE	0x07FB

.Assembly	COMMAND		Enable_ORG4_7, PullUp_P0, Enable_ISP		; Limit org 4~7, unavailible for user
.Assembly	PGM_TYPE	6				; 2's Program Type			
.Assembly	MASK_TEST_CODE	0x0000, 0x000, 0x0000, 0x0000
.Assembly	Port_Pins	8, 2, 0, 0, 0, 0, 0
.Assembly	LCD_Size	12, 4
.Assembly	CHIP_ID		0x9793

; Code Option 0x7FF
.Assembly	OPTION			0		Fix_High	
.Assembly	OPTION			1		Security	Enable	Disable
.Assembly	OPTION			2		High_Clk_DIV	Fhosc/4 Fhosc/8 
.Assembly	OPTION			3 : 7		Fix_High 
.Assembly	OPTION			8		Watch_Dog	x x x x x Enable x x x x Disable x x x x Always_On 
.Assembly	OPTION			12 : 15		Fix_High			

; Code Option 0x7FE
.Assembly	OPTION			16		Fix_Low
.Assembly	OPTION			17		Fix_High
.Assembly	OPTION			18		Fix_Low
.Assembly	OPTION			19		Fix_High
.Assembly	OPTION			20		Fix_High
.Assembly	OPTION			21		Fix_Low
.Assembly	OPTION			22		Fix_High
.Assembly	OPTION			23		Fix_Low
.Assembly	OPTION			24		Fix_Low
.Assembly	OPTION			25		Fix_High
.Assembly	OPTION			26		Fix_Low
.Assembly	OPTION			27 : 31		Fix_High

; Code Option 0x7FD
.Assembly	OPTION			32 : 40		Fix_High ;(IHRC_CAL_Data)
.Assembly	OPTION			41 : 47		Fix_High
;============================================================================

.Assembly	OPTION			48 : 63		Fix_High
.Assembly	OPTION			2ffh


	R			EQU		82h
	Z			EQU		83h
	Y			EQU		84h
	
	PFLAG			EQU		86h
		FC		EQU		PFLAG.2
		FDC		EQU		PFLAG.1
		FZ		EQU		PFLAG.0
		
	RBANK			EQU		87h
		FRBNKS0		EQU		RBANK.0

	LCDM1			EQU		89h
		FLCDREF		EQU		LCDM1.7
		FLCDPENB	EQU		LCDM1.6
		FLCDBNK		EQU		LCDM1.5
		FLCDTYPE	EQU		LCDM1.4
		FLCDENB		EQU		LCDM1.3
		FLCDBIAS	EQU		LCDM1.2		
		FLCDRATE	EQU		LCDM1.1
		FLCDCLK		EQU		LCDM1.0	

	LCDM2			EQU		8Ah	
		FVPPINTL	EQU		LCDM2.4
		FVCP3		EQU		LCDM2.3	
		FVCP2		EQU		LCDM2.2		
		FVCP1		EQU		LCDM2.1
		FVCP0		EQU		LCDM2.0
						
	VREG			EQU		90h
		FBGRENB		EQU		VREG.7
		FACMSEL		EQU		VREG.6
		FACMENB		EQU		VREG.5
		FAVESEL		EQU		VREG.4
		FAVENB		EQU		VREG.3
		FAVDDRENB	EQU		VREG.2

	AMPM1			EQU		91h
		FCHS2		EQU		AMPM1.7
		FCHS1		EQU		AMPM1.6
		FCHS0		EQU		AMPM1.5
		;FPGIAH		EQU		AMPM1.4
		FGS2		EQU		AMPM1.3
		FGS1		EQU		AMPM1.2
		FGS0		EQU		AMPM1.1
		FAMPENB		EQU		AMPM1.0

	AMPM2			EQU		92h
		FUGBH		EQU		AMPM2.7
		FGX		EQU		AMPM2.6
		FGR		EQU		AMPM2.5
		FAMPCKS		EQU		AMPM2.4
		FDTENB		EQU		AMPM2.1
		FDTSEL		EQU		AMPM2.0
		
	ADCM1			EQU		93h
		FRVS		EQU		ADCM1.7
		FIRVS2		EQU		ADCM1.6
		FIRVS1		EQU		ADCM1.5
		FIRVS0		EQU		ADCM1.4
		FADGN2		EQU		ADCM1.3
		FADGN1		EQU		ADCM1.2
		FADGN0		EQU		ADCM1.1
		FADCENB		EQU		ADCM1.0
				
	ADCM2			EQU		94h
		FADCKS		EQU		ADCM2.7
		FOSR2		EQU		ADCM2.6
		FOSR1		EQU		ADCM2.5
		FOSR0		EQU		ADCM2.4
		FADCKSDIV	EQU		ADCM2.3
		FOFSEL1		EQU		ADCM2.2
		FOFSEL0		EQU		ADCM2.1
		FDRDY		EQU		ADCM2.0

	LBTM			EQU		95h
		FP11IO		EQU		LBTM.5
		FLBTSEL2	EQU		LBTM.4
		FLBTSEL1	EQU		LBTM.3
		FLBTSEL0	EQU		LBTM.2
		FLBTO		EQU		LBTM.1
		FLBTENB		EQU		LBTM.0

	ADCDH			EQU_R		96h
	ADCDM			EQU_R		97h
	ADCDL			EQU_R		98h		
		
		
	ROMADRH			EQU		0A0h
		FVPPCHK		EQU_R		ROMADRH.7
		FROMADR10	EQU		ROMADRH.2
		FROMADR9	EQU		ROMADRH.1
		FROMADR8	EQU		ROMADRH.0
			
	ROMADRL			EQU		0A1h	
		FROMADR7	EQU		ROMADRL.7
		FROMADR6	EQU		ROMADRL.6
		FROMADR5	EQU		ROMADRL.5
		FROMADR4	EQU		ROMADRL.4
		FROMADR3	EQU		ROMADRL.3
		FROMADR2	EQU		ROMADRL.2
		FROMADR1	EQU		ROMADRL.1
		FROMADR0	EQU		ROMADRL.0
	
	ROMDAH			EQU		0A2h
		FROMDA15	EQU		ROMDAH.7
		FROMDA14	EQU		ROMDAH.6
		FROMDA13	EQU		ROMDAH.5
		FROMDA12	EQU		ROMDAH.4
		FROMDA11	EQU		ROMDAH.3
		FROMDA10	EQU		ROMDAH.2
		FROMDA9		EQU		ROMDAH.1
		FROMDA8		EQU		ROMDAH.0

	ROMDAL			EQU		0A3h
		FROMDA7		EQU		ROMDAL.7
		FROMDA6		EQU		ROMDAL.6
		FROMDA5		EQU		ROMDAL.5
		FROMDA4		EQU		ROMDAL.4
		FROMDA3		EQU		ROMDAL.3
		FROMDA2		EQU		ROMDAL.2
		FROMDA1		EQU		ROMDAL.1
		FROMDA0		EQU		ROMDAL.0

	ROMCNT			EQU_W		0A4h
		ROMCNT1		EQU_W		ROMCNT.1
		ROMCNT0		EQU_W		ROMCNT.0	

	P0M			EQU		0B8h
		FP07M		EQU		P0M.7
		FP06M		EQU		P0M.6
		FP05M		EQU		P0M.5
		FP04M		EQU		P0M.4
		FP03M		EQU		P0M.3
		FP02M		EQU		P0M.2
		FP01M		EQU		P0M.1
		FP00M		EQU		P0M.0

	PEDGE			EQU		0BFh
		FP00G1		EQU		PEDGE.4
		FP00G0		EQU		PEDGE.3

	P1M			EQU		0C1h
		FP11M		EQU		P1M.1
		FP10M		EQU		P1M.0
	
	INTRQ			EQU		0C8H
		FADCIRQ		EQU		INTRQ.7
		FT0IRQ		EQU		INTRQ.4
		FP00IRQ		EQU		INTRQ.0

	INTEN			EQU		0C9H
		FADCIEN		EQU		INTEN.7
		FT0IEN		EQU		INTEN.4
		FP00IEN		EQU		INTEN.0

	OSCM			EQU		0CAh
		FCPUM1		EQU		OSCM.4
		FCPUM0		EQU		OSCM.3
		FCLKMD		EQU		OSCM.2
		FSTPHX		EQU		OSCM.1

	WDTR			EQU_W		0CCh	
	
	PCL			EQU		0CEh
	PCH			EQU		0CFh

	P0			EQU		0D0H
		FP07		EQU		P0.7
		FP06		EQU		P0.6
		FP05		EQU		P0.5
		FP04		EQU		P0.4
		FP03		EQU		P0.3
		FP02		EQU		P0.2
		FP01		EQU		P0.1
		FP00		EQU		P0.0

	P1			EQU		0D1h
		FP11		EQU		P1.1
		FP10		EQU		P1.0

	T0M			EQU		0D8h
		FT0ENB		EQU		T0M.7
		FT0RATE2	EQU		T0M.6
		FT0RATE1	EQU		T0M.5
		FT0RATE0	EQU		T0M.4

	T0C			EQU		0D9h


	STKP			EQU		0DFh
		FGIE		EQU		STKP.7
		FSTKPB2		EQU		STKP.2
		FSTKPB1		EQU		STKP.1
		FSTKPB0		EQU		STKP.0

	P1UR			EQU_W		0E1h
		FP11R		EQU_W		P1UR.1
		FP10R		EQU_W		P1UR.0

	@YZ			EQU		0E7h	
	
	STK7L			EQU		0F0h
	STK7H			EQU		0F1h
	STK6L			EQU		0F2h
	STK6H			EQU		0F3h
	STK5L			EQU		0F4h
	STK5H			EQU		0F5h
	STK4L			EQU		0F6h
	STK4H			EQU		0F7h
	STK3L			EQU		0F8h
	STK3H			EQU		0F9h
	STK2L			EQU		0FAh
	STK2H			EQU		0FBh
	STK1L			EQU		0FCh
	STK1H			EQU		0FDh
	STK0L			EQU		0FEh
	STK0H			EQU		0FFh
	

; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm

; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm

; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
	
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SLowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm

; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
	
; -----------------------------------------------------
;  ISP ROM-Write with Internal VPP 6.9V Generation macro for compatibility in S8KD-2 ICE
;  Occupied Register: A,Y,Z,R  
;  execution time: 40ms(ISP_OK), 30ms(ISP_Fail)
;  Output status: R_Register (ISP_OK: R=0x5AH;   ISP_Fail: R=0xA5H)

	RomwrtVpp 	macro
	local		ISPP_End,ISP_Delay10ms	

	;==== [ VPP Set 6.9V ] ===================
	MOV	A,#01010101b	; ChargePump start-up setting (CP_Clock=62.2K, 1/2_Bias, C-Type, CP_Enale)
	XCH	a,LCDM1
	B0mov	Y,a		; Original setting of LCDM1 save in "Y" register
	Mov	a,#11111111b	; Set VCP=1111 and VPPINTL=1. (VPP set 6.9V and VPP-VLCD short)
	XCH	a,LCDM2
	B0mov	z,a		; Original setting of LCDM2 save in "Z" register
	Call	ISP_Delay10ms	; for VPP 6.9V stable 

	;==== [ ISP ROM Write Command ] ===========
	B0BTS1 	FVPPCHK		; VPP High Voltage check
	jmp	$+5
	Call	ISP_Delay10ms	; for VPP 6.9V stable
	ROMWRT			; ISP ROM Write Instruction
	nop			; must nop
	jmp	$+2
	b0bset	FLCDREF		; if VPP voltage Fail, set "LCDREF" for indication.

	;==== [VLCD drop to 2.2V ] ================
	b0bclr	FLCDBIAS		; Set 1/3 Bias
	mov	a,#11110000b		; VLCD=2.2V
	and	LCDM2,a	

	;-- Delay 20ms ---------- 
	Call	ISP_Delay10ms
	Call	ISP_Delay10ms

	;--- Set ISP status ---
	b0mov	r,#5AH		; ISP OK:   R=5AH
	b0bts0	FLCDREF
	SWAPM	R		; ISP Fail: R=A5H

	;===== [ Original LCD seting ] ============
	B0mov	a,z
	b0mov	LCDM2,a		
	B0mov	a,y
	b0mov	LCDM1,a
	jmp	ISPP_End
ISP_Delay10ms:
	;-- Delay 10ms -- 
	clr	R	
	b0mov	a,R	
	incms	R
	jmp	$-1	
	add	a,#1
	cmprs	a,#13
	jmp	$-4
ret
ISPP_End:
	endm
	
; -----------------------------------------------------	
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}