
;-------------------------------------------------------------------------------
;	Crt0 For Chip SN8P1989
;-------------------------------------------------------------------------------

CHIP	SN8P1989

IF ICE_Mode==1
	extern data R_Temp3, R_Temp2, R_Temp1, R_Temp0;
	extern data R_Temp3_isr, R_Temp2_isr, R_Temp1_isr, R_Temp0_isr;
ENDIF

public _tmpA
public _tmpB
public _tmpC
public T

public __ClearWatchDogTimer
public __ClrRAM
PUBLIC _sgv_init_entry

Extern CODE _main

;-------------------------------------------------------------------------------
;			Data section
;-------------------------------------------------------------------------------
crt0@data SEGMENT DATA AT 0x00 INBANK
	_tmpA ds 1
	_tmpB ds 1
	_tmpC ds 1
	T	ds 1

;-------------------------------------------------------------------------------
;			Code section
;-------------------------------------------------------------------------------
crt0@code SEGMENT CODE AT 0x0 INBANK
	ORG	0					;Code section start
	jmp		_sgv_init_entry		;Reset vector
	;Address 4 to 7 are reserved
	ORG	8
	NOP
_sgv_init_entry:
; Initialize STKP
	MOV A,# 0x7F
	B0MOV STKP, A 
	CALL __ClearWatchDogTimer;
	CALL __ClrRAM;

IF	ICE_Mode==1

	Sio_SCK		EQU	p3.6		; To P10
	Sio_SO		EQU	p3.7		; To P11
	Sio_SI		EQU	p3.4		; To P12
	ICE_Reset	EQU	p3.5		; ICE to reset EV Board 
	Chk_Flag	EQU	P3.5
	V_SioLoopCnt	EQU	8

	mov	a,#00000000b			; Initial port4 
	mov	p3,a				;
	mov	a,#11100000b			;
	mov	p3m,a				;
	mov	a,#00000000b			;
	mov	p3ur,a				;

Loop_Reset_EV:					; Reset use p3.1 reset emulation board
	b0bset	FWDRST
	decms	R_Temp0				;
	jmp	$-2				;
	decms	R_temp1				;
	jmp	Loop_Reset_EV			;
	b0bset	ICE_Reset			; for sync EV and ICE
	mov	a,#02h				; delay loop 256*256*2
	b0mov	R_Temp2,a			;
Loop_Reset_EV_OK:				;
	b0bset	FWDRST
	decms	R_Temp0				;
	jmp	$-2				;
	decms	R_Temp1				;
	jmp	Loop_Reset_EV_OK		;
	decms	R_Temp2				;
	jmp	Loop_Reset_Ev_OK		;
ENDIF

; Clear Watch dog timer
	CALL __ClearWatchDogTimer;

;Define a null segment
_SGV_INIT_CODE segment CODE


_SGV_INIT_CODE_END segment CODE
	CALL __ClearWatchDogTimer;
    JMP _main	


;-------------------------------------------------------------------------------
; Clear Watch dog timer
;-------------------------------------------------------------------------------
__ClearWatchDogTimer:
	B0BSET   FWDRST
	RET
	
;-------------------------------------------------------------------------------
; ClrRAM
; Use index @YZ to clear RAM
;-------------------------------------------------------------------------------

__ClrRAM:
	B0MOV RBANK,#0
; RAM Bank 0
	clr 		Y
	b0mov		Z,#0x7f	

ClrRAM10:
	clr 		@YZ	
	decms		Z 
	jmp 		ClrRAM10
	clr 		@YZ	

; RAM Bank 1
	b0mov		Y,#1
	b0mov		Z,#0xff

ClrRAM20:
	clr 		@YZ	
	decms		Z 
	jmp 		ClrRAM20
	clr 		@YZ	

; RAM Bank 2
	b0mov		Y,#1
	b0mov		Z,#0x7f

ClrRAM30:
	clr 		@YZ	
	decms		Z 
	jmp 		ClrRAM30
	clr 		@YZ	
	
;Clear LCDRAM
; RAM Bank 15
	b0mov   	Y,#1b
	b0mov		Z,#0x17  
	
ClrRAM40:
	clr 		@YZ	
	decms		Z   
	jmp 		ClrRAM40
	clr 		@YZ	
	
	ret
;-------------------------------------------------------------------------------
