;-------------------------------------------------------------------------------
;	Crt0 For Chip SN8P2839
;-------------------------------------------------------------------------------

CHIP SN8P2839


GOTO_THE_END EQU 0



Extern CODE _main
Public exit

public _tmpA
public _tmpB
public _tmpC
public T

public __ClearWatchDogTimer
public __ClrRAM

crt0@data segment data at 0x00 inbank
; 29 bytes
_tmpA ds 1
_tmpB ds 1
_tmpC ds 1
T	ds 1


;-------------------------------------------------------------------------------
;			Code section
;-------------------------------------------------------------------------------

crt0@code segment code at 0x0
	ORG	0					;Code section start
	jmp		_sgv_init_entry		;Reset vector
								;Address 4 to 7 are reserved



_SGV_INIT_CODE_BEGIN segment CODE 
PUBLIC _sgv_init_entry
_sgv_init_entry:

;------------------------------------------------------------------------------- 
; Initialize STKP 
  MOV A,# 0x17
  B0MOV STKP, A 
;------------------------------------------------------------------------------- 

;-------------------------------------------------------------------------------
; Clear Watch dog timer
;-------------------------------------------------------------------------------
	MOV A, #0x5A
	B0MOV WDTR, A
		
;-------------------------------------------------------------------------------
; Call Clear RAM : Use index @YZ to clear RAM 
;-------------------------------------------------------------------------------
	CALL __ClrRAM;
;-------------------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_SGV_INIT_CODE SEGMENT CODE BANK 0x0 INBANK
;Define a null segment

_SGV_INIT_CODE_END segment CODE  bank 0 inbank

;-------------------------------------------------------------------------------
; Clear Watch dog timer
;-------------------------------------------------------------------------------
	CALL __ClearWatchDogTimer;
    JMP _main	

;-------------------------------------------------------------------------------
; Clear Watch dog timer
;-------------------------------------------------------------------------------
__ClearWatchDogTimer:
	MOV  A, #5AH
	B0MOV  WDTR, A
	RET
	
;-------------------------------------------------------------------------------
; ClrRAM
; Use index @YZ to clear RAM 
;-------------------------------------------------------------------------------

__ClrRAM:
	B0MOV RBANK,#0
; Clear RAM Bank 0
	CLR 		Y
	B0MOV		Z,#0x7f

ClrRAM10:
	CLR 		@YZ
	DECMS		Z
	JMP 		ClrRAM10
	CLR 		@YZ
	
; Clear RAM Bank 1
	B0MOV		Y,#1
	B0MOV		Z,#0xff

ClrRAM20:
	CLR 		@YZ
	DECMS		Z
	JMP 		ClrRAM20
	CLR 		@YZ

; Clear RAM Bank 2
	B0MOV		Y,#2
	B0MOV		Z,#0xff

ClrRAM30:
	CLR 		@YZ
	DECMS		Z
	JMP 		ClrRAM30
	CLR 		@YZ	

; Clear RAM Bank 3
	B0MOV		Y,#3
	B0MOV		Z,#0xff

ClrRAM40:
	CLR 		@YZ
	DECMS		Z
	JMP 		ClrRAM40
	CLR 		@YZ

; Clear RAM Bank 4
	B0MOV		Y,#4
	B0MOV		Z,#0xff

ClrRAM50:
	CLR 		@YZ
	DECMS		Z
	JMP 		ClrRAM50
	CLR 		@YZ

; Clear RAM Bank 5
	B0MOV		Y,#5
	B0MOV		Z,#0xff

ClrRAM60:
	CLR 		@YZ
	DECMS		Z
	JMP 		ClrRAM60
	CLR 		@YZ

; Clear RAM Bank 6
	B0MOV		Y,#6
	B0MOV		Z,#0xff

ClrRAM70:
	CLR 		@YZ
	DECMS		Z
	JMP 		ClrRAM70
	CLR 		@YZ

; Clear RAM Bank 7
	B0MOV		Y,#7
	B0MOV		Z,#0xff

ClrRAM80:
	CLR 		@YZ
	DECMS		Z
	JMP 		ClrRAM80
	CLR 		@YZ

; Clear RAM Bank 8
	B0MOV		Y,#8
	B0MOV		Z,#0x7f

ClrRAM90:
	CLR 		@YZ
	DECMS		Z
	JMP 		ClrRAM90
	CLR 		@YZ
;Clear LCDRAM
; RAM Bank 15
	b0mov   Y,#15				;Select bank 15
	b0mov		Z,#0x23       ;Set @YZ  address from f1fh
	
ClrRAMa0:
	clr 		@YZ					;Clear @YZ content
	decms		Z   				;z = z - 1 , skip next if z=0
	jmp 		ClrRAMa0
	clr 		@YZ					;Clear address 0xf00

	RET