#ifndef __SN8P2213__H
#define __SN8P2213__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FNPD	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FNT0	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	RBANK	(*((__RAM unsigned int*)0x87))
#define	FRBNKS0	((*((__RAM struct specialRegister *)0x87)).bit0)
#define	UDA	(*((__RAM unsigned int*)0xa0))
#define	FUDE	((*((__RAM struct specialRegister *)0xa0)).bit7)
#define	FUDA6	((*((__RAM struct specialRegister *)0xa0)).bit6)
#define	FUDA5	((*((__RAM struct specialRegister *)0xa0)).bit5)
#define	FUDA4	((*((__RAM struct specialRegister *)0xa0)).bit4)
#define	FUDA3	((*((__RAM struct specialRegister *)0xa0)).bit3)
#define	FUDA2	((*((__RAM struct specialRegister *)0xa0)).bit2)
#define	FUDA1	((*((__RAM struct specialRegister *)0xa0)).bit1)
#define	FUDA0	((*((__RAM struct specialRegister *)0xa0)).bit0)
#define	USTATUS	(*((__RAM unsigned int*)0xa1))
#define	FBUSRST	((*((__RAM struct specialRegister *)0xa1)).bit6)
#define	FUSUSPEND	((*((__RAM struct specialRegister *)0xa1)).bit5)
#define	FUEP0SETUP	((*((__RAM struct specialRegister *)0xa1)).bit4)
#define	FUEP0IN	((*((__RAM struct specialRegister *)0xa1)).bit3)
#define	FUEP0OUT	((*((__RAM struct specialRegister *)0xa1)).bit2)
#define	FUEP1ACK	((*((__RAM struct specialRegister *)0xa1)).bit1)
#define	FUEP2ACK	((*((__RAM struct specialRegister *)0xa1)).bit0)
#define	UCTRL	(*((__RAM unsigned int*)0xa2))
#define	FFFS2	((*((__RAM struct specialRegister *)0xa2)).bit7)
#define	FFFS1	((*((__RAM struct specialRegister *)0xa2)).bit6)
#define	FFFS0	((*((__RAM struct specialRegister *)0xa2)).bit5)
#define	FUEP0OC4	((*((__RAM struct specialRegister *)0xa2)).bit4)
#define	FUEP0OC3	((*((__RAM struct specialRegister *)0xa2)).bit3)
#define	FUEP0OC2	((*((__RAM struct specialRegister *)0xa2)).bit2)
#define	FUEP0OC1	((*((__RAM struct specialRegister *)0xa2)).bit1)
#define	FUEP0OC0	((*((__RAM struct specialRegister *)0xa2)).bit0)
#define	UE0R	(*((__RAM unsigned int*)0xa3))
#define	FUE0M1	((*((__RAM struct specialRegister *)0xa3)).bit6)
#define	FUE0M0	((*((__RAM struct specialRegister *)0xa3)).bit5)
#define	FUE0C3	((*((__RAM struct specialRegister *)0xa3)).bit3)
#define	FUE0C2	((*((__RAM struct specialRegister *)0xa3)).bit2)
#define	FUE0C1	((*((__RAM struct specialRegister *)0xa3)).bit1)
#define	FUE0C0	((*((__RAM struct specialRegister *)0xa3)).bit0)
#define	UE1R	(*((__RAM unsigned int*)0xa4))
#define	FUE1E	((*((__RAM struct specialRegister *)0xa4)).bit7)
#define	FUE1M1	((*((__RAM struct specialRegister *)0xa4)).bit6)
#define	FUE1M0	((*((__RAM struct specialRegister *)0xa4)).bit5)
#define	FUE1C4	((*((__RAM struct specialRegister *)0xa4)).bit4)
#define	FUE1C3	((*((__RAM struct specialRegister *)0xa4)).bit3)
#define	FUE1C2	((*((__RAM struct specialRegister *)0xa4)).bit2)
#define	FUE1C1	((*((__RAM struct specialRegister *)0xa4)).bit1)
#define	FUE1C0	((*((__RAM struct specialRegister *)0xa4)).bit0)
#define	UE2R	(*((__RAM unsigned int*)0xa5))
#define	FUE2E	((*((__RAM struct specialRegister *)0xa5)).bit7)
#define	FUE2M1	((*((__RAM struct specialRegister *)0xa5)).bit6)
#define	FUE2M0	((*((__RAM struct specialRegister *)0xa5)).bit5)
#define	FUE2C4	((*((__RAM struct specialRegister *)0xa5)).bit4)
#define	FUE2C3	((*((__RAM struct specialRegister *)0xa5)).bit3)
#define	FUE2C2	((*((__RAM struct specialRegister *)0xa5)).bit2)
#define	FUE2C1	((*((__RAM struct specialRegister *)0xa5)).bit1)
#define	FUE2C0	((*((__RAM struct specialRegister *)0xa5)).bit0)
#define	UDP0	(*((__RAM unsigned int*)0xa6))
#define	FUDP05	((*((__RAM struct specialRegister *)0xa6)).bit5)
#define	FUDP04	((*((__RAM struct specialRegister *)0xa6)).bit4)
#define	FUDP03	((*((__RAM struct specialRegister *)0xa6)).bit3)
#define	FUDP02	((*((__RAM struct specialRegister *)0xa6)).bit2)
#define	FUDP01	((*((__RAM struct specialRegister *)0xa6)).bit1)
#define	FUDP00	((*((__RAM struct specialRegister *)0xa6)).bit0)
#define	UDR0	(*((__RAM unsigned int*)0xa7))
#define	FUDR07	((*((__RAM struct specialRegister *)0xa7)).bit7)
#define	FUDR06	((*((__RAM struct specialRegister *)0xa7)).bit6)
#define	FUDR05	((*((__RAM struct specialRegister *)0xa7)).bit5)
#define	FUDR04	((*((__RAM struct specialRegister *)0xa7)).bit4)
#define	FUDR03	((*((__RAM struct specialRegister *)0xa7)).bit3)
#define	FUDR02	((*((__RAM struct specialRegister *)0xa7)).bit2)
#define	FUDR01	((*((__RAM struct specialRegister *)0xa7)).bit1)
#define	FUDR00	((*((__RAM struct specialRegister *)0xa7)).bit0)
#define	UDP1	(*((__RAM unsigned int*)0xa8))
#define	FUDP15	((*((__RAM struct specialRegister *)0xa8)).bit5)
#define	FUDP14	((*((__RAM struct specialRegister *)0xa8)).bit4)
#define	FUDP13	((*((__RAM struct specialRegister *)0xa8)).bit3)
#define	FUDP12	((*((__RAM struct specialRegister *)0xa8)).bit2)
#define	FUDP11	((*((__RAM struct specialRegister *)0xa8)).bit1)
#define	FUDP10	((*((__RAM struct specialRegister *)0xa8)).bit0)
#define	UDR1	(*((__RAM unsigned int*)0xa9))
#define	FUDR17	((*((__RAM struct specialRegister *)0xa9)).bit7)
#define	FUDR16	((*((__RAM struct specialRegister *)0xa9)).bit6)
#define	FUDR15	((*((__RAM struct specialRegister *)0xa9)).bit5)
#define	FUDR14	((*((__RAM struct specialRegister *)0xa9)).bit4)
#define	FUDR13	((*((__RAM struct specialRegister *)0xa9)).bit3)
#define	FUDR12	((*((__RAM struct specialRegister *)0xa9)).bit2)
#define	FUDR11	((*((__RAM struct specialRegister *)0xa9)).bit1)
#define	FUDR10	((*((__RAM struct specialRegister *)0xa9)).bit0)
#define	UPID	(*((__RAM unsigned int*)0xaa))
#define	FUBDE	((*((__RAM struct specialRegister *)0xaa)).bit2)
#define	FDDP	((*((__RAM struct specialRegister *)0xaa)).bit1)
#define	FDDN	((*((__RAM struct specialRegister *)0xaa)).bit0)
#define	EP1OUT_CNT	(*((__RAM unsigned int*)0xab))
#define	FEP1OC4	((*((__RAM struct specialRegister *)0xab)).bit4)
#define	FEP1OC3	((*((__RAM struct specialRegister *)0xab)).bit3)
#define	FEP1OC2	((*((__RAM struct specialRegister *)0xab)).bit2)
#define	FEP1OC1	((*((__RAM struct specialRegister *)0xab)).bit1)
#define	FEP1OC0	((*((__RAM struct specialRegister *)0xab)).bit0)
#define	EP2OUT_CNT	(*((__RAM unsigned int*)0xac))
#define	FEP2OC4	((*((__RAM struct specialRegister *)0xac)).bit4)
#define	FEP2OC3	((*((__RAM struct specialRegister *)0xac)).bit3)
#define	FEP2OC2	((*((__RAM struct specialRegister *)0xac)).bit2)
#define	FEP2OC1	((*((__RAM struct specialRegister *)0xac)).bit1)
#define	FEP2OC0	((*((__RAM struct specialRegister *)0xac)).bit0)
#define	SIOM	(*((__RAM unsigned int*)0xb4))
#define	FSENB	((*((__RAM struct specialRegister *)0xb4)).bit7)
#define	FSTART	((*((__RAM struct specialRegister *)0xb4)).bit6)
#define	FSRATE1	((*((__RAM struct specialRegister *)0xb4)).bit5)
#define	FSRATE0	((*((__RAM struct specialRegister *)0xb4)).bit4)
#define	FSCKMD	((*((__RAM struct specialRegister *)0xb4)).bit2)
#define	FSEDGE	((*((__RAM struct specialRegister *)0xb4)).bit1)
#define	FTXRX	((*((__RAM struct specialRegister *)0xb4)).bit0)
#define	SIOR	(*((__RAM unsigned int*)0xb5))
#define	SIOB	(*((__RAM unsigned int*)0xb6))
#define	P0M	(*((__RAM unsigned int*)0xb8))
#define	FP04M	((*((__RAM struct specialRegister *)0xb8)).bit4)
#define	FP03M	((*((__RAM struct specialRegister *)0xb8)).bit3)
#define	FP02M	((*((__RAM struct specialRegister *)0xb8)).bit2)
#define	FP01M	((*((__RAM struct specialRegister *)0xb8)).bit1)
#define	FP00M	((*((__RAM struct specialRegister *)0xb8)).bit0)
#define	PEDGE	(*((__RAM unsigned int*)0xbf))
#define	FP00G1	((*((__RAM struct specialRegister *)0xbf)).bit4)
#define	FP00G0	((*((__RAM struct specialRegister *)0xbf)).bit3)
#define	P1W	(*((__RAM unsigned int*)0xc0))
#define	FP17W	((*((__RAM struct specialRegister *)0xc0)).bit7)
#define	FP16W	((*((__RAM struct specialRegister *)0xc0)).bit6)
#define	FP15W	((*((__RAM struct specialRegister *)0xc0)).bit5)
#define	FP14W	((*((__RAM struct specialRegister *)0xc0)).bit4)
#define	FP13W	((*((__RAM struct specialRegister *)0xc0)).bit3)
#define	FP12W	((*((__RAM struct specialRegister *)0xc0)).bit2)
#define	FP11W	((*((__RAM struct specialRegister *)0xc0)).bit1)
#define	FP10W	((*((__RAM struct specialRegister *)0xc0)).bit0)
#define	P1M	(*((__RAM unsigned int*)0xc1))
#define	FP17M	((*((__RAM struct specialRegister *)0xc1)).bit7)
#define	FP16M	((*((__RAM struct specialRegister *)0xc1)).bit6)
#define	FP15M	((*((__RAM struct specialRegister *)0xc1)).bit5)
#define	FP14M	((*((__RAM struct specialRegister *)0xc1)).bit4)
#define	FP13M	((*((__RAM struct specialRegister *)0xc1)).bit3)
#define	FP12M	((*((__RAM struct specialRegister *)0xc1)).bit2)
#define	FP11M	((*((__RAM struct specialRegister *)0xc1)).bit1)
#define	FP10M	((*((__RAM struct specialRegister *)0xc1)).bit0)
#define	P5M	(*((__RAM unsigned int*)0xc5))
#define	FP52M	((*((__RAM struct specialRegister *)0xc5)).bit2)
#define	FP51M	((*((__RAM struct specialRegister *)0xc5)).bit1)
#define	FP50M	((*((__RAM struct specialRegister *)0xc5)).bit0)
#define	INTRQ	(*((__RAM unsigned int*)0xc8))
#define	FUSBIRQ	((*((__RAM struct specialRegister *)0xc8)).bit6)
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit5)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	FSIOIRQ	((*((__RAM struct specialRegister *)0xc8)).bit3)
#define	FWAKEIRQ	((*((__RAM struct specialRegister *)0xc8)).bit1)
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	INTEN	(*((__RAM unsigned int*)0xc9))
#define	FUSBIEN	((*((__RAM struct specialRegister *)0xc9)).bit6)
#define	FTC0IEN	((*((__RAM struct specialRegister *)0xc9)).bit5)
#define	FT0IEN	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	FSIOIEN	((*((__RAM struct specialRegister *)0xc9)).bit3)
#define	FWAKEIEN	((*((__RAM struct specialRegister *)0xc9)).bit1)
#define	FP00IEN	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	OSCM	(*((__RAM unsigned int*)0xca))
#define	FCPUM1	((*((__RAM struct specialRegister *)0xca)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xca)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xca)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0xca)).bit1)
#define	WDTR	(*((__RAM unsigned int*)0xcc))
#define	PCL	(*((__RAM unsigned int*)0xce))
#define	PCH	(*((__RAM unsigned int*)0xcf))
#define	P0	(*((__RAM unsigned int*)0xd0))
#define	FP05	((*((__RAM struct specialRegister *)0xd0)).bit5)
#define	FP04	((*((__RAM struct specialRegister *)0xd0)).bit4)
#define	FP03	((*((__RAM struct specialRegister *)0xd0)).bit3)
#define	FP02	((*((__RAM struct specialRegister *)0xd0)).bit2)
#define	FP01	((*((__RAM struct specialRegister *)0xd0)).bit1)
#define	FP00	((*((__RAM struct specialRegister *)0xd0)).bit0)
#define	P1	(*((__RAM unsigned int*)0xd1))
#define	FP17	((*((__RAM struct specialRegister *)0xd1)).bit7)
#define	FP16	((*((__RAM struct specialRegister *)0xd1)).bit6)
#define	FP15	((*((__RAM struct specialRegister *)0xd1)).bit5)
#define	FP14	((*((__RAM struct specialRegister *)0xd1)).bit4)
#define	FP13	((*((__RAM struct specialRegister *)0xd1)).bit3)
#define	FP12	((*((__RAM struct specialRegister *)0xd1)).bit2)
#define	FP11	((*((__RAM struct specialRegister *)0xd1)).bit1)
#define	FP10	((*((__RAM struct specialRegister *)0xd1)).bit0)
#define	P5	(*((__RAM unsigned int*)0xd5))
#define	FP52	((*((__RAM struct specialRegister *)0xd5)).bit2)
#define	FP51	((*((__RAM struct specialRegister *)0xd5)).bit1)
#define	FP50	((*((__RAM struct specialRegister *)0xd5)).bit0)
#define	T0M	(*((__RAM unsigned int*)0xd8))
#define	FT0ENB	((*((__RAM struct specialRegister *)0xd8)).bit7)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xd8)).bit6)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xd8)).bit5)
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xd8)).bit4)
#define	T0C	(*((__RAM unsigned int*)0xd9))
#define	TC0M	(*((__RAM unsigned int*)0xda))
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xda)).bit7)
#define	FTC0RATE2	((*((__RAM struct specialRegister *)0xda)).bit6)
#define	FTC0RATE1	((*((__RAM struct specialRegister *)0xda)).bit5)
#define	FTC0RATE0	((*((__RAM struct specialRegister *)0xda)).bit4)
#define	TC0C	(*((__RAM unsigned int*)0xdb))
#define	STKP	(*((__RAM unsigned int*)0xdf))
#define	FGIE	((*((__RAM struct specialRegister *)0xdf)).bit7)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xdf)).bit2)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xdf)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xdf)).bit0)
#define	P0UR	(*((__RAM unsigned int*)0xe0))
#define	P1UR	(*((__RAM unsigned int*)0xe1))
#define	P5UR	(*((__RAM unsigned int*)0xe5))
#define	_YZ	(*((__RAM unsigned int*)0xe7))
#define	P1OC	(*((__RAM unsigned int*)0xe9))
#define	STK7L	(*((__RAM unsigned int*)0xf0))
#define	STK7H	(*((__RAM unsigned int*)0xf1))
#define	STK6L	(*((__RAM unsigned int*)0xf2))
#define	STK6H	(*((__RAM unsigned int*)0xf3))
#define	STK5L	(*((__RAM unsigned int*)0xf4))
#define	STK5H	(*((__RAM unsigned int*)0xf5))
#define	STK4L	(*((__RAM unsigned int*)0xf6))
#define	STK4H	(*((__RAM unsigned int*)0xf7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#endif
