#ifndef __SN8P2308__H
#define __SN8P2308__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	L	(*((__RAM unsigned int*)0x80))
#define	H	(*((__RAM unsigned int*)0x81))
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FLVD24	((*((__RAM struct specialRegister *)0x86)).bit4)
#define	FLVD36	((*((__RAM struct specialRegister *)0x86)).bit5)
#define	FNPD	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FNT0	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	RBANK	(*((__RAM unsigned int*)0x87))
#define	FRBNKS0	((*((__RAM struct specialRegister *)0x87)).bit0)
#define	FRBNKS1	((*((__RAM struct specialRegister *)0x87)).bit1)
#define	FRBNKS2	((*((__RAM struct specialRegister *)0x87)).bit2)
#define	FRBNKS3	((*((__RAM struct specialRegister *)0x87)).bit3)
#define	VLCD	(*((__RAM unsigned int*)0x89))
#define	FVLCDCP	((*((__RAM struct specialRegister *)0x89)).bit0)
#define	FVLCD0	((*((__RAM struct specialRegister *)0x89)).bit1)
#define	FVLCD1	((*((__RAM struct specialRegister *)0x89)).bit2)
#define	FVLCD2	((*((__RAM struct specialRegister *)0x89)).bit3)
#define	FCPCK0	((*((__RAM struct specialRegister *)0x89)).bit4)
#define	FCPCK1	((*((__RAM struct specialRegister *)0x89)).bit5)
#define	T1M	(*((__RAM unsigned int*)0xA0))
#define	FT1IRQ	((*((__RAM struct specialRegister *)0xA0)).bit0)
#define	FT1IEN	((*((__RAM struct specialRegister *)0xA0)).bit1)
#define	FT1CKS	((*((__RAM struct specialRegister *)0xA0)).bit3)
#define	FT1RATE0	((*((__RAM struct specialRegister *)0xA0)).bit4)
#define	FT1RATE1	((*((__RAM struct specialRegister *)0xA0)).bit5)
#define	FT1RATE2	((*((__RAM struct specialRegister *)0xA0)).bit6)
#define	FT1ENB	((*((__RAM struct specialRegister *)0xA0)).bit7)
#define	T1CL	(*((__RAM unsigned int*)0xA1))
#define	T1CH	(*((__RAM unsigned int*)0xA2))
#define	RFCM	(*((__RAM unsigned int*)0xA3))
#define	FRFCENB	((*((__RAM struct specialRegister *)0xA3)).bit0)
#define	FRFCH0	((*((__RAM struct specialRegister *)0xA3)).bit1)
#define	FRFCH1	((*((__RAM struct specialRegister *)0xA3)).bit2)
#define	FRFCOUT	((*((__RAM struct specialRegister *)0xA3)).bit7)
#define	P0M	(*((__RAM unsigned int*)0xB8))
#define	FP00M	((*((__RAM struct specialRegister *)0xB8)).bit0)
#define	FP01M	((*((__RAM struct specialRegister *)0xB8)).bit1)
#define	FP03M	((*((__RAM struct specialRegister *)0xB8)).bit3)
#define	PEDGE	(*((__RAM unsigned int*)0xbf))
#define	FT1G0	((*((__RAM struct specialRegister *)0xbf)).bit0)
#define	FT1G1	((*((__RAM struct specialRegister *)0xbf)).bit1)
#define	FP00G1	((*((__RAM struct specialRegister *)0xbf)).bit4)
#define	FP00G0	((*((__RAM struct specialRegister *)0xbf)).bit3)
#define	P1W	(*((__RAM unsigned int*)0XC0))
#define	FP10W	((*((__RAM struct specialRegister *)0XC0)).bit0)
#define	FP11W	((*((__RAM struct specialRegister *)0XC0)).bit1)
#define	FP12W	((*((__RAM struct specialRegister *)0XC0)).bit2)
#define	FP13W	((*((__RAM struct specialRegister *)0XC0)).bit3)
#define	FP14W	((*((__RAM struct specialRegister *)0XC0)).bit4)
#define	FP15W	((*((__RAM struct specialRegister *)0XC0)).bit5)
#define	FP16W	((*((__RAM struct specialRegister *)0XC0)).bit6)
#define	P1M	(*((__RAM unsigned int*)0xc1))
#define	FP10M	((*((__RAM struct specialRegister *)0xc1)).bit0)
#define	FP11M	((*((__RAM struct specialRegister *)0xc1)).bit1)
#define	FP12M	((*((__RAM struct specialRegister *)0xc1)).bit2)
#define	FP13M	((*((__RAM struct specialRegister *)0xc1)).bit3)
#define	FP14M	((*((__RAM struct specialRegister *)0xc1)).bit4)
#define	FP15M	((*((__RAM struct specialRegister *)0xc1)).bit5)
#define	FP16M	((*((__RAM struct specialRegister *)0xc1)).bit6)
#define	P3M	(*((__RAM unsigned int*)0xc3))
#define	FP37M	((*((__RAM struct specialRegister *)0xc3)).bit7)
#define	FP36M	((*((__RAM struct specialRegister *)0xc3)).bit6)
#define	FP35M	((*((__RAM struct specialRegister *)0xc3)).bit5)
#define	FP34M	((*((__RAM struct specialRegister *)0xc3)).bit4)
#define	FP33M	((*((__RAM struct specialRegister *)0xc3)).bit3)
#define	FP32M	((*((__RAM struct specialRegister *)0xc3)).bit2)
#define	FP31M	((*((__RAM struct specialRegister *)0xc3)).bit1)
#define	FP30M	((*((__RAM struct specialRegister *)0xc3)).bit0)
#define	P5M	(*((__RAM unsigned int*)0xc5))
#define	FP55M	((*((__RAM struct specialRegister *)0xc5)).bit5)
#define	FP54M	((*((__RAM struct specialRegister *)0xc5)).bit4)
#define	FP53M	((*((__RAM struct specialRegister *)0xc5)).bit3)
#define	FP52M	((*((__RAM struct specialRegister *)0xc5)).bit2)
#define	FP51M	((*((__RAM struct specialRegister *)0xc5)).bit1)
#define	FP50M	((*((__RAM struct specialRegister *)0xc5)).bit0)
#define	INTRQ	(*((__RAM unsigned int*)0xc8))
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit5)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	INTEN	(*((__RAM unsigned int*)0xc9))
#define	FTC0IEN	((*((__RAM struct specialRegister *)0xc9)).bit5)
#define	FT0IEN	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	FP00IEN	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	OSCM	(*((__RAM unsigned int*)0xca))
#define	FCPUM1	((*((__RAM struct specialRegister *)0xca)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xca)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xca)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0xca)).bit1)
#define	LCDM	(*((__RAM unsigned int*)0XCB))
#define	FLCDENB	((*((__RAM struct specialRegister *)0XCB)).bit0)
#define	FBIAS	((*((__RAM struct specialRegister *)0XCB)).bit1)
#define	FP3SEG	((*((__RAM struct specialRegister *)0XCB)).bit2)
#define	FRCLK	((*((__RAM struct specialRegister *)0XCB)).bit3)
#define	WDTR	(*((__RAM unsigned int*)0xcc))
#define	TC0R	(*((__RAM unsigned int*)0xcd))
#define	PCL	(*((__RAM unsigned int*)0xce))
#define	PCH	(*((__RAM unsigned int*)0xcf))
#define	P0	(*((__RAM unsigned int*)0xd0))
#define	FP03	((*((__RAM struct specialRegister *)0xd0)).bit3)
#define	FP02	((*((__RAM struct specialRegister *)0xd0)).bit2)
#define	FP01	((*((__RAM struct specialRegister *)0xd0)).bit1)
#define	FP00	((*((__RAM struct specialRegister *)0xd0)).bit0)
#define	P1	(*((__RAM unsigned int*)0xd1))
#define	FP16	((*((__RAM struct specialRegister *)0xd1)).bit6)
#define	FP15	((*((__RAM struct specialRegister *)0xd1)).bit5)
#define	FP14	((*((__RAM struct specialRegister *)0xd1)).bit4)
#define	FP13	((*((__RAM struct specialRegister *)0xd1)).bit3)
#define	FP12	((*((__RAM struct specialRegister *)0xd1)).bit2)
#define	FP11	((*((__RAM struct specialRegister *)0xd1)).bit1)
#define	FP10	((*((__RAM struct specialRegister *)0xd1)).bit0)
#define	P3	(*((__RAM unsigned int*)0xd3))
#define	FP37	((*((__RAM struct specialRegister *)0xd3)).bit7)
#define	FP36	((*((__RAM struct specialRegister *)0xd3)).bit6)
#define	FP35	((*((__RAM struct specialRegister *)0xd3)).bit5)
#define	FP34	((*((__RAM struct specialRegister *)0xd3)).bit4)
#define	FP33	((*((__RAM struct specialRegister *)0xd3)).bit3)
#define	FP32	((*((__RAM struct specialRegister *)0xd3)).bit2)
#define	FP31	((*((__RAM struct specialRegister *)0xd3)).bit1)
#define	FP30	((*((__RAM struct specialRegister *)0xd3)).bit0)
#define	P5	(*((__RAM unsigned int*)0xd5))
#define	FP55	((*((__RAM struct specialRegister *)0xd5)).bit5)
#define	FP54	((*((__RAM struct specialRegister *)0xd5)).bit4)
#define	FP53	((*((__RAM struct specialRegister *)0xd5)).bit3)
#define	FP52	((*((__RAM struct specialRegister *)0xd5)).bit2)
#define	FP51	((*((__RAM struct specialRegister *)0xd5)).bit1)
#define	FP50	((*((__RAM struct specialRegister *)0xd5)).bit0)
#define	T0M	(*((__RAM unsigned int*)0xd8))
#define	FT0TB	((*((__RAM struct specialRegister *)0xd8)).bit0)
#define	FTC0X8	((*((__RAM struct specialRegister *)0xd8)).bit2)
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xd8)).bit4)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xd8)).bit5)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xd8)).bit6)
#define	FT0ENB	((*((__RAM struct specialRegister *)0xd8)).bit7)
#define	T0C	(*((__RAM unsigned int*)0XD9))
#define	TC0M	(*((__RAM unsigned int*)0xda))
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xda)).bit7)
#define	FTC0RATE2	((*((__RAM struct specialRegister *)0xda)).bit6)
#define	FTC0RATE1	((*((__RAM struct specialRegister *)0xda)).bit5)
#define	FTC0RATE0	((*((__RAM struct specialRegister *)0xda)).bit4)
#define	FTC0CKS	((*((__RAM struct specialRegister *)0xda)).bit3)
#define	FALOAD0	((*((__RAM struct specialRegister *)0xda)).bit2)
#define	FTC0OUT	((*((__RAM struct specialRegister *)0xda)).bit1)
#define	FPWM0OUT	((*((__RAM struct specialRegister *)0xda)).bit0)
#define	TC0C	(*((__RAM unsigned int*)0xdb))
#define	STKP	(*((__RAM unsigned int*)0xdf))
#define	FGIE	((*((__RAM struct specialRegister *)0xdf)).bit7)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xdf)).bit2)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xdf)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xdf)).bit0)
#define	P0UR	(*((__RAM unsigned int*)0xe0))
#define	FP03R	((*((__RAM struct specialRegister *)0xe0)).bit3)
#define	FP01R	((*((__RAM struct specialRegister *)0xe0)).bit1)
#define	FP00R	((*((__RAM struct specialRegister *)0xe0)).bit0)
#define	P1UR	(*((__RAM unsigned int*)0xe1))
#define	FP16R	((*((__RAM struct specialRegister *)0xe1)).bit6)
#define	FP15R	((*((__RAM struct specialRegister *)0xe1)).bit5)
#define	FP14R	((*((__RAM struct specialRegister *)0xe1)).bit4)
#define	FP13R	((*((__RAM struct specialRegister *)0xe1)).bit3)
#define	FP12R	((*((__RAM struct specialRegister *)0xe1)).bit2)
#define	FP11R	((*((__RAM struct specialRegister *)0xe1)).bit1)
#define	FP10R	((*((__RAM struct specialRegister *)0xe1)).bit0)
#define	P3UR	(*((__RAM unsigned int*)0xe3))
#define	FP37R	((*((__RAM struct specialRegister *)0xe3)).bit7)
#define	FP36R	((*((__RAM struct specialRegister *)0xe3)).bit6)
#define	FP35R	((*((__RAM struct specialRegister *)0xe3)).bit5)
#define	FP34R	((*((__RAM struct specialRegister *)0xe3)).bit4)
#define	FP33R	((*((__RAM struct specialRegister *)0xe3)).bit3)
#define	FP32R	((*((__RAM struct specialRegister *)0xe3)).bit2)
#define	FP31R	((*((__RAM struct specialRegister *)0xe3)).bit1)
#define	FP30R	((*((__RAM struct specialRegister *)0xe3)).bit0)
#define	P5UR	(*((__RAM unsigned int*)0xe5))
#define	FP56R	((*((__RAM struct specialRegister *)0xe5)).bit6)
#define	FP55R	((*((__RAM struct specialRegister *)0xe5)).bit5)
#define	FP54R	((*((__RAM struct specialRegister *)0xe5)).bit4)
#define	FP53R	((*((__RAM struct specialRegister *)0xe5)).bit3)
#define	FP52R	((*((__RAM struct specialRegister *)0xe5)).bit2)
#define	FP51R	((*((__RAM struct specialRegister *)0xe5)).bit1)
#define	FP50R	((*((__RAM struct specialRegister *)0xe5)).bit0)
#define	_HL	(*((__RAM unsigned int*)0xe6))
#define	DP0X	(*((__RAM unsigned int*)0xe6))
#define	_YZ	(*((__RAM unsigned int*)0xe7))
#define	DP1X	(*((__RAM unsigned int*)0xe7))
#define	NCREG	(*((__RAM unsigned int*)0xef))
#define	STK7L	(*((__RAM unsigned int*)0xf0))
#define	STK7H	(*((__RAM unsigned int*)0xf1))
#define	STK6L	(*((__RAM unsigned int*)0xf2))
#define	STK6H	(*((__RAM unsigned int*)0xf3))
#define	STK5L	(*((__RAM unsigned int*)0xf4))
#define	STK5H	(*((__RAM unsigned int*)0xf5))
#define	STK4L	(*((__RAM unsigned int*)0xf6))
#define	STK4H	(*((__RAM unsigned int*)0xf7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#endif
