#ifndef __SN8P2602B__H
#define __SN8P2602B__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FLVD24	((*((__RAM struct specialRegister *)0x86)).bit4)
#define	FLVD36	((*((__RAM struct specialRegister *)0x86)).bit5)
#define	FNPD	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FNT0	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	P0M	(*((__RAM unsigned int*)0xb8))
#define	FP00M	((*((__RAM struct specialRegister *)0xb8)).bit0)
#define	PEDGE	(*((__RAM unsigned int*)0xbf))
#define	FP00G1	((*((__RAM struct specialRegister *)0xbf)).bit4)
#define	FP00G0	((*((__RAM struct specialRegister *)0xbf)).bit3)
#define	P1W	(*((__RAM unsigned int*)0xc0))
#define	P1M	(*((__RAM unsigned int*)0xc1))
#define	FP10M	((*((__RAM struct specialRegister *)0xc1)).bit0)
#define	FP11M	((*((__RAM struct specialRegister *)0xc1)).bit1)
#define	FP12M	((*((__RAM struct specialRegister *)0xc1)).bit2)
#define	FP13M	((*((__RAM struct specialRegister *)0xc1)).bit3)
#define	FP14M	((*((__RAM struct specialRegister *)0xc1)).bit4)
#define	P5M	(*((__RAM unsigned int*)0xc5))
#define	FP50M	((*((__RAM struct specialRegister *)0xc5)).bit0)
#define	FP51M	((*((__RAM struct specialRegister *)0xc5)).bit1)
#define	FP52M	((*((__RAM struct specialRegister *)0xc5)).bit2)
#define	FP53M	((*((__RAM struct specialRegister *)0xc5)).bit3)
#define	FP54M	((*((__RAM struct specialRegister *)0xc5)).bit4)
#define	FP55M	((*((__RAM struct specialRegister *)0xc5)).bit5)
#define	FP56M	((*((__RAM struct specialRegister *)0xc5)).bit6)
#define	FP57M	((*((__RAM struct specialRegister *)0xc5)).bit7)
#define	INTRQ	(*((__RAM unsigned int*)0xc8))
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit5)
#define	INTEN	(*((__RAM unsigned int*)0xc9))
#define	FP00IEN	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	FT0IEN	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	FTC0IEN	((*((__RAM struct specialRegister *)0xc9)).bit5)
#define	OSCM	(*((__RAM unsigned int*)0xca))
#define	FCPUM1	((*((__RAM struct specialRegister *)0xca)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xca)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xca)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0xca)).bit1)
#define	WDTR	(*((__RAM unsigned int*)0xcc))
#define	TC0R	(*((__RAM unsigned int*)0xcd))
#define	PCL	(*((__RAM unsigned int*)0xce))
#define	PCH	(*((__RAM unsigned int*)0xcf))
#define	P0	(*((__RAM unsigned int*)0xd0))
#define	FP00	((*((__RAM struct specialRegister *)0xd0)).bit0)
#define	P1	(*((__RAM unsigned int*)0xd1))
#define	FP10	((*((__RAM struct specialRegister *)0xd1)).bit0)
#define	FP11	((*((__RAM struct specialRegister *)0xd1)).bit1)
#define	FP12	((*((__RAM struct specialRegister *)0xd1)).bit2)
#define	FP13	((*((__RAM struct specialRegister *)0xd1)).bit3)
#define	FP14	((*((__RAM struct specialRegister *)0xd1)).bit4)
#define	FP15	((*((__RAM struct specialRegister *)0xd1)).bit5)
#define	P5	(*((__RAM unsigned int*)0xd5))
#define	FP50	((*((__RAM struct specialRegister *)0xd5)).bit0)
#define	FP51	((*((__RAM struct specialRegister *)0xd5)).bit1)
#define	FP52	((*((__RAM struct specialRegister *)0xd5)).bit2)
#define	FP53	((*((__RAM struct specialRegister *)0xd5)).bit3)
#define	FP54	((*((__RAM struct specialRegister *)0xd5)).bit4)
#define	FP55	((*((__RAM struct specialRegister *)0xd5)).bit5)
#define	FP56	((*((__RAM struct specialRegister *)0xd5)).bit6)
#define	FP57	((*((__RAM struct specialRegister *)0xd5)).bit7)
#define	T0M	(*((__RAM unsigned int*)0xd8))
#define	FT0TB	((*((__RAM struct specialRegister *)0xd8)).bit0)
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xd8)).bit4)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xd8)).bit5)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xd8)).bit6)
#define	FT0ENB	((*((__RAM struct specialRegister *)0xd8)).bit7)
#define	T0C	(*((__RAM unsigned int*)0xd9))
#define	TC0M	(*((__RAM unsigned int*)0xda))
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xda)).bit7)
#define	FTC0RATE2	((*((__RAM struct specialRegister *)0xda)).bit6)
#define	FTC0RATE1	((*((__RAM struct specialRegister *)0xda)).bit5)
#define	FTC0RATE0	((*((__RAM struct specialRegister *)0xda)).bit4)
#define	FTC0CKS	((*((__RAM struct specialRegister *)0xda)).bit3)
#define	FALOAD0	((*((__RAM struct specialRegister *)0xda)).bit2)
#define	FTC0OUT	((*((__RAM struct specialRegister *)0xda)).bit1)
#define	FPWM0OUT	((*((__RAM struct specialRegister *)0xda)).bit0)
#define	TC0C	(*((__RAM unsigned int*)0xdb))
#define	STKP	(*((__RAM unsigned int*)0xdf))
#define	FGIE	((*((__RAM struct specialRegister *)0xdf)).bit7)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xdf)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xdf)).bit0)
#define	P0UR	(*((__RAM unsigned int*)0xe0))
#define	FP00R	((*((__RAM struct specialRegister *)0xe0)).bit0)
#define	P1UR	(*((__RAM unsigned int*)0xe1))
#define	FP10R	((*((__RAM struct specialRegister *)0xe1)).bit0)
#define	FP11R	((*((__RAM struct specialRegister *)0xe1)).bit1)
#define	FP12R	((*((__RAM struct specialRegister *)0xe1)).bit2)
#define	FP13R	((*((__RAM struct specialRegister *)0xe1)).bit3)
#define	FP14R	((*((__RAM struct specialRegister *)0xe1)).bit4)
#define	P5UR	(*((__RAM unsigned int*)0xe5))
#define	FP50R	((*((__RAM struct specialRegister *)0xe5)).bit0)
#define	FP51R	((*((__RAM struct specialRegister *)0xe5)).bit1)
#define	FP52R	((*((__RAM struct specialRegister *)0xe5)).bit2)
#define	FP53R	((*((__RAM struct specialRegister *)0xe5)).bit3)
#define	FP54R	((*((__RAM struct specialRegister *)0xe5)).bit4)
#define	FP55R	((*((__RAM struct specialRegister *)0xe5)).bit5)
#define	FP56R	((*((__RAM struct specialRegister *)0xe5)).bit6)
#define	FP57R	((*((__RAM struct specialRegister *)0xe5)).bit7)
#define	_YZ	(*((__RAM unsigned int*)0xe7))
#define	P1OC	(*((__RAM unsigned int*)0xe9))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#endif
