#ifndef __SN8F27E61__H
#define __SN8F27E61__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	L	(*((__RAM unsigned int*)0x80))
#define	H	(*((__RAM unsigned int*)0x81))
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	X	(*((__RAM unsigned int*)0x85))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FSTKOV	((*((__RAM struct specialRegister *)0x86)).bit4)
#define	FRST	((*((__RAM struct specialRegister *)0x86)).bit5)
#define	FWDT	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FPOR	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	W0	(*((__RAM unsigned int*)0x88))
#define	W1	(*((__RAM unsigned int*)0x89))
#define	W2	(*((__RAM unsigned int*)0x8a))
#define	W3	(*((__RAM unsigned int*)0x8b))
#define	W4	(*((__RAM unsigned int*)0x8c))
#define	W5	(*((__RAM unsigned int*)0x8d))
#define	W6	(*((__RAM unsigned int*)0x8e))
#define	W7	(*((__RAM unsigned int*)0x8f))
#define	_HL	(*((__RAM unsigned int*)0x90))
#define	_YZ	(*((__RAM unsigned int*)0x91))
#define	PCL	(*((__RAM unsigned int*)0x93))
#define	PCH	(*((__RAM unsigned int*)0x94))
#define	OSCM	(*((__RAM unsigned int*)0x95))
#define	FCPUM1	((*((__RAM struct specialRegister *)0x95)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0x95)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0x95)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0x95)).bit1)
#define	WDTR	(*((__RAM unsigned int*)0x96))
#define	INTRQ0	(*((__RAM unsigned int*)0x97))
#define	FADCIRQ	((*((__RAM struct specialRegister *)0x97)).bit7)
#define	FTC2IRQ	((*((__RAM struct specialRegister *)0x97)).bit5)
#define	FTC1IRQ	((*((__RAM struct specialRegister *)0x97)).bit4)
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0x97)).bit3)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0x97)).bit2)
#define	FP00IRQ	((*((__RAM struct specialRegister *)0x97)).bit0)
#define	INTRQ1	(*((__RAM unsigned int*)0x98))
#define	FUTXIRQ	((*((__RAM struct specialRegister *)0x98)).bit3)
#define	FURXIRQ	((*((__RAM struct specialRegister *)0x98)).bit2)
#define	FSIOIRQ	((*((__RAM struct specialRegister *)0x98)).bit1)
#define	FWAKEIRQ	((*((__RAM struct specialRegister *)0x98)).bit0)
#define	INTEN0	(*((__RAM unsigned int*)0x9a))
#define	FADCIEN	((*((__RAM struct specialRegister *)0x9a)).bit7)
#define	FTC2IEN	((*((__RAM struct specialRegister *)0x9a)).bit5)
#define	FTC1IEN	((*((__RAM struct specialRegister *)0x9a)).bit4)
#define	FTC0IEN	((*((__RAM struct specialRegister *)0x9a)).bit3)
#define	FT0IEN	((*((__RAM struct specialRegister *)0x9a)).bit2)
#define	FP00IEN	((*((__RAM struct specialRegister *)0x9a)).bit0)
#define	INTEN1	(*((__RAM unsigned int*)0x9b))
#define	FUTXIEN	((*((__RAM struct specialRegister *)0x9b)).bit3)
#define	FURXIEN	((*((__RAM struct specialRegister *)0x9b)).bit2)
#define	FSIOIEN	((*((__RAM struct specialRegister *)0x9b)).bit1)
#define	FWAKEIEN	((*((__RAM struct specialRegister *)0x9b)).bit0)
#define	P1W	(*((__RAM unsigned int*)0x9e))
#define	FP17W	((*((__RAM struct specialRegister *)0x9e)).bit7)
#define	FP16W	((*((__RAM struct specialRegister *)0x9e)).bit6)
#define	FP15W	((*((__RAM struct specialRegister *)0x9e)).bit5)
#define	FP14W	((*((__RAM struct specialRegister *)0x9e)).bit4)
#define	FP13W	((*((__RAM struct specialRegister *)0x9e)).bit3)
#define	FP12W	((*((__RAM struct specialRegister *)0x9e)).bit2)
#define	FP11W	((*((__RAM struct specialRegister *)0x9e)).bit1)
#define	FP10W	((*((__RAM struct specialRegister *)0x9e)).bit0)
#define	PEDGE	(*((__RAM unsigned int*)0x9f))
#define	FP00G1	((*((__RAM struct specialRegister *)0x9f)).bit1)
#define	FP00G0	((*((__RAM struct specialRegister *)0x9f)).bit0)
#define	P0M	(*((__RAM unsigned int*)0xa0))
#define	FP04M	((*((__RAM struct specialRegister *)0xa0)).bit4)
#define	FP03M	((*((__RAM struct specialRegister *)0xa0)).bit3)
#define	FP02M	((*((__RAM struct specialRegister *)0xa0)).bit2)
#define	FP01M	((*((__RAM struct specialRegister *)0xa0)).bit1)
#define	FP00M	((*((__RAM struct specialRegister *)0xa0)).bit0)
#define	P1M	(*((__RAM unsigned int*)0xa1))
#define	FP17M	((*((__RAM struct specialRegister *)0xa1)).bit7)
#define	FP16M	((*((__RAM struct specialRegister *)0xa1)).bit6)
#define	FP15M	((*((__RAM struct specialRegister *)0xa1)).bit5)
#define	FP14M	((*((__RAM struct specialRegister *)0xa1)).bit4)
#define	FP13M	((*((__RAM struct specialRegister *)0xa1)).bit3)
#define	FP12M	((*((__RAM struct specialRegister *)0xa1)).bit2)
#define	FP11M	((*((__RAM struct specialRegister *)0xa1)).bit1)
#define	FP10M	((*((__RAM struct specialRegister *)0xa1)).bit0)
#define	P0	(*((__RAM unsigned int*)0xa6))
#define	FP04	((*((__RAM struct specialRegister *)0xa6)).bit4)
#define	FP03	((*((__RAM struct specialRegister *)0xa6)).bit3)
#define	FP02	((*((__RAM struct specialRegister *)0xa6)).bit2)
#define	FP01	((*((__RAM struct specialRegister *)0xa6)).bit1)
#define	FP00	((*((__RAM struct specialRegister *)0xa6)).bit0)
#define	P1	(*((__RAM unsigned int*)0xa7))
#define	FP17	((*((__RAM struct specialRegister *)0xa7)).bit7)
#define	FP16	((*((__RAM struct specialRegister *)0xa7)).bit6)
#define	FP15	((*((__RAM struct specialRegister *)0xa7)).bit5)
#define	FP14	((*((__RAM struct specialRegister *)0xa7)).bit4)
#define	FP13	((*((__RAM struct specialRegister *)0xa7)).bit3)
#define	FP12	((*((__RAM struct specialRegister *)0xa7)).bit2)
#define	FP11	((*((__RAM struct specialRegister *)0xa7)).bit1)
#define	FP10	((*((__RAM struct specialRegister *)0xa7)).bit0)
#define	P0UR	(*((__RAM unsigned int*)0xac))
#define	P1UR	(*((__RAM unsigned int*)0xad))
#define	T0M	(*((__RAM unsigned int*)0xb2))
#define	FT0ENB	((*((__RAM struct specialRegister *)0xb2)).bit7)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xb2)).bit6)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xb2)).bit5)
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xb2)).bit4)
#define	FT0TB	((*((__RAM struct specialRegister *)0xb2)).bit0)
#define	T0C	(*((__RAM unsigned int*)0xb3))
#define	TC0M	(*((__RAM unsigned int*)0xb4))
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xb4)).bit7)
#define	FTC0RATE2	((*((__RAM struct specialRegister *)0xb4)).bit6)
#define	FTC0RATE1	((*((__RAM struct specialRegister *)0xb4)).bit5)
#define	FTC0RATE0	((*((__RAM struct specialRegister *)0xb4)).bit4)
#define	FTC0CKS1	((*((__RAM struct specialRegister *)0xb4)).bit3)
#define	FTC0CKS0	((*((__RAM struct specialRegister *)0xb4)).bit2)
#define	FTC0PO	((*((__RAM struct specialRegister *)0xb4)).bit1)
#define	FPWM0OUT	((*((__RAM struct specialRegister *)0xb4)).bit0)
#define	TC0C	(*((__RAM unsigned int*)0xb5))
#define	TC0R	(*((__RAM unsigned int*)0xb6))
#define	TC0D	(*((__RAM unsigned int*)0xb7))
#define	TC1M	(*((__RAM unsigned int*)0xb8))
#define	FTC1ENB	((*((__RAM struct specialRegister *)0xb8)).bit7)
#define	FTC1RATE2	((*((__RAM struct specialRegister *)0xb8)).bit6)
#define	FTC1RATE1	((*((__RAM struct specialRegister *)0xb8)).bit5)
#define	FTC1RATE0	((*((__RAM struct specialRegister *)0xb8)).bit4)
#define	FTC1CKS1	((*((__RAM struct specialRegister *)0xb8)).bit3)
#define	FTC1CKS0	((*((__RAM struct specialRegister *)0xb8)).bit2)
#define	FTC1PO	((*((__RAM struct specialRegister *)0xb8)).bit1)
#define	FPWM1OUT	((*((__RAM struct specialRegister *)0xb8)).bit0)
#define	TC1C	(*((__RAM unsigned int*)0xb9))
#define	TC1R	(*((__RAM unsigned int*)0xba))
#define	TC1D	(*((__RAM unsigned int*)0xbb))
#define	TC2M	(*((__RAM unsigned int*)0xbc))
#define	FTC2ENB	((*((__RAM struct specialRegister *)0xbc)).bit7)
#define	FTC2RATE2	((*((__RAM struct specialRegister *)0xbc)).bit6)
#define	FTC2RATE1	((*((__RAM struct specialRegister *)0xbc)).bit5)
#define	FTC2RATE0	((*((__RAM struct specialRegister *)0xbc)).bit4)
#define	FTC2CKS1	((*((__RAM struct specialRegister *)0xbc)).bit3)
#define	FTC2CKS0	((*((__RAM struct specialRegister *)0xbc)).bit2)
#define	FTC2PO	((*((__RAM struct specialRegister *)0xbc)).bit1)
#define	FPWM2OUT	((*((__RAM struct specialRegister *)0xbc)).bit0)
#define	TC2C	(*((__RAM unsigned int*)0xbd))
#define	TC2R	(*((__RAM unsigned int*)0xbe))
#define	TC2D	(*((__RAM unsigned int*)0xbf))
#define	P1CON	(*((__RAM unsigned int*)0xc6))
#define	ADM	(*((__RAM unsigned int*)0xc8))
#define	FADENB	((*((__RAM struct specialRegister *)0xc8)).bit7)
#define	FADS	((*((__RAM struct specialRegister *)0xc8)).bit6)
#define	FEOC	((*((__RAM struct specialRegister *)0xc8)).bit5)
#define	FGCHS	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	FCHS2	((*((__RAM struct specialRegister *)0xc8)).bit2)
#define	FCHS1	((*((__RAM struct specialRegister *)0xc8)).bit1)
#define	FCHS0	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	ADB	(*((__RAM unsigned int*)0xc9))
#define	FADB11	((*((__RAM struct specialRegister *)0xc9)).bit7)
#define	FADB10	((*((__RAM struct specialRegister *)0xc9)).bit6)
#define	FADB9	((*((__RAM struct specialRegister *)0xc9)).bit5)
#define	FADB8	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	FADB7	((*((__RAM struct specialRegister *)0xc9)).bit3)
#define	FADB6	((*((__RAM struct specialRegister *)0xc9)).bit2)
#define	FADB5	((*((__RAM struct specialRegister *)0xc9)).bit1)
#define	FADB4	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	ADR	(*((__RAM unsigned int*)0xca))
#define	FADCKS1	((*((__RAM struct specialRegister *)0xca)).bit6)
#define	FADLEN	((*((__RAM struct specialRegister *)0xca)).bit5)
#define	FADCKS0	((*((__RAM struct specialRegister *)0xca)).bit4)
#define	FADB3	((*((__RAM struct specialRegister *)0xca)).bit3)
#define	FADB2	((*((__RAM struct specialRegister *)0xca)).bit2)
#define	FADB1	((*((__RAM struct specialRegister *)0xca)).bit1)
#define	FADB0	((*((__RAM struct specialRegister *)0xca)).bit0)
#define	ADT	(*((__RAM unsigned int*)0xcb))
#define	FADTS1	((*((__RAM struct specialRegister *)0xcb)).bit7)
#define	FADTS0	((*((__RAM struct specialRegister *)0xcb)).bit6)
#define	FADT4	((*((__RAM struct specialRegister *)0xcb)).bit4)
#define	FADT3	((*((__RAM struct specialRegister *)0xcb)).bit3)
#define	FADT2	((*((__RAM struct specialRegister *)0xcb)).bit2)
#define	FADT1	((*((__RAM struct specialRegister *)0xcb)).bit1)
#define	FADT0	((*((__RAM struct specialRegister *)0xcb)).bit0)
#define	VREFH	(*((__RAM unsigned int*)0xcc))
#define	FEVHENB	((*((__RAM struct specialRegister *)0xcc)).bit7)
#define	FVHS1	((*((__RAM struct specialRegister *)0xcc)).bit1)
#define	FVHS0	((*((__RAM struct specialRegister *)0xcc)).bit0)
#define	PECMD	(*((__RAM unsigned int*)0xdb))
#define	PEROML	(*((__RAM unsigned int*)0xdc))
#define	PEROMH	(*((__RAM unsigned int*)0xdd))
#define	PERAML	(*((__RAM unsigned int*)0xde))
#define	PERAMCNT	(*((__RAM unsigned int*)0xdf))
#define	SIOM	(*((__RAM unsigned int*)0xe0))
#define	FSENB	((*((__RAM struct specialRegister *)0xe0)).bit7)
#define	FSTART	((*((__RAM struct specialRegister *)0xe0)).bit6)
#define	FSRATE1	((*((__RAM struct specialRegister *)0xe0)).bit5)
#define	FSRATE0	((*((__RAM struct specialRegister *)0xe0)).bit4)
#define	FMLSB	((*((__RAM struct specialRegister *)0xe0)).bit3)
#define	FSCKMD	((*((__RAM struct specialRegister *)0xe0)).bit2)
#define	FCPOL	((*((__RAM struct specialRegister *)0xe0)).bit1)
#define	FCPHA	((*((__RAM struct specialRegister *)0xe0)).bit0)
#define	SIOR	(*((__RAM unsigned int*)0xe1))
#define	SIOB	(*((__RAM unsigned int*)0xe2))
#define	SIOC	(*((__RAM unsigned int*)0xe3))
#define	FSIOBZ	((*((__RAM struct specialRegister *)0xe3)).bit2)
#define	FSCSEN	((*((__RAM struct specialRegister *)0xe3)).bit1)
#define	FSCSP	((*((__RAM struct specialRegister *)0xe3)).bit0)
#define	URTX	(*((__RAM unsigned int*)0xe4))
#define	FUTXEN	((*((__RAM struct specialRegister *)0xe4)).bit7)
#define	FUTXPEN	((*((__RAM struct specialRegister *)0xe4)).bit6)
#define	FUTXPS	((*((__RAM struct specialRegister *)0xe4)).bit5)
#define	FUTXBRK	((*((__RAM struct specialRegister *)0xe4)).bit4)
#define	FURXBZ	((*((__RAM struct specialRegister *)0xe4)).bit3)
#define	FUTXBZ	((*((__RAM struct specialRegister *)0xe4)).bit2)
#define	URRX	(*((__RAM unsigned int*)0xe5))
#define	FURXEN	((*((__RAM struct specialRegister *)0xe5)).bit7)
#define	FURXPEN	((*((__RAM struct specialRegister *)0xe5)).bit6)
#define	FURXPS	((*((__RAM struct specialRegister *)0xe5)).bit5)
#define	FURXPC	((*((__RAM struct specialRegister *)0xe5)).bit4)
#define	FUFMER	((*((__RAM struct specialRegister *)0xe5)).bit3)
#define	FURS2	((*((__RAM struct specialRegister *)0xe5)).bit2)
#define	FURS1	((*((__RAM struct specialRegister *)0xe5)).bit1)
#define	FURS0	((*((__RAM struct specialRegister *)0xe5)).bit0)
#define	URCR	(*((__RAM unsigned int*)0xe6))
#define	UTXD	(*((__RAM unsigned int*)0xe7))
#define	URXD	(*((__RAM unsigned int*)0xe8))
#define	STKP	(*((__RAM unsigned int*)0xef))
#define	FGIE	((*((__RAM struct specialRegister *)0xef)).bit7)
#define	FLVD24	((*((__RAM struct specialRegister *)0xef)).bit6)
#define	FLVD33	((*((__RAM struct specialRegister *)0xef)).bit5)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xef)).bit2)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xef)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xef)).bit0)
#define	STK7L	(*((__RAM unsigned int*)0xf0))
#define	STK7H	(*((__RAM unsigned int*)0xf1))
#define	STK6L	(*((__RAM unsigned int*)0xf2))
#define	STK6H	(*((__RAM unsigned int*)0xf3))
#define	STK5L	(*((__RAM unsigned int*)0xf4))
#define	STK5H	(*((__RAM unsigned int*)0xf5))
#define	STK4L	(*((__RAM unsigned int*)0xf6))
#define	STK4H	(*((__RAM unsigned int*)0xf7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#endif
