/*-------------------------------------------------------------------------
  stdlib.h - ANSI functions forward declarations

             Written By -  Sandeep Dutta . sandeep.dutta@usa.net (1998)

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   In other words, you are welcome to use, share and improve this program.
   You are forbidden to forbid anyone else to use, share and improve
   what you give them.   Help stamp out software-hoarding!
-------------------------------------------------------------------------*/

#ifndef __STDLIB_H
#define __STDLIB_H

#include <stddef.h>

typedef struct
{
    int quot;
    int rem;
} div_t;

typedef struct
{
    long quot;
    long rem;
} ldiv_t;


extern float atof(__GENERIC char *);
extern int atoi(__GENERIC char *);
extern long atol(__GENERIC char *);
extern int abs(int);
extern long labs(long);
extern div_t div(int, int);
extern ldiv_t ldiv(long, long);
extern int rand(void);
extern void srand(unsigned int);
extern long strtol(__GENERIC char *, __GENERIC char **, int); 
extern unsigned long strtoul(__GENERIC char *, __GENERIC char **, int); 
#endif
