; crt0_mb for sn8cc
; Support chip SN8270X series

CHIP		SN8P2708A	; Select the CHIP

; Define GOTO_THE_END to run batch tests
GOTO_THE_END EQU 0

;INCLUDESTD	MACRO1.H
;INCLUDESTD	MACRO2.H
;INCLUDESTD	MACRO3.H

Extern CODE _main
Public exit

public _tmpA
public FR0
public FR1
public FR2
public FR3
public LR0
public LR1
public LR2
public LR3
public R0
public R1
public R2
public R3
public T

crt0@data segment data bank 0
; 29 bytes
;_tmpB ds 1
_tmpA ds 1
T ds 1	;temp register for library
R0 ds 1
R1 ds 1
R2 ds 1
R3 ds 1
LR0 ds 2
LR1 ds 2
LR2 ds 2
LR3 ds 2
FR0 ds 4
FR1 ds 4
FR2 ds 4
FR3 ds 4



;-------------------------------------------------------------------------------
;			Code section
;-------------------------------------------------------------------------------
//.CODE
crt0@code segment code at 0x0
	ORG	0					;Code section start
	jmp		_sgv_init_entry		;Reset vector
								;Address 4 to 7 are reserved
								
	;2005-06-23	Joe Add NOP at org 8 let rom converter fixed interrupt problem
	ORG	8
	NOP;

if (GOTO_THE_END != 0)
		ORG	10h
THE_END:
	nop	
	jmp THE_END
endif


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_SGV_INIT_CODE segment CODE
PUBLIC _sgv_init_entry
_sgv_init_entry:

;-------------------------------------------------------------------------------
; Clear Watch dog timer
;-------------------------------------------------------------------------------
	MOV  A, #5AH
	B0MOV  WDTR, A
	
;-------------------------------------------------------------------------------
; Call Clear RAM : Use index @YZ to clear RAM  (00h~7Fh)
;-------------------------------------------------------------------------------
	CALL ClrRAM;
;-------------------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_SGV_INIT_CODE_END segment CODE

;-------------------------------------------------------------------------------
; Clear Watch dog timer
;-------------------------------------------------------------------------------
	MOV  A, #5AH
	B0MOV  WDTR, A
	
if (GOTO_THE_END != 0)
    CALL _main
	B0MOV	R, A
    JMP THE_END
else
    JMP _main
endif	

;-------------------------------------------------------------------------------
; ClrRAM
; Use index @YZ to clear RAM  (00h~7Fh)
;-------------------------------------------------------------------------------

ClrRAM:

; RAM Bank 0
	clr 		Y	    			;Select bank 0 
	b0mov		Z,#0x7f				;Set @YZ address from 7fh

ClrRAM10:
	clr 		@YZ				;Clear @YZ content
	decms		Z   				;z = z - 1 , skip next if z=0
	jmp 		ClrRAM10
	clr 		@YZ				;Clear address 0x00

	ret
