
;------------------------------------------------------------------------------
;  CHIP: SN8F2288
;  Revision History
;  
;  V01   2008/05/23
;  V02   2008/10/22   1. 092H bit 6  PKT_ERR	
;                     2. 0E9H bit 2  P05OC		
;	                            bit 3  P06OC
;                     3. Update the 0xC7 bit6&7
;	                    4. 092H bit 7  CRC_ERR
;	                    5. 09CH bit 4  UE3MODE
;                     6. 09EH bit 4  UE4MODE
;	                    7. 0B3H Register OSBH
;                     8. 0B4H Register OSBL
;                     9. 0A9H bit 7  UCLK_SEL
;  V03   2008/10/23   1. Reserve 4-Words of ROM size for unique code
;  V04   2008/12/30   1. Rename T1C Counting Register to T1CH and T1CL
;  V05	 2009/11/16   1. Remove LVD_L selection in Code option.
;		      						2. Replace Ext_OSC with High_CLK in Code option.
;  V06   2012/07/12   1. Add "PCL_READ_LIMIT" Key word
;  V07   2013/09/04   1. Add "B0BTS0_LIMIT, B0BTS1_LIMIT, BTS0_LIMIT, BTS1_LIMIT" Key word.
;  V08   2013/11/29   1. Modify TC0R, TC1R, TC2R, UE1R_C, ADB, ADR, P4CON, P1OC, STKnH, STKnL registers define.
;------------------------------------------------------------------------------
.ASSEMBLY RedWrt_FORMAT    1
.Assembly	INC_VER		6
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	512

.Assembly	INSTRUMENT	SN8F2288
.Assembly	BIT_FILE	SN8F2288

.Assembly	OTP_BODY_SIZE	0x3000
.Assembly	USER_ROM_SIZE	0x2FF8

.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000

.Assembly	PGM_TYPE	6
.Assembly	CHIP_ID		0x2700
.Assembly	command		Enable_ORG4_7, RBANK_LIMIT, Enable_ISP, PCL_READ_LIMIT, B0_B_TS01_LIMIT
.Assembly	Port_Pins	8, 8, 6, 4, 8, 6

.Assembly	USB_FIFO_Size	136, 136

; Code Option 0x2FFF
.Assembly	OPTION		0		Fix_Low
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		4		High_CLK	6M_X'tal 12M_X'tal 16M_X'tal x
.Help
{
;	IHRC_6M		: "Internal 6M RC Oscillator"
;	IHRC_RTC	: "Internal 6M RC Oscillator with RTC\nConnect 32768Hz crytal to XIN/XOUT"
	6M_X'tal	: "Crystal/Resonator: 6Mhz"
	12M_X'tal	: "Crystal/Resonator: 12Mhz"
	16M_X'tal	: "Crystal/Resonator: 16Mhz"
}
;.Assembly	OPTION		6 		Bypass		Enable  Disable
.Assembly	OPTION		6 		Fix_High
.Assembly	OPTION		7		Fslow	Flosc/2	Flosc/4
.Help
{
	Flosc/2		: "Slow mode clock = Flosc/2"
	Flosc/4		: "Slow mode clock = Flosc/4"
}
;.Assembly	OPTION		7		Fix_High
.Assembly	OPTION		8		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x
.Assembly	OPTION		12		Reset_Pin       P07 	Reset
.Assembly	OPTION		13		Rst_Length  	No 	128*ILRC
;.Assembly	OPTION		13		Fix_High
;.Assembly	OPTION		14		Fix_High
;.Assembly	OPTION		15		Fix_Low
.Assembly	OPTION		14		LVD		x	LVD_M	LVD_H	x
.Help
{
	LVD_M		: "Low Voltage Detect 2.4V"
	LVD_H		: "Low Voltage Detect 3.6V"
}
;.Assembly	OPTION		15		SMODE3      Disable Enable


; Code Option 0x2FFE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x2FFD
.Assembly	OPTION		32 		Fix_low
.Assembly	OPTION		33 		Fix_low
.Assembly	OPTION		34 		Fix_High
.Assembly	OPTION		35 		Fix_low
.Assembly	OPTION		36 		Fix_low
.Assembly	OPTION		37 		Fix_High
.Assembly	OPTION		38 		Fix_low
.Assembly	OPTION		39 		Fix_low
.Assembly	OPTION		40 		Fix_High
.Assembly	OPTION		41 		Fix_low
.Assembly	OPTION		42 		Fix_low
.Assembly	OPTION		43 		Fix_High
.Assembly	OPTION		44 		Fix_High
.Assembly	OPTION		45 		Fix_High
.Assembly	OPTION		46 		Fix_High
.Assembly	OPTION		47		Fix_low

; Code Option 0x2FFC
.Assembly	OPTION		48 		Fix_low
.Assembly	OPTION		49 		Fix_low
.Assembly	OPTION		50 		Fix_High

.Assembly	OPTION		51 		Fix_low
.Assembly	OPTION		52 : 63 		Fix_High


.Assembly	OPTION		2ffh

	H			EQU		80H
	L			EQU		81H
	R			EQU		82H
	Z			EQU		83H
	Y			EQU		84H
	
	PFLAG		EQU		86H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FNPD	EQU		PFLAG.6
		FNT0	EQU		PFLAG.7

	RBANK		EQU		87H
		FRBNKS0	EQU		RBANK.0
		FRBNKS1	EQU		RBANK.1

	TC0M		EQU		088H
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		FTC0CKS		EQU	TC0M.3
    		FALOAD0 	EQU 	TC0M.2
    		FTC0OUT   	EQU 	TC0M.1
    		FPWM0OUT  	EQU 	TC0M.0 
    
	TC0C			EQU		089H	
	TC0R			EQU_W		08AH
	
	TC1M		EQU		08BH
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
		FTC1CKS		EQU	TC1M.3
    		FALOAD1   	EQU 	TC1M.2
    		FTC1OUT   	EQU 	TC1M.1
    		FPWM1OUT  	EQU 	TC1M.0 
    
	TC1C		EQU		08CH	
	TC1R		EQU_W		08DH

	TC2M		EQU		08EH
		FTC2ENB		EQU	TC2M.7
		FTC2RATE2	EQU	TC2M.6
		FTC2RATE1	EQU	TC2M.5
		FTC2RATE0	EQU	TC2M.4
		FTC2CKS		EQU	TC2M.3
    		FALOAD2   	EQU 	TC2M.2
    		FTC2OUT   	EQU 	TC2M.1
    		FPWM2OUT  	EQU 	TC2M.0 

	TC2C		EQU		08FH
	TC2R		EQU_W		090H

	UDA		EQU		091H
		FUDE		EQU	UDA.7
		FUDA6		EQU	UDA.6
		FUDA5		EQU	UDA.5
		FUDA4		EQU	UDA.4
		FUDA3		EQU	UDA.3
		FUDA2		EQU	UDA.2
		FUDA1		EQU	UDA.1
		FUDA0		EQU	UDA.0

	USTATUS		EQU		092H
		FCRCERR	EQU	USTATUS.7
		FPKTERR	EQU	USTATUS.6
		FSOF		EQU	USTATUS.5				
		FBUS_RST	EQU_R	USTATUS.4
		FSUSPEND	EQU_R	USTATUS.3
		FEP0SETUP	EQU	USTATUS.2
		FEP0IN		EQU	USTATUS.1
		FEP0OUT		EQU	USTATUS.0
		
	EP0OUT_CNT	EQU		093H
		FUEP0OC4	EQU	EP0OUT_CNT.4
		FUEP0OC3	EQU	EP0OUT_CNT.3
		FUEP0OC2	EQU	EP0OUT_CNT.2
		FUEP0OC1	EQU	EP0OUT_CNT.1
		FUEP0OC0	EQU	EP0OUT_CNT.0
	
	USB_INT_EN	EQU		094H
		FREG_EN		EQU	USB_INT_EN.7
		FDP_PU_EN	EQU	USB_INT_EN.6
		FSOF_INT_EN	EQU	USB_INT_EN.5
		FEP4NAK_INT_EN	EQU	USB_INT_EN.3
		FEP3NAK_INT_EN	EQU	USB_INT_EN.2
		FEP2NAK_INT_EN	EQU	USB_INT_EN.1
		FEP1NAK_INT_EN	EQU	USB_INT_EN.0
	
	EP_ACK		EQU		095H
		FEP4_ACK	EQU	EP_ACK.3
		FEP3_ACK	EQU	EP_ACK.2
		FEP2_ACK	EQU	EP_ACK.1
		FEP1_ACK	EQU	EP_ACK.0
	
	EP_NAK		EQU		096H
		FEP4_NAK	EQU	EP_NAK.3
		FEP3_NAK	EQU	EP_NAK.2
		FEP2_NAK	EQU	EP_NAK.1
		FEP1_NAK	EQU	EP_NAK.0
		
	UE0R		EQU		097H
		FUE0M1		EQU	UE0R.6
		FUE0M0		EQU	UE0R.5
		FUE0C3		EQU	UE0R.3
		FUE0C2		EQU	UE0R.2
		FUE0C1		EQU	UE0R.1
		FUE0C0		EQU	UE0R.0

	UE1R		EQU		098H
		FUE1E		EQU	UE1R.7
		FUE1M1		EQU	UE1R.6
		FUE1M0		EQU	UE1R.5

	UE1R_C		EQU		099H
		FUE1C6		EQU	UE1R_C.6
		FUE1C5		EQU	UE1R_C.5
		FUE1C4		EQU	UE1R_C.4
		FUE1C3		EQU	UE1R_C.3
		FUE1C2		EQU	UE1R_C.2
		FUE1C1		EQU	UE1R_C.1
		FUE1C0		EQU	UE1R_C.0

	UE2R		EQU		09AH
		FUE2E		EQU	UE2R.7
		FUE2M1		EQU	UE2R.6
		FUE2M0		EQU	UE2R.5


	UE2R_C		EQU		09BH
		FUE2C6		EQU	UE2R_C.6
		FUE2C5		EQU	UE2R_C.5
		FUE2C4		EQU	UE2R_C.4
		FUE2C3		EQU	UE2R_C.3
		FUE2C2		EQU	UE2R_C.2
		FUE2C1		EQU	UE2R_C.1
		FUE2C0		EQU	UE2R_C.0
	
	UE3R		EQU		09CH
		FUE3E		EQU	UE3R.7
		FUE3M1		EQU	UE3R.6
		FUE3M0		EQU	UE3R.5

	UE3R_C		EQU		09DH
		FUE3C6		EQU	UE3R_C.6
		FUE3C5		EQU	UE3R_C.5
		FUE3C4		EQU	UE3R_C.4
		FUE3C3		EQU	UE3R_C.3
		FUE3C2		EQU	UE3R_C.2
		FUE3C1		EQU	UE3R_C.1
		FUE3C0		EQU	UE3R_C.0
	
	UE4R		EQU		09EH
		FUE4E		EQU	UE4R.7
		FUE4M1		EQU	UE4R.6
		FUE4M0		EQU	UE4R.5

	UE4R_C		EQU		09FH
		FUE4C6		EQU	UE4R_C.6
		FUE4C5		EQU	UE4R_C.5
		FUE4C4		EQU	UE4R_C.4
		FUE4C3		EQU	UE4R_C.3
		FUE4C2		EQU	UE4R_C.2
		FUE4C1		EQU	UE4R_C.1
		FUE4C0		EQU	UE4R_C.0
	
	EP2FIFO_ADDR	EQU		0A0H
		FEP2FIFO7	EQU	EP2FIFO_ADDR.7
		FEP2FIFO6	EQU	EP2FIFO_ADDR.6
		FEP2FIFO5	EQU	EP2FIFO_ADDR.5
		FEP2FIFO4	EQU	EP2FIFO_ADDR.4
		FEP2FIFO3	EQU	EP2FIFO_ADDR.3
		FEP2FIFO2	EQU	EP2FIFO_ADDR.2
		FEP2FIFO1	EQU	EP2FIFO_ADDR.1
		FEP2FIFO0	EQU	EP2FIFO_ADDR.0

	EP3FIFO_ADDR	EQU		0A1H
		FEP3FIFO7	EQU	EP3FIFO_ADDR.7
		FEP3FIFO6	EQU	EP3FIFO_ADDR.6
		FEP3FIFO5	EQU	EP3FIFO_ADDR.5
		FEP3FIFO4	EQU	EP3FIFO_ADDR.4
		FEP3FIFO3	EQU	EP3FIFO_ADDR.3
		FEP3FIFO2	EQU	EP3FIFO_ADDR.2
		FEP3FIFO1	EQU	EP3FIFO_ADDR.1
		FEP3FIFO0	EQU	EP3FIFO_ADDR.0

	EP4FIFO_ADDR	EQU		0A2H
		FEP4FIFO7	EQU	EP4FIFO_ADDR.7
		FEP4FIFO6	EQU	EP4FIFO_ADDR.6
		FEP4FIFO5	EQU	EP4FIFO_ADDR.5
		FEP4FIFO4	EQU	EP4FIFO_ADDR.4
		FEP4FIFO3	EQU	EP4FIFO_ADDR.3
		FEP4FIFO2	EQU	EP4FIFO_ADDR.2
		FEP4FIFO1	EQU	EP4FIFO_ADDR.1
		FEP4FIFO0	EQU	EP4FIFO_ADDR.0
	
	UDP0		EQU		0A3H
		FUDP07		EQU	UDP0.7
		FUDP06		EQU	UDP0.6
		FUDP05		EQU	UDP0.5
		FUDP04		EQU	UDP0.4
		FUDP03		EQU	UDP0.3
		FUDP02		EQU	UDP0.2
		FUDP01		EQU	UDP0.1
		FUDP00		EQU	UDP0.0		
	
	UDR0_R		EQU		0A5H
	 	FUDR0_R7	EQU		UDR0_R.7
		FUDR0_R6	EQU		UDR0_R.6
		FUDR0_R5	EQU		UDR0_R.5
		FUDR0_R4	EQU		UDR0_R.4
		FUDR0_R3	EQU		UDR0_R.3
		FUDR0_R2	EQU		UDR0_R.2
		FUDR0_R1	EQU		UDR0_R.1
		FUDR0_R0	EQU		UDR0_R.0
	
	UDR0_W		EQU		0A6H
		FUDR0_W7	EQU		UDR0_W.7
		FUDR0_W6	EQU		UDR0_W.6
		FUDR0_W5	EQU		UDR0_W.5
		FUDR0_W4	EQU		UDR0_W.4
		FUDR0_W3	EQU		UDR0_W.3
		FUDR0_W2	EQU		UDR0_W.2
		FUDR0_W1	EQU		UDR0_W.1
		FUDR0_W0	EQU		UDR0_W.0	

	UPID		EQU		0A7H
	 	FUBDE		EQU		UPID.2
		FDDP		EQU		UPID.1
		FDDN		EQU		UPID.0	

	UTOGGLE		EQU		0A8H
		FEP4_DATA01	EQU		UTOGGLE.3
		FEP3_DATA01	EQU		UTOGGLE.2
		FEP2_DATA01	EQU		UTOGGLE.1
		FEP1_DATA01	EQU		UTOGGLE.0

	
	URTX		EQU		0A9H

		FUCLKS	EQU		URTX.7
		FUTXEN		EQU		URTX.4
		FUTXPEN		EQU		URTX.3
		FUTXPS		EQU		URTX.2
		FUTXM		EQU		URTX.1

	URRX		EQU		0AAH
		FURXEN		EQU		URRX.7
		FURXS1		EQU		URRX.6
		FURXS0		EQU		URRX.5
		FURXPEN		EQU		URRX.4
		FURXPS		EQU		URRX.3
		FURXPC		EQU		URRX.2
		FURXM		EQU		URRX.1

	URBRC		EQU		0ABH
		FUDIV4		EQU		URBRC.7
		FUDIV3		EQU		URBRC.6
		FUDIV2		EQU		URBRC.5
		FUDIV1		EQU		URBRC.4
		FUDIV0		EQU		URBRC.3
		FUPCS2		EQU		URBRC.2
		FUPCS1		EQU		URBRC.1
		FUPCS0		EQU		URBRC.0

	URTXD1		EQU		0ACH
		FUTXD17		EQU		URTXD1.7
		FUTXD16		EQU		URTXD1.6
		FUTXD15		EQU		URTXD1.5
		FUTXD14		EQU		URTXD1.4
		FUTXD13		EQU		URTXD1.3
		FUTXD12		EQU		URTXD1.2
		FUTXD11		EQU		URTXD1.1
		FUTXD10		EQU		URTXD1.0

	URTXD2		EQU		0ADH
		FUTXD27		EQU		URTXD2.7
		FUTXD26		EQU		URTXD2.6
		FUTXD25		EQU		URTXD2.5
		FUTXD24		EQU		URTXD2.4
		FUTXD23		EQU		URTXD2.3
		FUTXD22		EQU		URTXD2.2
		FUTXD21		EQU		URTXD2.1
		FUTXD20		EQU		URTXD2.0
/*
	URRXD1		EQU		0AEH
		FURXD17		EQU		URRXD1.7
		FURXD16		EQU		URRXD1.6
		FURXD15		EQU		URRXD1.5
		FURXD14		EQU		URRXD1.4
		FURXD13		EQU		URRXD1.3
		FURXD12		EQU		URRXD1.2
		FURXD11		EQU		URRXD1.1
		FURXD10		EQU		URRXD1.0

	URRXD2		EQU		0AFH
		FURXD27		EQU		URRXD2.7
		FURXD26		EQU		URRXD2.6
		FURXD25		EQU		URRXD2.5
		FURXD24		EQU		URRXD2.4
		FURXD23		EQU		URRXD2.3
		FURXD22		EQU		URRXD2.2
		FURXD21		EQU		URRXD2.1
		FURXD20		EQU		URRXD2.0
*/		
	URRXD1		EQU_R		0AEH
	URRXD2		EQU_R		0AFH
		
	SIOM		EQU		0B0H
		FSENB		EQU		SIOM.7
		FSTART		EQU		SIOM.6
		FSRATE1		EQU		SIOM.5
		FSRATE0		EQU		SIOM.4
		FMLSB		EQU		SIOM.3
		FSCKMD		EQU		SIOM.2
		FCPOL		EQU		SIOM.1
		FCPHA		EQU		SIOM.0

	SIOR		EQU_W		0B1H
	
	SIOB		EQU		0B2H
		FSIOB7		EQU		SIOB.7
		FSIOB6		EQU		SIOB.6
		FSIOB5		EQU		SIOB.5
		FSIOB4		EQU		SIOB.4
		FSIOB3		EQU		SIOB.3
		FSIOB2		EQU		SIOB.2
		FSIOB1		EQU		SIOB.1
		FSIOB0		EQU		SIOB.0
		
	/*
	OSBH		EQU		0B3H
		FOSB11		EQU		OSBH.7
		FOSB10		EQU		OSBH.6
		FOSB09		EQU		OSBH.5
		FOSB08		EQU		OSBH.4
		FOSB07		EQU		OSBH.3
		FOSB06		EQU		OSBH.2
		FOSB05		EQU		OSBH.1
		FOSB04		EQU		OSBH.0
	
	OSBL		EQU		0B4H
		FADCOF		EQU		OSBL.7
		FOSSIG		EQU		OSBL.6
		FOSB03		EQU		OSBL.3
		FOSB02		EQU		OSBL.2
		FOSB01		EQU		OSBL.1
		FOSB00		EQU		OSBL.0
	*/
	
	P0M		EQU		0B5H
		FP07M		EQU		P0M.7
		FP06M		EQU		P0M.6
		FP05M		EQU		P0M.5		
		FP04M		EQU		P0M.4
		FP03M		EQU		P0M.3
		FP02M		EQU		P0M.2
		FP01M		EQU		P0M.1
		FP00M		EQU		P0M.0

	ADM		EQU		0B6H
		FADENB		EQU		ADM.7
		FADS		EQU		ADM.6
		FEOC		EQU		ADM.5
		FGCHS		EQU		ADM.4
		FCHS3		EQU		ADM.3
		FCHS2		EQU		ADM.2
		FCHS1		EQU		ADM.1
		FCHS0		EQU		ADM.0

	ADB		EQU_R		0B7H
		FADB11		EQU_R		ADB.7
		FADB10		EQU_R		ADB.6
		FADB9		EQU_R		ADB.5
		FADB8		EQU_R		ADB.4
		FADB7		EQU_R		ADB.3
		FADB6		EQU_R		ADB.2
		FADB5		EQU_R		ADB.1
		FADB4		EQU_R		ADB.0

	ADR		EQU		0B8H
		FADCKS2		EQU		ADR.7
		FADCKS1		EQU		ADR.6
		FADCKS0		EQU		ADR.5
		FADLEN		EQU		ADR.4
		FADB3		EQU_R		ADR.3
		FADB2		EQU_R		ADR.2
		FADB1		EQU_R		ADR.1
		FADB0		EQU_R		ADR.0

	P4CON		EQU_W		0B9H
		FP4CON7		EQU_W		P4CON.7
		FP4CON6		EQU_W		P4CON.6
		FP4CON5		EQU_W		P4CON.5
		FP4CON4		EQU_W		P4CON.4
		FP4CON3		EQU_W		P4CON.3
		FP4CON2		EQU_W		P4CON.2
		FP4CON1		EQU_W		P4CON.1
		FP4CON0		EQU_W		P4CON.0

	PECMD		EQU_W		0BAH
		
	PEROML		EQU		0BBH		
		FPEROML7	EQU	PEROML.7
		FPEROML6	EQU	PEROML.6
		FPEROML5	EQU	PEROML.5
		FPEROML4	EQU	PEROML.4
		FPEROML3	EQU	PEROML.3
		FPEROML2	EQU	PEROML.2
		FPEROML1	EQU	PEROML.1
		FPEROML0	EQU	PEROML.0	
		
	PEROMH		EQU		0BCH
		FPEROMH7	EQU	PEROMH.7
		FPEROMH6	EQU	PEROMH.6
		FPEROMH5	EQU	PEROMH.5
		FPEROMH4	EQU	PEROMH.4
		FPEROMH3	EQU	PEROMH.3
		FPEROMH2	EQU	PEROMH.2
		FPEROMH1	EQU	PEROMH.1
		FPEROMH0	EQU	PEROMH.0	
		
	PERAML		EQU		0BDH
		FPERAML7	EQU	PERAML.7
		FPERAML6	EQU	PERAML.6
		FPERAML5	EQU	PERAML.5
		FPERAML4	EQU	PERAML.4
		FPERAML3	EQU	PERAML.3
		FPERAML2	EQU	PERAML.2
		FPERAML1	EQU	PERAML.1
		FPERAML0	EQU	PERAML.0

	PERAMCNT	EQU		0BEH
		FPERAMCNT4	EQU	PERAMCNT.7
		FPERAMCNT3	EQU	PERAMCNT.6
		FPERAMCNT2	EQU	PERAMCNT.5
		FPERAMCNT1	EQU	PERAMCNT.4
		FPERAMCNT0	EQU	PERAMCNT.3
		FPERAML9	EQU	PERAMCNT.1
		FPERAML8	EQU	PERAMCNT.0

	PEDGE		EQU		0BFH		
		FP01G1		EQU	PEDGE.3
		FP01G0		EQU	PEDGE.2
		FP00G1		EQU	PEDGE.1
		FP00G0		EQU	PEDGE.0

	P1W		EQU		0C0H
		FP17W		EQU	P1W.7
		FP16W		EQU	P1W.6
		FP15W		EQU	P1W.5
		FP14W		EQU	P1W.4
		FP13W		EQU	P1W.3
		FP12W		EQU	P1W.2
		FP11W		EQU	P1W.1
		FP10W		EQU	P1W.0

	P1M		EQU		0C1H
		FP17M		EQU	P1M.7
		FP16M		EQU	P1M.6
		FP15M		EQU	P1M.5
		FP14M		EQU	P1M.4
		FP13M		EQU	P1M.3
		FP12M		EQU	P1M.2
		FP11M		EQU	P1M.1
		FP10M		EQU	P1M.0
		
	P2M		EQU		0C2H
		FP27M		EQU	P2M.7
		FP26M		EQU	P2M.6
		FP25M		EQU	P2M.5
		FP24M		EQU	P2M.4
		FP23M		EQU	P2M.3
		FP22M		EQU	P2M.2
		FP21M		EQU	P2M.1
		FP20M		EQU	P2M.0
/*
	P3M		EQU		0C3H
		FP33M		EQU	P3M.3
		FP32M		EQU	P3M.2
		FP31M		EQU	P3M.1
		FP30M		EQU	P3M.0
*/
	P4M		EQU		0C4H
		FP47M		EQU	P4M.7
		FP46M		EQU	P4M.6
		FP45M		EQU	P4M.5
		FP44M		EQU	P4M.4
		FP43M		EQU	P4M.3
		FP42M		EQU	P4M.2
		FP41M		EQU	P4M.1
		FP40M		EQU	P4M.0
		
	P5M		EQU		0C5H
		FP55M		EQU	P5M.5
  	FP54M		EQU	P5M.4
  	FP53M		EQU	P5M.3	  		
  	FP52M		EQU	P5M.2
  	FP51M		EQU	P5M.1
  	FP50M		EQU	P5M.0	
  		
  INTRQ1		EQU		0C6H
		FP1IRQ		EQU	INTRQ1.7
		FP0IRQ		EQU	INTRQ1.6
		FMSPIRQ		EQU	INTRQ1.5
		FUTRXIRQ	EQU	INTRQ1.4
		FUTTXIRQ	EQU	INTRQ1.3
		FTC2IRQ		EQU	INTRQ1.2
		FTC1IRQ		EQU	INTRQ1.1
		FTC0IRQ		EQU	INTRQ1.0

	INTEN1		EQU		0C7H
		FP1IEN		EQU	INTEN1.7
		FP0IEN		EQU	INTEN1.6
		FMSPIEN		EQU	INTEN1.5
		FUTRXIEN	EQU	INTEN1.4
		FUTTXIEN	EQU	INTEN1.3
		FTC2IEN		EQU	INTEN1.2
		FTC1IEN		EQU	INTEN1.1
		FTC0IEN		EQU	INTEN1.0
				
	INTRQ		EQU		0C8H
		FADCIRQ		EQU	INTRQ.7
		FUSBIRQ		EQU	INTRQ.6
		FT1IRQ		EQU	INTRQ.5
		FT0IRQ		EQU	INTRQ.4
		FSIOIRQ		EQU	INTRQ.3	
		FWAKEIRQ	EQU	INTRQ.2
		FP01IRQ		EQU	INTRQ.1
		FP00IRQ		EQU	INTRQ.0

	INTEN		EQU		0C9H
		FADCIEN 	EQU	INTEN.7
		FUSBIEN		EQU	INTEN.6
		FT1IEN		EQU	INTEN.5
		FT0IEN		EQU	INTEN.4
		FSIOIEN		EQU	INTEN.3		
		FWAKEIEN	EQU	INTEN.2
		FP01IEN		EQU	INTEN.1
		FP00IEN		EQU	INTEN.0

	OSCM		EQU		0CAH
		FCPUM1		EQU	OSCM.4
		FCPUM0		EQU	OSCM.3
		FCLKMD		EQU	OSCM.2
		FSTPHX		EQU	OSCM.1

	WDTR		EQU_W		0CCH
    
	PCL		EQU		0CEH
		FPC7		EQU 	PCL.7
		FPC6		EQU 	PCL.6
		FPC5		EQU 	PCL.5		
		FPC4		EQU 	PCL.4
		FPC3		EQU 	PCL.3
		FPC2		EQU 	PCL.2
		FPC1		EQU 	PCL.1
		FPC0		EQU 	PCL.0
		
	PCH		EQU		0CFH
		FPC13		EQU 	PCH.5		
		FPC12		EQU 	PCH.4
		FPC11		EQU 	PCH.3
		FPC10		EQU 	PCH.2
		FPC9		EQU 	PCH.1
		FPC8		EQU 	PCH.0
		
	P0		EQU 		0D0H
		FP07		EQU 	P0.7
		FP06		EQU 	P0.6
		FP05		EQU 	P0.5		
		FP04		EQU 	P0.4
		FP03		EQU 	P0.3
		FP02		EQU 	P0.2
		FP01		EQU 	P0.1
		FP00		EQU 	P0.0

	P1		EQU 		0D1H
		FP17		EQU 	P1.7
		FP16		EQU 	P1.6
		FP15		EQU 	P1.5
		FP14		EQU 	P1.4
		FP13		EQU 	P1.3
		FP12		EQU 	P1.2
		FP11		EQU 	P1.1
		FP10		EQU 	P1.0
		
	P2		EQU 		0D2H
		FP27		EQU		P2.7
		FP26		EQU		P2.6
		FP25		EQU		P2.5	
		FP24		EQU		P2.4
		FP23		EQU 	P2.3
		FP22		EQU 	P2.2
		FP21		EQU 	P2.1
		FP20		EQU 	P2.0	
/*
	P3		EQU 		0D3H
		FP33		EQU 	P3.3
		FP32		EQU 	P3.2
		FP31		EQU 	P3.1
		FP30		EQU 	P3.0	
*/
	P4		EQU 		0D4H
		FP47		EQU		P4.7
		FP46		EQU		P4.6
		FP45		EQU		P4.5	
		FP44		EQU		P4.4
		FP43		EQU 	P4.3
		FP42		EQU 	P4.2
		FP41		EQU 	P4.1
		FP40		EQU 	P4.0
	
	P5		EQU		0D5H
		FP55		EQU		P5.5
		FP54		EQU		P5.4
		FP53		EQU		P5.3		
		FP52		EQU		P5.2
		FP51		EQU		P5.1
		FP50		EQU		P5.0	

	T0M		EQU		0D8H
		FT0ENB     	EQU	T0M.7
		FT0RATE2   	EQU	T0M.6
		FT0RATE1   	EQU	T0M.5
		FT0RATE0   	EQU	T0M.4

	T0C		EQU		0D9H
		FT0C7		EQU		T0C.7
		FT0C6		EQU		T0C.6
		FT0C5		EQU		T0C.5	
		FT0C4		EQU		T0C.4
		FT0C3		EQU 	T0C.3
		FT0C2		EQU 	T0C.2
		FT0C1		EQU 	T0C.1
		FT0C0		EQU 	T0C.0
		
	T1M		EQU		0DAH
		FT1ENB		EQU	T1M.7
		FT1RATE2	EQU	T1M.6
		FT1RATE1	EQU	T1M.5
		FT1RATE0	EQU	T1M.4		

	T1CL		EQU		0DBH
		FT1C7			EQU	T1CL.7
		FT1C6			EQU	T1CL.6
		FT1C5			EQU	T1CL.5
		FT1C4			EQU	T1CL.4
		FT1C3			EQU	T1CL.3
		FT1C2			EQU	T1CL.2
		FT1C1			EQU	T1CL.1
		FT1C0			EQU	T1CL.0

	T1CH		EQU		0DCH 
		FT1C15		EQU	T1CH.7
		FT1C14		EQU	T1CH.6
		FT1C13		EQU	T1CH.5
		FT1C12		EQU	T1CH.4
		FT1C11		EQU	T1CH.3
		FT1C10		EQU	T1CH.2
		FT1C9			EQU	T1CH.1
		FT1C8			EQU	T1CH.0

	STKP		EQU		0DFH
		FGIE			EQU	STKP.7
		FSTKPB2		EQU	STKP.2
		FSTKPB1		EQU	STKP.1
		FSTKPB0		EQU	STKP.0

 	P0UR   	EQU_W  	0E0H
 	P1UR   	EQU_W  	0E1H
	P2UR		EQU_W		0E2H
	/*
	P3UR		EQU_W		0E3H
	*/
	P4UR		EQU_W		0E4H
 	P5UR   		EQU_W  		0E5H
       
	@YZ		EQU		0E7H

	P1OC		EQU_W		0E9H
		FP06OC	EQU_W	P1OC.3
		FP05OC	EQU_W	P1OC.2
		FP11OC	EQU_W	P1OC.1
		FP10OC	EQU_W	P1OC.0

	MSPSTAT		EQU		0EAH
		FCKE			EQU		MSPSTAT.6
		FD_A			EQU_R	MSPSTAT.5
		FP				EQU_R	MSPSTAT.4
		FS				EQU_R	MSPSTAT.3
		FRED_WRT	EQU_R	MSPSTAT.2
		FBF				EQU_R	MSPSTAT.0

	MSPM1		EQU		0EBH
		FWCOL			EQU	MSPM1.7
		FMSPOV		EQU	MSPM1.6
		FMSPENB		EQU	MSPM1.5
		FCKP			EQU	MSPM1.4
		FSLRXCKP	EQU	MSPM1.3
		FMSPWK		EQU	MSPM1.2
		FMSPC			EQU	MSPM1.0

	MSPM2		EQU		0ECH
		FGCEN			EQU	MSPM2.7
		FACKSTAT	EQU	MSPM2.6
		FACKDT		EQU	MSPM2.5
		FACKEN		EQU	MSPM2.4
		FRCEN			EQU	MSPM2.3
		FPEN			EQU	MSPM2.2
		FRSEN			EQU	MSPM2.1	
		FSEN			EQU	MSPM2.0	

	MSPBUF		EQU		0EDH
		FMSPBUF7	EQU	MSPBUF.7
		FMSPBUF6	EQU	MSPBUF.6
		FMSPBUF5	EQU	MSPBUF.5
		FMSPBUF4	EQU	MSPBUF.4
		FMSPBUF3	EQU	MSPBUF.3
		FMSPBUF2	EQU	MSPBUF.2
		FMSPBUF1	EQU	MSPBUF.1
		FMSPBUF0	EQU	MSPBUF.0

	MSPADR		EQU		0EEH
		FMSPADR7	EQU	MSPADR.7
		FMSPADR6	EQU	MSPADR.6
		FMSPADR5	EQU	MSPADR.5
		FMSPADR4	EQU	MSPADR.4
		FMSPADR3	EQU	MSPADR.3
		FMSPADR2	EQU	MSPADR.2
		FMSPADR1	EQU	MSPADR.1
		FMSPADR0	EQU	MSPADR.0

	STK7L		EQU		0F0h
		FS7PC7		EQU	STK7L.7
		FS7PC6		EQU	STK7L.6
		FS7PC5		EQU	STK7L.5
		FS7PC4		EQU	STK7L.4
		FS7PC3		EQU	STK7L.3
		FS7PC2		EQU	STK7L.2
		FS7PC1		EQU	STK7L.1
		FS7PC0		EQU	STK7L.0

	STK7H		EQU		0F1h
		FS7PC13		EQU	STK7H.5
		FS7PC12		EQU	STK7H.4
		FS7PC11		EQU	STK7H.3
		FS7PC10		EQU	STK7H.2
		FS7PC9		EQU	STK7H.1
		FS7PC8		EQU	STK7H.0

	STK6L		EQU		0F2h
		FS6PC7		EQU	STK6L.7
		FS6PC6		EQU	STK6L.6
		FS6PC5		EQU	STK6L.5
		FS6PC4		EQU	STK6L.4
		FS6PC3		EQU	STK6L.3
		FS6PC2		EQU	STK6L.2
		FS6PC1		EQU	STK6L.1
		FS6PC0		EQU	STK6L.0

	STK6H		EQU		0F3h
		FS6PC13		EQU	STK6H.5
		FS6PC12		EQU	STK6H.4
		FS6PC11		EQU	STK6H.3
		FS6PC10		EQU	STK6H.2
		FS6PC9		EQU	STK6H.1
		FS6PC8		EQU	STK6H.0

	STK5L		EQU		0F4h
		FS5PC7		EQU	STK5L.7
		FS5PC6		EQU	STK5L.6
		FS5PC5		EQU	STK5L.5
		FS5PC4		EQU	STK5L.4
		FS5PC3		EQU	STK5L.3
		FS5PC2		EQU	STK5L.2
		FS5PC1		EQU	STK5L.1
		FS5PC0		EQU	STK5L.0

	STK5H		EQU		0F5h
		FS5PC13		EQU	STK5H.5
		FS5PC12		EQU	STK5H.4
		FS5PC11		EQU	STK5H.3
		FS5PC10		EQU	STK5H.2
		FS5PC9		EQU	STK5H.1
		FS5PC8		EQU	STK5H.0

	STK4L		EQU		0F6h
		FS4PC7		EQU	STK4L.7
		FS4PC6		EQU	STK4L.6
		FS4PC5		EQU	STK4L.5
		FS4PC4		EQU	STK4L.4
		FS4PC3		EQU	STK4L.3
		FS4PC2		EQU	STK4L.2
		FS4PC1		EQU	STK4L.1
		FS4PC0		EQU	STK4L.0

	STK4H		EQU		0F7h
		FS4PC13		EQU	STK4H.5
		FS4PC12		EQU	STK4H.4
		FS4PC11		EQU	STK4H.3
		FS4PC10		EQU	STK4H.2
		FS4PC9		EQU	STK4H.1
		FS4PC8		EQU	STK4H.0

	STK3L		EQU		0F8h
		FS3PC7		EQU	STK3L.7
		FS3PC6		EQU	STK3L.6
		FS3PC5		EQU	STK3L.5
		FS3PC4		EQU	STK3L.4
		FS3PC3		EQU	STK3L.3
		FS3PC2		EQU	STK3L.2
		FS3PC1		EQU	STK3L.1
		FS3PC0		EQU	STK3L.0

	STK3H		EQU		0F9h
		FS3PC13		EQU	STK3H.5
		FS3PC12		EQU	STK3H.4
		FS3PC11		EQU	STK3H.3
		FS3PC10		EQU	STK3H.2
		FS3PC9		EQU	STK3H.1
		FS3PC8		EQU	STK3H.0

	STK2L		EQU		0FAh
		FS2PC7		EQU	STK2L.7
		FS2PC6		EQU	STK2L.6
		FS2PC5		EQU	STK2L.5
		FS2PC4		EQU	STK2L.4
		FS2PC3		EQU	STK2L.3
		FS2PC2		EQU	STK2L.2
		FS2PC1		EQU	STK2L.1
		FS2PC0		EQU	STK2L.0

	STK2H		EQU		0FBh
		FS2PC13		EQU	STK2H.5
		FS2PC12		EQU	STK2H.4
		FS2PC11		EQU	STK2H.3
		FS2PC10		EQU	STK2H.2
		FS2PC9		EQU	STK2H.1
		FS2PC8		EQU	STK2H.0

	STK1L		EQU		0FCh
		FS1PC7		EQU	STK1L.7
		FS1PC6		EQU	STK1L.6
		FS1PC5		EQU	STK1L.5
		FS1PC4		EQU	STK1L.4
		FS1PC3		EQU	STK1L.3
		FS1PC2		EQU	STK1L.2
		FS1PC1		EQU	STK1L.1
		FS1PC0		EQU	STK1L.0

	STK1H		EQU		0FDh
		FS1PC13		EQU	STK1H.5
		FS1PC12		EQU	STK1H.4
		FS1PC11		EQU	STK1H.3
		FS1PC10		EQU	STK1H.2
		FS1PC9		EQU	STK1H.1
		FS1PC8		EQU	STK1H.0

	STK0L		EQU		0FEh
		FS0PC7		EQU	STK0L.7
		FS0PC6		EQU	STK0L.6
		FS0PC5		EQU	STK0L.5
		FS0PC4		EQU	STK0L.4
		FS0PC3		EQU	STK0L.3
		FS0PC2		EQU	STK0L.2
		FS0PC1		EQU	STK0L.1
		FS0PC0		EQU	STK0L.0

	STK0H		EQU		0FFh
		FS0PC13		EQU	STK0H.5
		FS0PC12		EQU	STK0H.4
		FS0PC11		EQU	STK0H.3
		FS0PC10		EQU	STK0H.2
		FS0PC9		EQU	STK0H.1
		FS0PC8		EQU	STK0H.0	

; -----------------------------------------------------
; Clear watchdog macro. 
;  
; Total Cycle: 2

	@RST_WDT	macro
		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Set_P3_Input_Pullup	macro	
		DW	0x2D00 		;mov	a, #0x00	; Port 3: Input pull-up high
    DW 	0x2FC3 		;b0mov	P3M,a
    DW	0x2DFF 		;mov	a, #0xFF
    DW	0x2FD3 		;b0mov	P3,a
    DW	0x2FE3 		;b0mov	P3UR,a
	endm
; -----------------------------------------------------
	
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}