
;------------------------------------------------------------------------------
;  CHIP: SN8P1604, SN8A1604A down grade
;  Revision History:
;  V1.0  10/09/2002  First issue
;  V2.0   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		2
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	80h

.Assembly	INSTRUMENT	SN8P1604

.Assembly	MASK_BODY_SIZE	0x1200
.Assembly	OTP_BODY_SIZE	0x1000
.Assembly	USER_ROM_SIZE	0x0FFF
.Assembly	OTP_TEST_SIZE	0x00A0

.Assembly	MASK_TEST_FILE	SN8A1604A
.Assembly	OTP_TEST_FILE	SN87P
.Assembly	PGM_TYPE	1
.Assembly	MASK_TEST_CODE	0x3600, 0x9003, 0x0000, 0x908B
.Assembly	Port_Pins	2, 8, 8, 0, 0, 4
.Assembly	CHIP_ID		0xFFFF;None Chip ID

.Assembly	OPTION		0		Watch_Dog	Enable	Disable
.Assembly	OPTION		1		Pull_Up		Disable	Enable
.Assembly	OPTION		2		LVD		Enable	Disable
.Assembly	OPTION		3		Security	Enable	Disable
.Assembly	OPTION		4		High_Clk/2	Enable	Disable
.Assembly	OPTION		5		High_Clk	RC	32K_X'tal	12M_X'tal	4M_X'tal
.Assembly	OPTION		7		OSG		Enable	Disable
.Assembly	OPTION		8 : 15	Fix_High
.Assembly	OPTION		2ffh
.Assembly	OTP2MSK		0xFFFF, 0x000C, 0x0002

	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
	PFLAG		EQU		0x86
		FZ		EQU		0x86.0
		FDC		EQU		0x86.1
		FC		EQU		0x86.2

	P1W			EQU_W	0C0H
		FP17W	EQU_W	P1W.7
		FP16W	EQU_W	P1W.6
		FP15W	EQU_W	P1W.5
		FP14W	EQU_W	P1W.4
		FP13W	EQU_W	P1W.3
		FP12W	EQU_W	P1W.2
		FP11W	EQU_W	P1W.1
		FP10W	EQU_W	P1W.0

	P1M			EQU		0C1H
		FP17M	EQU		P1M.7
		FP16M	EQU		P1M.6
		FP15M	EQU		P1M.5
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0

	P2M			EQU		0C2H
		FP27M	EQU		P2M.7
		FP26M	EQU		P2M.6
		FP25M	EQU		P2M.5
		FP24M	EQU		P2M.4
		FP23M	EQU		P2M.3
		FP22M	EQU		P2M.2
		FP21M	EQU		P2M.1
		FP20M	EQU		P2M.0

	P5M			EQU		0C5H
		FP53M	EQU		P5M.3
		FP52M	EQU		P5M.2
		FP51M	EQU		P5M.1
		FP50M	EQU		P5M.0

	INTRQ		EQU		0C8H
		FTC1IRQ	EQU	INTRQ.6
		FP00IRQ	EQU	INTRQ.0

	INTEN		EQU		0C9H
		FTC1IEN	EQU	INTEN.6
		FP00IEN	EQU	INTEN.0

	OSCM		EQU		0CAH
	.W_LIMIT        0x00,0x80	;bit 7= low
;		FWTCKS	EQU	OSCM.7
		FWDRST	EQU	OSCM.6
		FCPUM0	EQU	OSCM.3
		FCLKMD	EQU	OSCM.2
		FSTPHX	EQU	OSCM.1

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU_R	0D0H
;		FP02	EQU_R	P0.2	; V2.0: remove P02, 11/15/2002
		FP01	EQU_R	P0.1
		FP00	EQU_R	P0.0

	P1			EQU		0D1H
		FP17	EQU		P1.7
		FP16	EQU		P1.6
		FP15	EQU		P1.5
		FP14	EQU		P1.4
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0

	P2			EQU		0D2H
		FP27	EQU		P2.7
		FP26	EQU		P2.6
		FP25	EQU		P2.5
		FP24	EQU		P2.4
		FP23	EQU		P2.3
		FP22	EQU		P2.2
		FP21	EQU		P2.1
		FP20	EQU		P2.0

	P5			EQU		0D5H
		FP53	EQU		P5.3
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0

	TC1M		EQU		0DCH
	.W_LIMIT        0x00,0x08	;bit 3=low	
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
;		FTC1CKS		EQU	TC1M.3
		FALOAD1		EQU	TC1M.2
		FTC1OUT		EQU	TC1M.1
		FPWM1OUT	EQU	TC1M.0

	TC1C		EQU		0DDH

	TC1R		EQU_W	0DEH

	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	@YZ			EQU		0E7H
	DP1X		EQU		0E7H

	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

.TEXT
{
	//{{SONIX_SMOV_S8KD
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	0F 08 01 8F -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 00
	-1 -1 -1 -1 -1 -1 00 00   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 00 00 -1 -1 -1   -1 -1 -1 -1 -1 -1 27 -1
	00 -1 -1 -1 -1 -1 -1 -1   -1 41 8C -1 -1 -1 -1 -1
	83 FF FF 00 00 0F 00 00   00 -1 00 -1 -1 -1 -1 00
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	87 00 DF 7F -1
	02 BE 00 27 -1
	01 71 00 01 -1
	//}}SONIX_SMOV_S8KD


	//{{SONIX_OPTION_RULE
	IF	High_Clk == RC
	{
		High_Clk/2	=	Enable
	}

	IF	High_Clk == 32K_X'tal
	{
		OSG			=	Enable
	}

	ENDP
	//}}SONIX_OPTION_RULE

	; V2.0: change 0xD0 from 87 to 83, 11/15/2002
}
