
;------------------------------------------------------------------------------
;  CHIP: SN8P1703A 20 pin 4-ch ADC( NO MASK Correspond for Production)
;  Revision History:
;  V1.0  07/10/2003  First issue
;  V2.0  07/29/2003  1:Rename as SN8P1703A,inc
;                    2:Set Digital Filter Option as Hide and Disable In RC-mode,
;                      other mode is Enable
;		     3:Add ID=0x40
;		     4:SMOV table addr0xD8=0x0E (Enable FPWM1/FPWM0/TC0GN)
;		     5:Add register T0M.3/2=FTC1/0X8
;		     6:SMOV table addr0xC9=0x61 (old=0x21) (Enable TC1IEN)
;  V3.0  09/08/2003  1:Rename Digital Filter as Noise File and release it for 
;                      user selection
;  V4.0  11/06/2003  1:Fixed OSG Option at disable and remove related setting.
;                    2:Change Low power option to bit 15
;                    3:Add an option: Noise_Filter2 (OTP_Debunce)
;                    4:Noise_Filter2 doesn't be show in option selection window and 
;                      sync. to Noise_Filter option.
;                      Note: In S86P20A-A version, enable Noise_filter2 will cause
;                            Low_Power option useless, S86P20A-B will correct this bug
;                    5:Remove option control macro: 
;                      "High_Clk/2 = Enable then Noise_Filter =	Disable"
;                      In SN8P1602B need this macro.
;  V5.0  11/13/2003  1:Add SMOV talbe for Internal RC always ON, when code option is enabled
;  V6.0  11/18/2003  1:Disable High_CLk = 32K code option
;                    2:The relation of Noise_Filter and Low_Power is XOR
;                    3:Change selection name of Int_16K_RC
;                      Enable ==> Always_ON, Disable ==> By_CPUM
;  V7.0   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		7
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	0x80

.Assembly	INSTRUMENT	SN8P1703A

;.Assembly	MASK_BODY_SIZE	0x600
.Assembly	OTP_BODY_SIZE	0x400
.Assembly	USER_ROM_SIZE	0x3FF
.Assembly	OTP_TEST_SIZE	0x00E0

;.Assembly	MASK_TEST_FILE	SN8A1702A
.Assembly	OTP_TEST_FILE	SN8P1702A
.Assembly	PGM_TYPE	5
.Assembly	MASK_TEST_CODE	0x3600, 0x8523, 0x0000, 0x85A6
.Assembly	Port_Pins	1, 2, 0, 0, 4, 6
.Assembly	CHIP_ID		0x38,0x40

.Assembly	OPTION		0		Watch_Dog	Enable	Disable
.Assembly	OPTION		1		Fix_High
.Assembly	OPTION		2		Int_16K_RC	Always_ON	By_CPUM
.Assembly	OPTION		3		Security	Enable	Disable
.Assembly	OPTION		4		High_Clk/2	Enable	Disable
;.Assembly	OPTION		5		High_Clk	RC	32K_X'tal	12M_X'tal	4M_X'tal
.Assembly	OPTION		5		High_Clk	RC	X		12M_X'tal	4M_X'tal
;.Assembly	OPTION		7		OSG		Enable	Disable
.Assembly	OPTION		7		Fix_High
.Assembly	OPTION		8		Noise_Filter	Enable	Disable
.Assembly	OPTION		9 		TC1_Counter	4-Bit	5-Bit	6-Bit	8-Bit
.Assembly	OPTION		11 		TC0_Counter	4-Bit	5-Bit	6-Bit	8-Bit
.Assembly	OPTION		13 		Fix_High
;.Assembly	OPTION		14 		OTP_Debunce	Enable	Disable
.Assembly	OPTION_Hide	14 		Noise_Filter2	Enable	Disable
.Assembly	OPTION		15 		Low_Power	Enable	Disable
.Assembly	OPTION		2ffh
;.Assembly	OTP2MSK		0xFFFF, 0x000C, 0x0000

	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
	PFLAG		EQU		0x86
		FZ		EQU		0x86.0
		FDC		EQU		0x86.1
		FC		EQU		0x86.2
;		FNPD	EQU_R	0x86.6
;		FNT0	EQU_R	0x86.7

	P4CON			EQU		0xAE
		FP4CON3	EQU		P4CON.3
		FP4CON2	EQU		P4CON.2
		FP4CON1	EQU		P4CON.1
		FP4CON0	EQU		P4CON.0



	ADM			EQU		0xB1
		FADENB	EQU		ADM.7
		FADS	EQU		ADM.6
		FEOC	EQU		ADM.5
		FGCHS	EQU		ADM.4
;		FCHS2	EQU		ADM.2
		FCHS1	EQU		ADM.1
		FCHS0	EQU		ADM.0
		
	ADB			EQU_R	0B2H

	ADR			EQU		0B3H
		FADCKS1	EQU	ADR.6
		FADLEN	EQU	ADR.5
		FADCKS0	EQU	ADR.4
		FADB3	EQU_R	ADR.3
		FADB2	EQU_R	ADR.2
		FADB1	EQU_R	ADR.1
		FADB0	EQU_R	ADR.0
/*
	PUR			EQU_W	0BEH
		FPUR5	EQU_W	PUR.5
		FPUR4	EQU_W	PUR.4
		FPUR1	EQU_W	PUR.1
		FPUR0	EQU_W	PUR.0
*/
	PEDGE		EQU		0BFH
		FPEDGEN	EQU		PEDGE.7
		FP00G1	EQU		PEDGE.4
		FP00G0	EQU		PEDGE.3

	P1W			EQU_W	0C0H
		FP11W	EQU_W	P1W.1
		FP10W	EQU_W	P1W.0

	P1M			EQU		0C1H
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0

	P4M			EQU		0C4H
		FP43M	EQU		P4M.3
		FP42M	EQU		P4M.2
		FP41M	EQU		P4M.1
		FP40M	EQU		P4M.0

	P5M			EQU		0C5H
		FP55M	EQU		P5M.5
		FP54M	EQU		P5M.4
		FP53M	EQU		P5M.3
		FP52M	EQU		P5M.2
		FP51M	EQU		P5M.1
		FP50M	EQU		P5M.0

	INTRQ		EQU		0C8H
		FTC1IRQ	EQU	INTRQ.6
		FTC0IRQ	EQU	INTRQ.5
		FP00IRQ	EQU	INTRQ.0

	INTEN		EQU		0C9H
		FTC1IEN	EQU	INTEN.6
		FTC0IEN	EQU	INTEN.5
		FP00IEN	EQU	INTEN.0

	OSCM		EQU		0CAH
		FWTCKS	EQU	OSCM.7
		FWDRST	EQU	OSCM.6
		FWDRATE	EQU	OSCM.5
		FCPUM1	EQU	OSCM.4
		FCPUM0	EQU	OSCM.3
		FCLKMD	EQU	OSCM.2
		FSTPHX	EQU	OSCM.1
		FOSCM_UNUSED	EQU	OSCM.0

	TC0R		EQU_W	0CDH

	PCL		EQU	0CEH

	PCH		EQU	0CFH

	P0		EQU_R	0D0H
		FP00	EQU_R	P0.0

	P1		EQU		0D1H
		FP11	EQU	P1.1
		FP10	EQU	P1.0

	P4		EQU		0D4H
		FP43	EQU	P4.3
		FP42	EQU	P4.2
		FP41	EQU	P4.1
		FP40	EQU	P4.0

	P5		EQU		0D5H
		FP55	EQU	P5.5
		FP54	EQU	P5.4
		FP53	EQU	P5.3
		FP52	EQU	P5.2
		FP51	EQU	P5.1
		FP50	EQU	P5.0

	T0M			EQU		0D8H
		FTC0GN	EQU		T0M.1
		FTC0X8	EQU		T0M.2
		FTC1X8	EQU		T0M.3


	TC0M		EQU		0DAH
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		FTC0CKS		EQU	TC0M.3
		FALOAD0		EQU	TC0M.2
		FTC0OUT		EQU	TC0M.1
		FPWM0OUT	EQU	TC0M.0

	TC0C		EQU		0DBH

	TC1M		EQU		0DCH
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
		;FTC1CKS		EQU	TC1M.3 ;Disable for P0.1 not exist
		FALOAD1		EQU	TC1M.2
		FTC1OUT		EQU	TC1M.1
		FPWM1OUT	EQU	TC1M.0

	TC1C		EQU		0DDH
	TC1R		EQU_W		0DEH

	STKP		EQU		0DFH
		FGIE	EQU	STKP.7
		FSTKPB3	EQU	STKP.3
		FSTKPB2	EQU	STKP.2
		FSTKPB1	EQU	STKP.1
		FSTKPB0	EQU	STKP.0

	P0UR		EQU_W		0E0H
		FP00R	EQU_W	P0UR.0

	P1UR		EQU_W		0E1H
		FP11R	EQU_W	P1UR.1
		FP10R	EQU_W	P1UR.0

	P4UR		EQU_W		0E4H
		FP43R	EQU_W	P4UR.3
		FP42R	EQU_W	P4UR.2
		FP41R	EQU_W	P4UR.1
		FP40R	EQU_W	P4UR.0

	P5UR		EQU_W		0E5H
		FP55R	EQU_W	P5UR.5
		FP54R	EQU_W	P5UR.4
		FP53R	EQU_W	P5UR.3
		FP52R	EQU_W	P5UR.2
		FP51R	EQU_W	P5UR.1
		FP50R	EQU_W	P5UR.0

	@YZ			EQU		0E7H
	DP1X		EQU		0E7H

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

; @SET_PUR macro will maintain the compatibility of PUR (MASK) and PnUR (OTP).
; If you want to set pull-up register in MASK, use @SET_PUR macro to replace 
; setting PUR register.

	@SET_PUR	macro	val
		

		IF	val !& 0CCh
			ERROR	@SET_PUR value error, valid value is 00XX-00XX
			exitm
		ENDIF

		mov		a, #val
		DC		0x2FBE		; B0MOV	PUR, A

		IF	val ^ 33h
			IFE	val !& 1
				mov	a, #0FEh
				DC	0x2FE0
			ENDIF
			IFE	val !& 2
				mov	a, #0FCh
				DC	0x2FE1
			ENDIF
			IFE	val !& 10h
				mov	a, #0F0h
				DC	0x2FE4
			ENDIF
			IFE	val !& 20h
				mov	a, #0E0h
				DC	0x2FE5
			ENDIF

		ENDIF

		mov	a, #0FFh
		DC	0x2FE2

		IF	val
			mov	a, #0xFF
			IF	val !& 1
				DC	0x2FE0
			ENDIF
			IF	val !& 2
				DC	0x2FE1
			ENDIF
			IF	val !& 10h
				DC	0x2FE4
			ENDIF
			IF	val !& 20h
				DC	0x2FE5
			ENDIF
		ENDIF

		endm

.TEXT
{
	//{{SONIX_SMOV_S8KD
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	07 48 01 80 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 11
	-1 -1 -1 -1 -1 -1 C0 00   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 10 00 -1 -1 -1   -1 -1 -1 -1 -1 -1 33 -1
	00 -1 -1 -1 -1 -1 -1 -1   -1 61 BD -1 -1 -1 -1 -1
	81 03 00 00 0F 3F 00 00   0E -1 07 -1 -1 -1 -1 08
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	87 00 DF 7F -1 -1
	0600  73 00 04 08 0C     0600  7F E0 C0 80 00		
	1800  73 00 01 02 03     1800  7F 0E 0C 08 00	
	0004 72 10 00
	0001 71 00 01 -1
	//}}SONIX_SMOV_S8KD

	//{{SONIX_OPTION_RULE

	IF	High_Clk == RC
	{
		High_Clk/2		=	Enable		
	}

	IF	Noise_Filter == Enable
	{
		Noise_Filter2	=	Enable
		Low_Power	=	Disable
	}
	
	IF	Noise_Filter == Disable
	{
		Noise_Filter2	=	Disable
		Low_Power	=	Enable
	}

	ENDP
	//}}SONIX_OPTION_RULE
}
