
;------------------------------------------------------------------------------
;  CHIP: SN8P1704, SN8A1704A down grade
;  Revision History:
;  V1.0  10/09/2002  First issue
;  V2.0   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		2
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	0x80

.Assembly	INSTRUMENT	SN8P1704

.Assembly	MASK_BODY_SIZE	0x0A00
.Assembly	OTP_BODY_SIZE	0x1000
.Assembly	USER_ROM_SIZE	0x0800
.Assembly	OTP_TEST_SIZE	0x00E0

.Assembly	MASK_TEST_FILE	SN8A1704A
.Assembly	OTP_TEST_FILE	SN86P
.Assembly	PGM_TYPE	1
.Assembly	MASK_TEST_CODE	0x3600, 0x8803, 0x0000, 0x8887
.Assembly	Port_Pins	3, 5, 0, 0, 5, 5
.Assembly	COMMAND		PUSH, MUL
.Assembly	CHIP_ID		0xFFFF;None Chip ID

.Assembly	OPTION		0		Watch_Dog	Enable	Disable
.Assembly	OPTION		1		Fix_High
.Assembly	OPTION		2		LVD		Enable	Disable
.Assembly	OPTION		3		Security	Enable	Disable
.Assembly	OPTION		4		High_Clk/2	Enable	Disable
.Assembly	OPTION		5		High_Clk	RC	32K_X'tal	12M_X'tal	4M_X'tal
.Assembly	OPTION		7		OSG		Enable	Disable
.Assembly	OPTION		8 : 15	Fix_High
.Assembly	OPTION		2ffh
.Assembly	OTP2MSK		0xFFFF, 0x000C, 0x0000

;	L			EQU		0x80
;	H			EQU		0x81
	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
;	X			EQU		0x85
	PFLAG		EQU		0x86
		FZ		EQU		0x86.0
		FDC		EQU		0x86.1
		FC		EQU		0x86.2

	DAM			EQU		0xB0
		FDAENB	EQU		DAM.7
		FDAB6	EQU		DAM.6
		FDAB5	EQU		DAM.5
		FDAB4	EQU		DAM.4
		FDAB3	EQU		DAM.3
		FDAB2	EQU		DAM.2
		FDAB1	EQU		DAM.1
		FDAB0	EQU		DAM.0

	ADM			EQU		0xB1
		FADENB	EQU		ADM.7
		FADS	EQU		ADM.6
		FEOC	EQU		ADM.5
		FGCHS	EQU		ADM.4
		FCHS2	EQU		ADM.2
		FCHS1	EQU		ADM.1
		FCHS0	EQU		ADM.0
		
	ADB			EQU_R	0B2H

	ADR			EQU		0B3H
	.W_LIMIT        0x00,0x10	;bit 4= low	
		FADCKS1	EQU		ADR.6
		FADCKS	EQU		ADR.6
		FADLEN	EQU		ADR.5
;		FADCKS0	EQU		ADR.4
		FADB3	EQU_R	ADR.3
		FADB2	EQU_R	ADR.2
		FADB1	EQU_R	ADR.1
		FADB0	EQU_R	ADR.0

	SIOM		EQU		0B4H
	.W_LIMIT        0x00,0x08	;bit 3= low
		FSENB	EQU		SIOM.7
		FSTART	EQU		SIOM.6
		FSRATE1	EQU		SIOM.5
		FSRATE0	EQU		SIOM.4
;		FSIG	EQU		SIOM.3
		FSCKMD	EQU		SIOM.2
		FSEDGE	EQU		SIOM.1
		FTXRX	EQU		SIOM.0

	SIOR		EQU_W	0B5H
	SIOB		EQU		0B6H

	P1W			EQU_W	0C0H
		FP14W	EQU_W	P1W.4
		FP13W	EQU_W	P1W.3
		FP12W	EQU_W	P1W.2
		FP11W	EQU_W	P1W.1
		FP10W	EQU_W	P1W.0

	P1M			EQU		0C1H
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0

	P4M			EQU		0C4H
		FP44M	EQU		P4M.4
		FP43M	EQU		P4M.3
		FP42M	EQU		P4M.2
		FP41M	EQU		P4M.1
		FP40M	EQU		P4M.0

	P5M			EQU		0C5H
		FP54M	EQU		P5M.4
		FP53M	EQU		P5M.3
		FP52M	EQU		P5M.2
		FP51M	EQU		P5M.1
		FP50M	EQU		P5M.0

	INTRQ		EQU		0C8H
		FTC1IRQ	EQU	INTRQ.6
		FTC0IRQ	EQU	INTRQ.5
		FSIOIRQ	EQU	INTRQ.3
		FP02IRQ	EQU	INTRQ.2
		FP01IRQ	EQU	INTRQ.1
		FP00IRQ	EQU	INTRQ.0

	INTEN		EQU		0C9H
		FTC1IEN	EQU	INTEN.6
		FTC0IEN	EQU	INTEN.5
		FSIOIEN	EQU	INTEN.3
		FP02IEN	EQU	INTEN.2
		FP01IEN	EQU	INTEN.1
		FP00IEN	EQU	INTEN.0

	OSCM		EQU		0CAH
	.W_LIMIT        0x00,0x90	;bit 7/4= low
;		FWTCKS	EQU	OSCM.7
		FWDRST	EQU	OSCM.6
		FWDRATE	EQU	OSCM.5
;		FCPUM1	EQU	OSCM.4
		FCPUM0	EQU	OSCM.3
		FCLKMD	EQU	OSCM.2
		FSTPHX	EQU	OSCM.1
		FOSCM_UNUSED	EQU	OSCM.0

	TC0R		EQU_W	0CDH

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU_R	0D0H
		FP02	EQU_R	P0.2
		FP01	EQU_R	P0.1
		FP00	EQU_R	P0.0

	P1			EQU		0D1H
		FP14	EQU		P1.4
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0

	P4			EQU		0D4H
		FP44	EQU		P4.4
		FP43	EQU		P4.3
		FP42	EQU		P4.2
		FP41	EQU		P4.1
		FP40	EQU		P4.0

	P5			EQU		0D5H
		FP54	EQU		P5.4
		FP53	EQU		P5.3
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0

	TC0M		EQU		0DAH
	.W_LIMIT        0x00,0x08	;bit 3=low
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
;		FTC0CKS		EQU	TC0M.3
		FALOAD0		EQU	TC0M.2
		FTC0OUT		EQU	TC0M.1
		FPWM0OUT	EQU	TC0M.0

	TC0C		EQU		0DBH

	TC1M		EQU		0DCH
	.W_LIMIT        0x00,0x08	;bit 3=low	
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
;		FTC1CKS		EQU	TC1M.3
		FALOAD1		EQU	TC1M.2
		FTC1OUT		EQU	TC1M.1
		FPWM1OUT	EQU	TC1M.0

	TC1C		EQU		0DDH
	TC1R		EQU_W	0DEH

	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB3	EQU		STKP.3
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

;	@HL			EQU		0E6H
;	DP0X		EQU		0E6H

	@YZ			EQU		0E7H
	DP1X		EQU		0E7H

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

; @SET_PUR macro will maintain the compatibility of PUR (MASK) and PnUR (OTP).
; If you want to set pull-up register in MASK, use @SET_PUR macro to replace 
; setting PUR register.

	@SET_PUR	macro	val
		
		IF	val !& 0CCh
			ERROR	@SET_PUR value error, valid value is 00XX-00XX
			exitm
		ENDIF

		mov		a, #val
		DC		0x2FBE		; B0MOV	PUR, A

		IF	val ^ 33h
			IFE	val !& 1
				IF	val
					mov	a, #0
				ENDIF
				DC	0x2FE0
			ENDIF
			IFE	val !& 2
				mov	a, #0E0h
				DC	0x2FE1
			ENDIF
			IFE	val !& 10h
				IF	val !& 2
					mov	a, #0E0h
				ENDIF
				DC	0x2FE4
			ENDIF
			IFE	val !& 20h
				IF	(val !& 12h) == 12h
					mov	a, #0E0h
				ENDIF
				DC	0x2FE5
			ENDIF
		ENDIF

		mov	a, #0FFh
		DC	0x2FE2

		IF	val
			mov	a, #0xFF
			IF	val !& 1
				DC	0x2FE0
			ENDIF
			IF	val !& 2
				DC	0x2FE1
			ENDIF
			IF	val !& 10h
				DC	0x2FE4
			ENDIF
			IF	val !& 20h
				DC	0x2FE5
			ENDIF
		ENDIF

		endm

.TEXT
{
	//{{SONIX_SMOV_S8KD
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	0F 48 01 8F -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 00
	-1 -1 -1 -1 -1 -1 00 00   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 00 00 -1 -1 -1   -1 -1 -1 -1 -1 -1 00 -1
	00 -1 -1 -1 -1 -1 -1 -1   -1 6F AD -1 -1 -1 -1 -1
	87 1F 00 00 1F 1F 00 00   F0 -1 07 -1 -1 -1 -1 08
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	87 00 DF 7F -1 -1
	01 71 00 01 -1
	//}}SONIX_SMOV_S8KD

	//{{SONIX_OPTION_RULE
	IF	High_Clk == RC
	{
		High_Clk/2	=	Enable
	}

	IF	High_Clk == 32K_X'tal
	{
		OSG			=	Enable
	}

	ENDP
	//}}SONIX_OPTION_RULE
}
