
;------------------------------------------------------------------------------
;  CHIP: SN8P1808, OTP Only
;  Revision History:
;  V1.0  09/01/2002  First issue
;  V2.0  03/26/2003  a. Release FTC0CKS & FTC1CKS function
;					 b. Release FWTCKS function
;                    c. Note: Chip date code must be late than 0226
;                       (exclude 0226) to use above released function.
;  V3.0  05/21/2003  a. changeUSER_ROM_SIZE to 0xFF0
;                    b. add MASK_TEST_CODE
;        07/08/2003  c. changeUSER_ROM_SIZE to 0xFFF
;  V4.0  11/13/2003  a. SMOV table: Change 0x7F from 00 to 11
;                       Enable TC0/TC1 event counter function 
;  V5.0   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		5
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	100h

.Assembly	INSTRUMENT	SN8P1808

;.Assembly	MASK_BODY_SIZE
.Assembly	OTP_BODY_SIZE	0x1000
.Assembly	USER_ROM_SIZE	0x0FFF
.Assembly	OTP_TEST_SIZE	0x0180

;.Assembly	MASK_TEST_FILE
.Assembly	OTP_TEST_FILE	SN88P
.Assembly	PGM_TYPE	1
.Assembly	MASK_TEST_CODE	0x0000, 0x000, 0x0000, 0x0000
.Assembly	Port_Pins	6, 4, 8, 8, 8, 5, 8
.Assembly	LCD_Size	24, 3
.Assembly	COMMAND		PUSH, MUL
.Assembly	CHIP_ID		0xFFFF;None Chip ID

.Assembly	OPTION		0		Watch_Dog	Enable	Disable
.Assembly	OPTION		1		LCD		Enable	Disable
.Assembly	OPTION		2		LVD		Enable	Disable
.Assembly	OPTION		3		Security	Enable	Disable
.Assembly	OPTION		4		High_Clk/2	Enable	Disable
.Assembly	OPTION		5		High_Clk	RC	32K_X'tal	12M_X'tal	4M_X'tal
.Assembly	OPTION		7		OSG		Enable	Disable
.Assembly	OPTION		8 : 15	Fix_High
.Assembly	OPTION		2ffh

	L			EQU		0x80
	H			EQU		0x81
	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
	X			EQU		0x85
	PFLAG			EQU		0x86
		FZ		EQU		0x86.0
		FDC		EQU		0x86.1
		FC		EQU		0x86.2

	RBANK			EQU		0x87
			FRBNKS0	EQU		0x87.0
			FRBNKS1	EQU		0x87.1
			FRBNKS2	EQU		0x87.2
			FRBNKS3	EQU		0x87.3

	OPTION			EQU		0x88
		FRCLK	EQU		0x88.0
		FP3LCD	EQU		0x88.1

	ADM			EQU		0xB1
		FADENB	EQU		ADM.7
		FADS	EQU		ADM.6
		FEOC	EQU		ADM.5
		FGCHS	EQU		ADM.4
		FCHS2	EQU		ADM.2
		FCHS1	EQU		ADM.1
		FCHS0	EQU		ADM.0
		
	ADB			EQU_R	0B2H

	ADR			EQU		0B3H
		FADCKS1	EQU		ADR.6
		FADLEN	EQU		ADR.5
		FADCKS0	EQU		ADR.4
		FADB3	EQU_R	ADR.3
		FADB2	EQU_R	ADR.2
		FADB1	EQU_R	ADR.1
		FADB0	EQU_R	ADR.0

	SIOM		EQU		0B4H
	.W_LIMIT        0x00,0x08	;bit 3= low
		FSENB	EQU		SIOM.7
		FSTART	EQU		SIOM.6
		FSRATE1	EQU		SIOM.5
		FSRATE0	EQU		SIOM.4
;		FSIG	EQU		SIOM.3
		FSCKMD	EQU		SIOM.2
		FSEDGE	EQU		SIOM.1
		FTXRX	EQU		SIOM.0

	SIOR		EQU_W	0B5H
	SIOB		EQU		0B6H

	P1W			EQU_W	0C0H
		FP13W	EQU_W	P1W.3
		FP12W	EQU_W	P1W.2
		FP11W	EQU_W	P1W.1
		FP10W	EQU_W	P1W.0

	P1M			EQU		0C1H
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0

	P4M			EQU		0C4H
		FP47M	EQU		P4M.7
		FP46M	EQU		P4M.6
		FP45M	EQU		P4M.5
		FP44M	EQU		P4M.4
		FP43M	EQU		P4M.3
		FP42M	EQU		P4M.2
		FP41M	EQU		P4M.1
		FP40M	EQU		P4M.0

	P5M			EQU		0C5H
		FP54M	EQU		P5M.4
		FP53M	EQU		P5M.3
		FP52M	EQU		P5M.2
		FP51M	EQU		P5M.1
		FP50M	EQU		P5M.0

	P6M			EQU		0C6H
		FP67M	EQU		P6M.7
		FP66M	EQU		P6M.6
		FP65M	EQU		P6M.5
		FP64M	EQU		P6M.4
		FP63M	EQU		P6M.3
		FP62M	EQU		P6M.2
		FP61M	EQU		P6M.1
		FP60M	EQU		P6M.0

	INTRQ		EQU		0C8H
		FTC1IRQ	EQU	INTRQ.6
		FTC0IRQ	EQU	INTRQ.5
		FT0IRQ	EQU	INTRQ.4
		FSIOIRQ	EQU	INTRQ.3
		FP02IRQ	EQU	INTRQ.2
		FP01IRQ	EQU	INTRQ.1
		FP00IRQ	EQU	INTRQ.0

	INTEN		EQU		0C9H
		FTC1IEN	EQU	INTEN.6
		FTC0IEN	EQU	INTEN.5
		FT0IEN	EQU	INTEN.4
		FSIOIEN	EQU	INTEN.3
		FP02IEN	EQU	INTEN.2
		FP01IEN	EQU	INTEN.1
		FP00IEN	EQU	INTEN.0

	OSCM		EQU		0CAH
		FWTCKS	EQU	OSCM.7
		FWDRST	EQU	OSCM.6
		FWDRATE	EQU	OSCM.5
		FCPUM1	EQU	OSCM.4
		FCPUM0	EQU	OSCM.3
		FCLKMD	EQU	OSCM.2
		FSTPHX	EQU	OSCM.1
		FOSCM_UNUSED	EQU	OSCM.0

	LCDM		EQU		0CBH
		FBLANK	EQU	LCDM.5
		FLENB		EQU	LCDM.3
		FP6HSEG	EQU	LCDM.1
		FP6LSEG	EQU	LCDM.0

	TC0R		EQU_W	0CDH

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU_R	0D0H
		FP05	EQU_R	P0.5
		FP04	EQU_R	P0.4
		FP03	EQU_R	P0.3
		FP02	EQU_R	P0.2
		FP01	EQU_R	P0.1
		FP00	EQU_R	P0.0

	P1			EQU		0D1H
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0

	P2			EQU		0D2H
		FP27	EQU		P2.7
		FP26	EQU		P2.6
		FP25	EQU		P2.5
		FP24	EQU		P2.4
		FP23	EQU		P2.3
		FP22	EQU		P2.2
		FP21	EQU		P2.1
		FP20	EQU		P2.0

	P3			EQU_R	0D3H
		FP37	EQU_R	P3.7
		FP36	EQU_R	P3.6
		FP35	EQU_R	P3.5
		FP34	EQU_R	P3.4
		FP33	EQU_R	P3.3
		FP32	EQU_R	P3.2
		FP31	EQU_R	P3.1
		FP30	EQU_R	P3.0

	P4			EQU		0D4H
		FP47	EQU		P4.7
		FP46	EQU		P4.6
		FP45	EQU		P4.5
		FP44	EQU		P4.4
		FP43	EQU		P4.3
		FP42	EQU		P4.2
		FP41	EQU		P4.1
		FP40	EQU		P4.0

	P5			EQU		0D5H
		FP54	EQU		P5.4
		FP53	EQU		P5.3
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0

	P6			EQU		0D6H
		FP67	EQU		P6.7
		FP66	EQU		P6.6
		FP65	EQU		P6.5
		FP64	EQU		P6.4
		FP63	EQU		P6.3
		FP62	EQU		P6.2
		FP61	EQU		P6.1
		FP60	EQU		P6.0

	T0M			EQU		0D8H
		FT0ENB		EQU	T0M.7
		FT0RATE2	EQU	T0M.6
		FT0RATE1	EQU	T0M.5
		FT0RATE0	EQU	T0M.4
		FT0TB		EQU	T0M.0

	T0C			EQU		0D9H

	TC0M		EQU		0DAH
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		FTC0CKS		EQU	TC0M.3
		FALOAD0		EQU	TC0M.2
		FTC0OUT		EQU	TC0M.1
		FPWM0OUT	EQU	TC0M.0

	TC0C		EQU		0DBH

	TC1M		EQU		0DCH
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
		FTC1CKS		EQU	TC1M.3
		FALOAD1		EQU	TC1M.2
		FTC1OUT		EQU	TC1M.1
		FPWM1OUT	EQU	TC1M.0

	TC1C		EQU		0DDH
	TC1R		EQU_W	0DEH

	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB3	EQU		STKP.3
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	P0UR		EQU_W	0E0H
		FP05R	EQU_W	P0UR.5
		FP04R	EQU_W	P0UR.4
		FP03R	EQU_W	P0UR.3
		FP02R	EQU_W	P0UR.2
		FP01R	EQU_W	P0UR.1
		FP00R	EQU_W	P0UR.0

	P1UR		EQU_W	0E1H
		FP13R	EQU_W	P1UR.3
		FP12R	EQU_W	P1UR.2
		FP11R	EQU_W	P1UR.1
		FP10R	EQU_W	P1UR.0

	P4UR		EQU_W	0E4H
		FP47R	EQU_W	P4UR.7
		FP46R	EQU_W	P4UR.6
		FP45R	EQU_W	P4UR.5
		FP44R	EQU_W	P4UR.4
		FP43R	EQU_W	P4UR.3
		FP42R	EQU_W	P4UR.2
		FP41R	EQU_W	P4UR.1
		FP40R	EQU_W	P4UR.0

	P5UR		EQU_W	0E5H
		FP54R	EQU_W	P5UR.4
		FP53R	EQU_W	P5UR.3
		FP52R	EQU_W	P5UR.2
		FP51R	EQU_W	P5UR.1
		FP50R	EQU_W	P5UR.0

	@HL			EQU		0E6H
	DP0X		EQU		0E6H

	@YZ			EQU		0E7H
	DP1X		EQU		0E7H

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

; @SET_PUR macro will maintain the compatibility of PUR (MASK) and PnUR (OTP).
; If you want to set pull-up register in MASK, use @SET_PUR macro to replace 
; setting PUR register.

	@SET_PUR	macro	val

		IF	val !& 0CCh
			ERROR	SET_PUR value error, valid value is 00XX-00XX
			exitm
		ENDIF

		IF	val ^ 33h
			mov	a, #0
			IFE	val !& 1
				DC	0x2FE0
			ENDIF
			IFE	val !& 2
				DC	0x2FE1
			ENDIF
			IFE	val !& 10h
				DC	0x2FE4
			ENDIF
			IFE	val !& 20h
				DC	0x2FE5
			ENDIF
		ENDIF

		IF	val
			mov	a, #0xFF
			IF	val !& 1
				DC	0x2FE0
			ENDIF
			IF	val !& 2
				DC	0x2FE1
			ENDIF
			IF	val !& 10h
				DC	0x2FE4
			ENDIF
			IF	val !& 20h
				DC	0x2FE5
			ENDIF
		ENDIF

		endm

.TEXT
{
	//{{SONIX_SMOV_S8KD
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	17 74 00 8F -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 11
	-1 -1 -1 -1 -1 -1 00 0F   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 10 00 -1 -1 -1   -1 -1 -1 -1 -1 -1 00 -1
	00 -1 -1 -1 -1 -1 -1 -1   -1 7F BD -1 -1 -1 -1 -1
	BF 0F FF FF FF 1F FF 00   F1 -1 07 -1 -1 -1 -1 08
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	87 00 C2 FF C3 00 E3 FF DF 7F -1 
	-1	
	01 71 00 01 -1
	//}}SONIX_SMOV_S8KD

	//{{SONIX_OPTION_RULE
	IF	High_Clk == RC
	{
		High_Clk/2	=	Enable
	}

	IF	High_Clk == 32K_X'tal
	{
		OSG			=	Enable
	}

	ENDP
	//}}SONIX_OPTION_RULE
}
