
;------------------------------------------------------------------------------
;  CHIP: SN8P1909, OTP Only
;  Revision History:
;  V1.0  10/14/2003  First issue
;  V2.0  11/10/2003  1. In ICE mode, move FP2SEG bit from 0xCB.0 to 0x89.0
;                    2. SMOV table:
;		     3. Add 0004 72 10 00 into SMOV table for internal RC always ON
;  V3.0  01/03/2005  1. Release ROM size when ICE mode = 1 to 9K
;		     2. Modified Int_16K_RC code option as By_CPUM or Always_ON
;		     3. Add ID: 0x3E, 0x3F
;  V4.0  08/03/2005  1. Change CPCKS, AMPCKS, ADCKS as write only register
;  V5.0  04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;  V6.0  06/29/2010  1: Add Macro "@RST_WDT", "SleepMode", "GreenMode", "SlowMode", "Slow2Normal" 
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		6
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	200h

.Assembly	INSTRUMENT	SN8P1909

;.Assembly	MASK_BODY_SIZE
IF 	ICE_Mode == 0
  .Assembly	OTP_BODY_SIZE	0x2000
  .Assembly	USER_ROM_SIZE	0x1FFF
ELSE
  .Assembly	OTP_BODY_SIZE	0x2400
  .Assembly	USER_ROM_SIZE	0x23FF
ENDIF
;;.Assembly	OTP_BODY_SIZE	0x2000
;;.Assembly	USER_ROM_SIZE	0x1FFF
;.Assembly	OTP_TEST_SIZE	0x0180

;.Assembly	MASK_TEST_FILE
.Assembly	OTP_TEST_FILE	SN8P1909
.Assembly	PGM_TYPE	5
.Assembly	MASK_TEST_CODE	0x0000, 0x000, 0x0000, 0x0000
.Assembly	Port_Pins	2, 5, 8, 0, 0, 5, 0
.Assembly	LCD_Size	24, 4
.Assembly	COMMAND		PUSH, MUL
.Assembly	CHIP_ID		0x3C, 0x3D, 0x3E, 0x3F

.Assembly	OPTION		0		Watch_Dog	Enable	Disable
.Assembly	OPTION		1		Fix_High
.Assembly	OPTION		2		Int_16K_RC	Always_ON	By_CPUM
.Assembly	OPTION		3		Security	Enable	Disable
.Assembly	OPTION		4		High_Clk/2	Enable	Disable
.Assembly	OPTION		5		High_Clk	RC	32K_X'tal	12M_X'tal	4M_X'tal
.Assembly	OPTION		7		OSG		Enable	Disable
.Assembly	OPTION		8		Noise_Filter	Enable	Disable
.Assembly	OPTION		9 		TC1_Counter	4-Bit	5-Bit	6-Bit	8-Bit
.Assembly	OPTION		11 		TC0_Counter	4-Bit	5-Bit	6-Bit	8-Bit
.Assembly	OPTION		13 		Fix_High
.Assembly	OPTION		14		Low_Power	X	Enable	X	Disable	;Phase_Select	8_Phase	1_Phase	4_Phase	6_Phase
.Assembly	OPTION		2ffh
;.Assembly	OTP2MSK		0xFFFF, 0x000C, 0x0000

	L			EQU		0x80
	H			EQU		0x81
	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
	X			EQU		0x85	
	
	PFLAG			EQU		0x86

		FNT0		EQU		PFLAG.7
		FNPD		EQU		PFLAG.6
		FC		EQU		PFLAG.2
		FDC		EQU		PFLAG.1
		FZ		EQU		PFLAG.0



	RBANK			EQU		0x87
			FRBNKS0	EQU		0x87.0
			FRBNKS1	EQU		0x87.1
			FRBNKS2	EQU		0x87.2
			FRBNKS3	EQU		0x87.3

	OPTION			EQU		0x88
		FRTCM1	EQU		0x88.3
		FRTCM0	EQU		0x88.2
		FRCLK	EQU		0x88.0

IF	ICE_Mode==1

		LCDM1		EQU		0XCB	;S8KD-2 address
		FLCDBNK	EQU		LCDM1.5
		FLCDENB	EQU		LCDM1.3
		FBIAS	EQU		LCDM1.2

		Dummy		EQU		0X8F	;FOR by pass
		FP2SEG	EQU		Dummy.0
ELSE	
	LCDM1			EQU		0x89	;SN8P1909 real chip address
		FLCDBNK	EQU		LCDM1.5
		FLCDENB	EQU		LCDM1.3
		FBIAS	EQU		LCDM1.2
		FP2SEG	EQU		LCDM1.0
ENDIF



	AMPM			EQU		0x90
		FFD1	EQU		AMPM.5
		FFD0	EQU		AMPM.4
		FGS2	EQU		AMPM.3
		FGS1	EQU		AMPM.2
		FGS0	EQU		AMPM.1
		FAMPENB	EQU		AMPM.0

	AMPCHS			EQU		0x91
		FCHS2	EQU		AMPCHS.2
		FCHS1	EQU		AMPCHS.1
		FCHS0	EQU		AMPCHS.0

	AMPCKS			EQU_W		0x92

	ADCM			EQU		0x93
		FRVS1	EQU		ADCM.2
		FRVS0	EQU		ADCM.1
		FADCENB	EQU		ADCM.0
				
	ADCKS			EQU_W		0X94

	CPM			EQU		0x95
		FCPSTS	EQU_R		CPM.3
		FCPAUTO	EQU		CPM.2
		FCPON	EQU		CPM.1
		FCPRENB	EQU		CPM.0
	
	CPCKS			EQU_W		0x96
		
	DFM			EQU		0x97

		;FHC1	EQU		DFM.7
		;FHC0	EQU		DFM.6		;Inside test only
		FWRS1	EQU		DFM.3
		FWRS0	EQU		DFM.2
		FSTOD   EQU		DFM.1
		FDRDY	EQU		DFM.0

	ADCDL			EQU_R		0x98
	ADCDH			EQU_R		0x99
		
	SIOM		EQU			0xB4
		FSENB	EQU		SIOM.7
		FSTART	EQU		SIOM.6
		FSRATE1	EQU		SIOM.5
		FSRATE0	EQU		SIOM.4
		FSIG	EQU		SIOM.3
		FSCKMD	EQU		SIOM.2
		FSEDGE	EQU		SIOM.1
		FTXRX	EQU		SIOM.0

	SIOR		EQU_W			0xB5
	SIOB		EQU			0xB6

	PEDGE		EQU			0xBF

		FPEDGEN EQU		PEDGE.7
		FP00G0	EQU		PEDGE.3
		FP00G1	EQU		PEDGE.4
	P1W			EQU_W		0C0H

		FP14W	EQU_W		P1W.4
		FP13W	EQU_W		P1W.3
		FP12W	EQU_W		P1W.2
		FP11W	EQU_W		P1W.1
		FP10W	EQU_W		P1W.0

	P1M			EQU		0xC1

		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0

;	P2M			EQU		0xC2	;change to input only
;		FP27M	EQU		P2M.7
;		FP26M	EQU		P2M.6
;		FP25M	EQU		P2M.5
;		FP24M	EQU		P2M.4
;		FP23M	EQU		P2M.3
;		FP22M	EQU		P2M.2
;		FP21M	EQU		P2M.1
;		FP20M	EQU		P2M.0

	P5M			EQU		0C5H
		FP54M	EQU		P5M.4
		FP53M	EQU		P5M.3
		FP52M	EQU		P5M.2
		FP51M	EQU		P5M.1
		FP50M	EQU		P5M.0
	
	INTRQ		EQU		0C8H
		FTC1IRQ	EQU	INTRQ.6
		FTC0IRQ	EQU	INTRQ.5
		FT0IRQ	EQU	INTRQ.4
		FSIOIRQ	EQU	INTRQ.3
	;;	FP02IRQ	EQU	INTRQ.2
		FP01IRQ	EQU	INTRQ.1
		FP00IRQ	EQU	INTRQ.0

	INTEN		EQU		0C9H
		FTC1IEN	EQU	INTEN.6
		FTC0IEN	EQU	INTEN.5
		FT0IEN	EQU	INTEN.4
		FSIOIEN	EQU	INTEN.3
	;;	FP02IEN	EQU	INTEN.2
		FP01IEN	EQU	INTEN.1
		FP00IEN	EQU	INTEN.0

	OSCM		EQU			0xCA
		FWTCKS	EQU	OSCM.7
		FWDRST	EQU	OSCM.6
		FWDRATE	EQU	OSCM.5
		FCPUM1	EQU	OSCM.4
		FCPUM0	EQU	OSCM.3
		FCLKMD	EQU	OSCM.2
		FSTPHX	EQU	OSCM.1
	;	FHXUP	EQU	OSCM.0

	TC0R		EQU_W			0xCD

	PCL			EQU		0xCE
	PCH			EQU		0xCF

	P0			EQU_R	0D0H

		FP01	EQU_R	P0.1
		FP00	EQU_R	P0.0

	P1			EQU		0xD1
		FP14	EQU		P1.4
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0

	P2			EQU_R		0xD2
		FP27	EQU_R		P2.7
		FP26	EQU_R		P2.6
		FP25	EQU_R		P2.5
		FP24	EQU_R		P2.4
		FP23	EQU_R		P2.3
		FP22	EQU_R		P2.2
		FP21	EQU_R		P2.1
		FP20	EQU_R		P2.0

	P5			EQU		0xD5
		FP54	EQU		P5.4
		FP53	EQU		P5.3
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0



	T0M			EQU		0xD8
		FT0ENB		EQU	T0M.7
		FT0RATE2	EQU	T0M.6
		FT0RATE1	EQU	T0M.5
		FT0RATE0	EQU	T0M.4
		FTC1X8		EQU	T0M.3
		FTC0X8		EQU	T0M.2
		FTC0GN		EQU	T0M.1
		FT0TB		EQU	T0M.0

	T0C			EQU		0xD9

	TC0M		EQU			0DAH
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		FTC0CKS		EQU	TC0M.3
		FALOAD0		EQU	TC0M.2
		FTC0OUT		EQU	TC0M.1
		FPWM0OUT	EQU	TC0M.0

	TC0C		EQU			0xDB

	TC1M		EQU			0xDC
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
		FTC1CKS		EQU	TC1M.3
		FALOAD1		EQU	TC1M.2
		FTC1OUT		EQU	TC1M.1
		FPWM1OUT	EQU	TC1M.0

	TC1C		EQU			0xDD
	TC1R		EQU_W			0xDE

	STKP		EQU			0xDF
		FGIE	EQU		STKP.7
		FSTKPB3	EQU		STKP.3
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	P0UR		EQU_W			0xE0
		FP01R	EQU_W	P0UR.1
		FP00R	EQU_W	P0UR.0

	P1UR		EQU_W			0xE1
		FP14R	EQU_W	P1UR.4
		FP13R	EQU_W	P1UR.3
		FP12R	EQU_W	P1UR.2
		FP11R	EQU_W	P1UR.1
		FP10R	EQU_W	P1UR.0

	P2UR		EQU_W			0xE2
		FP27R	EQU_W	P2UR.7
		FP26R	EQU_W	P2UR.6
		FP25R	EQU_W	P2UR.5
		FP24R	EQU_W	P2UR.4
		FP23R	EQU_W	P2UR.3
		FP22R	EQU_W	P2UR.2
		FP21R	EQU_W	P2UR.1
		FP20R	EQU_W	P2UR.0

	P5UR		EQU_W			0xE5
		FP54R	EQU_W	P5UR.4
		FP53R	EQU_W	P5UR.3
		FP52R	EQU_W	P5UR.2
		FP51R	EQU_W	P5UR.1
		FP50R	EQU_W	P5UR.0

	@HL			EQU		0xE6
	DP0X			EQU		0xE6

	@YZ			EQU		0xE7
	DP1X			EQU		0xE7

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh


; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 1 

	@RST_WDT	macro		
 		B0BSET	FWDRST
	endm
	
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 1

	SleepMode	macro	 
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm

;;*************************************************************
; For simulation use 
; ICE connect to EV Board
;;*************************************************************
	
IF ICE_Mode==1


		P3M			EQU		0xC3
			FP37M	EQU		P3M.7
			FP36M	EQU		P3M.6
			FP35M	EQU		P3M.5
			FP34M	EQU		P3M.4
			FP33M	EQU		P3M.3
			FP32M	EQU		P3M.2
			FP31M	EQU		P3M.1
			FP30M	EQU		P3M.0
		P3			EQU		0xD3
			FP37	EQU		P3.7
			FP36	EQU		P3.6
			FP35	EQU		P3.5
			FP34	EQU		P3.4
			FP33	EQU		P3.3
			FP32	EQU		P3.2
			FP31	EQU		P3.1
			FP30	EQU		P3.0

		P3UR		EQU_W			0xE3
			FP37R	EQU_W	P3UR.7
			FP36R	EQU_W	P3UR.6
			FP35R	EQU_W	P3UR.5
			FP34R	EQU_W	P3UR.4
			FP33R	EQU_W	P3UR.3
			FP32R	EQU_W	P3UR.2
			FP31R	EQU_W	P3UR.1
			FP30R	EQU_W	P3UR.0

ENDIF


.TEXT
{

	//{{SONIX_SMOV_S8KD
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	27 5A 00 8F -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 00
	-1 -1 -1 -1 -1 -1 C0 0F   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 10 00 -1 -1 -1   -1 -1 -1 -1 -1 -1 00 -1
	00 -1 -1 -1 -1 -1 -1 -1   -1 7B BD -1 -1 -1 -1 -1
	BF 1F FF FF 00 1F 00 00   FF -1 07 -1 -1 -1 -1 08
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	87 00 DF 7F -1 
	-1	
	0600  73 00 04 08 0C     0600  7F E0 C0 80 00		
	1800  73 00 01 02 03     1800  7F 0E 0C 08 00	
	0004 72 10 00
	0001 71 00 01 -1

	//}}SONIX_SMOV_S8KD

	//{{SONIX_OPTION_RULE
	

	IF	High_Clk == RC
	{
		High_Clk/2		=	Enable
	}


	IF	High_Clk == 32K_X'tal
	{
		OSG			=	Enable
	}

	ENDP
	//}}SONIX_OPTION_RULE
}