
;------------------------------------------------------------------------------
;  CHIP: SN8P1919, OTP Only
;  Revision History:
;  V1.0  01/17/2006  First issue
;  V2.0  03/17/2006  Correct High_Clock code option for only one bit.
;  V3.0  05/18/2006  Remove Calibration bit 
;  V4.0  08/27/2007  Update SMOV table addr 0x87 to 0xFF (old is 0xF1)
;  V5.0  04/03/2008  Add "RedWrt_FORMAT    1"  	
;  V6.0  11/11/2008  Cancel ADCM.4 definition (IREFENB)
;  V7.0  06/29/2010  Add Macro "@RST_WDT", "SleepMode", "GreenMode", "SlowMode", "Slow2Normal" 
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		7
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	100h

.Assembly	INSTRUMENT	SN8P1919

;.Assembly	MASK_BODY_SIZE
IF 	ICE_Mode == 0
  .Assembly	OTP_BODY_SIZE	0x01800
  .Assembly	USER_ROM_SIZE	0x017FF
ELSE
  .Assembly	OTP_BODY_SIZE	0x01C00
  .Assembly	USER_ROM_SIZE	0x01BFF
ENDIF
;.Assembly	OTP_TEST_SIZE	0x0180

;.Assembly	MASK_TEST_FILE
;.Assembly	OTP_TEST_FILE	SN8P1919
.Assembly	PGM_TYPE	9
.Assembly	MASK_TEST_CODE	0x0000, 0x000, 0x0000, 0x0000
.Assembly	Port_Pins	2, 6, 2, 4, 0, 8, 0
.Assembly	LCD_Size	32, 4
.Assembly	COMMAND		PUSH, MUL
.Assembly	CHIP_ID		0x9910

.Assembly	OPTION		0		Watch_Dog	Enable	Disable
.Assembly	OPTION		1		Low_Power	Enable	Disable	;
.Assembly	OPTION		2		Int_16K_RC	Always_ON	By_CPUM
.Assembly	OPTION		3		Security	Enable	Disable
.Assembly	OPTION		4		High_Clk	IHRC 	4M_X'tal
.Assembly	OPTION		5		OTP_Low_Power	Enable	Disable
.Assembly	OPTION		6		Noise_Filter	Enable	Disable
.Assembly	OPTION		7 : 15 		Fix_High
;.Assembly	OPTION		7 		IHRC_CAL_LL	000 001 010 011 100 101 110 111 
;.Assembly	OPTION		10 		IHRC_CAL_LH	000 001 010 011 100 101 110 111 
;.Assembly	OPTION		13 		IHRC_CAL_H	H0 H1 H2 H3 H4 H5 H6 H7 
.Assembly	OPTION		2ffh
;.Assembly	OTP2MSK		0xFFFF, 0x000C, 0x0000

	L			EQU		0x80
	H			EQU		0x81
	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
	X			EQU		0x85		
	
	PFLAG			EQU		0x86
		FNT0		EQU		PFLAG.7
		FNPD		EQU		PFLAG.6
		FC		EQU		PFLAG.2
		FDC		EQU		PFLAG.1
		FZ		EQU		PFLAG.0
		
	RBANK			EQU		0x87
			FRBNKS0	EQU		0x87.0
			FRBNKS1	EQU		0x87.1
			FRBNKS2	EQU		0x87.2
			FRBNKS3	EQU		0x87.3

	OPTION			EQU		0x88
		FRCLK	EQU		0x88.0

IF	ICE_Mode==1

	LCDM1		EQU		0XCB	;S8KD-2 address
		FLCDBNK		EQU		LCDM1.5
		FLCDENB		EQU		LCDM1.3
		FLCDBIAS	EQU		LCDM1.2
		
		Dummy		EQU		0X8F	;FOR by pass
		FP3SEG		EQU		Dummy.0				
ELSE	
	LCDM1			EQU		0x89	;SN8P1919 real chip address
		FLCDBNK		EQU		LCDM1.5
		FLCDENB		EQU		LCDM1.3
		FLCDBIAS	EQU		LCDM1.2		
		FP3SEG		EQU		LCDM1.0
						
ENDIF
	AMPM			EQU		0x90
		FCHPENB	EQU		AMPM.7
		FBGRENB	EQU		AMPM.6
		FFDS1	EQU		AMPM.5
		FFDS0	EQU		AMPM.4
		FGS2	EQU		AMPM.3
		FGS1	EQU		AMPM.2
		FGS0	EQU		AMPM.1
		FAMPENB	EQU		AMPM.0

	AMPCHS			EQU		0x91
		FCHS3	EQU		AMPCHS.3
		FCHS2	EQU		AMPCHS.2
		FCHS1	EQU		AMPCHS.1
		FCHS0	EQU		AMPCHS.0

	AMPCKS			EQU_W		0x92
		FAMPCKS2	EQU_W	AMPCKS.2
		FAMPCKS1	EQU_W	AMPCKS.1
		FAMPCKS0	EQU_W	AMPCKS.0
		
	ADCM			EQU		0x93
		FIRVS		EQU		ADCM.3
		FRVS1		EQU		ADCM.2
		FRVS0		EQU		ADCM.1
		FADCENB		EQU		ADCM.0
				
	ADCKS			EQU_W		0X94

	CPM			EQU		0x95

		FACMENB		EQU		CPM.7	
		FAVDDRENB	EQU		CPM.6	
		FAVENB		EQU		CPM.5	
		FAVESEL1	EQU		CPM.4
		FAVESEL0	EQU		CPM.3
		FCPAUTO		EQU		CPM.2
		FCPON		EQU		CPM.1
		FCPRENB		EQU		CPM.0
	
	CPCKS			EQU_W		0x96
		FCPCKS3	EQU_W		CPCKS.3
		FCPCKS2	EQU_W		CPCKS.2
		FCPCKS1	EQU_W		CPCKS.1
		FCPCKS0	EQU_W		CPCKS.0
		
	DFM			EQU		0x97
		FWRS0	EQU		DFM.2
		FDRDY	EQU		DFM.0

	ADCDL			EQU_R		0x98
	ADCDH			EQU_R		0x99

	LBTM			EQU		0x9A

		FLBTO	EQU_R		LBTM.2
		FP51IO	EQU		LBTM.1
		FLBTENB	EQU		LBTM.0

	CPMTEST			EQU		0x9B
		FCPSAVE	EQU		CPMTEST.0

	PEDGE		EQU			0xBF
		FPEDGEN EQU		PEDGE.7
		FP00G0	EQU		PEDGE.3
		FP00G1	EQU		PEDGE.4

	P1W			EQU_W		0C0H
		;FP15W	EQU_W		P1W.5
		FP14W	EQU_W		P1W.4
		FP13W	EQU_W		P1W.3
		FP12W	EQU_W		P1W.2
		FP11W	EQU_W		P1W.1
		FP10W	EQU_W		P1W.0

	P1M			EQU		0xC1
		FP15M	EQU		P1M.5
		FP14M	EQU		P1M.4	
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0
		
	P2M			EQU		0xC2
		FP21M	EQU		P2M.1
		FP20M	EQU		P2M.0		
	
	P3M			EQU		0xC3
		FP33M	EQU		P3M.3
		FP32M	EQU		P3M.2		
		FP31M	EQU		P3M.1
		FP30M	EQU		P3M.0		

	P5M			EQU		0C5H
		FP57M	EQU		P5M.7
		FP56M	EQU		P5M.6
		FP55M	EQU		P5M.5
		FP54M	EQU		P5M.4
		FP53M	EQU		P5M.3
		FP52M	EQU		P5M.2
		FP51M	EQU		P5M.1
		FP50M	EQU		P5M.0


	INTRQ		EQU		0C8H
		FTC1IRQ	EQU	INTRQ.6
		FTC0IRQ	EQU	INTRQ.5
		FT0IRQ	EQU	INTRQ.4
		FP01IRQ	EQU	INTRQ.1
		FP00IRQ	EQU	INTRQ.0

	INTEN		EQU		0C9H
		FTC1IEN	EQU	INTEN.6
		FTC0IEN	EQU	INTEN.5
		FT0IEN	EQU	INTEN.4
		FP01IEN	EQU	INTEN.1
		FP00IEN	EQU	INTEN.0

	OSCM		EQU			0xCA
		FWTCKS	EQU	OSCM.7
		FWDRST	EQU	OSCM.6
		FWDRATE	EQU	OSCM.5
		FCPUM1	EQU	OSCM.4
		FCPUM0	EQU	OSCM.3
		FCLKMD	EQU	OSCM.2
		FSTPHX	EQU	OSCM.1

	TC0R		EQU_W			0xCD

	PCL			EQU		0xCE
	PCH			EQU		0xCF

	P0			EQU_R	0D0H
		;FP02	EQU_R	P0.2	
		FP01	EQU_R	P0.1	
		FP00	EQU_R	P0.0

	P1			EQU		0xD1
		FP15	EQU		P1.5
		FP14	EQU		P1.4	
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0

	P2			EQU		0xD2
		FP21	EQU		P2.1
		FP20	EQU		P2.0

	P3			EQU		0xD3
		FP33	EQU		P3.3	
		FP32	EQU		P3.2
		FP31	EQU		P3.1
		FP30	EQU		P3.0

	P5			EQU		0xD5
		FP57	EQU		P5.7
		FP56	EQU		P5.6
		FP55	EQU		P5.5
		FP54	EQU		P5.4
		FP53	EQU		P5.3	
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0

	T0M			EQU		0xD8
		FT0ENB		EQU	T0M.7
		FT0RATE2	EQU	T0M.6
		FT0RATE1	EQU	T0M.5
		FT0RATE0	EQU	T0M.4
		FTC1X8		EQU	T0M.3				
		FTC0X8		EQU	T0M.2				
		FTC0GN		EQU	T0M.1		
		FT0TB		EQU	T0M.0		

	T0C			EQU		0xD9
	
	TC0M		EQU			0DAH
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		;FTC0CKS		EQU	TC0M.3
		FALOAD0		EQU	TC0M.2
		FTC0OUT		EQU	TC0M.1
		FPWM0OUT	EQU	TC0M.0

	TC0C		EQU			0xDB

	TC1M		EQU			0xDC
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
		;FTC1CKS		EQU	TC1M.3
		FALOAD1		EQU	TC1M.2
		FTC1OUT		EQU	TC1M.1
		FPWM1OUT	EQU	TC1M.0	

	TC1C		EQU			0xDD
	
	TC1R		EQU_W			0xDE

	STKP		EQU			0xDF
		FGIE	EQU		STKP.7
		FSTKPB3	EQU		STKP.3
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	P0UR		EQU_W			0xE0
		FP01R	EQU_W	P0UR.1
		FP00R	EQU_W	P0UR.0		

	P1UR		EQU_W			0xE1
		FP15R	EQU_W	P1UR.5
		FP14R	EQU_W	P1UR.4
		FP13R	EQU_W	P1UR.3
		FP12R	EQU_W	P1UR.2
		FP11R	EQU_W	P1UR.1
		FP10R	EQU_W	P1UR.0

	P2UR		EQU_W			0xE2
		FP21R	EQU_W	P2UR.1
		FP20R	EQU_W	P2UR.0	
		
	P3UR		EQU_W			0xE3
		FP33R	EQU_W	P3UR.3
		FP32R	EQU_W	P3UR.2
		FP31R	EQU_W	P3UR.1
		FP30R	EQU_W	P3UR.0
	P5UR		EQU_W			0xE5
		FP57R	EQU_W	P5UR.7		
		FP56R	EQU_W	P5UR.6		
		FP55R	EQU_W	P5UR.5
		FP54R	EQU_W	P5UR.4
		FP53R	EQU_W	P5UR.3
		FP52R	EQU_W	P5UR.2
		FP51R	EQU_W	P5UR.1
		FP50R	EQU_W	P5UR.0

	@HL			EQU		0xE6
	DP0X			EQU		0xE6			

	@YZ			EQU		0xE7
	DP1X			EQU		0xE7

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh



; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 1 

	@RST_WDT	macro		
 		B0BSET	FWDRST
	endm
	
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 1

	SleepMode	macro	 
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm

;;*************************************************************
; For simulation use 
; ICE connect to EV Board
;;*************************************************************
	
IF ICE_Mode==1

	P4M			EQU		0C4H
		FP47M	EQU		P4M.7
		FP46M	EQU		P4M.6
		FP45M	EQU		P4M.5
		FP44M	EQU		P4M.4
	

	P4			EQU		0xD4
		FP47	EQU		P4.7
		FP46	EQU		P4.6
		FP45	EQU		P4.5
		FP44	EQU		P4.4

	P4UR		EQU_W			0xE4
		FP47R	EQU_W	P4UR.7		
		FP46R	EQU_W	P4UR.6		
		FP45R	EQU_W	P4UR.5
		FP44R	EQU_W	P4UR.4


	

ENDIF


.TEXT
{
	//{{SONIX_SMOV_S8KD
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	17 58 00 8F -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 11
	-1 -1 -1 -1 -1 -1 C0 0F   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 00 00 -1 -1 -1   -1 -1 -1 -1 -1 -1 00 -1
	3F -1 -1 -1 -1 -1 -1 -1   -1 73 BD -1 -1 -1 -1 -1
	83 3F 03 0F FF FF 00 00   FF -1 07 -1 -1 -1 -1 08
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	87 00 DF 7F  -1
	-1	
	0004 72 10 00
	0001 71 00 01 -1

	//}}SONIX_SMOV_S8KD

	//{{SONIX_OPTION_RULE
	

	ENDP
	//}}SONIX_OPTION_RULE
}

