
;------------------------------------------------------------------------------
;  CHIP: SN8P1927, OTP Only.
;  Revision History:
;  V1.0  04/13/2007  First issue - Modified from 1917
;
;  V4.0  05/23/2007  1: Remove Sytem register 0xE4= P4UR initial setting(old= 0xFF)
;		        For PUR will reffect LBT function, disable ICE PUR and using EV-chip internal PUR
;  V5.0   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;  Body note: This body not support C-compiler for ISP ROM fucntion.
;  V6.0  09/12/2008  Change ISP ROMWRT address and data register ICE=1 equ address.
;  V7.0  09/22/2008  Change ROMDAH address and Enable SMOV Table  PORT 7.
;  V8.0  09/23/2008  Change SIG bit and function of SIOM register is available .
;  V9.0  11/11-2008  Cancel ADCM.4 bit definition(IREFENB)
;		     Modify ADCM.3 bit definition from FRVS2 into FIRVS 
;  V10.0 17/12/2009  Modify WatchDog function always disable when High_Clk=IHRC.
;  V11.0 06/29/2010  Add Macro "@RST_WDT", "SleepMode", "SlowMode", "Slow2Normal" 
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		11
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	80h

.Assembly	INSTRUMENT	SN8P1907

;.Assembly	MASK_BODY_SIZE
IF 	ICE_Mode == 0
  .Assembly	OTP_BODY_SIZE	0x0800
  .Assembly	USER_ROM_SIZE	0x07FF
ELSE
  .Assembly	OTP_BODY_SIZE	0x1000
  .Assembly	USER_ROM_SIZE	0x0FFF
ENDIF
;.Assembly	OTP_TEST_SIZE	0x0180

;.Assembly	MASK_TEST_FILE
;.Assembly	OTP_TEST_FILE	SN8P1927
.Assembly	PGM_TYPE	9
.Assembly	MASK_TEST_CODE	0x0000, 0x000, 0x0000, 0x0000
.Assembly	Port_Pins	1, 4, 0, 0, 3, 3, 0
.Assembly	LCD_Size	12, 4
;.Assembly	COMMAND		PUSH, MUL
.Assembly	CHIP_ID		0x9730

.Assembly	OPTION		0		Watch_Dog	Enable	Disable
.Assembly	OPTION		1		Low_Power	Enable	Disable	;
.Assembly	OPTION		2		Int_16K_RC	Always_ON	By_CPUM
.Assembly	OPTION		3		Security	Enable	Disable
.Assembly	OPTION		4		High_Clk	IHRC X X X X X X 4M_X'tal
.Assembly	OPTION		7 : 15 		Fix_High	;IHRC_CAL_LL	000 001 010 011 100 101 110 111 
;.Assembly	OPTION		7 		IHRC_CAL_LL	000 001 010 011 100 101 110 111 
;.Assembly	OPTION		10 		IHRC_CAL_LH	000 001 010 011 100 101 110 111 
;.Assembly	OPTION		13 		IHRC_CAL_H	H0 H1 H2 H3 H4 H5 H6 H7 
.Assembly	OPTION		2ffh
;.Assembly	OTP2MSK		0xFFFF, 0x000C, 0x0000


	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
	
	PFLAG			EQU		0x86
		FC		EQU		PFLAG.2
		FDC		EQU		PFLAG.1
		FZ		EQU		PFLAG.0
		
	RBANK			EQU		0x87
			FRBNKS0	EQU		0x87.0
			FRBNKS1	EQU		0x87.1
			FRBNKS2	EQU		0x87.2
			FRBNKS3	EQU		0x87.3

IF	ICE_Mode==1

	LCDM1		EQU		0XCB	;S8KD-2 address
		FLCDBNK	EQU		LCDM1.5
		FLCDENB	EQU		LCDM1.3

		Dummy		EQU		0X8F	;FOR by pass
		FLCDDATA	EQU		Dummy.4
		FLCDBIAS	EQU		Dummy.2
		FLCDRATE	EQU		Dummy.1
		FLCDCLK		EQU		Dummy.0				
ELSE	
	LCDM1			EQU		0x89	;SN8P1927 real chip address
		FLCDBNK		EQU		LCDM1.5
		FLCDDATA	EQU		LCDM1.4
		FLCDENB		EQU		LCDM1.3
		FLCDBIAS	EQU		LCDM1.2		
		FLCDRATE	EQU		LCDM1.1
		FLCDCLK		EQU		LCDM1.0
						
ENDIF
	AMPM			EQU		0x90
		FBGRENB	EQU		AMPM.6
		FFDS1	EQU		AMPM.5
		FFDS0	EQU		AMPM.4
		FGS2	EQU		AMPM.3
		FGS1	EQU		AMPM.2
		FGS0	EQU		AMPM.1
		FAMPENB	EQU		AMPM.0

	AMPCHS			EQU		0x91
		FCHS2	EQU		AMPCHS.2
		FCHS1	EQU		AMPCHS.1
		FCHS0	EQU		AMPCHS.0

	AMPCKS			EQU_W		0x92
		FAMPCKS2	EQU_W	AMPCKS.2
		FAMPCKS1	EQU_W	AMPCKS.1
		FAMPCKS0	EQU_W	AMPCKS.0
		
	ADCM			EQU		0x93
		FIRVS		EQU		ADCM.3
		FRVS1		EQU		ADCM.2
		FRVS0		EQU		ADCM.1
		FADCENB		EQU		ADCM.0
				
	ADCKS			EQU_W		0X94

	CPM			EQU		0x95

		FACMENB		EQU		CPM.7	
		FAVDDRENB	EQU		CPM.6	
		FAVESEL		EQU		CPM.5	
		FAVENB		EQU		CPM.4
		FCPSTS		EQU_R		CPM.3
		FCPAUTO		EQU		CPM.2
		FCPON		EQU		CPM.1
		FCPRENB		EQU		CPM.0
	
	CPCKS			EQU_W		0x96
		FCPCKS3	EQU_W		CPCKS.3
		FCPCKS2	EQU_W		CPCKS.2
		FCPCKS1	EQU_W		CPCKS.1
		FCPCKS0	EQU_W		CPCKS.0
		
	DFM			EQU		0x97
		FWRS0	EQU		DFM.2
		FDRDY	EQU		DFM.0

	ADCDL			EQU_R		0x98
	ADCDH			EQU_R		0x99

	LBTM			EQU		0x9A

		FLBTO	EQU		LBTM.2
		FP41IO	EQU		LBTM.1
		FLBTENB	EQU		LBTM.0

	CPMTEST			EQU		0x9B

		FCPSAVE	EQU		CPMTEST.0
		
		
IF	ICE_Mode==1						;Un-used ICE RAM for IDE simulation
	ROMADRH			EQU		0XB4		;SIOM
		FVPPCHK		EQU_R		ROMADRH.7
		FROMADR14	EQU		ROMADRH.6
		FROMADR13	EQU		ROMADRH.5
		FROMADR12	EQU		ROMADRH.4
		FROMADR11	EQU		ROMADRH.3
		FROMADR10	EQU		ROMADRH.2
		FROMADR9	EQU		ROMADRH.1
		FROMADR8	EQU		ROMADRH.0
				
	ROMADRL			EQU		0XB6		;SIOB
		FROMADR7	EQU		ROMADRL.7
		FROMADR6	EQU		ROMADRL.6
		FROMADR5	EQU		ROMADRL.5
		FROMADR4	EQU		ROMADRL.4
		FROMADR3	EQU		ROMADRL.3
		FROMADR2	EQU		ROMADRL.2
		FROMADR1	EQU		ROMADRL.1
		FROMADR0	EQU		ROMADRL.0
	//ROMDAH			EQU		0XB5		;SIORU
	ROMDAH			EQU		0XC7		;P7M
		FROMDA15	EQU		ROMDAH.7
		FROMDA14	EQU		ROMDAH.6
		FROMDA13	EQU		ROMDAH.5
		FROMDA12	EQU		ROMDAH.4
		FROMDA11	EQU		ROMDAH.3
		FROMDA10	EQU		ROMDAH.2
		FROMDA9		EQU		ROMDAH.1
		FROMDA8		EQU		ROMDAH.0
				
	ROMDAL			EQU		0XB0		;DAM
		FROMDA7		EQU		ROMDAL.7
		FROMDA6		EQU		ROMDAL.6
		FROMDA5		EQU		ROMDAL.5
		FROMDA4		EQU		ROMDAL.4
		FROMDA3		EQU		ROMDAL.3
		FROMDA2		EQU		ROMDAL.2
		FROMDA1		EQU		ROMDAL.1
		FROMDA0		EQU		ROMDAL.0
		
	ROMCNT			EQU_W		0XB5		;SIOR	
ELSE		
	ROMADRH			EQU		0XA0
		FVPPCHK		EQU_R		ROMADRH.7
		FROMADR14	EQU		ROMADRH.6
		FROMADR13	EQU		ROMADRH.5
		FROMADR12	EQU		ROMADRH.4
		FROMADR11	EQU		ROMADRH.3
		FROMADR10	EQU		ROMADRH.2
		FROMADR9	EQU		ROMADRH.1
		FROMADR8	EQU		ROMADRH.0
			
	ROMADRL			EQU		0XA1	
		FROMADR7	EQU		ROMADRL.7
		FROMADR6	EQU		ROMADRL.6
		FROMADR5	EQU		ROMADRL.5
		FROMADR4	EQU		ROMADRL.4
		FROMADR3	EQU		ROMADRL.3
		FROMADR2	EQU		ROMADRL.2
		FROMADR1	EQU		ROMADRL.1
		FROMADR0	EQU		ROMADRL.0
	ROMDAH			EQU		0XA2
		FROMDA15	EQU		ROMDAH.7
		FROMDA14	EQU		ROMDAH.6
		FROMDA13	EQU		ROMDAH.5
		FROMDA12	EQU		ROMDAH.4
		FROMDA11	EQU		ROMDAH.3
		FROMDA10	EQU		ROMDAH.2
		FROMDA9		EQU		ROMDAH.1
		FROMDA8		EQU		ROMDAH.0
	ROMDAL			EQU		0XA3
		FROMDA7		EQU		ROMDAL.7
		FROMDA6		EQU		ROMDAL.6
		FROMDA5		EQU		ROMDAL.5
		FROMDA4		EQU		ROMDAL.4
		FROMDA3		EQU		ROMDAL.3
		FROMDA2		EQU		ROMDAL.2
		FROMDA1		EQU		ROMDAL.1
		FROMDA0		EQU		ROMDAL.0
	ROMCNT			EQU_W		0XA4	
ENDIF

	PEDGE		EQU			0xBF
		FPEDGEN EQU		PEDGE.7
		FP00G0	EQU		PEDGE.3
		FP00G1	EQU		PEDGE.4

	P1M			EQU		0xC1
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0
		
	P2M			EQU		0xC2
		FP21M	EQU		P2M.1
		FP20M	EQU		P2M.0		
	
	INTRQ		EQU		0C8H
		FT0IRQ	EQU	INTRQ.4
		FP00IRQ	EQU	INTRQ.0

	INTEN		EQU		0C9H
		FT0IEN	EQU	INTEN.4
		FP00IEN	EQU	INTEN.0

	OSCM		EQU			0xCA
		FWTCKS	EQU	OSCM.7
		FWDRST	EQU	OSCM.6
		FWDRATE	EQU	OSCM.5
		FCPUM0	EQU	OSCM.3
		FCLKMD	EQU	OSCM.2
		FSTPHX	EQU	OSCM.1

	PCL			EQU		0xCE
	PCH			EQU		0xCF

	P0			EQU_R	0D0H
		FP00	EQU_R	P0.0

	P1			EQU		0xD1
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0

	P2			EQU		0xD2
		FP21	EQU		P2.1
		FP20	EQU		P2.0

	P4			EQU_R		0xD4
		FP42	EQU_R		P4.2
		FP41	EQU_R		P4.1
		FP40	EQU_R		P4.0

	P5			EQU		0xD5
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0

	T0M			EQU		0xD8
		FT0ENB		EQU	T0M.7
		FT0RATE2	EQU	T0M.6
		FT0RATE1	EQU	T0M.5
		FT0RATE0	EQU	T0M.4

	T0C			EQU		0xD9

	STKP		EQU			0xDF
		FGIE	EQU		STKP.7
		FSTKPB3	EQU		STKP.3
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	P1UR		EQU_W			0xE1
		FP13R	EQU_W	P1UR.3
		FP12R	EQU_W	P1UR.2
		FP11R	EQU_W	P1UR.1
		FP10R	EQU_W	P1UR.0

	P2UR		EQU_W			0xE2
		FP21R	EQU_W	P2UR.1
		FP20R	EQU_W	P2UR.0		

	@YZ			EQU		0xE7
	DP1X			EQU		0xE7

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh


; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 1 

	@RST_WDT	macro		
 		B0BSET	FWDRST
	endm
	
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 1

	SleepMode	macro	 
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-1 ICE
; 		1927 No Green Mode

	
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm




;;*************************************************************
; For simulation use 
; ICE connect to EV Board
;;*************************************************************
	
IF ICE_Mode==1


		P3M			EQU		0xC3
			FP37M	EQU		P3M.7
			FP36M	EQU		P3M.6
			FP35M	EQU		P3M.5
			FP34M	EQU		P3M.4
			FP33M	EQU		P3M.3
			FP32M	EQU		P3M.2
			FP31M	EQU		P3M.1
			FP30M	EQU		P3M.0
		P3			EQU		0xD3
			FP37	EQU		P3.7
			FP36	EQU		P3.6
			FP35	EQU		P3.5
			FP34	EQU		P3.4
			FP33	EQU		P3.3
			FP32	EQU		P3.2
			FP31	EQU		P3.1
			FP30	EQU		P3.0

		P3UR		EQU_W			0xE3
			FP37R	EQU_W	P3UR.7
			FP36R	EQU_W	P3UR.6
			FP35R	EQU_W	P3UR.5
			FP34R	EQU_W	P3UR.4
			FP33R	EQU_W	P3UR.3
			FP32R	EQU_W	P3UR.2
			FP31R	EQU_W	P3UR.1
			FP30R	EQU_W	P3UR.0

ENDIF


.TEXT
{
	//{{SONIX_SMOV_S8KD
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	0F 48 00 8F -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 11
	-1 -1 -1 -1 -1 -1 00 0F   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 00 08 -1 -1 -1   -1 -1 -1 -1 -1 -1 00 -1
	00 -1 -1 -1 -1 -1 -1 -1   -1 11 AD -1 -1 -1 -1 -1
	81 0F 03 FF 07 07 00 FF   F0 -1 00 -1 -1 -1 -1 08
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	87 00 DF 7F C0 FF E0 FF D3 00 C3 EF E3 FF C4 00 C5 FF D5 00-1
	-1	
	0004 72 10 00
	0001 71 00 01 -1

	//}}SONIX_SMOV_S8KD

	//{{SONIX_OPTION_RULE

	IF High_Clk	 == IHRC
	{
		OPTION		0		Watch_Dog	X	Disable
  }
	ELSE	
	{
		OPTION		0		Watch_Dog Enable Disable
  }      

	//}}SONIX_OPTION_RULE
	
	ENDP
}

