
;------------------------------------------------------------------------------
;  CHIP: SN8P22421
;  Revision History
;  
;  V01   2009/08/05	First Version
;  V02   2009/09/22     1. Add FUE0E enable bit in UE0R.
;                       2. Add FUE1D direction bit in UE1R.
;                       3. Add FUE2D direction bit in UE2R.
;  V03	 2009/11/27	1. Update USB PHY
;			2. Update Code option
;			3. Update bit name of USB_INT_EN
;  V04	 2009/12/01	1. Update R/W attribution of specified bits.
;  v05	 2010/03/10 1.CHIP_ID 0x2210 => 0x2212
;					2.INC_VER 4 => 5
;					3.ADD FLENGTH4_TOGGLE at USB_INT_EN.0
;					4.ADD FEP0_IN_STALL at IHRCU.0
;					5.ADD FEP0_OUT_STALL at IHRCL.0
;  V06 2010/06/30   1.ADD MACRO:
;					  SleepMode
;					  GreenMode
;					  SlowMode
;					  Slow2Normal
;  V07 2010/07/13	1.Remove IHRC Code Option
;  V08 2010/11/15	1.Remove FCPU Option(FCPU/1 Only)
;					2.CHIP_ID 0x2212 => 0x2213
;					3.INC_VER 7 => 8
;  V09   2012/07/12  	1. Add "PCL_READ_LIMIT" Key word
;  V10	 2013/08/27	1. Remove USTATUS bit5~bit7.
;			2. Remove IHRCU & IHRCL bit1~bit3.
;			3. Add the P0UR & P1UR bit0~bit6 to write only.
;			4. Add the PCH bit0~bit4 define.
;			5. Add the STKnH(n=0~7) bit0~bit4 define.
;			6. Remove CFS, IHRC_HOLD, IHRC_VALUE register.
;------------------------------------------------------------------------------

.ASSEMBLY   RedWrt_FORMAT	1
.Assembly	INC_VER		9
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	128

.Assembly	INSTRUMENT	SN8P2242
.Assembly	BIT_FILE	SN8P2242

.Assembly	OTP_BODY_SIZE	0x0C00
.Assembly	USER_ROM_SIZE	0x0BFC

.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000

.Assembly	PGM_TYPE	6
.Assembly	CHIP_ID		0x2213
.Assembly	command		Enable_ORG4_7, RBANK_LIMIT, PCL_READ_LIMIT
.Assembly	Port_Pins	7, 8, 0, 0, 0, 0

.Assembly	USB_FIFO_Size	32, 32


; Code Option 0x0BFF
.Assembly	OPTION		0		Fix_Low
.Assembly	OPTION		1		Security	Enable	Disable

;.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 x
.Assembly	OPTION		2		Fix_Low
.Assembly	OPTION		3		Fix_Low

;For regulator adjust
.Assembly	OPTION		4		Fix_Low
.Assembly 	OPTION		5		Fix_High
.Assembly	OPTION		6		Fix_Low
;
.Assembly	OPTION		7		Fix_High	;IHRC_Auto_Adjust = Enable
.Assembly	OPTION		8		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x
.Assembly	OPTION		12		Reset_Pin       P17 	Reset
.Assembly	OPTION		13		Rst_Length  	No 	128*ILRC
.Assembly	OPTION		14		Fix_High
.Assembly	OPTION		15		Fix_Low

; Code Option 0x0BFE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x0BFD
;.Assembly	OPTION		32 : 47 		Fix_High

.Assembly	OPTION		32 		Fix_High
.Assembly	OPTION		33 		Fix_low
.Assembly	OPTION		34 		Fix_low
.Assembly	OPTION		35 		Fix_low
.Assembly	OPTION		36 		Fix_High
.Assembly	OPTION		37 		Fix_low
.Assembly	OPTION		38 		Fix_High
.Assembly	OPTION		39 		Fix_low

.Assembly	OPTION		40 		Fix_low
.Assembly	OPTION		41 		Fix_low
.Assembly	OPTION		42 		Fix_High
.Assembly	OPTION		43 		Fix_low
.Assembly	OPTION		44 		Fix_low
.Assembly	OPTION		45 		Fix_low
.Assembly	OPTION		46 		Fix_low
.Assembly	OPTION		47		Fix_low

; Code Option 0x0BFC

.Assembly	OPTION		48 : 63 		Fix_High

/*
.Assembly	OPTION		48 		Fix_low
.Assembly	OPTION		49 		Fix_low
.Assembly	OPTION		50 		Fix_High
.Assembly	OPTION		51 		Fix_low
.Assembly	OPTION		52 		Fix_High
.Assembly	OPTION		53 		Fix_low
.Assembly	OPTION		54 		Fix_low
.Assembly	OPTION		55 		Fix_low

.Assembly	OPTION		56 		Fix_low
.Assembly	OPTION		57 		Fix_High
.Assembly	OPTION		58		Fix_High
.Assembly	OPTION		59 		Fix_High
.Assembly	OPTION		60 		Fix_High
.Assembly	OPTION		61 		Fix_High
.Assembly	OPTION		62 		Fix_High
.Assembly	OPTION		63 		Fix_High
*/
.Assembly	OPTION		2ffh
	R			EQU	82H
	Z			EQU	83H
	Y			EQU	84H
	
	PFLAG			EQU	86H
		FZ		EQU	PFLAG.0
		FDC		EQU	PFLAG.1
		FC		EQU	PFLAG.2
		FNPD		EQU	PFLAG.6
		FNT0		EQU	PFLAG.7
	
	UDA			EQU	090H
		FUDE		EQU	UDA.7
		FUDA6		EQU	UDA.6
		FUDA5		EQU	UDA.5
		FUDA4		EQU	UDA.4
		FUDA3		EQU	UDA.3
		FUDA2		EQU	UDA.2
		FUDA1		EQU	UDA.1
		FUDA0		EQU	UDA.0

	USTATUS			EQU	091H
		FBUS_RST	EQU_R	USTATUS.4
		FSUSPEND	EQU_R	USTATUS.3
		FEP0_SETUP	EQU	USTATUS.2
		FEP0_IN		EQU	USTATUS.1
		FEP0_OUT	EQU	USTATUS.0
		
	EP0OUT_CNT		EQU	092H
		FUEP0OC4	EQU	EP0OUT_CNT.4
		FUEP0OC3	EQU	EP0OUT_CNT.3
		FUEP0OC2	EQU	EP0OUT_CNT.2
		FUEP0OC1	EQU	EP0OUT_CNT.1
		FUEP0OC0	EQU	EP0OUT_CNT.0
	
	USB_INT_EN				EQU		093H
		FREG_EN				EQU		USB_INT_EN.7
		FDN_PU_EN			EQU		USB_INT_EN.6
		FIHRCCTR_EN			EQU_R	USB_INT_EN.5
		FLENGTH4_TOGGLE	EQU		USB_INT_EN.0
	
	EP_ACK			EQU	094H
		FEP2_ACK	EQU	EP_ACK.1
		FEP1_ACK	EQU	EP_ACK.0
	
		
	UE0R			EQU	096H
		FUE0E		EQU	UE0R.7
		FUE0M1		EQU	UE0R.6
		FUE0M0		EQU	UE0R.5
		FUE0C3		EQU	UE0R.3
		FUE0C2		EQU	UE0R.2
		FUE0C1		EQU	UE0R.1
		FUE0C0		EQU	UE0R.0

	UE1R			EQU	097H
		FUE1E		EQU	UE1R.7
		FUE1M1		EQU	UE1R.6
		FUE1M0		EQU	UE1R.5
		FUE1D		EQU	UE1R.4
		FUE1C3		EQU	UE1R.3
		FUE1C2		EQU	UE1R.2
		FUE1C1		EQU	UE1R.1
		FUE1C0		EQU	UE1R.0

	UE2R			EQU	098H
		FUE2E		EQU	UE2R.7
		FUE2M1		EQU	UE2R.6
		FUE2M0		EQU	UE2R.5
		FUE2D		EQU	UE2R.4
		FUE2C3		EQU	UE2R.3
		FUE2C2		EQU	UE2R.2
		FUE2C1		EQU	UE2R.1
		FUE2C0		EQU	UE2R.0
		
	UDP0_L			EQU	0A3H
		FUDP07		EQU	UDP0_L.7
		FUDP06		EQU	UDP0_L.6
		FUDP05		EQU	UDP0_L.5
		FUDP04		EQU	UDP0_L.4
		FUDP03		EQU	UDP0_L.3
		FUDP02		EQU	UDP0_L.2
		FUDP01		EQU	UDP0_L.1
		FUDP00		EQU	UDP0_L.0
	
	UDP0_H			EQU	0A4H
		FWE0		EQU	UDP0_H.7
		FRE0		EQU	UDP0_H.6
	
	UDR0_R			EQU	0A5H
	 	FUDR0_R7	EQU	UDR0_R.7
		FUDR0_R6	EQU	UDR0_R.6
		FUDR0_R5	EQU	UDR0_R.5
		FUDR0_R4	EQU	UDR0_R.4
		FUDR0_R3	EQU	UDR0_R.3
		FUDR0_R2	EQU	UDR0_R.2
		FUDR0_R1	EQU	UDR0_R.1
		FUDR0_R0	EQU	UDR0_R.0
	
	UDR0_W			EQU	0A6H
		FUDR0_W7	EQU	UDR0_W.7
		FUDR0_W6	EQU	UDR0_W.6
		FUDR0_W5	EQU	UDR0_W.5
		FUDR0_W4	EQU	UDR0_W.4
		FUDR0_W3	EQU	UDR0_W.3
		FUDR0_W2	EQU	UDR0_W.2
		FUDR0_W1	EQU	UDR0_W.1
		FUDR0_W0	EQU	UDR0_W.0		
	
		
	UPID			EQU	0ABH
	 	FCRC_ERR	EQU	UPID.4
	 	FPKT_ERR	EQU	UPID.3
	 	FUBDE		EQU	UPID.2
		FDDP		EQU	UPID.1
		FDDN		EQU	UPID.0

	UTOGGLE			EQU	0ACH
		FEP2_DATA01	EQU	UTOGGLE.1
		FEP1_DATA01	EQU	UTOGGLE.0	

	IHRCU			EQU	0B0H
		FEP0_IN_STALL		EQU	IHRCU.0
	
	IHRCL			EQU	0B1H
		FEP0_OUT_STALL		EQU	IHRCL.0	

	P0M			EQU	0B8H		
		FP06M		EQU	P0M.6
		FP05M		EQU	P0M.5
		FP04M		EQU	P0M.4
		FP03M		EQU	P0M.3
		FP02M		EQU	P0M.2
		FP01M		EQU	P0M.1
		FP00M		EQU	P0M.0

	
	PEDGE			EQU	0BFH		
		FP00G1		EQU	PEDGE.1
		FP00G0		EQU	PEDGE.0

	P1M			EQU	0C1H
		FP16M		EQU	P1M.6
		FP15M		EQU	P1M.5
		FP14M		EQU	P1M.4
		FP13M		EQU	P1M.3
		FP12M		EQU	P1M.2
		FP11M		EQU	P1M.1
		FP10M		EQU	P1M.0
  				
	INTRQ			EQU	0C8H
		FUSBIRQ		EQU	INTRQ.6
		FT0IRQ		EQU	INTRQ.4
		FWAKEIRQ 	EQU	INTRQ.2
		FP00IRQ		EQU	INTRQ.0

	INTEN			EQU	0C9H
		FUSBIEN		EQU	INTEN.6
		FT0IEN		EQU	INTEN.4
		FWAKEIEN 	EQU	INTEN.2
		FP00IEN		EQU	INTEN.0

	OSCM			EQU	0CAH
		FCPUM1		EQU	OSCM.4
		FCPUM0		EQU	OSCM.3
		FCLKMD		EQU	OSCM.2
		FSTPHX		EQU	OSCM.1

	WDTR			EQU_W	0CCH
    
	PCL			EQU	0CEH
	PCH			EQU	0CFH
		FPC12		EQU	PCH.4
		FPC11		EQU	PCH.3
		FPC10		EQU	PCH.2
		FPC9		EQU	PCH.1
		FPC8		EQU	PCH.0

	P0			EQU 	0D0H		
		FP06		EQU 	P0.6
		FP05		EQU 	P0.5
		FP04		EQU 	P0.4
		FP03		EQU 	P0.3
		FP02		EQU 	P0.2
		FP01		EQU 	P0.1
		FP00		EQU 	P0.0

	P1			EQU 	0D1H
		FP17		EQU_R 	P1.7
		FP16		EQU 	P1.6
		FP15		EQU 	P1.5
		FP14		EQU 	P1.4
		FP13		EQU 	P1.3
		FP12		EQU 	P1.2
		FP11		EQU 	P1.1
		FP10		EQU 	P1.0
		
	T0M			EQU	0D8H
		FT0ENB     	EQU	T0M.7
		FT0RATE2   	EQU	T0M.6
		FT0RATE1   	EQU	T0M.5
		FT0RATE0   	EQU	T0M.4

	T0C			EQU	0D9H

	STKP			EQU	0DFH
		FGIE		EQU	STKP.7
		FSTKPB2		EQU	STKP.2
		FSTKPB1		EQU	STKP.1
		FSTKPB0		EQU	STKP.0

    P0UR        		EQU_W	0E0H
		FP06R		EQU_W	P0UR.6
		FP05R		EQU_W	P0UR.5
		FP04R		EQU_W	P0UR.4
		FP03R		EQU_W	P0UR.3
		FP02R		EQU_W	P0UR.2
		FP01R		EQU_W	P0UR.1
		FP00R		EQU_W	P0UR.0

    P1UR        		EQU_W	0E1H
		FP16R		EQU_W	P1UR.6
		FP15R		EQU_W	P1UR.5
		FP14R		EQU_W	P1UR.4
		FP13R		EQU_W	P1UR.3
		FP12R		EQU_W	P1UR.2
		FP11R		EQU_W	P1UR.1
		FP10R		EQU_W	P1UR.0

	@YZ			EQU	0E7H

	
	STK7L			EQU	0F0h
	STK7H			EQU	0F1h
		FS7PC12		EQU	STK7H.4
		FS7PC11		EQU	STK7H.3
		FS7PC10		EQU	STK7H.2
		FS7PC9		EQU	STK7H.1
		FS7PC8		EQU	STK7H.0
	STK6L			EQU	0F2h
	STK6H			EQU	0F3h
		FS6PC12		EQU	STK6H.4
		FS6PC11		EQU	STK6H.3
		FS6PC10		EQU	STK6H.2
		FS6PC9		EQU	STK6H.1
		FS6PC8		EQU	STK6H.0
	STK5L			EQU	0F4h
	STK5H			EQU	0F5h
		FS5PC12		EQU	STK5H.4
		FS5PC11		EQU	STK5H.3
		FS5PC10		EQU	STK5H.2
		FS5PC9		EQU	STK5H.1
		FS5PC8		EQU	STK5H.0
	STK4L			EQU	0F6h
	STK4H			EQU	0F7h
		FS4PC12		EQU	STK4H.4
		FS4PC11		EQU	STK4H.3
		FS4PC10		EQU	STK4H.2
		FS4PC9		EQU	STK4H.1
		FS4PC8		EQU	STK4H.0
				
	STK3L			EQU	0F8h
	STK3H			EQU	0F9h
		FS3PC12		EQU	STK3H.4
		FS3PC11		EQU	STK3H.3
		FS3PC10		EQU	STK3H.2
		FS3PC9		EQU	STK3H.1
		FS3PC8		EQU	STK3H.0
	STK2L			EQU	0FAh
	STK2H			EQU	0FBh
		FS2PC12		EQU	STK2H.4
		FS2PC11		EQU	STK2H.3
		FS2PC10		EQU	STK2H.2
		FS2PC9		EQU	STK2H.1
		FS2PC8		EQU	STK2H.0
	STK1L			EQU	0FCh
	STK1H			EQU	0FDh
		FS1PC12		EQU	STK1H.4
		FS1PC11		EQU	STK1H.3
		FS1PC10		EQU	STK1H.2
		FS1PC9		EQU	STK1H.1
		FS1PC8		EQU	STK1H.0
	STK0L			EQU	0FEh
	STK0H			EQU	0FFh
		FS0PC12		EQU	STK0H.4
		FS0PC11		EQU	STK0H.3
		FS0PC10		EQU	STK0H.2
		FS0PC9		EQU	STK0H.1
		FS0PC8		EQU	STK0H.0

;*******************************************************
; Clear watchdog macro. 
;  
; Total Cycle: 2
    @RST_WDT macro
           MOV  A, #0x5A
           B0MOV  WDTR, A
    endm

;******************************************************
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1
    SleepMode macro          
           B0BSET      FCPUM0
    endm
;******************************************************
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3
    GreenMode macro          
           B0BSET      FCPUM1
           NOP
           NOP
    endm
;******************************************************
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2
    SlowMode macro          
           B0BSET      FCLKMD
           B0BSET      FSTPHX
    endm
;******************************************************
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5
    Slow2Normal       macro          
           B0BCLR     FSTPHX
           NOP
           NOP
           NOP
           B0BCLR     FCLKMD
    endm
;******************************************************
	
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}