
;------------------------------------------------------------------------------
;  CHIP: SN8P2308
;  Revision History:
;  V1  01/05/2005   First issue and only for SN8ICE 2K.
;  V2  01/13/2005   Modified bit0 of RFC register from FRFCEB to FRFCENB 
;  V3  04/04/2005   1. Disable LVD de-bounce. 
;                   2. Add ID 0x5801 (5 layer change)
;  V4   12/12/2005  1. Remove 32K_X'Tal mode code option. 
;                   2. Limit Fcpu 1T, 2T rate when Noise_Filter enable.
;  V5   12/17/2007  1. "GreenMode","SleepMode","SlowMode","Slow2Normal" macro programs. 
;  V6   04/03/2008  1. Add "RedWrt_FORMAT 1"  	
;  V7   11/16/2009  1. Modify green mode command limit to "Green_B0BSET_LIMIT_0XEF".
;                   2. Modify "GreenMode" macro.  	
;  V8   06/29/2010  1. modify MACRO text "SLowMode" to "SlowMode"
;  V9   02/01/2012  1. Delete CHIP_ID Value 0x5800
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		9
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	80h

.Assembly	INSTRUMENT	SN8P2308
.Assembly	BIT_FILE	SN8P2308

.Assembly	OTP_BODY_SIZE	0x1000;0800
.Assembly	USER_ROM_SIZE	0x0FFC;07FC

;.Assembly	OTP_TEST_SIZE	0x00E0
;.Assembly	MASK_TEST_FILE
;.Assembly	OTP_TEST_FILE	SN86P
.Assembly	PGM_TYPE	6
.Assembly	MASK_TEST_CODE	0x0000, 0x000, 0x0000, 0x0000
.Assembly	Port_Pins	4, 7, 0, 8, 0, 6
.Assembly	LCD_Size	32, 4

.Assembly	COMMAND		PCL_LIMIT, Enable_ORG4_7, Instead_P6, RBANK_LIMIT, GREEN_B0BSET_LIMIT_0XEF
;.Assembly	CHIP_ID		0x5800, 0x5801
.Assembly	CHIP_ID		0x5801
; Code Option 0x3FF
.Assembly	OPTION   	0		Noise_Filter	Enable	Disable
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1	Fosc/2	Fosc/4	Fosc/8
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}

;.Assembly	OPTION		4		RST_debounce    NO	128*ILOSC
.Assembly	OPTION		4		Fix_High

.Assembly	OPTION		5		High_Clk	RC	x	12M_X'tal	4M_X'tal
.Help
{	
	RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	12M_X'tal	:	"Crystal/Resonator: 10Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~10Mhz"
}
.Assembly	OPTION		7		Fix_High
.Assembly	OPTION   	8		Watch_Dog	Always_ON x x x x Enable x x x x Disable x x x x x
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen mode : Enable Watchdog\nSleep mode : Stop Watchdog"
	Disable         :       "Disable Watchdog"
}
.Assembly	OPTION		12		RST_P0.2	P0.2	RESET

;.Assembly	OPTION		13		RFC_EV		Enable	Disable
.Assembly	OPTION		13		Fix_High

;.Assembly	OPTION		14		LVD     	LVD_MAX	LVD_H	LVD_M	LVD_L
;.Help
;{
;	LVD_L		:	"2.0V Reset"
;	LVD_M		:	"2.0V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
;	LVD_H		:	"2.4V Reset\nEnable LVD36 bit of PFLAG for\n3.6V Low Voltage Indicator"
;	LVD_MAX		:	"3.6V Reset"
;}

.Assembly	OPTION		14		LVD     	X	LVD_H	LVD_M	LVD_L
.Help
{
	LVD_L		:	"2.0V Reset"
	LVD_M		:	"2.0V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
	LVD_H		:	"2.4V Reset\nEnable LVD36 bit of PFLAG for\n3.6V Low Voltage Indicator"	
}


; Code Option 0x3FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 29		Fix_High
;.Assembly	OPTION		30		LVD_Debounce   NO	32ms	512u	2m
.Assembly	OPTION		30 : 31		Fix_Low
; Code Option 0x3FD
.Assembly	OPTION		32 : 63		Fix_High;
.Assembly	OPTION		2ffh
;.Assembly	OTP2MSK		0xFFFF, 0x000C, 0x0000


	L		EQU		0x80
	H		EQU		0x81
	R		EQU		0x82
	Z		EQU		0x83
	Y		EQU		0x84

	PFLAG		EQU		0x86
		FZ	EQU		PFLAG.0
		FDC	EQU		PFLAG.1
		FC	EQU		PFLAG.2
		FLVD24	EQU		PFLAG.4
		FLVD36	EQU		PFLAG.5		
		FNPD	EQU		PFLAG.6
		FNT0	EQU		PFLAG.7

	RBANK			EQU		0x87
		FRBNKS0	EQU		RBANK.0
		FRBNKS1	EQU		RBANK.1
		FRBNKS2	EQU		RBANK.2
		FRBNKS3	EQU		RBANK.3

	VLCD			EQU		0x89
		FVLCDCP	EQU		VLCD.0
		FVLCD0	EQU		VLCD.1
		FVLCD1	EQU		VLCD.2
		FVLCD2	EQU		VLCD.3
		FCPCK0	EQU		VLCD.4
		FCPCK1	EQU		VLCD.5
   
	T1M				EQU		0xA0
		FT1IRQ	EQU		T1M.0
		FT1IEN	EQU		T1M.1
		FT1CKS	EQU		T1M.3
		FT1RATE0	EQU		T1M.4
		FT1RATE1	EQU		T1M.5
		FT1RATE2	EQU		T1M.6
		FT1ENB	EQU		T1M.7

	T1CL			EQU		0xA1
	T1CH			EQU		0xA2

	RFCM				EQU		0xA3
		FRFCENB	EQU		RFCM.0
		FRFCH0	EQU		RFCM.1
		FRFCH1	EQU		RFCM.2
		FRFCOUT	EQU		RFCM.7

	P0M				EQU		0xB8
		FP00M	EQU		P0M.0
		FP01M	EQU		P0M.1
		;FP02M	EQU		P0M.2		;P0.2 RST/P0.2 is input only		
		FP03M	EQU		P0M.3

	PEDGE				EQU		0BFH
		FT1G0	EQU		PEDGE.0
		FT1G1	EQU		PEDGE.1
		FP00G1	EQU		PEDGE.4
		FP00G0	EQU		PEDGE.3

	P1W				EQU_W		0XC0
		FP10W	EQU_W		P1W.0
		FP11W	EQU_W		P1W.1
		FP12W	EQU_W		P1W.2
		FP13W	EQU_W		P1W.3
		FP14W	EQU_W		P1W.4
		FP15W	EQU_W		P1W.5
		FP16W	EQU_W		P1W.6
	
	P1M				EQU		0C1H
		FP10M	EQU		P1M.0
		FP11M	EQU		P1M.1
		FP12M	EQU		P1M.2
		FP13M	EQU		P1M.3
		FP14M	EQU		P1M.4
		FP15M	EQU		P1M.5
		FP16M	EQU		P1M.6

	P3M			EQU		0C3H
		FP37M	EQU		P3M.7
		FP36M	EQU		P3M.6
		FP35M	EQU		P3M.5
		FP34M	EQU		P3M.4
		FP33M	EQU		P3M.3
		FP32M	EQU		P3M.2
		FP31M	EQU		P3M.1
		FP30M	EQU		P3M.0

	P5M			EQU		0C5H
		FP55M	EQU		P5M.5
		FP54M	EQU		P5M.4
		FP53M	EQU		P5M.3
		FP52M	EQU		P5M.2
		FP51M	EQU		P5M.1
		FP50M	EQU		P5M.0		

	INTRQ			EQU		0C8H
		FTC0IRQ	EQU		INTRQ.5
		FT0IRQ	EQU		INTRQ.4
		FP00IRQ	EQU		INTRQ.0

	INTEN			EQU		0C9H
		FTC0IEN	EQU		INTEN.5
		FT0IEN	EQU		INTEN.4
		FP00IEN	EQU		INTEN.0

	OSCM			EQU		0CAH
		FCPUM1	EQU	OSCM.4		
		FCPUM0	EQU	OSCM.3
		FCLKMD	EQU	OSCM.2
		FSTPHX	EQU	OSCM.1

	LCDM			EQU		0XCB
		FLCDENB	EQU	LCDM.0
		FBIAS	EQU	LCDM.1
		FP3SEG	EQU	LCDM.2
		FRCLK	EQU	LCDM.3
		
	WDTR		EQU_W		0CCH				

	TC0R		EQU_W		0CDH

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU		0D0H
	    	FP03	EQU		P0.3
		FP02	EQU_R		P0.2
		FP01	EQU		P0.1
		FP00	EQU		P0.0	

	P1			EQU		0D1H
		FP16	EQU		P1.6
		FP15	EQU		P1.5
		FP14	EQU		P1.4
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0


	P3			EQU		0D3H
		FP37	EQU		P3.7
		FP36	EQU		P3.6
		FP35	EQU		P3.5
		FP34	EQU		P3.4
		FP33	EQU		P3.3
		FP32	EQU		P3.2
		FP31	EQU		P3.1
		FP30	EQU		P3.0

	P5			EQU		0D5H
		FP55	EQU		P5.5
		FP54	EQU		P5.4
		FP53	EQU		P5.3
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0		

	T0M			EQU		0D8H
		FT0TB	EQU	T0M.0
		FTC0X8  EQU	T0M.2
		FT0RATE0	EQU	T0M.4
		FT0RATE1	EQU	T0M.5
		FT0RATE2	EQU	T0M.6
		FT0ENB		EQU	T0M.7
		
	T0C			EQU		0XD9	


	TC0M			EQU		0DAH
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		FTC0CKS		EQU	TC0M.3
		FALOAD0		EQU	TC0M.2
		FTC0OUT		EQU	TC0M.1
		FPWM0OUT	EQU	TC0M.0

	TC0C			EQU		0DBH


	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	P0UR			EQU_W		0E0H
		FP03R	EQU_W		P0UR.3
;		FP02R	EQU_W		P0UR.2		;Reset pin with pull-up R
		FP01R	EQU_W		P0UR.1
		FP00R	EQU_W		P0UR.0

	P1UR			EQU_W		0E1H
		FP16R	EQU_W		P1UR.6
		FP15R	EQU_W		P1UR.5
		FP14R	EQU_W		P1UR.4
		FP13R	EQU_W		P1UR.3
		FP12R	EQU_W		P1UR.2
		FP11R	EQU_W		P1UR.1
		FP10R	EQU_W		P1UR.0

	P3UR			EQU_W		0E3H
		FP37R	EQU_W		P3UR.7
		FP36R	EQU_W		P3UR.6
		FP35R	EQU_W		P3UR.5
		FP34R	EQU_W		P3UR.4
		FP33R	EQU_W		P3UR.3
		FP32R	EQU_W		P3UR.2
		FP31R	EQU_W		P3UR.1
		FP30R	EQU_W		P3UR.0


	P5UR			EQU_W		0E5H

		FP56R	EQU_W		P5UR.6
		FP55R	EQU_W		P5UR.5
		FP54R	EQU_W		P5UR.4
		FP53R	EQU_W		P5UR.3
		FP52R	EQU_W		P5UR.2
		FP51R	EQU_W		P5UR.1
		FP50R	EQU_W		P5UR.0

	
	@HL			EQU		0E6H
	DP0X		EQU		0E6H
	
	@YZ			EQU		0E7H
	DP1X		EQU		0E7H

	NCREG		EQU	0EFH

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh
	
; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		B0BSET	0xEF.7
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------	
.TEXT
{
	//{{SONIX_OPTION_RULE		
	IF Noise_Filter == Enable
	{
		OPTION		2		Fcpu		x	x	Fosc/4	Fosc/8
  	}
	ELSE	
	{
		OPTION		2		Fcpu		Fosc/1	Fosc/2	Fosc/4	Fosc/8
  	}
	ENDP
	//}}SONIX_OPTION_RULE
}
