;------------------------------------------------------------------------------
;  CHIP: SN8P2604A
;  Revision History
;  
;  V01   06/27/2006  1. First issue and only for SN8ICE 2K. 
;  V02   12/17/2007  1. "GreenMode","SleepMode","SlowMode","Slow2Normal" macro programs. 
;  V03   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;  V04   07/04/2008  1. Add LVD24, LVD36 bits.  	
;  V05   06/29/2010  1. modify MACRO text "SLowMode" to "SlowMode"
;  V06   03/15/2011  1. modify MACRO SlowMode and Slow2Normal: FSPTHX ->> FSTPHX
;  V07   02/01/2012  1. modify CHIP_ID item  ->> delete "A" comma 
;------------------------------------------------------------------------------
.ASSEMBLY	RedWrt_FORMAT	1
.Assembly	INC_VER		7
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	128

.Assembly	INSTRUMENT	SN8P2604A
.Assembly	BIT_FILE	SN8P2604A

.Assembly	OTP_BODY_SIZE	0x1000
.Assembly	USER_ROM_SIZE	0x0FFC

;.Assembly	OTP_TEST_SIZE	0x00E0
;.Assembly	MASK_TEST_FILE
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	
.Assembly	PGM_TYPE	6
;.Assembly	CHIP_ID		0x3430,		
.Assembly	CHIP_ID		0x3430
.Assembly	COMMAND		Enable_ORG4_7, GREEN_NOP_LIMIT
.Assembly	Port_Pins	3,8,8,0,0,5

; Code Option 0xFFF
.Assembly	OPTION		0		Noise_Filter	Disable Enable	
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		4		Fix_High
.Assembly	OPTION		5		High_Clk	RC	32K_X'tal	12M_X'tal	4M_X'tal
.Help
{	
	RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	32K_X'tal	:	"32.768K Crystal"
	12M_X'tal	:	"Crystal/Resonator: 10Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~10Mhz"
}

.Assembly	OPTION		7		Fix_High
.Assembly	OPTION		8		Watch_Dog 	Always_On x x x x Enable x x x x Disable x x x x x 
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen and Sleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
} 
.Assembly	OPTION		12		Reset_Pin 	P02	Reset
.Assembly	OPTION		13		Fix_High
.Assembly	OPTION   	14		Fix_High
.Assembly	OPTION   	15		Fix_High

; Code Option 0xFFE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0xFFD
.Assembly	OPTION		32		LVD     	X	LVD_H	LVD_M	LVD_L
.Help
{
	LVD_L		:	"2.0V Reset"
	LVD_M		:	"2.0V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
	LVD_H		:	"2.4V Reset\nEnable LVD36 bit of PFLAG for\n3.6V Low Voltage Indicator"	
}
 
;.Assembly	OPTION_Hide		34		LVDB0 no 2_ILRC 4_ILRC 8_ILRC
.Assembly	OPTION		34		Fix_Low
.Assembly	OPTION		35		Fix_Low

.Assembly	OPTION		36 : 63	Fix_High

.Assembly	OPTION		2ffh

	L			EQU		0x80
	H			EQU		0x81
	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
	PFLAG		EQU		0x86
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FLVD24	EQU_R	PFLAG.4
		FLVD36	EQU_R	PFLAG.5
		FNPD	EQU		PFLAG.6
		FNT0	EQU		PFLAG.7

	P0M			EQU		0B8H
		FP01M	EQU		P0M.1
		FP00M	EQU		P0M.0


	PEDGE		EQU		0BFH
		FP00G1	EQU		PEDGE.4
		FP00G0	EQU		PEDGE.3

	P1W			EQU_W	0C0H
		FP17W	EQU_W	P1W.7
		FP16W	EQU_W	P1W.6
		FP15W	EQU_W	P1W.5
		FP14W	EQU_W	P1W.4
		FP13W	EQU_W	P1W.3
		FP12W	EQU_W	P1W.2
		FP11W	EQU_W	P1W.1
		FP10W	EQU_W	P1W.0

	P1M			EQU		0C1H
		FP17M	EQU		P1M.7
		FP16M	EQU		P1M.6
		FP15M	EQU		P1M.5
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0

	P2M			EQU		0C2H
		FP27M	EQU		P2M.7
		FP26M	EQU		P2M.6
		FP25M	EQU		P2M.5
		FP24M	EQU		P2M.4
		FP23M	EQU		P2M.3
		FP22M	EQU		P2M.2
		FP21M	EQU		P2M.1
		FP20M	EQU		P2M.0

	P5M			EQU		0C5H
     	FP54M	EQU		P5M.4
     	FP53M	EQU		P5M.3
     	FP52M	EQU		P5M.2
     	FP51M	EQU		P5M.1
     	FP50M	EQU		P5M.0	

	INTRQ		EQU		0C8H
		FTC1IRQ	EQU		INTRQ.6
        FT0IRQ  EQU 	INTRQ.4
		FP01IRQ	EQU		INTRQ.1
		FP00IRQ	EQU		INTRQ.0

	INTEN		EQU		0C9H
		FTC1IEN	EQU		INTEN.6
        FT0IEN  EQU 	INTEN.4
		FP01IEN	EQU		INTEN.1
		FP00IEN	EQU		INTEN.0

	OSCM		EQU		0CAH
		FCPUM1	EQU		OSCM.4
		FCPUM0	EQU		OSCM.3
		FCLKMD	EQU		OSCM.2
		FSTPHX	EQU		OSCM.1

	WDTR		EQU_W	0CCH

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU 	0D0H
		FP02	EQU 	P0.2
		FP01	EQU 	P0.1
		FP00	EQU 	P0.0

	P1			EQU		0D1H
		FP17	EQU		P1.7
		FP16	EQU		P1.6
		FP15	EQU		P1.5
		FP14	EQU		P1.4
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0

	P2			EQU		0D2H
		FP27	EQU		P2.7
		FP26	EQU		P2.6
		FP25	EQU		P2.5
		FP24	EQU		P2.4
		FP23	EQU		P2.3
		FP22	EQU		P2.2
		FP21	EQU		P2.1
		FP20	EQU		P2.0

	P5			EQU		0D5H
		FP54	EQU		P5.4
		FP53	EQU		P5.3
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0

	T0M			EQU		0D8H
		FT0ENB	 EQU   	T0M.7
		FT0RATE2 EQU   	T0M.6
		FT0RATE1 EQU   	T0M.5
		FT0RATE0 EQU   	T0M.4

   	T0C        	 EQU     0D9H
               

	TC1M		EQU		0DCH
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
		FTC1CKS		EQU	TC1M.3
       	FALOAD1    	EQU	TC1M.2
       	FTC1OUT    	EQU	TC1M.1
       	FPWM1OUT   	EQU	TC1M.0 

	TC1C		EQU		0DDH

	TC1R		EQU_W	0DEH

	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

    P0UR        EQU_W   0E0H
	    FP01R   EQU_W   P0UR.1
	    FP00R   EQU_W   P0UR.0

    P1UR        EQU_W   0E1H
	    FP17R   EQU_W   P1UR.7
	    FP16R   EQU_W   P1UR.6
	    FP15R   EQU_W   P1UR.5
	    FP14R   EQU_W   P1UR.4
	    FP13R   EQU_W   P1UR.3
	    FP12R   EQU_W   P1UR.2
	    FP11R   EQU_W   P1UR.1
	    FP10R   EQU_W   P1UR.0

    P2UR        EQU_W   0E2H
	    FP27R   EQU_W   P2UR.7
	    FP26R   EQU_W   P2UR.6
	    FP25R   EQU_W   P2UR.5
	    FP24R   EQU_W   P2UR.4
	    FP23R   EQU_W   P2UR.3
	    FP22R   EQU_W   P2UR.2
	    FP21R   EQU_W   P2UR.1
	    FP20R   EQU_W   P2UR.0

    P5UR        EQU_W   0E5H
	    FP54R   EQU_W   P5UR.4
	    FP53R   EQU_W   P5UR.3
	    FP52R   EQU_W   P5UR.2
	    FP51R   EQU_W   P5UR.1
	    FP50R   EQU_W   P5UR.0

	@HL			EQU		0E6H
	@YZ			EQU		0E7H

    P1OC        EQU_W   0E9H
	    FP11OC  EQU_W   P1OC.1
	    FP10OC  EQU_W   P1OC.0


	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------	
.TEXT
{
	//{{SONIX_OPTION_RULE
	IF Noise_Filter == Enable
	{
			OPTION    2 	Fcpu		X X Fosc/4 Fosc/8
	}
	
	IF Noise_Filter == Disable
	{
			OPTION    2 	Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8
  	}

	ENDP
	//}}SONIX_OPTION_RULE
}
