
;------------------------------------------------------------------------------
;  CHIP: SN8P2608
;  Revision History:
;  V1.0  06/08/2004  First issue:
;
;  		             1. Align the timing of built-in macro between ICE and real chip
;                    2. Force users to define ICE_MODE before compiler, in ICE_MODE = 1
;                       the user's ROM size is 6K+512 words
;  		             3. SMOV table:
;                       a. Disable P4.7 on initial stage
;                          "FF FF FF 00 FF FF 00 00"
;                       b. Enable P4.7 if Reset_Pin = P47
;                          Add "1000 D4 80 00"
;
;  V2.0  06/14/2004: 1. Modify code option. Bit 4 fixed low, bit 7 fixed high.
;                    2. Change T0C from EQU to EQU_RMW
;
;  V20   07/06/2004  1. For S8KE ICE, INC version start from V20
;                       S8KE can emulate all function of SN8P2608
;                       So SMOV table isn't necessary.
;                    2. It's no necessary to define ICE_MODE = 0 or 1
;                    3. Keep following Macro definition for backword compatibility.
;                       @RST_WDT, @P0x_MODE, @P0x_OUT
;                    4. Remove following S8KD-2 emulation register definition:
;                       S8KDP6M(0C6H), FS8KDWTCKS(OSCM.7), FS8KDWDRST(OSCM.6,
;                       FWDRATE(OSCM.5), S8KDP6(0D6H)
;                    5. Define instructions by SN8P2608.BOL,                       
;                       But ORG8_Limit can't be defined by BOL table, so keep it.
;                    6. Add EQU_RMW register access attribute
;                       EQU_RMW: this register is R/W, but can't be accessed by
;                       Read then modify write instruction, e.g. ADD M, A
;                    7. Change T0C from EQU to EQU_RMW
;
;  V21   09/09/2004  1. Use Enable_ORG4_7 command to release ROM address 4~7
;
;  V22   04/01/2005  1. Remove Low_Power code option.
;                    2. Fcpu = Fosc/1~Fosc/8 even Noise_Filter enable.
;
;  V23   12/12/2005  1. Remove 32K_X'Tal mode code option. 
;                    2. Limit Fcpu 1T, 2T rate when Noise_Filter enable.
;  V24   12/17/2007  1. "GreenMode","SleepMode","SlowMode","Slow2Normal" macro programs. 
;  V25   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;  V26   06/29/2010  1. modify MACRO text "SLowMode" to "SlowMode"
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		26
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	128

.Assembly	INSTRUMENT	SN8P2608
.Assembly	BIT_FILE	SN8P2608


.Assembly	OTP_BODY_SIZE	0x1800
.Assembly	USER_ROM_SIZE	0x17FC


;.Assembly	OTP_TEST_SIZE	0x00E0
;.Assembly	MASK_TEST_FILE
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	
.Assembly	PGM_TYPE	6
.Assembly	CHIP_ID		0x3700
.Assembly	COMMAND		ORG8_LIMIT, Enable_ORG4_7, PCL_LIMIT, GREEN_NOP_LIMIT
.Assembly	Port_Pins	8,8,8,0,8,8

; Code Option 0x3FF
.Assembly	OPTION_Hide	0		Noise_Filter0	Disable Enable	
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
; Option 4: 32K CE time: 0=160ns, 1=320ns
.Assembly	OPTION		4		Fix_Low  
.Assembly	OPTION		5		High_Clk	RC	x	12M_X'tal	4M_X'tal
.Help
{	
	RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	12M_X'tal	:	"Crystal/Resonator: 10Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~10Mhz"
}

; Option 7: Stop low RC in 32K mode: 0=RUN, 1=STOP, if watchdog enable this option is no effect
.Assembly	OPTION		7		Fix_High
.Assembly	OPTION		8		Watch_Dog 	Always_On x x x x Enable x x x x Disable x x x x x 
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen and Sleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
} 
.Assembly	OPTION		12		Reset_Pin 	P47	Reset
;.Assembly	OPTION		13		RST_DeBnc	No 128_ILOSC
.Assembly	OPTION		13		Fix_High
;.Assembly	OPTION		14		Low_Power	Enable Disable
.Assembly	OPTION		14		Fix_High   
.Assembly	OPTION_Hide	15		ROM_Chk0	Disable Enable 

; Code Option 0x3FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x3FD
.Assembly	OPTION		32 : 63	Fix_High

.Assembly	OPTION_VIRTUAL			Noise_Filter	Enable		Disable

.Assembly	OPTION		2ffh

	L			EQU		0x80
	H			EQU		0x81
	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
	PFLAG		EQU		0x86
		FZ	EQU		PFLAG.0
		FDC	EQU		PFLAG.1
		FC	EQU		PFLAG.2
		FNPD	EQU		PFLAG.6
		FNT0	EQU		PFLAG.7

	P0M			EQU		0B8H
		FP07M	EQU		P0M.7
		FP06M	EQU		P0M.6
		FP05M	EQU		P0M.5
		FP04M	EQU		P0M.4
		FP03M	EQU		P0M.3
		FP02M	EQU		P0M.2
		FP01M	EQU		P0M.1
		FP00M	EQU		P0M.0


	PEDGE		EQU		0BFH
;		.W_LIMIT        0x80,0x00	;Force bit 7 = high 	
		FP00G1	EQU		PEDGE.4
		FP00G0	EQU		PEDGE.3

	P1W			EQU_W	0C0H
		FP17W	EQU_W	P1W.7
		FP16W	EQU_W	P1W.6
		FP15W	EQU_W	P1W.5
		FP14W	EQU_W	P1W.4
		FP13W	EQU_W	P1W.3
		FP12W	EQU_W	P1W.2
		FP11W	EQU_W	P1W.1
		FP10W	EQU_W	P1W.0

	P1M			EQU		0C1H
		FP17M	EQU		P1M.7
		FP16M	EQU		P1M.6
		FP15M	EQU		P1M.5
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0

	P2M			EQU		0C2H
		FP27M	EQU		P2M.7
		FP26M	EQU		P2M.6
		FP25M	EQU		P2M.5
		FP24M	EQU		P2M.4
		FP23M	EQU		P2M.3
		FP22M	EQU		P2M.2
		FP21M	EQU		P2M.1
		FP20M	EQU		P2M.0

	P4M			EQU		0C4H
;		FP47M	EQU		P4M.7
		FP46M	EQU		P4M.6
		FP45M	EQU		P4M.5
		FP44M	EQU		P4M.4
		FP43M	EQU		P4M.3
		FP42M	EQU		P4M.2
		FP41M	EQU		P4M.1
		FP40M	EQU		P4M.0

	P5M			EQU		0C5H
     	FP57M	EQU		P5M.7
     	FP56M	EQU		P5M.6
     	FP55M	EQU		P5M.5
     	FP54M	EQU		P5M.4
     	FP53M	EQU		P5M.3
     	FP52M	EQU		P5M.2
     	FP51M	EQU		P5M.1
     	FP50M	EQU		P5M.0

	INTRQ		EQU		0C8H
		FTC1IRQ	EQU		INTRQ.6
        FT0IRQ  EQU 	INTRQ.4
		FP01IRQ	EQU		INTRQ.1
		FP00IRQ	EQU		INTRQ.0

	INTEN		EQU		0C9H
		FTC1IEN	EQU		INTEN.6
        FT0IEN  EQU 	INTEN.4
		FP01IEN	EQU		INTEN.1
		FP00IEN	EQU		INTEN.0

	OSCM		EQU		0CAH
		
		FCPUM1	EQU		OSCM.4
		FCPUM0	EQU		OSCM.3
		FCLKMD	EQU		OSCM.2
		FSTPHX	EQU		OSCM.1

	WDTR		EQU_W	0CCH

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU 	0D0H
		FP07	EQU 	P0.7
		FP06	EQU 	P0.6
		FP05	EQU 	P0.5
		FP04	EQU 	P0.4
		FP03	EQU 	P0.3
		FP02	EQU 	P0.2
		FP01	EQU 	P0.1
		FP00	EQU 	P0.0

	P1			EQU		0D1H
		FP17	EQU		P1.7
		FP16	EQU		P1.6
		FP15	EQU		P1.5
		FP14	EQU		P1.4
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0

	P2			EQU		0D2H
		FP27	EQU		P2.7
		FP26	EQU		P2.6
		FP25	EQU		P2.5
		FP24	EQU		P2.4
		FP23	EQU		P2.3
		FP22	EQU		P2.2
		FP21	EQU		P2.1
		FP20	EQU		P2.0

	P4			EQU		0D4H
		FP47	EQU_R 	P4.7
		FP46	EQU		P4.6
		FP45	EQU		P4.5
		FP44	EQU		P4.4
		FP43	EQU		P4.3
		FP42	EQU		P4.2
		FP41	EQU		P4.1
		FP40	EQU		P4.0

	P5			EQU		0D5H
		FP57	EQU		P5.7
		FP56	EQU		P5.6
		FP55	EQU		P5.5
		FP54	EQU		P5.4
		FP53	EQU		P5.3
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0

	T0M			EQU		0D8H
		FT0ENB	 EQU		T0M.7
		FT0RATE2 EQU		T0M.6
		FT0RATE1 EQU		T0M.5
		FT0RATE0 EQU		T0M.4

    T0C         EQU_RMW     0D9H
               

	TC1M		EQU		0DCH
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
		FTC1CKS		EQU	TC1M.3
        FALOAD1     EQU TC1M.2
        FTC1OUT     EQU TC1M.1
        FPWM1OUT    EQU TC1M.0 

	TC1C		EQU		0DDH

	TC1R		EQU_W		0DEH

	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

    P0UR        EQU_W   0E0H
	    FP07R   EQU_W   P0UR.7
	    FP06R   EQU_W   P0UR.6
	    FP05R   EQU_W   P0UR.5
	    FP04R   EQU_W   P0UR.4
	    FP03R   EQU_W   P0UR.3
	    FP02R   EQU_W   P0UR.2
	    FP01R   EQU_W   P0UR.1
	    FP00R   EQU_W   P0UR.0

    P1UR        EQU_W   0E1H
	    FP17R   EQU_W   P1UR.7
	    FP16R   EQU_W   P1UR.6
	    FP15R   EQU_W   P1UR.5
	    FP14R   EQU_W   P1UR.4
	    FP13R   EQU_W   P1UR.3
	    FP12R   EQU_W   P1UR.2
	    FP11R   EQU_W   P1UR.1
	    FP10R   EQU_W   P1UR.0

    P2UR        EQU_W   0E2H
	    FP27R   EQU_W   P2UR.7
	    FP26R   EQU_W   P2UR.6
	    FP25R   EQU_W   P2UR.5
	    FP24R   EQU_W   P2UR.4
	    FP23R   EQU_W   P2UR.3
	    FP22R   EQU_W   P2UR.2
	    FP21R   EQU_W   P2UR.1
	    FP20R   EQU_W   P2UR.0

    P4UR        EQU_W   0E4H
	    FP47R   EQU_W   P4UR.7
	    FP46R   EQU_W   P4UR.6
	    FP45R   EQU_W   P4UR.5
	    FP44R   EQU_W   P4UR.4
	    FP43R   EQU_W   P4UR.3
	    FP42R   EQU_W   P4UR.2
	    FP41R   EQU_W   P4UR.1
	    FP40R   EQU_W   P4UR.0

    P5UR        EQU_W   0E5H
	    FP57R   EQU_W   P5UR.7
	    FP56R   EQU_W   P5UR.6
	    FP55R   EQU_W   P5UR.5
	    FP54R   EQU_W   P5UR.4
	    FP53R   EQU_W   P5UR.3
	    FP52R   EQU_W   P5UR.2
	    FP51R   EQU_W   P5UR.1
	    FP50R   EQU_W   P5UR.0

	@HL			EQU		0E6H
	@YZ			EQU		0E7H

    P1OC        EQU_W   0E9H
	    FP11OC  EQU_W   P1OC.1
	    FP10OC  EQU_W   P1OC.0


	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh


; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------
; In S8KD-2 ICE P0 is input only, but SN8P2608 P0.0, P0.1 are I/O pins
; Connect the P6.0 and P0.0 to emulate P0.0 output pin
; Connect the P6.1 and P0.1 to emulate P0.1 output pin
; Use @P00_Mode macro to set P0.0 output mode
;     @P00_Mode 0, Set P0.0 as input pin
;     @P00_Mode 1, Set P0.0 as output pin
;
; Use @P00_Out to set P0.0 output high or low
;     @P00_Out 0, Set P0.0 output low
;     @P00_Out 1, Set P0.0 output high

; Use @P01_Mode macro to set P0.1 output mode
;     @P01_Mode 0, Set P0.1 as input pin
;     @P01_Mode 1, Set P0.1 as output pin
;
; Use @P01_Out to set P0.1 output high or low
;     @P01_Out 0, Set P0.1 output low
;     @P01_Out 1, Set P0.1 output high
;
; P0X_Mode and P0X_Out Total Cycle: 1
; -----------------------------------------------------

	@P00_MODE	macro	val	; val = 0 input mode
					; val = 1 output mode
			
		IFNDEF  val
			ECHO	Error: @P00_MODE macro need one parameter
			ECHO	Syntax: @P00_MODE  Mode
			ECHO	Example:
			ECHO	@P00_MODE 0  Configure P0.0 as input mode
			ECHO	@P00_MODE 1  Configure P0.0 as output mode			
			ERROR
			ECHO
		ENDIF

		IF val == 0		; val = 0 input mode						
			   B0BCLR FP00M			
		ELSEIF val == 1		; val = 1 output mode
			   B0BSET FP00M			
		ELSE
			ECHO	Error: val is invalid parameter of @P00_MODE macro
			ECHO	Syntax: @P00_MODE  Mode
			ECHO	Example:
			ECHO	@P00_MODE 0  Configure P0.0 as input mode
			ECHO	@P00_MODE 1  Configure P0.0 as output mode			
			ERROR
			ECHO				
		ENDIF		
	endm

;------------------------------------------------------------------------------	
	@P00_OUT	macro	val	; val = 0 output low
					; val = 1 output high
		IFNDEF  val
			ECHO	Error: @P00_OUT macro need one parameter
			ECHO	Syntax: @P00_OUT  Level			
			ECHO	Example:
			ECHO	@P00_OUT 0  P0.0 output high
			ECHO	@P00_OUT 1  P0.0 output low
			ERROR
			ECHO
		ENDIF
					
		IF val == 0		; val = 0 P0.0 output low
		
			   B0BCLR FP00		
		ELSEIF val == 1		; val = 1 P0.0 output high
			
			   B0BSET FP00			
		ELSE
			ECHO	Error: val is invalid parameter of @P00_OUT macro
			ECHO	Syntax: @P00_OUT    Level
			ECHO	Example:
			ECHO	@P00_OUT 0  P0.0 output high
			ECHO	@P00_OUT 1  P0.0 output low
			ERROR
			ECHO			
		ENDIF
	endm			

; -----------------------------------------------------------------------------	
	@P01_MODE	macro	val	; val = 0 input mode
					; val = 1 output mode		
		IFNDEF  val
			ECHO	Error: @P01_MODE macro need one parameter
			ECHO	Syntax: @P01_MODE  Mode
			ECHO	Example:
			ECHO	@P01_MODE 0  Configure P0.1 as input mode
			ECHO	@P01_MODE 1  Configure P0.1 as output mode			
			ERROR
			ECHO
		ENDIF

		IF val == 0		; val = 0 input mode	
					
			   B0BCLR FP01M			
			
		ELSEIF val == 1		; val = 1 output mode
			
			    B0BSET FP01M			
		ELSE
			ECHO	Error: val is invalid parameter of @P01_MODE macro
			ECHO	Syntax: @P01_MODE  Mode
			ECHO	Example:
			ECHO	@P01_MODE 0  Configure P0.1 as input mode
			ECHO	@P01_MODE 1  Configure P0.1 as output mode			
			ERROR
			ECHO				
		ENDIF
	endm
;------------------------------------------------------------------------------
	@P01_OUT	macro	val	; val = 0 output low
					; val = 1 output high
		IFNDEF  val
			ECHO	Error: @P01_OUT macro need one parameter
			ECHO	Syntax: @P01_OUT    Level
			ECHO	Example:
			ECHO	@P01_OUT 0  P0.1 output high
			ECHO	@P01_OUT 1  P0.1 output low
			ERROR
			ECHO
		ENDIF
					
		IF val == 0		; val = 0 output low
			
			   B0BCLR FP01			
		ELSEIF val == 1		; val = 1 output high
			
			   B0BSET FP01			
		ELSE
			ECHO	Error: val is invalid parameter of @P01_OUT macro
			ECHO	Syntax: @P01_OUT    Level
			ECHO	Example:
			ECHO	@P01_OUT 0  P0.1 output high
			ECHO	@P01_OUT 1  P0.1 output low
			ERROR
			ECHO			
		ENDIF
	endm			

; -----------------------------------------------------------------------------	
	@P02_MODE	macro	val	; val = 0 input mode
					; val = 1 output mode		
		IFNDEF  val
			ECHO	Error: @P02_MODE macro need one parameter
			ECHO	Syntax: @P02_MODE  Mode
			ECHO	Example:
			ECHO	@P02_MODE 0  Configure P0.2 as input mode
			ECHO	@P02_MODE 1  Configure P0.2 as output mode			
			ERROR
			ECHO
		ENDIF

		IF val == 0		; val = 0 input mode						
			   B0BCLR FP02M			
			
		ELSEIF val == 1		; val = 1 output mode
			
			    B0BSET FP02M			
		ELSE
			ECHO	Error: val is invalid parameter of @P02_MODE macro
			ECHO	Syntax: @P02_MODE  Mode
			ECHO	Example:
			ECHO	@P02_MODE 0  Configure P0.2 as input mode
			ECHO	@P02_MODE 1  Configure P0.2 as output mode			
			ERROR
			ECHO				
		ENDIF
	endm
;------------------------------------------------------------------------------
	@P02_OUT	macro	val	; val = 0 output low
					; val = 1 output high
		IFNDEF  val
			ECHO	Error: @P02_OUT macro need one parameter
			ECHO	Syntax: @P02_OUT    Level
			ECHO	Example:
			ECHO	@P02_OUT 0  P0.2 output high
			ECHO	@P02_OUT 1  P0.2 output low
			ERROR
			ECHO
		ENDIF
					
		IF val == 0		; val = 0 output low
			
			   B0BCLR FP02			
		ELSEIF val == 1		; val = 1 output high
			
			   B0BSET FP02			
		ELSE
			ECHO	Error: val is invalid parameter of @P02_OUT macro
			ECHO	Syntax: @P02_OUT    Level
			ECHO	Example:
			ECHO	@P02_OUT 0  P0.2 output high
			ECHO	@P02_OUT 1  P0.2 output low
			ERROR
			ECHO			
		ENDIF
	endm			
	
; -----------------------------------------------------------------------------	
	@P03_MODE	macro	val	; val = 0 input mode
					; val = 1 output mode		
		IFNDEF  val
			ECHO	Error: @P03_MODE macro need one parameter
			ECHO	Syntax: @P03_MODE  Mode
			ECHO	Example:
			ECHO	@P03_MODE 0  Configure P0.3 as input mode
			ECHO	@P03_MODE 1  Configure P0.3 as output mode			
			ERROR
			ECHO
		ENDIF

		IF val == 0		; val = 0 input mode	
					
			   B0BCLR FP03M			
		ELSEIF val == 1		; val = 1 output mode
			
			    B0BSET FP03M			
		ELSE
			ECHO	Error: val is invalid parameter of @P03_MODE macro
			ECHO	Syntax: @P03_MODE  Mode
			ECHO	Example:
			ECHO	@P03_MODE 0  Configure P0.3 as input mode
			ECHO	@P03_MODE 1  Configure P0.3 as output mode			
			ERROR
			ECHO				
		ENDIF
	endm
;------------------------------------------------------------------------------
	@P03_OUT	macro	val	; val = 0 output low
					; val = 1 output high
		IFNDEF  val
			ECHO	Error: @P03_OUT macro need one parameter
			ECHO	Syntax: @P03_OUT    Level
			ECHO	Example:
			ECHO	@P03_OUT 0  P0.3 output high
			ECHO	@P03_OUT 1  P0.3 output low
			ERROR
			ECHO
		ENDIF
					
		IF val == 0		; val = 0 output low
			
			   B0BCLR FP03			
		ELSEIF val == 1		; val = 1 output high

			   B0BSET FP03
		ELSE
			ECHO	Error: val is invalid parameter of @P03_OUT macro
			ECHO	Syntax: @P03_OUT    Level
			ECHO	Example:
			ECHO	@P03_OUT 0  P0.3 output high
			ECHO	@P03_OUT 1  P0.3 output low
			ERROR
			ECHO			
		ENDIF
	endm			
	
; -----------------------------------------------------------------------------	
	@P04_MODE	macro	val	; val = 0 input mode
					; val = 1 output mode		
		IFNDEF  val
			ECHO	Error: @P04_MODE macro need one parameter
			ECHO	Syntax: @P04_MODE  Mode
			ECHO	Example:
			ECHO	@P04_MODE 0  Configure P0.4 as input mode
			ECHO	@P04_MODE 1  Configure P0.4 as output mode			
			ERROR
			ECHO
		ENDIF

		IF val == 0		; val = 0 input mode			
			
			   B0BCLR FP04M			
			
		ELSEIF val == 1		; val = 1 output mode
			
			    B0BSET FP04M			
		ELSE
			ECHO	Error: val is invalid parameter of @P04_MODE macro
			ECHO	Syntax: @P04_MODE  Mode
			ECHO	Example:
			ECHO	@P04_MODE 0  Configure P0.4 as input mode
			ECHO	@P04_MODE 1  Configure P0.4 as output mode			
			ERROR
			ECHO				
		ENDIF
	endm
;------------------------------------------------------------------------------
	@P04_OUT	macro	val	; val = 0 output low
					; val = 1 output high
		IFNDEF  val
			ECHO	Error: @P04_OUT macro need one parameter
			ECHO	Syntax: @P04_OUT    Level
			ECHO	Example:
			ECHO	@P04_OUT 0  P0.4 output high
			ECHO	@P04_OUT 1  P0.4 output low
			ERROR
			ECHO
		ENDIF
					
		IF val == 0		; val = 0 output low
			
			   B0BCLR FP04
			
		ELSEIF val == 1		; val = 1 output high
			
			   B0BSET FP04			
		ELSE
			ECHO	Error: val is invalid parameter of @P04_OUT macro
			ECHO	Syntax: @P04_OUT    Level
			ECHO	Example:
			ECHO	@P04_OUT 0  P0.4 output high
			ECHO	@P04_OUT 1  P0.4 output low
			ERROR
			ECHO			
		ENDIF
	endm			
	
; -----------------------------------------------------------------------------	
	@P05_MODE	macro	val	; val = 0 input mode
					; val = 1 output mode		
		IFNDEF  val
			ECHO	Error: @P05_MODE macro need one parameter
			ECHO	Syntax: @P05_MODE  Mode
			ECHO	Example:
			ECHO	@P05_MODE 0  Configure P0.5 as input mode
			ECHO	@P05_MODE 1  Configure P0.5 as output mode			
			ERROR
			ECHO
		ENDIF

		IF val == 0		; val = 0 input mode		
			
			   B0BCLR FP05M			
			
		ELSEIF val == 1		; val = 1 output mode
			
			    B0BSET FP05M			
		ELSE
			ECHO	Error: val is invalid parameter of @P05_MODE macro
			ECHO	Syntax: @P05_MODE  Mode
			ECHO	Example:
			ECHO	@P05_MODE 0  Configure P0.5 as input mode
			ECHO	@P05_MODE 1  Configure P0.5 as output mode			
			ERROR
			ECHO				
		ENDIF
	endm
;------------------------------------------------------------------------------
	@P05_OUT	macro	val	; val = 0 output low
					; val = 1 output high
		IFNDEF  val
			ECHO	Error: @P05_OUT macro need one parameter
			ECHO	Syntax: @P05_OUT    Level
			ECHO	Example:
			ECHO	@P05_OUT 0  P0.5 output high
			ECHO	@P05_OUT 1  P0.5 output low
			ERROR
			ECHO
		ENDIF
					
		IF val == 0		; val = 0 output low
			
			   B0BCLR FP05			
		ELSEIF val == 1		; val = 1 output high
			
			   B0BSET FP05			
		ELSE
			ECHO	Error: val is invalid parameter of @P05_OUT macro
			ECHO	Syntax: @P05_OUT    Level
			ECHO	Example:
			ECHO	@P05_OUT 0  P0.5 output high
			ECHO	@P05_OUT 1  P0.5 output low
			ERROR
			ECHO			
		ENDIF
	endm			
	
; -----------------------------------------------------------------------------	
	@P06_MODE	macro	val	; val = 0 input mode
					; val = 1 output mode		
		IFNDEF  val
			ECHO	Error: @P06_MODE macro need one parameter
			ECHO	Syntax: @P06_MODE  Mode
			ECHO	Example:
			ECHO	@P06_MODE 0  Configure P0.6 as input mode
			ECHO	@P06_MODE 1  Configure P0.6 as output mode			
			ERROR
			ECHO
		ENDIF

		IF val == 0		; val = 0 input mode	
				
			   B0BCLR FP06M		
			
		ELSEIF val == 1		; val = 1 output mode			
			   B0BSET FP06M			
		ELSE
			ECHO	Error: val is invalid parameter of @P06_MODE macro
			ECHO	Syntax: @P06_MODE  Mode
			ECHO	Example:
			ECHO	@P06_MODE 0  Configure P0.6 as input mode
			ECHO	@P06_MODE 1  Configure P0.6 as output mode			
			ERROR
			ECHO				
		ENDIF
	endm
;------------------------------------------------------------------------------
	@P06_OUT	macro	val	; val = 0 output low
					; val = 1 output high
		IFNDEF  val
			ECHO	Error: @P06_OUT macro need one parameter
			ECHO	Syntax: @P06_OUT    Level
			ECHO	Example:
			ECHO	@P06_OUT 0  P0.6 output high
			ECHO	@P06_OUT 1  P0.6 output low
			ERROR
			ECHO
		ENDIF
					
		IF val == 0		; val = 0 output low
			
			   B0BCLR FP06			
		ELSEIF val == 1		; val = 1 output high
			
			   B0BSET FP06			
		ELSE
			ECHO	Error: val is invalid parameter of @P06_OUT macro
			ECHO	Syntax: @P06_OUT    Level
			ECHO	Example:
			ECHO	@P06_OUT 0  P0.6 output high
			ECHO	@P06_OUT 1  P0.6 output low
			ERROR
			ECHO			
		ENDIF
	endm			
	
; -----------------------------------------------------------------------------	
	@P07_MODE	macro	val	; val = 0 input mode
					; val = 1 output mode		
		IFNDEF  val
			ECHO	Error: @P07_MODE macro need one parameter
			ECHO	Syntax: @P07_MODE  Mode
			ECHO	Example:
			ECHO	@P07_MODE 0  Configure P0.7 as input mode
			ECHO	@P07_MODE 1  Configure P0.7 as output mode			
			ERROR
			ECHO
		ENDIF

		IF val == 0		; val = 0 input mode	
		
			
			   B0BCLR FP07M			
			
		ELSEIF val == 1		; val = 1 output mode
			
			    B0BSET FP07M			
		ELSE
			ECHO	Error: val is invalid parameter of @P07_MODE macro
			ECHO	Syntax: @P07_MODE  Mode
			ECHO	Example:
			ECHO	@P07_MODE 0  Configure P0.7 as input mode
			ECHO	@P07_MODE 1  Configure P0.7 as output mode			
			ERROR
			ECHO				
		ENDIF
	endm
;------------------------------------------------------------------------------
	@P07_OUT	macro	val	; val = 0 output low
					; val = 1 output high
		IFNDEF  val
			ECHO	Error: @P07_OUT macro need one parameter
			ECHO	Syntax: @P07_OUT    Level
			ECHO	Example:
			ECHO	@P07_OUT 0  P0.7 output high
			ECHO	@P07_OUT 1  P0.7 output low
			ERROR
			ECHO
		ENDIF
					
		IF val == 0		; val = 0 output low
			
			   B0BCLR FP07
			
		ELSEIF val == 1		; val = 1 output high
			
			   B0BSET FP07			
		ELSE
			ECHO	Error: val is invalid parameter of @P07_OUT macro
			ECHO	Syntax: @P07_OUT    Level
			ECHO	Example:
			ECHO	@P07_OUT 0  P0.7 output high
			ECHO	@P07_OUT 1  P0.7 output low
			ERROR
			ECHO			
		ENDIF
	endm			
	

; -----------------------------------------------------	

.TEXT
{	
	//{{SONIX_OPTION_RULE

	IF Noise_Filter == Enable
	{
			Noise_Filter0 = Enable		
			ROM_Chk0 = Enable		
		OPTION		2		Fcpu		x x Fosc/4 Fosc/8
	}
	
	IF Noise_Filter == Disable
	{
		Noise_Filter0 = Disable
		ROM_Chk0 = Disable
		OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8
  	}
	ENDP
	//}}SONIX_OPTION_RULE
}
