;------------------------------------------------------------------------------
;  CHIP: SN8P2735
;  Revision History
;  
;  V01   12/19/2008  1. First issue and only for SN8ICE 2K. 
;  V02   03/25/2009  1. Modify IHRC_8M to IHRC_16M.
; 		     2. Modify Fcpu code option.
;  V03   05/18/2009  1. Modify Fcpu code option as enabling Noise_Filter.
;  V04   06/29/2010  1. modify MACRO text "SLowMode" to "SlowMode"
;		     2. Add "RedWrt_FORMAT    1"
;------------------------------------------------------------------------------
.ASSEMBLY	RedWrt_FORMAT	1
.Assembly	INC_VER		4
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	256

.Assembly	INSTRUMENT	SN8P2735
.Assembly	BIT_FILE	SN8P2735

.Assembly	OTP_BODY_SIZE	0x1800 
.Assembly	USER_ROM_SIZE	0x17FC

.Assembly	OTP_TEST_SIZE	0x00E0
;.Assembly	MASK_TEST_FILE
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	
.Assembly	PGM_TYPE	13
.Assembly	CHIP_ID		0x6540		
.Assembly	COMMAND		Enable_ORG4_7 
.Assembly	Port_Pins	6,8,0,0,8,8

; Code Option 0x17FF
.Assembly	OPTION		0		Noise_Filter	Disable Enable	
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 x x x Fosc/16
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		5		High_Clk	IHRC_16M IHRC_RTC x x Ext_RC 32K_X'tal 12M_X'tal 4M_X'tal
.Help
{	
	IHRC_16M	:	"Internal 16 RC Oscillator"
	IHRC_RTC	:	"Internal 16M RC Oscillator with RTC.\n" \
	                "Connect 32.768K crystal to Xin/Xout"

	Ext_RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	32K_X'tal	:	"32.768K Crystal"
	12M_X'tal	:	"Crystal/Resonator: 10Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~10Mhz"
}

.Assembly	OPTION		8		Watch_Dog 	Always_On x x x x Enable x x x x Disable x x x x x 
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen and Sleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
} 
.Assembly	OPTION		12		Reset_Pin 	P03	Reset
.Assembly	OPTION   	13		Fix_High
.Assembly	OPTION   	14		Fix_High
.Assembly	OPTION   	15		Fix_Low

; Code Option 0x17FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x17FD
.Assembly	OPTION		32 : 40		Fix_High
.Assembly	OPTION		41		LVDM     	LVD_Max	LVD_H LVD_M LVD_L
.Help
{
	LVD_L		:	"2.0V Reset"
	LVD_M		:	"2.0V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
	LVD_H		:	"2.4V Reset\nEnable LVD36 bit of PFLAG for\n3.6V Low Voltage Indicator"	
	LVD_Max		:	"3.6V Reset"	
}
.Assembly	OPTION		43		Fix_Low
.Assembly	OPTION		44 : 63		Fix_High

.Assembly	OPTION		2ffh

	L		EQU		0x80
	H		EQU		0x81
	R		EQU		0x82
	Z		EQU		0x83
	Y		EQU		0x84
	PFLAG		EQU		0x86
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FLVD24		EQU		PFLAG.4
		FLVD36		EQU		PFLAG.5
		FNPD		EQU		PFLAG.6
		FNT0		EQU		PFLAG.7

	RBANK		EQU		087H
		FRBNKS0	EQU		RBANK.0

	PW1NM		EQU		090H
		FPW1NEN		EQU		PW1NM.7
		FPW1D2		EQU		PW1NM.6
		FPW1D1		EQU		PW1NM.5
		FPW1D0		EQU		PW1NM.4
		FPW1DEN		EQU		PW1NM.3
		FPW1NV		EQU		PW1NM.2
	PW1M		EQU		093H
		FPW1EN		EQU		PW1M.7
		FPW1RATE2	EQU		PW1M.6
		FPW1RATE1	EQU		PW1M.5
		FPW1RATE0	EQU		PW1M.4
		FPW1CKS		EQU		PW1M.3
		FPW1LN1		EQU		PW1M.2
		FPW1LN0		EQU		PW1M.1
		FPW1S		EQU		PW1M.0

	PW2M		EQU		094H
		FPW2EN		EQU		PW2M.7
		FPW2RATE2	EQU		PW2M.6
		FPW2RATE1	EQU		PW2M.5
		FPW2RATE0	EQU		PW2M.4
		FPW2CKS		EQU		PW2M.3
		FPW2LN1		EQU		PW2M.2
		FPW2LN0		EQU		PW2M.1

	PW2CHS		EQU		095H
		FPW2CH6		EQU		PW2CHS.5
		FPW2CH5		EQU		PW2CHS.4
		FPW2CH4		EQU		PW2CHS.3
		FPW2CH3		EQU		PW2CHS.2
		FPW2CH2		EQU		PW2CHS.1
		FPW2CH1		EQU		PW2CHS.0

	PW1RH		EQU		096H
		FPW1GS		EQU		PW1RH.7
		FPW1GEN		EQU		PW1RH.6
		FPW1GD		EQU		PW1RH.5
		FPW1R11		EQU		PW1RH.3
		FPW1R10		EQU		PW1RH.2
		FPW1R9		EQU		PW1RH.1
		FPW1R8		EQU		PW1RH.0
	PW1RL		EQU_W		097H

	PW2RH		EQU		098H
		FPW2R11		EQU		PW2RH.3
		FPW2R10		EQU		PW2RH.2
		FPW2R9		EQU		PW2RH.1
		FPW2R8		EQU		PW2RH.0
	PW2RL		EQU_W		099H

	CMP0M		EQU		09CH
		FCM0EN		EQU		CMP0M.7
		FCM0IEN		EQU		CMP0M.6
		FCM0IRQ		EQU		CMP0M.5
		FCM0OEN		EQU		CMP0M.4
		FCM0REF		EQU		CMP0M.3
		FCM0OUT		EQU_R	 	CMP0M.2
		FCM0G1		EQU		CMP0M.1
		FCM0G0		EQU		CMP0M.0
	CMP1M		EQU		09DH
		FCM1EN		EQU		CMP1M.7
		FCM1IEN		EQU		CMP1M.6
		FCM1IRQ		EQU		CMP1M.5
		FCM1OEN		EQU		CMP1M.4
		FCM1REF		EQU		CMP1M.3
		FCM1OUT		EQU_R	 	CMP1M.2
		FCM1G1		EQU		CMP1M.1
		FCM1G0		EQU		CMP1M.0
	CMP2M		EQU		09EH
		FCM2EN		EQU		CMP2M.7
		FCM2IEN		EQU		CMP2M.6
		FCM2IRQ		EQU		CMP2M.5
		FCM2OEN		EQU		CMP2M.4
		FCM2REF		EQU		CMP2M.3
		FCM2OUT		EQU_R	 	CMP2M.2
		FCM2G1		EQU		CMP2M.1
		FCM2G0		EQU		CMP2M.0
	OPM		EQU		09FH
		FOP2EN		EQU		OPM.2
		FOP1EN		EQU		OPM.1
		FOP0EN		EQU		OPM.0
	
	T1M		EQU		0A0H
		FT1ENB		EQU		T1M.7
		FT1RATE2	EQU		T1M.6
		FT1RATE1	EQU		T1M.5
		FT1RATE0	EQU		T1M.4
		FCPTCKS		EQU		T1M.3
		FCPTStart	EQU		T1M.2
		FCPTG1		EQU		T1M.1
		FCPTG0		EQU		T1M.0
	T1CL		EQU		0A1H
	T1CH		EQU		0A2H

	P4CON		EQU_W		0AEH

	ADM		EQU		0xB1
		FADENB		EQU		ADM.7
		FADS		EQU		ADM.6
		FEOC		EQU		ADM.5
		FGCHS		EQU		ADM.4
		FAVREFH		EQU		ADM.3
		FCHS2		EQU		ADM.2
		FCHS1		EQU		ADM.1
		FCHS0		EQU		ADM.0
	ADB		EQU_R  		0B2H

	ADR		EQU		0B3H
		FADCKS1		EQU		ADR.6
		FADLEN		EQU		ADR.5
		FADCKS0		EQU		ADR.4
		FADB3		EQU_R	 	ADR.3
		FADB2		EQU_R	 	ADR.2
		FADB1		EQU_R 		ADR.1
		FADB0		EQU_R 		ADR.0		
	ADT		EQU		0B4H
		FADTS1		EQU		ADT.7
		FADTS0		EQU		ADT.6
		FADT4		EQU		ADT.4
		FADT3		EQU		ADT.3
		FADT2		EQU		ADT.2
		FADT1		EQU		ADT.1
		FADT0		EQU		ADT.0

	P0M		EQU		0B8H
		FP05M		EQU		P0M.5
		FP04M		EQU		P0M.4
		FP02M		EQU		P0M.2
		FP01M		EQU		P0M.1
		FP00M		EQU		P0M.0

	PEDGE		EQU		0BFH
		FP02G1		EQU		PEDGE.5
		FP02G0		EQU		PEDGE.4
		FP01G1		EQU		PEDGE.3
		FP01G0		EQU		PEDGE.2
		FP00G1		EQU		PEDGE.1
		FP00G0		EQU		PEDGE.0

	P1W		EQU_W  		0C0H

	P1M		EQU		0C1H
		FP17M		EQU		P1M.7
		FP16M		EQU		P1M.6
		FP15M		EQU		P1M.5
		FP14M		EQU		P1M.4
		FP13M		EQU		P1M.3
		FP12M		EQU		P1M.2
		FP11M		EQU		P1M.1
		FP10M		EQU		P1M.0
	P4M		EQU		0C4H
		FP47M		EQU		P4M.7
		FP46M		EQU		P4M.6
		FP45M		EQU		P4M.5
		FP44M		EQU		P4M.4
		FP43M		EQU		P4M.3
		FP42M		EQU		P4M.2
		FP41M		EQU		P4M.1
		FP40M		EQU		P4M.0
	P5M		EQU		0C5H
  	     	FP57M		EQU		P5M.7
   		FP56M		EQU		P5M.6
  	     	FP55M		EQU		P5M.5
   	    	FP54M		EQU		P5M.4
   		FP53M		EQU		P5M.3
  	     	FP52M		EQU		P5M.2
       		FP51M		EQU		P5M.1
       		FP50M		EQU		P5M.0	
	INTRQ		EQU		0C8H
		FADCIRQ		EQU		INTRQ.7
		FT1IRQ		EQU		INTRQ.6
		FTC0IRQ		EQU		INTRQ.5
  		FT0IRQ  	EQU	  	INTRQ.4
		FP02IRQ		EQU		INTRQ.2
		FP01IRQ		EQU		INTRQ.1
		FP00IRQ		EQU		INTRQ.0
	INTEN		EQU		0C9H
		FADCIEN		EQU		INTEN.7
		FT1IEN		EQU		INTEN.6
		FTC0IEN		EQU		INTEN.5
		FT0IEN		EQU 		INTEN.4
		FP02IEN		EQU		INTEN.2
		FP01IEN		EQU		INTEN.1
		FP00IEN		EQU		INTEN.0
	OSCM		EQU		0CAH
		FCPUM1		EQU		OSCM.4
		FCPUM0		EQU		OSCM.3
		FCLKMD		EQU		OSCM.2
		FSTPHX		EQU		OSCM.1
	WDTR		EQU_W		0CCH

	TC0R		EQU_W	  	0CDH

	PCL		EQU		0CEH
	PCH		EQU		0CFH

	P0		EQU  		0D0H
		FP05		EQU   		P0.5
		FP04		EQU  	 	P0.4
		FP03		EQU 		P0.3
		FP02		EQU  	 	P0.2
		FP01		EQU  	 	P0.1
		FP00		EQU  	 	P0.0

	P1		EQU		0D1H
		FP17		EQU		P1.7
		FP16		EQU		P1.6
		FP15		EQU		P1.5
		FP14		EQU		P1.4
		FP13		EQU		P1.3
		FP12		EQU		P1.2
		FP11		EQU		P1.1
		FP10		EQU		P1.0

	P4		EQU		0D4H
		FP47		EQU		P4.7
		FP46		EQU		P4.6
		FP45		EQU		P4.5
		FP44		EQU		P4.4
		FP43		EQU		P4.3
		FP42		EQU		P4.2
		FP41		EQU		P4.1
		FP40		EQU		P4.0

	P5		EQU		0D5H
		FP57		EQU		P5.7
		FP56		EQU		P5.6
		FP55		EQU		P5.5
		FP54		EQU		P5.4
		FP53		EQU		P5.3
		FP52		EQU		P5.2
		FP51		EQU		P5.1
		FP50		EQU		P5.0

	T0M		EQU		0D8H
		FT0ENB	 	EQU  	 	T0M.7
		FT0RATE2 	EQU  	  	T0M.6
		FT0RATE1 	EQU  	  	T0M.5
		FT0RATE0 	EQU  	  	T0M.4
		FT0TB	 	EQU  	  	T0M.0

   	T0C		EQU		0D9H

	TC0M  		EQU		0DAH
		FTC0ENB		EQU		TC0M.7
		FTC0RATE2	EQU		TC0M.6
		FTC0RATE1	EQU		TC0M.5
		FTC0RATE0	EQU		TC0M.4
		FTC0CKS		EQU		TC0M.3
   	 	FALOAD0    	EQU		TC0M.2
    		FTC0OUT    	EQU		TC0M.1
    		FPWM0OUT   	EQU		TC0M.0 

	TC0C		EQU		0DBH

	STKP		EQU		0DFH
		FGIE		EQU		STKP.7
		FSTKPB2		EQU		STKP.2
		FSTKPB1		EQU		STKP.1
		FSTKPB0		EQU		STKP.0

    	P0UR		EQU_W  		0E0H
    	P1UR		EQU_W  		0E1H
    	P4UR		EQU_W  		0E4H
    	P5UR		EQU_W  		0E5H

	@HL		EQU		0E6H
	@YZ		EQU		0E7H

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------
.TEXT
{
	//{{SONIX_OPTION_RULE
	IF Noise_Filter == Enable
	{
		IF High_Clk == IHRC_16M
		{
		OPTION		2		Fcpu		x x Fosc/4 Fosc/8 x x x Fosc/16  
		}
		ELSEIF High_Clk == IHRC_RTC
		{
		OPTION		2		Fcpu		x x Fosc/4 Fosc/8 x x x Fosc/16  
		}
		ELSEIF High_Clk == 32K_X'tal
		{
		OPTION		2		Fcpu		x x Fosc/4 Fosc/8 x x x Fosc/16  
		}
		ELSEIF High_Clk == 4M_X'tal
		{
		OPTION		2		Fcpu		x x Fosc/4 Fosc/8 x x x Fosc/16  
		}
		ELSEIF High_Clk == 12M_X'tal
		{
		OPTION		2		Fcpu		x x Fosc/4 Fosc/8 x x x Fosc/16  
		}
		ELSEIF High_Clk == Ext_RC
		{
		OPTION		2		Fcpu		x x Fosc/4 Fosc/8 x x x Fosc/16  
		}
		ELSE
		{
		OPTION		2		Fcpu		x x Fosc/4 Fosc/8 x x x Fosc/16  
		}
  	}
	ELSE	
	{
		IF High_Clk == IHRC_16M
		{
		OPTION		2		Fcpu		x Fosc/2 Fosc/4 Fosc/8 x x x Fosc/16  
		}
		ELSEIF High_Clk == IHRC_RTC
		{
		OPTION		2		Fcpu		x Fosc/2 Fosc/4 Fosc/8 x x x Fosc/16   
		}
		ELSEIF High_Clk == 32K_X'tal
		{
		OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 x x x Fosc/16   
		}
		ELSEIF High_Clk == 4M_X'tal
		{
		OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 x x x Fosc/16  
		}
		ELSEIF High_Clk == 12M_X'tal
		{
		OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 x x x Fosc/16  
		}
		ELSEIF High_Clk == Ext_RC
		{
		OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 x x x Fosc/16  
		}
		ELSE
		{
		OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 x x x Fosc/16  
		}
  	}
	ENDP
	//}}SONIX_OPTION_RULE
}
