
;------------------------------------------------------------------------------
;  CHIP: SN8P2929, OTP Only.
;------------------------------------------------------------------------------

.Assembly	INC_VER		1
.Assembly       RedWrt_FORMAT   1
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	100h

.Assembly	INSTRUMENT	SN8P2929
.Assembly	BIT_FILE	SN8P2929

.Assembly	OTP_BODY_SIZE	0x1000
.Assembly	USER_ROM_SIZE	0x0FFC

.Assembly	COMMAND		Enable_ORG4_7, Enable_ISP	; Limit org 4~7, unavailible for user
.Assembly	PGM_TYPE	6				; 2's Program Type			
.Assembly	MASK_TEST_CODE	0x0000, 0x000, 0x0000, 0x0000
.Assembly	Port_Pins	8, 0, 2, 0, 0, 5, 0
.Assembly	LCD_Size	20, 4
.Assembly	CHIP_ID		0x9800

; Code Option 0x0FFF
.Assembly	OPTION			0		Fix_Low	
.Assembly	OPTION			1		Security	Enable	Disable
.Assembly	OPTION			2		High_Clk_DIV	Fhosc/4 Fhosc/8	Fhosc/16 Fhosc/32 
.Assembly	OPTION			4		Fix_Low
.Assembly	OPTION		        5		High_Clk	IHRC	IHRC_RTC
.Assembly	OPTION			6		Fix_Low 
.Assembly	OPTION			7		Fix_Low			
.Assembly	OPTION			8		Watch_Dog	x x x x x Enable x x x x Disable x x x x Always_On 
.Assembly	OPTION			12 : 13		Fix_Low
.Assembly	OPTION			14 : 15		Fix_Low	

; Code Option 0x0FFE
.Assembly	OPTION			16		Fix_Low
.Assembly	OPTION			17		Fix_High
.Assembly	OPTION			18		Fix_Low
.Assembly	OPTION			19		Fix_High
.Assembly	OPTION			20		Fix_High
.Assembly	OPTION			21		Fix_Low
.Assembly	OPTION			22		Fix_High
.Assembly	OPTION			23		Fix_Low
.Assembly	OPTION			24		Fix_Low
.Assembly	OPTION			25		Fix_High
.Assembly	OPTION			26		Fix_Low
.Assembly	OPTION			27 : 31		Fix_High

; Code Option 0x0FFD
.Assembly	OPTION			32 : 40		Fix_High ;(IHRC_CAL_Data)
.Assembly	OPTION			41 : 47		Fix_High
;============================================================================
.Assembly	OPTION			48 : 63		Fix_High
.Assembly	OPTION			2ffh


	L			EQU		80H
	H			EQU		81H
	R			EQU		82H
	Z			EQU		83H
	Y			EQU		84H
	X			EQU		85H
	
	PFLAG			EQU		86H
		FC		EQU		PFLAG.2
		FDC		EQU		PFLAG.1
		FZ		EQU		PFLAG.0
		
	RBANK			EQU		87H
		FRBNKS3		EQU		RBANK.3
		FRBNKS2		EQU		RBANK.2
		FRBNKS1		EQU		RBANK.1
		FRBNKS0		EQU		RBANK.0

	LCDM1			EQU		89H
		FLCDREF1	EQU		LCDM1.7
		FLCDREF0	EQU		LCDM1.6
		FLCDBNK		EQU		LCDM1.5
		FLCDTYPE	EQU		LCDM1.4
		FLCDENB		EQU		LCDM1.3
		FLCDBIAS	EQU		LCDM1.2		
		FLCDRATE	EQU		LCDM1.1
		FLCDCLK		EQU		LCDM1.0	

	LCDM2			EQU		8AH
	

		FLCDPENB	EQU		LCDM2.5	
		FVPPINTL	EQU		LCDM2.4
		FVCP3		EQU		LCDM2.3	
		FVCP2		EQU		LCDM2.2		
		FVCP1		EQU		LCDM2.1
		FVCP0		EQU		LCDM2.0

	LCDM3			EQU		8BH
		FO_MODE		EQU		LCDM3.7			
		FBGCSET		EQU		LCDM3.6	
		FLCDPSEL1	EQU		LCDM3.5
		FLCDPSEL0	EQU		LCDM3.4
		FBGSEL2		EQU		LCDM3.3
		FBGSEL1		EQU		LCDM3.2
		FBGSEL0		EQU		LCDM3.1
		FBGM		EQU		LCDM3.0
						
	VREG			EQU		90H
		FBGRENB		EQU		VREG.7
		
		FACMENB		EQU		VREG.5
		FAVESEL		EQU		VREG.4
		FAVENB		EQU		VREG.3
		FAVDDRSEL	EQU		VREG.2
		FAVDDRENB	EQU		VREG.1

	AMPM1			EQU		91H
		FCHS3		EQU		AMPM1.7
		FCHS2		EQU		AMPM1.6
		FCHS1		EQU		AMPM1.5
		FCHS0		EQU		AMPM1.4
		FGS2		EQU		AMPM1.3
		FGS1		EQU		AMPM1.2
		FGS0		EQU		AMPM1.1
		FAMPENB		EQU		AMPM1.0

	AMPM2			EQU		92H
		FINRENB		EQU		AMPM2.7
		FGX		EQU		AMPM2.6
		FGR		EQU		AMPM2.5
		FAMPCKS1	EQU		AMPM2.4
		FAMPCKS0	EQU		AMPM2.3
		FPCHPENB	EQU		AMPM2.2		
		FDTENB		EQU		AMPM2.1
		FDTSEL		EQU		AMPM2.0
		
	ADCM1			EQU		93H
		FRVS		EQU		ADCM1.7
		FIRVS3		EQU		ADCM1.6
		FIRVS2		EQU		ADCM1.5
		FIRVS1		EQU		ADCM1.4
		FIRVS0		EQU		ADCM1.3
		FADGN1		EQU		ADCM1.2
		FADGN0		EQU		ADCM1.1
		FADCENB		EQU		ADCM1.0
				
	ADCM2			EQU		94H
		FOSR2		EQU		ADCM2.6
		FOSR1		EQU		ADCM2.5
		FOSR0		EQU		ADCM2.4
		FOFSEL1		EQU		ADCM2.2
		FOFSEL0		EQU		ADCM2.1
		FDRDY		EQU		ADCM2.0

	ADCM3			EQU		95H
		FACHPENB	EQU		ADCM3.4
		FADCKINV	EQU		ADCM3.3
		FADCKS2		EQU		ADCM3.2
		FADCKS1		EQU		ADCM3.1
		FADCKS0		EQU		ADCM3.0

	LBTM			EQU		96H
		FP51IO		EQU		LBTM.6
		FLBTSEL3	EQU		LBTM.5
		FLBTSEL2	EQU		LBTM.4
		FLBTSEL1	EQU		LBTM.3
		FLBTSEL0	EQU		LBTM.2
		FLBTO		EQU_R		LBTM.1
		FLBTENB		EQU		LBTM.0

	ADCDH			EQU_R		97H
	ADCDM			EQU_R		98H
	ADCDL			EQU_R		99H		
		
	LEDCPM			EQU		9AH
		FVLEDENB	EQU		LEDCPM.4
		FCPCKS2		EQU		LEDCPM.3
		FCPCKS1		EQU		LEDCPM.2
		FCPCKS0 	EQU		LEDCPM.1
		FCPRENB		EQU		LEDCPM.0
		
	ROMADRH			EQU		0A0H
		FVPPCHK		EQU_R		ROMADRH.7
		FROMADR11	EQU		ROMADRH.3
		FROMADR10	EQU		ROMADRH.2
		FROMADR9	EQU		ROMADRH.1
		FROMADR8	EQU		ROMADRH.0
			
	ROMADRL			EQU		0A1H	
		FROMADR7	EQU		ROMADRL.7
		FROMADR6	EQU		ROMADRL.6
		FROMADR5	EQU		ROMADRL.5
		FROMADR4	EQU		ROMADRL.4
		FROMADR3	EQU		ROMADRL.3
		FROMADR2	EQU		ROMADRL.2
		FROMADR1	EQU		ROMADRL.1
		FROMADR0	EQU		ROMADRL.0
	
	ROMDAH			EQU		0A2H
		FROMDA15	EQU		ROMDAH.7
		FROMDA14	EQU		ROMDAH.6
		FROMDA13	EQU		ROMDAH.5
		FROMDA12	EQU		ROMDAH.4
		FROMDA11	EQU		ROMDAH.3
		FROMDA10	EQU		ROMDAH.2
		FROMDA9		EQU		ROMDAH.1
		FROMDA8		EQU		ROMDAH.0
	
	ROMDAL			EQU		0A3H
		FROMDA7		EQU		ROMDAL.7
		FROMDA6		EQU		ROMDAL.6
		FROMDA5		EQU		ROMDAL.5
		FROMDA4		EQU		ROMDAL.4
		FROMDA3		EQU		ROMDAL.3
		FROMDA2		EQU		ROMDAL.2
		FROMDA1		EQU		ROMDAL.1
		FROMDA0		EQU		ROMDAL.0

	ROMCNT			EQU_W		0A4H
		FROMCNT1	EQU_W		ROMCNT.1
		FROMCNT0	EQU_W		ROMCNT.0
	
	T1M			EQU		0B0H
		FT1ENB		EQU		T1M.7
		FT1RATE2	EQU		T1M.6
		FT1RATE1	EQU		T1M.5
		FT1RATE0	EQU		T1M.4
		FALOAD1		EQU		T1M.3
		FCPTSTART	EQU		T1M.2
		FT1OV		EQU		T1M.1
		

	T1CL			EQU		0B1H
		FT1CL7		EQU		T1CL.7
		FT1CL6		EQU		T1CL.6
		FT1CL5		EQU		T1CL.5
		FT1CL4		EQU		T1CL.4
		FT1CL3		EQU		T1CL.3
		FT1CL2		EQU		T1CL.2
		FT1CL1		EQU		T1CL.1
		FT1CL0		EQU		T1CL.0

	T1CH			EQU		0B2H
		FT1CH7		EQU		T1CH.7
		FT1CH6		EQU		T1CH.6
		FT1CH5		EQU		T1CH.5
		FT1CH4		EQU		T1CH.4
		FT1CH3		EQU		T1CH.3
		FT1CH2		EQU		T1CH.2
		FT1CH1		EQU		T1CH.1
		FT1CH0		EQU		T1CH.0

	T1VCL			EQU		0B3H
		FT1VCL7		EQU		T1VCL.7
		FT1VCL6		EQU		T1VCL.6
		FT1VCL5		EQU		T1VCL.5
		FT1VCL4		EQU		T1VCL.4
		FT1VCL3		EQU		T1VCL.3
		FT1VCL2		EQU		T1VCL.2
		FT1VCL1		EQU		T1VCL.1
		FT1VCL0		EQU		T1VCL.0

	T1VCH			EQU		0B4H
		FT1VCH3		EQU		T1VCH.3
		FT1VCH2		EQU		T1VCH.2
		FT1VCH1		EQU		T1VCH.1
		FT1VCH0		EQU		T1VCH.0

	T1RL			EQU		0B5H
		FT1RL7		EQU		T1RL.7
		FT1RL6		EQU		T1RL.6
		FT1RL5		EQU		T1RL.5
		FT1RL4		EQU		T1RL.4
		FT1RL3		EQU		T1RL.3
		FT1RL2		EQU		T1RL.2
		FT1RL1		EQU		T1RL.1
		FT1RL0		EQU		T1RL.0

	T1RH			EQU		0B6H
		FT1RH7		EQU		T1RH.7
		FT1RH6		EQU		T1RH.6
		FT1RH5		EQU		T1RH.5
		FT1RH4		EQU		T1RH.4
		FT1RH3		EQU		T1RH.3
		FT1RH2		EQU		T1RH.2
		FT1RH1		EQU		T1RH.1
		FT1RH0		EQU		T1RH.0

	P0M			EQU		0B8H
		FP07M		EQU		P0M.7
		FP06M		EQU		P0M.6
		FP05M		EQU		P0M.5
		FP04M		EQU		P0M.4
		FP03M		EQU		P0M.3
		FP02M		EQU		P0M.2
		FP01M		EQU		P0M.1
		FP00M		EQU		P0M.0

	CM0M			EQU		0B9H
		FCM0EN		EQU		CM0M.7
		FCM0OUT		EQU		CM0M.6
		FCM0S1		EQU		CM0M.5
		FCM0S0		EQU		CM0M.4
		FCM0N3		EQU		CM0M.3
		FCM0N2		EQU		CM0M.2
		FCM0N1		EQU		CM0M.1
		FCM0N0		EQU		CM0M.0

	CM0M1			EQU		0BAH
		FTCHEN		EQU		CM0M1.7
	


		FCMDB1		EQU		CM0M1.3
		FCMDB0		EQU		CM0M1.2
		FCM0OEN		EQU		CM0M1.1
		FCM0G		EQU		CM0M1.0

	CM0M2			EQU		0BBH
		FTRS3		EQU		CM0M2.7
		FTRS2		EQU		CM0M2.6
		FTRS1		EQU		CM0M2.5
		FTRS0		EQU		CM0M2.4
	

	


	PEDGE			EQU		0BFH
		FP01G1		EQU		PEDGE.3
		FP01G0		EQU		PEDGE.2
		FP00G1		EQU		PEDGE.1
		FP00G0		EQU		PEDGE.0

	P0W			EQU_W		0C0H
		FP07W		EQU_W		P0W.7
		FP06W		EQU_W		P0W.6
		FP05W		EQU_W		P0W.5
		FP04W		EQU_W		P0W.4
		FP03W		EQU_W		P0W.3
		FP02W		EQU_W		P0W.2
		FP01W		EQU_W		P0W.1
		FP00W		EQU_W		P0W.0

	P2M			EQU		0C2H
		FP21M		EQU		P2M.1
		FP20M		EQU		P2M.0

	P5M			EQU		0C5H
		FP54M		EQU		P5M.4
		FP53M		EQU		P5M.3
		FP52M		EQU		P5M.2
		FP51M		EQU		P5M.1
		FP50M		EQU		P5M.0
		
	INTRQ			EQU		0C8H
		FADCIRQ		EQU		INTRQ.7
		FT1IRQ		EQU		INTRQ.6
		FTC0IRQ		EQU		INTRQ.5
		FT0IRQ		EQU		INTRQ.4
		FCM0IRQ		EQU		INTRQ.3

		FP01IRQ		EQU		INTRQ.1
		FP00IRQ		EQU		INTRQ.0

	INTEN			EQU		0C9H
		FADCIEN		EQU		INTEN.7
		FT1IEN		EQU		INTEN.6
		FTC0IEN		EQU		INTEN.5
		FT0IEN		EQU		INTEN.4
		FCM0IEN		EQU		INTEN.3

		FP01IEN		EQU		INTEN.1
		FP00IEN		EQU		INTEN.0

	OSCM			EQU		0CAH
		FCPUM1		EQU		OSCM.4
		FCPUM0		EQU		OSCM.3
		FCLKMD		EQU		OSCM.2
		FSTPHX		EQU		OSCM.1

	WDTR			EQU_W		0CCH
	
	TC0R			EQU_W		0CDH	

	PCL			EQU		0CEH

	PCH			EQU		0CFH

	P0			EQU		0D0H
		FP07		EQU		P0.7
		FP06		EQU		P0.6
		FP05		EQU		P0.5
		FP04		EQU		P0.4
		FP03		EQU		P0.3
		FP02		EQU		P0.2
		FP01		EQU		P0.1
		FP00		EQU		P0.0

	P2			EQU		0D2H
		FP21		EQU		P2.1
		FP20		EQU		P2.0

	P5			EQU		0D5H
		FP54		EQU		P5.4
		FP53		EQU		P5.3
		FP52		EQU		P5.2
		FP51		EQU		P5.1
		FP50		EQU		P5.0
	
	T0M			EQU		0D8H
		FT0ENB		EQU		T0M.7
		FT0RATE2	EQU		T0M.6
		FT0RATE1	EQU		T0M.5
		FT0RATE0	EQU		T0M.4
		FT1X8		EQU		T0M.3
		FTC0X8		EQU		T0M.2
		FTC0GN		EQU		T0M.1
		FT0TB		EQU		T0M.0

	T0C			EQU		0D9H

	TC0M			EQU		0DAH
		FTC0ENB		EQU		TC0M.7
		FTC0RATE2	EQU		TC0M.6
		FTC0RATE1	EQU		TC0M.5
		FTC0RATE0	EQU		TC0M.4
		FTC0CKS		EQU		TC0M.3
		FALOAD0		EQU		TC0M.2
		FTC0OUT		EQU		TC0M.1
		FPWM0OUT	EQU		TC0M.0

	TC0C			EQU		0DBH

	STKP			EQU		0DFH
		FGIE		EQU		STKP.7
		FSTKPB2		EQU		STKP.2
		FSTKPB1		EQU		STKP.1
		FSTKPB0		EQU		STKP.0

	P0UR			EQU_W		0E0H
		FP07R		EQU_W		P0UR.7
		FP06R		EQU_W		P0UR.6
		FP05R		EQU_W		P0UR.5
		FP04R		EQU_W		P0UR.4
		FP03R		EQU_W		P0UR.3
		FP02R		EQU_W		P0UR.2
		FP01R		EQU_W		P0UR.1
		FP00R		EQU_W		P0UR.0

	P2UR			EQU_W		0E2H
		FP21R		EQU_W		P2UR.1
		FP20R		EQU_W		P2UR.0

	P5UR			EQU_W		0E5H
		FP54R		EQU_W		P5UR.4
		FP53R		EQU_W		P5UR.3
		FP52R		EQU_W		P5UR.2
		FP51R		EQU_W		P5UR.1
	
	@HL			EQU		0E6H

	@YZ			EQU		0E7H	
	
	STK7L			EQU		0F0h
	STK7H			EQU		0F1h	
	STK6L			EQU		0F2h
	STK6H			EQU		0F3h
	STK5L			EQU		0F4h
	STK5H			EQU		0F5h	
	STK4L			EQU		0F6h
	STK4H			EQU		0F7h	
	STK3L			EQU		0F8h
	STK3H			EQU		0F9h
	STK2L			EQU		0FAh
	STK2H			EQU		0FBh	
	STK1L			EQU		0FCh
	STK1H			EQU		0FDh	
	STK0L			EQU		0FEh
	STK0H			EQU		0FFh
	
; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm

; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm

; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
	
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SLowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm

; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
	
; -----------------------------------------------------
;  ISP ROM-Write with Internal VPP 6.5V Generation macro for compatibility in S8KD-2 ICE
;  Occupied Register: A,Y,Z,R  
;  execution time: 40ms(ISP_OK), 30ms(ISP_Fail)
;  Output status: R_Register (ISP_OK: R=0x5AH;   ISP_Fail: R=0xA5H)

	RomwrtVpp 	macro
	local		ISPP_End,ISP_Delay10ms	
	;==== [ISP programming Time ] ====================================
	MOV	A,#03			;Set Programming Counter 30us
	B0MOV	ROMCNT,A		;Programming ISP ROM

	;==== [ VPP Set 6.5V ] ===================
	MOV	A,#00010100b	; ChargePump start-up setting (CP_Clock=62.2K, 1/2_Bias, C-Type, CP_Enale)
	XCH	a,LCDM1
	B0mov	Y,a		; Original setting of LCDM1 save in "Y" register
	Mov	a,#11111111b	; Set VCP=1111 and VPPINTL=1. (VPP set 6.5V and VPP-VLCD short)
	XCH	a,LCDM2
	B0mov	z,a		; Original setting of LCDM2 save in "Z" register
	b0bset	FBGM		; BGM=1 when ISP
	Call	ISP_Delay10ms	; for VPP 6.5V stable 

	;==== [ ISP ROM Write Command ] ===========
	B0BTS1 	FVPPCHK		; VPP High Voltage check
	jmp	$+5
	Call	ISP_Delay10ms	; for VPP 6.5V stable
	ROMWRT			; ISP ROM Write Instruction
	nop			; must nop
	jmp	$+2
	b0bset	FLCDREF0	; if VPP voltage Fail, set "LCDREF0" for indication.

	;==== [VLCD drop to 2.7V ] ================
	b0bclr	FLCDBIAS		; Set 1/3 Bias
	mov	a,#11110000b		; VLCD=2.7V
	and	LCDM2,a	

	;-- Delay 20ms ---------- 
	Call	ISP_Delay10ms
	Call	ISP_Delay10ms

	;--- Set ISP status ---
	b0mov	r,#5AH		; ISP OK:   R=5AH
	b0bts0	FLCDREF0
	SWAPM	R		; ISP Fail: R=A5H

	;===== [ Original LCD seting ] ============
	B0mov	a,z
	b0mov	LCDM2,a		
	B0mov	a,y
	b0mov	LCDM1,a
	jmp	ISPP_End
ISP_Delay10ms:
	;-- Delay 10ms -- 
	clr	R	
	b0mov	a,R	
	incms	R
	jmp	$-1	
	add	a,#1
	cmprs	a,#13
	jmp	$-4
ret
ISPP_End:
	endm
	
;******************************************************************
;		Macro "LcdPumpStart"
; 	Occupied Register:  A,R,Y,Z
; 	Instruction cycle:  ~6170
; 	Code Size:          25-Words
;******************************************************************
LcdPumpStart	macro
	B0MOV	A,LCDM1		; LCDM1 Data Push in Y
	B0MOV	Y,A
	B0MOV	A,LCDM2		; LCDM2 Data Push in Z
	B0MOV	Z,A
	
	;---- LCD Pump Start up setting -----------
	MOV	A,#00010111b	; C-Type, 1/2 bias
	B0MOV	LCDM1,A		; PumpClock=ILRC
	MOV	A,#01100111b	; Pump Enable, BGM=1, C-Type,
	B0MOV	LCDM2,A		; 1/2 bias, PumpClock=ILRC

	;----- Delay 1ms --
	CLR	R
	nop
	INCMS	R
	jmp	$-2
		
	;----- Original Setting --------------------
	B0MOV	A,Y
	B0MOV	LCDM1,A		; LCDM1 Data Pop 
	B0MOV	A,Z
	B0MOV	LCDM2,A		; LCDM2 Data Pop
	B0BSET	FBGM		; BGM Must Set "1"
	
	;-- Delay 5ms -- 
	CLR	R	
	B0MOV	A,R	
	nop
	INCMS	R
	JMP	$-2	
	ADD	A,#1
	CMPRS	A,#5
	JMP	$-4
		
	endm
;******************************************************************
;		Macro LcdDisable"
; 	Occupied Register:  Non
; 	Instruction cycle:  2
; 	Code Size:          16-Words
;******************************************************************
LcdDisable	macro
		B0BCLR	FLCDPENB	; Pump Disable
		B0BCLR	FLCDENB		; LCD Function Disable
		endm

; -----------------------------------------------------	
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}