
;------------------------------------------------------------------------------
;  CHIP: SN8PC13
;  Revision History
;  
;  V01   08/16/2005  1. First issue and only for SN8ICE 2K.
;  V02   12/12/2005  1. Remove P5.4 outpu control.
;  V03   12/17/2007  1. "GreenMode","SleepMode","SlowMode","Slow2Normal" macro programs. 
;  V04   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;  V05   07/10/2008  1. Modify @RST_WDT	macro.  	
;  V06   06/29/2010  1. modify MACRO text "SLowMode" to "SlowMode"
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1	

.Assembly	INC_VER		6
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	48

.Assembly	INSTRUMENT	SN8PC13
.Assembly	BIT_FILE	SN8PC13

.Assembly	OTP_BODY_SIZE	0x0800
.Assembly	USER_ROM_SIZE	0x07FF

;.Assembly	OTP_TEST_SIZE	0x00A0
;.Assembly	MASK_TEST_FILE	SN8A1602A
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	SN86P
.Assembly	PGM_TYPE	6
.Assembly	CHIP_ID		0x3310
.Assembly	command		Enable_ORG4_7, GREEN_NOP_LIMIT
.Assembly	Port_Pins	7, 8, 0, 0, 0, 1

; Code Option 0x07FF
.Assembly	OPTION		0		Reset_Pin   P04 	Reset
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2 : 7		Fix_High
.Assembly	OPTION		8		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x
.Assembly	OPTION		12 : 15		Fix_High

; Code Option 0x07FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x07FD
.Assembly	OPTION		32 : 63	Fix_High

.Assembly	OPTION		2ffh

	R			EQU		82H
	Z			EQU		83H
	Y			EQU		84H
	
	PFLAG		EQU		86H
		FZ		EQU		PFLAG.0
		FC		EQU		PFLAG.2

	P0M			EQU		0B8H
  		FP07M	EQU		P0M.7
  		FP06M	EQU		P0M.6

	P1M			EQU		0C1H
		FP17M	EQU		P1M.7
		FP16M	EQU		P1M.6
		FP15M	EQU		P1M.5
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0

	INTRQ		EQU		0C8H
		FT0IRQ	EQU		INTRQ.4

	OSCM		EQU		0CAH
		FCPUM1	EQU		OSCM.4
		FCPUM0	EQU		OSCM.3

	WDTR		EQU_W	0CCH

    TC0R        EQU_W   0CDH       

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU		0D0H
		FP07	EQU		P0.7
		FP06	EQU		P0.6
		FP04	EQU_R	P0.4
		FP03	EQU_R	P0.3
		FP02	EQU_R	P0.2
		FP01	EQU_R	P0.1
		FP00	EQU_R	P0.0
		
	P1			EQU 	0D1H
		FP17	EQU 	P1.7
		FP16	EQU 	P1.6
		FP15	EQU 	P1.5
		FP14	EQU 	P1.4
		FP13	EQU 	P1.3
		FP12	EQU 	P1.2
		FP11	EQU 	P1.1
		FP10	EQU 	P1.0

	T0M			EQU		0D8H
		FT0ENB     EQU	T0M.7
		FT0RATE2   EQU	T0M.6
		FT0RATE1   EQU	T0M.5
		FT0RATE0   EQU	T0M.4

	T0C			EQU		0D9H

	TC0M		EQU		0DAH
		FIROUT	   EQU	TC0M.0

	TC0C		EQU		0DBH

	STKP		EQU		0DFH
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	@YZ			EQU		0E7H

	TC0D		EQU_W	0E8H

	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSPTHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSPTHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------
	
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}
