;*******************************************************************************
; FILENAME	: 1829Ev.h
; AUTHOR	: SONiX Bryant Chen
; PURPOSE	: Constant and Macro definition for Ev Kit emulation code
;                 User must include 1819EV.h to communication with Ev. Kit
; REVISION	: 12/02/2003 V1.0 	First issue
; REVISION	: 01/06/2004 V2.0 	Add @SET_LCDM1	macro	val for LCDM1 setting
;		: 06/06/2005 v3.0	Fixd Bug for RBANK can be in Bank0
;*******************************************************************************
;*  (c) Copyright 2003, SONiX TECHNOLOGY CO., LTD.
;*******************************************************************************
;
;-------------------------------------------------------------------------------
;;Define user ram 7DH - 7FH to communication emulation board register 
;-------------------------------------------------------------------------------
IF	ICE_Mode==1

.DATA
	ORG		0x07C
	R_Temp2		DS	1				
	R_Temp2		DS	1				
	R_Temp1		DS	1
	R_Temp0		DS	1	
	ORG		0x00
EndIF
;-------------------------------------------------------------------------------
;;Define user ICE Mode SIO interface  
;-------------------------------------------------------------------------------
INIT_1829EV MACRO
IF	ICE_Mode==1

	Sio_SCK		EQU	p3.6	
	Sio_SO		EQU	p3.7
	Sio_SI		EQU	p3.4
	ICE_Reset	EQU	p3.1		; ICE to reset EV Board 
	V_SioLoopCnt	EQU	8

	mov	a,#00000000b			; Initial port3 
	mov	p3,a				;
	mov	a,#11101111b			;
	mov	p3m,a				;
	mov	a,#00000000b			;
	mov	p3ur,a				;

Loop_Reset_EV:					; Reset use p3.1 reset emulation board
                B0BSET   FWDRST	
	decms	R_Temp0				;
	jmp	$-1				;
	decms	R_temp1				;
	jmp	Loop_Reset_EV			;
	b0bset	ICE_Reset			; for sync EV and ICE
	mov	a,#02h				; delay loop 256*256*2
	b0mov	R_Temp2,a			;
Loop_Reset_EV_OK:	
                B0BSET   FWDRST				;
	decms	R_Temp0				;
	jmp	$-1				;
	decms	R_Temp1				;
	jmp	Loop_Reset_EV_OK		;
	decms	R_Temp2				;
	jmp	Loop_Reset_Ev_OK		;
ENDIF
	ENDM

;-------------------------------------------------------------------------------
; SN8P1909 special register access MACRO 
; Write register Usage : XMOV 	register,A
; Read  register Usage : XMOV 	A, register
;-------------------------------------------------------------------------------

XMOV   MACRO	REG,VAL

IF ICE_Mode==1

	IFIDNI <VAL>,<A>			; check witer mode to emulation board
			b0mov	R_Temp2,a	; save a value
			mov	a, #(REG)	; get address value
			b0mov	R_Temp0,a	; save value in R_tamp0
			B0mov	a,RBANK		; 
			B0mov	R_Temp3,a	; Save RBANK data to R_Temp3			
			mov	a,#00H		; 
			b0mov	RBANK,a	
			b0bclr	R_Temp0.7	; use bit7 mark to write mode flag.
			call	SIO		; sned write address to emulation board
			call	@@delayTime	; waiting for emulation board procrss command & address

			b0mov	a,R_Temp2	; load data to SIO buffer
			b0mov	R_Temp0,a	;	
			call	SIO		; send data into emulation board address 
			b0mov	a,R_Temp3		; 
			b0mov	RBANK,a				
			b0mov	a,R_Temp2	; for keep "Acc" value

	elseIFIDNI	<REG>,<A>		; check read mode from emulation board
		
    			mov	a,#(VAL)	; get register address value
			b0mov	R_Temp0,a	;
			B0mov	a,RBANK		; 
			B0mov	R_Temp3,a	; Save RBANK data to R_Temp3			
			mov	a,#00H		; 
			b0mov	RBANK,a	
			b0bset	R_Temp0.7	; use bit7 mark to read mode flag.
			call	SIO		; send read address to emulation board
			call	@@delayTime	; waiting for emulation board process command & address
			call	SIO		; received emulation board data
			b0mov	R_Temp2,a
			b0mov	a,R_Temp3	; 
			b0mov	RBANK,a		; Re-Load RBANK data from R_Temp3
			b0mov	a,R_Temp2			
			
	else
		Error!! Check XMOV macro parameter. This macro need "A" parameter.
	
	endif

else    ; Real chip mode

	IFIDNI  <VAL>,<A>
 		b0mov	(REG),a			;

	elseIFIDNI <REG>,<A>
		b0mov	a,(VAL)			;

	else
		Error!! Check XMOV macro parameter. This macro need "A" parameter.
	endif	
			
ENDIF
	endm

;-------------------------------------------------------------------------------
; SN8P1819 special register Bit test 0 MACRO
; this macro is only available in R/W register of bank 0
; e.g XB0BTS0  FCPRENB
;     XB0BTS1  PGIAM.0    <== this syntax Not available now;     
;-------------------------------------------------------------------------------

XB0BTS0 	MACRO 	REG
IF ICE_Mode==1
		mov	a,#@int(REG)		; get reg. address value
		b0mov	R_Temp0,a		;
		B0mov	a,RBANK			; 
		B0mov	R_Temp3,a		; Save RBANK data to R_Temp3			
		mov	a,#00H			; 
		b0mov	RBANK,a		
     		b0bset	R_Temp0.7		; use bit7 mark to read mode flag.
		call	SIO			; send read address to emulation board
		call	@@delayTime		; waiting for emulation board process command & address
		call	SIO			; received emulation board data
		mov	R_Temp0,a		; save received data 
		b0mov	a,R_Temp3		; 
		b0mov	RBANK,a				
		b0bts0	R_Temp0.@bit(REG)	; judge data bit
ELSE
	b0bts0	REG
ENDIF
	ENDM

;-------------------------------------------------------------------------------
; SN8P1819 special register Bit test 1 MACRO
; this macro is only available in R/W register of bank 0
; e.g XB0BTS1  FCPRENB
;     XB0BTS1  PGIAM.0    <== this syntax Not available now
;-------------------------------------------------------------------------------
XB0BTS1 	MACRO 	REG
IF ICE_Mode==1
		mov	a,#@int(REG)		; get reg. address value
		b0mov	R_Temp0,a		;
		B0mov	a,RBANK			; 
		B0mov	R_Temp3,a		; Save RBANK data to R_Temp3			
		mov	a,#00H			; 
		b0mov	RBANK,a			; Change to RBANK0
     		b0bset	R_Temp0.7		; use bit7 mark to read mode flag.
		call	SIO			; send read address to emulation board
		call	@@delayTime		; waiting for emulation board process command & address
		call	SIO			; received emulation board data
		mov	R_Temp0,a		; save reecived data
		b0mov	a,R_Temp3		; 
		b0mov	RBANK,a			
		b0bts1	R_Temp0.@bit(REG)	; judge data bit
ELSE
	b0bts1	REG
ENDIF
	ENDM

;-------------------------------------------------------------------------------
; SN8P1819 special register Bit set MACRO
; this macro is only available in R/W register of bank 0
; e.g XB0BSET  FCPRENB
;     XB0BSET  PGIAM.0    <== this syntax Not available now
;-------------------------------------------------------------------------------    

XB0BSET 	MACRO 	REG
IF ICE_Mode==1
    		mov	a,#@int(REG)		; get reg. address value
		b0mov	R_Temp0,a		;
		B0mov	a,RBANK			; 
		B0mov	R_Temp3,a		; Save RBANK data to R_Temp3			
		mov	a,#00H			; 
		b0mov	RBANK,a			; Change to RBANK0
     		b0bset	R_Temp0.7		; use bit7 mark to read mode flag.
		call	SIO			; send read address to emulation board
		call	@@delayTime		; waiting for emulation board process command & address

		call	SIO			; received emulation board data
		mov	R_Temp2,a		; save data 
		b0bset	R_Temp2.@bit(REG)	; process data bit

    		mov	a,#@int(REG)	        ; get reg. address value
		b0mov	R_Temp0,a		;

     		b0bclr	R_Temp0.7		; use bit7 mark to writer mode flag.
		call	SIO			; sned write address to emulation board
		call	@@delayTime		; waiting for emulation board process command & address
		b0mov	a,R_Temp2	        ; load data to SIO buffer
		b0mov	R_Temp0,a		;
		call	SIO			; send data into emulation board address
		b0mov	a,R_Temp3		; 
		b0mov	RBANK,a				
ELSE
	b0bset	REG
ENDIF
	endm

;-------------------------------------------------------------------------------
; SN8P1819 special register Bit clear MACRO
; this macro is only available in R/W register of bank 0
; e.g XB0BCLR  FCPRENB
;     XB0BCLR  PGIAM.0    <== this syntax Not available now
;-------------------------------------------------------------------------------    

XB0BCLR 	MACRO 	REG
IF ICE_Mode==1
    		mov	a,#@int(REG)		; get reg. address value
		b0mov	R_Temp0,a		;
		B0mov	a,RBANK			; 
		B0mov	R_Temp3,a		; Save RBANK data to R_Temp3			
		mov	a,#00H			; 
		b0mov	RBANK,a			; Change to RBANK0
     		b0bset	R_Temp0.7		; use bit7 mark to read mode flag.
		call	SIO			; send read address to emulation board
		call	@@delayTime		; waiting for emulation board process command & address
		call	SIO			; received emulation board data
		mov	R_Temp2,a		; save data
		b0bclr	R_Temp2.@bit(REG)	; process data bit
    		mov	a,#@int(REG)		; get reg.  address value
		b0mov	R_Temp0,a		;

     		b0bclr	R_Temp0.7	 	; use bit7 mark to writer mode flag.
		call	SIO			; sned write address to emulation board
		call	@@delayTime		; waiting for emulation board process command & address
		b0mov	a,R_Temp2		; load data to SIO buffer
		b0mov	R_Temp0,a
		call	SIO			;send data into emulation board address
		b0mov	a,R_Temp3		; 
		b0mov	RBANK,a			
ELSE
	b0bclr	reg
ENDIF
	endm

;******************************************************
; @SET_LCDM1 Macro to emulate 1819 LCDM in S8KD-2 ICE
	
	@SET_LCDM1	macro	val
		IF  ICE_MODE ==	1			;Set S8KD-2 ICE LCDM register
			mov	a,#(val)
			and	a,#0xfc
			b0mov	LCDM1,a
			mov	a,#(val)
			and	a,#0x01
			xor	a,#0x01
			b0bts0	FZ
			b0bset	FP2SEG
		ELSE					;;Set SN8P1909 ICE LCDM1 register
			mov	a,#(val)
			b0mov	LCDM1,a
		ENDIF
	endm
;**********************************************************		