#ifndef __BL08P154_H
#define __BL08P154_H

//
// Special function register definitions
//

volatile         unsigned char           OPTION              @ 0x051;
volatile         unsigned char           IOSTA               @ 0x055;
volatile         unsigned char           IOSTB               @ 0x056;

// Register: INDF
volatile         unsigned char           INDF                @ 0x000;
// bit and bitfield definitions

// Register: TMR0
volatile         unsigned char           TMR0                @ 0x001;
// bit and bitfield definitions

// Register: PCL
volatile         unsigned char           PCL                 @ 0x002;
// bit and bitfield definitions

// Register: STATUS
volatile         unsigned char           STATUS              @ 0x003;
// bit and bitfield definitions
volatile bit C   	             @ ((unsigned)&STATUS*8)+0;
volatile bit DC                  @ ((unsigned)&STATUS*8)+1;
volatile bit Z	                 @ ((unsigned)&STATUS*8)+2;
volatile bit PD                  @ ((unsigned)&STATUS*8)+3;
volatile bit T0                  @ ((unsigned)&STATUS*8)+4;
volatile bit GP0                 @ ((unsigned)&STATUS*8)+5;
volatile bit GP1                 @ ((unsigned)&STATUS*8)+6;
volatile bit RST                 @ ((unsigned)&STATUS*8)+7;

// Register: FSR
volatile         unsigned char           FSR                 @ 0x004;


// Register: PA
volatile         unsigned char           PA                @ 0x005;
// bit and bitfield definitions
volatile bit PA0                 @ ((unsigned)&PA*8)+0;
volatile bit PA1                 @ ((unsigned)&PA*8)+1;
volatile bit PA2                 @ ((unsigned)&PA*8)+2;
volatile bit PA3                 @ ((unsigned)&PA*8)+3;
volatile bit PA4                 @ ((unsigned)&PA*8)+4;
volatile bit PA5                 @ ((unsigned)&PA*8)+5;
volatile bit PA6                 @ ((unsigned)&PA*8)+6;
volatile bit PA7                 @ ((unsigned)&PA*8)+7;

// Register: PB
volatile         unsigned char           PB                @ 0x006;
// bit and bitfield definitions
volatile bit PB0                 @ ((unsigned)&PB*8)+0;
volatile bit PB1                 @ ((unsigned)&PB*8)+1;
volatile bit PB2                 @ ((unsigned)&PB*8)+2;
volatile bit PB3                 @ ((unsigned)&PB*8)+3;
volatile bit PB4                 @ ((unsigned)&PB*8)+4;
volatile bit PB5                 @ ((unsigned)&PB*8)+5;
volatile bit PB6                 @ ((unsigned)&PB*8)+6;
volatile bit PB7                 @ ((unsigned)&PB*8)+7;


volatile         unsigned char           PCON                @ 0x008;
volatile bit LVDTE                 @ ((unsigned)&PCON*8)+5;
volatile bit EIS                   @ ((unsigned)&PCON*8)+6;
volatile bit WDTE                  @ ((unsigned)&PCON*8)+7;


volatile         unsigned char           WUCON               @ 0x009;
volatile         unsigned char           PCHBUF              @ 0x00A;
volatile         unsigned char           PDCON               @ 0x00B;
volatile         unsigned char           ODCON               @ 0x00C;
volatile         unsigned char           PHCON               @ 0x00D;
volatile         unsigned char           INTEN               @ 0x00E;
volatile bit T0IE                 @ ((unsigned)&INTEN*8)+0;
volatile bit PBIE                 @ ((unsigned)&INTEN*8)+1;
volatile bit INTIE                @ ((unsigned)&INTEN*8)+2;
volatile bit GIE                  @ ((unsigned)&INTEN*8)+7;

volatile         unsigned char           INTFLAG             @ 0x00F;
volatile bit T0IF                 @ ((unsigned)&INTFLAG*8)+0;
volatile bit PBIF                 @ ((unsigned)&INTFLAG*8)+1;
volatile bit INTIF                @ ((unsigned)&INTFLAG*8)+2;

#define CLR_OPTION()	asm("movlw 0");\
						asm("movwf 51h");	

#define CLR_IOSTA()	asm("movlw 0");\
					asm("movwf 55h");
					
#define CLR_IOSTB()	asm("movlw 0");\
					asm("movwf 56h");	
					
				


#endif
