/**
*   ************************************************************************************

*   ************************************************************************************
**/

#ifndef __PWM_H__
#define	__PWM_H__
/**************************************************************************************/
//	PWM12λ
/**************************************************************************************/
/* PWM ƼĴPWMCON0 */
/* PWMCON0 (Ĭֵ 0B_00011100) */
#define	PWM_TYP2			BIT7		//0/1:PWM2 ض / Ķ
#define	PWM_TYP1			BIT6		//0/1:PWM1 ض / Ķ
#define	PWM_TYP0			BIT5		//0/1:PWM0 ض / Ķ
#define	PWM_RLOAD2			BIT4		//0/1:PWM2 ֹ / ʹ Զ(Ĭʹ)
#define	PWM_RLOAD1			BIT3		//0/1:PWM1 ֹ / ʹ Զ(Ĭʹ)
#define	PWM_RLOAD0			BIT2		//0/1:PWM0 ֹ / ʹ Զ(Ĭʹ)
#define	PWM_REMAIN			BIT1		//λ
#define	PWM_PENCTRL_EN		B0000_0000	//PWM0_EN,PWM1_EN,PWM2_EN PWMģʹ
#define	PWM_PENCTRL_ENA  	B0000_0001	//PWMENA ĴƿPWMģʹ

/* PWM ʹܼĴPWMENA (Ĭֵ0)*/
#define	PWM_PWM21EN			BIT6		//ʹPWM21
#define	PWM_PWM11EN			BIT5		//ʹPWM11
#define	PWM_PWM01EN			BIT4		//ʹPWM01
#define	PWM_PWM2EN			BIT2		//ʹPWM2
#define	PWM_PWM1EN			BIT1		//ʹPWM1
#define	PWM_PWM0EN			BIT0		//ʹPWM0
/**************************************************************************************/
/* PWM ʹܼĴPWM0EN,PWM1EN,PWM2EN (Ĭֵ0)*/
#define	PWM_FLT_M1			B0000_0000	//PWMƽ :CH0,CH1
#define	PWM_FLT_M2			B0010_0000	//                :CH0,CH1
#define	PWM_FLT_M3			B0100_0000	//                :CH0,CH1
#define	PWM_FLT_M4			B0110_0000	//                :CH0,CH1
#define	PWM_EFLT_EN			B0001_0000	//0/1: ֹϼ / FLT0(P00),FLT1(P01),FLT2(P02)Źϼ
#define	PWM_CPM				B0000_0000	//ڻģʽ
#define	PWM_IDP				B0000_1000	//ڶģʽ
#define	PWM_CH1_EN			B0000_0100	//0/1: ֹ /  CH1 
#define	PWM_CH0_EN			B0000_0010	//0/1: ֹ /  CH0 
#define	PWM_EN				B0000_0001	//0/1: ر /  PWM ģ

/* PWM0ƼĴPWM0C,PWM1C,PWM2C(Ĭֵ0) */
#define	PWM_INT_EN			B1000_0000	//0/1: ֹ / ʹ PWM ж
#define	PWM_INT_F			B0100_0000	//0/1: 0 / PWMڼ1
#define	PWM_FLT_STATUS		B0000_0000	//0/1: PWM״̬0 / PWMرӲ1
#define	PWM_FLT_LOW			B0000_0000	//FLTΪ͵ƽʱ,PWMر
#define	PWM_FLT_HIGH		B0001_0000	//FLTΪߵƽʱ,PWMر
#define	PWM_OUT_0H1H		B0000_0000	//CH0CH1ģʽ:CH0,CH1
#define	PWM_OUT_0H1L		B0000_0100	//                :CH0,CH1
#define	PWM_OUT_0L1H		B0000_1000	//                :CH0,CH1
#define	PWM_OUT_0L1L		B0000_1100	//                :CH0,CH1
#define	PWM_CLK_FOSC		B0000_0000	//PWMʱԴ: FOSC
#define	PWM_CLK_FOSC_8		B0000_0001	//         : FOSC/8
#define	PWM_CLK_FOSC_32		B0000_0010	//         : FOSC/32
#define	PWM_CLK_FOSC_128	B0000_0011	//         : FOSC/128

/* PWM ڼĴ[PWM0PL,PWM0PH],[PWM1PL,PWM1PH],[PWM2PL,PWM2PH](Ĭֵ0) */
/* PWM0PH,PWM1PH,PWM2PH 4λЧ */
/* ޸PWMڱ޸ĸλ޸ĵλ */

/* PWM ռձȼĴ[PWM0DL,PWM0DH],[PWM1DL,PWM1DH],[PWM2DL,PWM2DH](Ĭֵ0) */
/* PWM0DH,PWM1DH,PWM2DH 4λЧ */
/* ޸ PWM0 ռձȼĴ,޸ĸλ޸ĵλ,޸ĶһڲЧ */

/* PWM ʱĴ[PWM0DTL,PWM0DTH],[PWM1DTL,PWM1DTH],[PWM2DTL,PWM2DTH] */
/* PWM0DTH,PWM1DTH,PWM2DTH 4λЧ */
/* ģʽ PWM Բ 2 ·ͬ & ռձȿԲͬ PWM  */
/* ģʽ:ʱСռձʱ䣬ʱռձʱĺͱСPWM */

/* PWM3ƼĴPWM3C(Ĭֵ0) */
#define	PWM3_EN				B1000_0000	//0/1: ر /  PWM3
#define	PWM3_INT_EN			B0100_0000	//0/1: ֹ /  PWM3 ж
#define	PWM3_INT_F			B0010_0000	//0/1: 0 / PWM3ڼ(PWM3P)1
#define	PWM3_OEN			B0001_0000	//0/1: ֹ /  PWM3
#define	PWM3_LEVEL			B0000_1000	//0/1: ߵƽ / ͵ƽ PWM3ռձڼ
#define	PWM3_CLK_FOSC		B0000_0000	//PWM3ʱԴ: FOSC
#define	PWM3_CLK_FOSC_2		B0000_0001	//          : FOSC/2
#define	PWM3_CLK_FOSC_4		B0000_0010	//          : FOSC/4
#define	PWM3_CLK_FOSC_8		B0000_0011	//          : FOSC/8
#define	PWM3_CLK_FOSC_16	B0000_0100	//          : FOSC/16
#define	PWM3_CLK_FOSC_32	B0000_0101	//          : FOSC/32
#define	PWM3_CLK_FOSC_64	B0000_0110	//          : FOSC/64
#define	PWM3_CLK_FOSC_128	B0000_0111	//          : FOSC/128

/* PWM3ڼĴPWM3P(Ĭֵ0) */
/* PWM3ռձȼĴPWM3D(Ĭֵ0) */
/**************************************************************************************/




/**************************************************************************************/
/* ûӦöPWM PIN */
#define	pwm0_ch0_pin_att()			att_p10(IO_OUT_PUSH_PULL)
#define	pwm0_ch0_pin_status(x)		pin_out(P1_0,x)
#define	pwm0_ch0_pin_map()			PWM0_MAP = map_p1(0)
#define	pwm0_ch0_pin_io()			PWM0_MAP = map_io()

#define	pwm0_ch1_pin_att()			att_p11(IO_OUT_PUSH_PULL)
#define	pwm0_ch1_pin_status(x)		pin_out(P1_1,x)
#define	pwm0_ch1_pin_map()			PWM01_MAP = map_p1(1)
#define	pwm0_ch1_pin_io()			PWM01_MAP = map_io()

#define	pwm1_ch0_pin_att()			att_p10(IO_OUT_PUSH_PULL)
#define	pwm1_ch0_pin_status(x)		pin_out(P1_0,x)
#define	pwm1_ch0_pin_map()			PWM1_MAP = map_p1(0)
#define	pwm1_ch0_pin_io()			PWM1_MAP = map_io()

#define	pwm1_ch1_pin_att()			att_p11(IO_OUT_PUSH_PULL)
#define	pwm1_ch1_pin_status(x)		pin_out(P1_1,x)
#define	pwm1_ch1_pin_map()			PWM11_MAP = map_p1(1)
#define	pwm1_ch1_pin_io()			PWM11_MAP = map_io()

#define	pwm2_ch0_pin_att()			att_p10(IO_OUT_PUSH_PULL)
#define	pwm2_ch0_pin_status(x)		pin_out(P1_0,x)
#define	pwm2_ch0_pin_map()			PWM2_MAP = map_p1(0)
#define	pwm2_ch0_pin_io()			PWM2_MAP = map_io()

#define	pwm2_ch1_pin_att()			att_p11(IO_OUT_PUSH_PULL)
#define	pwm2_ch1_pin_status(x)		pin_out(P1_1,x)
#define	pwm2_ch1_pin_map()			PWM21_MAP = map_p1(1)
#define	pwm2_ch1_pin_io()			PWM21_MAP = map_io()

#define	pwm3_ch_pin_att()			att_p10(IO_OUT_PUSH_PULL)
#define	pwm3_ch_pin_status(x)		pin_out(P1_0,x)
#define	pwm3_ch_pin_map()			PWM3_MAP = map_p1(0)
#define	pwm3_ch_pin_io()			PWM3_MAP = map_io()
/**************************************************************************************/
/*رע:PWM0,PWM1,PW212λ,ֵ4095,Χ趨ֵ趨Ч*/
/*رע:PWM38λ,ֵ255*/
#define	SYS_FOSC					32000000UL
#define	PWM0_CLK					SYS_FOSC/8
#define	PWM0_FREQ					3000UL						//3K
#define	PMW0_PERIOD					(PWM0_CLK/PWM0_FREQ)		//
#define	PWM0_CH0_DUTY				(PMW0_PERIOD * 60 /100)		//60%
#define	PWM0_CH1_DUTY				(PMW0_PERIOD * 10 /100)		//10%
#define	PWM0_DEAD					(PWM0_CH0_DUTY * 5 /100)	//ʱΪDUYT5%

#define	PWM1_CLK					SYS_FOSC
#define	PWM1_FREQ					32000UL						//32K				
#define	PMW1_PERIOD					(PWM1_CLK/PWM1_FREQ)		//
#define	PWM1_CH0_DUTY				(PMW1_PERIOD * 20 /100)		//20%
#define	PWM1_CH1_DUTY				(PMW1_PERIOD * 50 /100)		//50%
#define	PWM1_DEAD					(PWM1_CH0_DUTY * 5 /100)	//ʱΪDUYT5%

#define	PWM2_CLK					SYS_FOSC
#define	PWM2_FREQ					20000UL						//20K				
#define	PMW2_PERIOD					(PWM2_CLK/PWM2_FREQ)		//
#define	PWM2_CH0_DUTY				(PMW2_PERIOD * 90 /100)		//90%
#define	PWM2_CH1_DUTY				(PMW2_PERIOD * 50 /100)		//50%
#define	PWM2_DEAD					(PWM2_CH0_DUTY * 5 /100)	//ʱΪDUYT5%

#define	PWM3_CLK					(SYS_FOSC/128)
#define	PWM3_FREQ					3000UL						//3K()
#define	PWM3_PERIOD					(PWM3_CLK/PWM3_FREQ)		//(ֵ8λ,ע)
#define	PWM3_DUTY					(PWM3_PERIOD * 50 /100)		//50%
/**************************************************************************************/
enum
{
	D_PWM_OFF = 0,					//PWM ر
	D_PWM_CH0,						//ʹPWM CH0
	D_PWM_CH1,						//ʹPWM CH1
	D_PWM_CH0_CH1,					//ʹPWM CH0 & CH1	
};
/**************************************************************************************/
void config_pwm0_module(u8 u8_ch);
void turn_on_pwm0_cpm(u16 u16_dtuy);
void change_duty_pwm0_cpm(u16 u16_duty);
void turn_on_pwm0_idp(u8 u8_ch, u16 u16_duty0, u16 u16_duty1);
void change_duty_pwm0_idp(u8_ch, u16 u16_duty0, u16 u16_duty1);
void turn_off_pwm0(u8 u8_ch);

void config_pwm1_module(u8 u8_ch);
void turn_on_pwm1_cpm(u16 u16_dtuy);
void change_duty_pwm1_cpm(u16 u16_duty);
void turn_on_pwm1_idp(u8 u8_ch, u16 u16_duty0, u16 u16_duty1);
void change_duty_pwm1_idp(u8_ch, u16 u16_duty0, u16 u16_duty1);
void turn_off_pwm1(u8 u8_ch);

void config_pwm2_module(u8 u8_ch);
void turn_on_pwm2_cpm(u16 u16_dtuy);
void change_duty_pwm2_cpm(u16 u16_duty);
void turn_on_pwm2_idp(u8 u8_ch, u16 u16_duty0, u16 u16_duty1);
void change_duty_pwm2_idp(u8_ch, u16 u16_duty0, u16 u16_duty1);
void turn_off_pwm2(u8 u8_ch);

void config_pwm3_module(void);
void turn_on_pwm3(u8 u8_duty);
void turn_off_pwm3(void);
/**************************************************************************************/
#endif
