
.CHIP	IRC123
//{{PADAUK_CODE_OPTION
	.Code_Option	Security	Enable		// Security 7/8 words Enable
	.Code_Option	Bootup_Time	Slow		// 2048 ILRC
//}}PADAUK_CODE_OPTION

//================================================================
.include    "hs6220.h"

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define RF_WR_LEN  4	//RFշݳ

#define LED_R	PA.3
#define LED_L	PB.7
#define LED_F	PB.4
#define LED_B	PB.2

#define LED		PA.4
//----------------------------------------------------------------
//-------- RFַ --------
#define RF_ADDR0 Public_Address_0 
#define RF_ADDR1 Public_Address_1
#define RF_ADDR2 Public_Address_2
#define RF_ADDR3 Public_Address_3
#define RF_ADDR4 Public_Address_4

//-----------------------------
#define BANK0_CONFIG		0x0f 
#define BANK0_RX_PW_P0 		RF_WR_LEN	;//P0ܵݳȣΪ̬ݳǣֵãҪ
#define BANK0_DYNPD			0x3f 		;//ӦλʹӦ̬ܵݳ
#define BANK0_FEATURE   	0x00		;//ʹݶ̬

#define BANK0_EN_AA			0x01 		;//ʹӦܵԶӦ
#define BANK0_RXADDR		0x01 		;//ӦλӦܵ
#define BAMK0_SETUP_AW		0x02 		;//õַ; õַ4ֽ
#define BANK0_SETUP_RETR	0x13 		;//ԶطʱʱԶط;ʱ256usطط3
#define BANK0_RF_CH			0x05 		;//RFƵ
#define BANK0_SETUP			0x47 		;//RF봫

#define BANK1_RX_CTRL_BYTE0	0x56 		;BANK1_RX_CTRLP_BYTE0 = 0x56BAMK0_SETUP_AW = 0x02RFַΪ4byte
										;BANK1_RX_CTRLP_BYTE0 = 0x52BAMK0_SETUP_AW = 0x03RFַΪ5byte

//================================================================
//----------------
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//-------ȫֱ---------
word Point;			//ָ
word gw_T16Cnt;
byte MARK;
bit Time2ms : MARK.0	//2MS
bit RX_DR_F : MARK.1;
bit TX_TD_F : MARK.2;

byte rf_Mode;
byte RegAddr;
byte RegData;
;byte Freq_Change_R
;byte RF_Sleep_Cnt

byte SPIDDR;
bit  SentBit : SPIDDR.7
bit  ReadBit : SPIDDR.0

bit  RegDataHbit:RegData.7;
byte rf_rwBuf[RF_WR_LEN];
;byte Freq_Switch_Time_Cnt;

byte cnt;
byte DelayCnt;
byte rf_reset_cnt;
byte rf_sleep_cnt;
//-------ֲ---------
byte LEVEL_1_BUF0;		//һʹõʱûеĺΪһ㺬
byte LEVEL_2_BUF0;		//ڶʹõʱõһ㺯ĺΪڶ㺯
byte LEVEL_3_BUF0;		//ʹõʱõڶĺΪ㺯
byte BUF;
byte Roll_Code_Buf[3];	//ݣڶʱõɺ󣬿


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//================================================================
	goto	FPPA0
//	goto	FPPA1

	.romadr	0x10
;=========================================================

interrupt:
	pushaf
	intrq.0	=	0;			//	Clear PA0-IRQ
	if(intrq.2)
	{
		intrq.2 = 0;
		stt16 gw_T16Cnt;

		Time2ms = 1;
		if(rf_sleep_cnt) rf_sleep_cnt--
		if(rf_reset_cnt) rf_reset_cnt--
		
	}
	
	popaf
	reti

	WORD	Stack_FPPA0 [4];	;˴ΪջռãΪ4ջջռռRAMռ
//	WORD	Stack_FPPA1 [2];

FPPA0:
	;.ADJUST_IC	SYSCLK=IHRC/8, IHRC=16MHz, VDD=3V;
	.ADJUST_IC	SYSCLK=IHRC/8, IHRC=16MHz, Body=Inc, VDD=3V; 
	;.ADJUST_IC	SYSCLK=IHRC/8, IHRC=16MHz, Body=Inc, VDD=3V; 
	SP	=	Stack_FPPA0;
	Point = _SYS(RAM_SIZE)-1;
	a = 0;
	do 
	{
		*Point = a;
	}while(--Point$0);
	
	CALL F_System_Init
	call Wirless_Init;
	CALL Get_Rolling_Code
	
;	rf_Mode = Rf_RX_Mode;Rf_RX_Mode; Rf_Carrier_Mode; Rf_TX_Mode;
;	CALL RW1600_ModeSwitch
;	GOTO $

;	SET1 LED 
;	GOTO Match_Code		; 
L_Match_Code_Exit:
;	SET0 LED
	nop
	while (1)
	{
		wdreset;
		nop;
		if(Time2ms)
		{
			Time2ms = 0;
			
			
			CALL RW1600_RecivePack  
			if(RX_DR_F)
			{	//нյ rf_rwBuf

				nop;	
				nop;
			}

			if(!rf_reset_cnt) // 300msûյ1ݣλRF³ʼ
			{

				CALL Wirless_Init;
				rf_reset_cnt=rf_reset_time;
				rf_sleep_cnt=rf_sleep_time;

			}
			if(!rf_sleep_cnt)// 20msûյ1ݣRF˯߻һ
			{

				CALL SPI_CE_LOW
				CALL HS6200_FlushRx;
				CALL HS6200_Clear_All_Irq;

				RegData = 0xae;
				RegAddr = HS6220_BANK0_PMU_CTL
				CALL HS6200_WriteReg; 
		
				MOV A,10
				MOV DelayCnt,A 
				CALL Delay100US// 1msʱȱ٣ҲС 

				RegData = 0xac;
				RegAddr = HS6220_BANK0_PMU_CTL
				CALL HS6200_WriteReg; 
		
				MOV A,10
				MOV DelayCnt,A 
				CALL Delay100US// 1msʱȱ٣ҲС 

				CALL SPI_CE_HIGH
				rf_sleep_cnt=rf_sleep_time;
			}	

		/*	if(RX_DR_F)					
			{
				Roll_Code_Buf[0] = 0;
				;CALL F_Freq_Change			;ͺƵ
				if(0x01 == rf_rwBuf[0])
				{
					LED_R = 1;
					LED_L = 0;
					LED_F = 0;
					LED_B = 0;
				}
				else if(0x02 == rf_rwBuf[0])
				{
					LED_R = 0;
					LED_L = 1;
					LED_F = 0;
					LED_B = 0;
				}
				else if(0x04 == rf_rwBuf[0])
				{
					LED_R = 0;
					LED_L = 0;
					LED_F = 1;
					LED_B = 0;
				}
				else if(0x08 == rf_rwBuf[0])
				{
					LED_R = 0;
					LED_L = 0;
					LED_F = 0;
					LED_B = 1;
				}
			}
			else 						//ûнյ
			{
				Roll_Code_Buf[0]++;
				if(49 < Roll_Code_Buf[0])   //û50*2msֹͣ
				{
					Roll_Code_Buf[0] = 0;
					LED_R = 0;
					LED_L = 0;
					LED_F = 0;
					LED_B = 0;
					;CALL F_Freq_Change			;ͺƵ
				}
			}

			*/
			
		}
	}	

;/**********************************************************
;*@: 
;***********************************************************/
Match_Code:
	rf_Mode = Rf_TX_Mode;    //лtxģʽ
	CALL RW1600_ModeSwitch; 
	DelayCnt = 30;
	CALL Delay100US;
	rf_rwBuf[0] = Roll_Code_Buf[0];
	rf_rwBuf[1] = Roll_Code_Buf[1];
	rf_rwBuf[2] = Roll_Code_Buf[2];
	rf_rwBuf[3] = 0xaa;//Roll_Code_Buf[3];
	;rf_rwBuf[4] = Roll_Code_Buf[4];
	CALL RW1600_start_TXsend_data	;ڹַƵ·͹

	CALL Set_TX_RX_ADDR				;ROLL_CODEдշַĴ

	rf_Mode = Rf_RX_Mode;    //лRXģʽ
	CALL RW1600_ModeSwitch; 	
	T0SN TX_TD_F			;͵ַյACK˳
	GOTO  L_Match_Code_Exit
	DelayCnt = 30;
	CALL Delay100US;
	BUF = 16;
L_Match_Code_0:	
	CALL RW1600_RecivePack;
	DelayCnt = 30;
	CALL Delay100US;
	T0SN RX_DR_F
	GOTO L_Match_Code_Exit
	DZSN BUF 
	GOTO L_Match_Code_0
	rf_rwBuf[0] = Public_Address_0;
	rf_rwBuf[1] = Public_Address_1;
	rf_rwBuf[2] = Public_Address_2;
	rf_rwBuf[3] = Public_Address_3;
	;rf_rwBuf[4] = Public_Address_4;
	CALL Set_TX_RX_ADDR;
	
	GOTO Match_Code
;/**************************************
;*@ : дTX/RXַ
;***************************************/
Set_TX_RX_ADDR:
	SET0 SPI_SS
	MOV A,0x2A		;//HS6200_BANK0_RX_ADDR_P0 | HS6200_WR_REG;
	MOV SPIDDR,A 
	Point = rf_rwBuf;
	MOV A,RF_WR_LEN
	MOV LEVEL_2_BUF0,A 
	CALL F_Write_More_Data
	SET1 SPI_SS
	
	SET0 SPI_SS
	MOV A,0x30		;//HS6200_BANK0_TX_ADDR | HS6200_WR_REG; 
	MOV SPIDDR,A 
	Point = rf_rwBuf;
	MOV A,RF_WR_LEN
	MOV LEVEL_2_BUF0,A 
	CALL F_Write_More_Data
	SET1 SPI_SS
/*
	SET0 SPI_SS
	MOV A,0x2A		;//HS6200_BANK0_TX_ADDR | HS6200_WR_REG; 
	MOV SPIDDR,A 
	Point = rf_rwBuf;
	MOV A,RF_WR_LEN
	MOV LEVEL_2_BUF0,A 
	CALL F_Read_More_Data
	SET1 SPI_SS
*/
	RET 
	
;/*****************************************************
;*@ : Ƶ
;*@ : RegData
;******************************************************/
/*
Set_Freq_Point:

	CALL SPI_CE_LOW;
	RegAddr = HS6200_BANK0_RF_CH;
	CALL HS6200_WriteReg;
	CALL SPI_CE_HIGH;
	
	RET 
*/
;/**************************************************************
;@ : Ƶ
;@
;@     ע: Ƶ->5,19,33
;***************************************************************
/*
F_Freq_Change:
	MOV A,14
	ADD Freq_Change_R,A
	MOV A,Freq_Change_R
	SUB A,47
	T0SN FLAG.1
	GOTO L_Freq_Change_0
	MOV A,5
	MOV Freq_Change_R,A 
L_Freq_Change_0:
	MOV A,Freq_Change_R
	MOV RegData,A 
	CALL Set_Freq_Point
	RET 	
*/
;/*******************************************************************************
;*@ : 뺯
;*@ 	 : 
;*@   ֵ: 
;*@ 	 ע: 
;********************************************************************************/
Get_Rolling_Code:
	.if	_SYS(AT_ICE)
	Roll_Code_Buf[0] = 0x01;
	Roll_Code_Buf[1] = 0x66;
	Roll_Code_Buf[2] = 0x55;
//	Roll_Code_Buf[3] = 0xAA;
	.else
	call    _SYS(ADR.ROLL);     //  ȡ Roll:0
	Roll_Code_Buf[0] =   A;
	call    _SYS(ADR.ROLL) +1;  //  ȡ Roll:1
	Roll_Code_Buf[1] =   A;
	call    _SYS(ADR.ROLL) +2;  //  ȡ Roll:2
	Roll_Code_Buf[2] =   A;
//	call    _SYS(ADR.ROLL) +3;  //  ȡ Roll:3
//	Roll_Code_Buf[3] =   A;
	.endif
	/*
	LEVEL_1_BUF0= 16; 
    while(LEVEL_1_BUF0!=0)         
	  {
			LEVEL_2_BUF0=Roll_Code_Buf[1];
			Roll_Code_Buf[1]>>=1;
			BUF = Roll_Code_Buf[2]&0x01;
			if(BUF)
			{
				Roll_Code_Buf[1]|=0x80;
			}
			Roll_Code_Buf[2]>>=1;
			BUF = LEVEL_2_BUF0&0x01;
			if(BUF)
			{
				Roll_Code_Buf[1] ^=0x05;
				Roll_Code_Buf[2] ^=0x88;
			}
			LEVEL_1_BUF0--;
		}
    Roll_Code_Buf[4] = Roll_Code_Buf[2] >> 4; 
    Roll_Code_Buf[4] = Roll_Code_Buf[4] + 0x80; 
    Roll_Code_Buf[3] = Roll_Code_Buf[2] & 0x0f; 
    Roll_Code_Buf[3] = Roll_Code_Buf[3] + 0x50; 
    Roll_Code_Buf[2] = Roll_Code_Buf[1] >> 4; 
    Roll_Code_Buf[2] = Roll_Code_Buf[2] + 0xb0; 
    Roll_Code_Buf[1] &= 0x0f;                 
    Roll_Code_Buf[1] = Roll_Code_Buf[1] + 0xc0; 
    */
	RET 
;//*******************************************************************
; : ϵͳʼ
;     : 
;   ֵ: 
;     ע:
;---------------------------------------------------------------------
F_System_Init:
;-----------------------------------------------------

	MOV A,11111111b		;0->룬1->
	MOV PAC,A
	MOV A,00H		;1->
	MOV PAPH,A 
	MOV PA,A 
	
	MOV A,11111101b
	MOV PBC,A 		;0->룬1->
	MOV A,02H
	MOV PBPH,A 		;1->
	MOV A,00H
	MOV PB,A 
	
;------------------------------------------------------
	; MOV A,30H
	; MOV lb@Point,A 
	; MOV A,18H
	; MOV hb@Point,A 
	gw_T16Cnt = 8192 - 1000;
	STT16 gw_T16Cnt
	$ t16m SYSCLK,/4,bit13;
	
	inten.2	=	1;			//	Use PA.0 to generate interrupt
	intrq	=	0;
	engint;
ret 

;/*******************************************************************************
;* : SystemStop
;* : ˯
;* β:       
;* : 
;* ˵: 
;*******************************************************************************/
/*
SystemStop:
	
	INC RF_Sleep_Cnt
	MOV A,RF_Sleep_Cnt
	SUB A,200
	T0SN FLAG.1
	GOTO L_SystemStop_EXIT
	
	CLEAR RF_Sleep_Cnt
	CALL Wirless_Sleep;
	.disgint;
	$  T16M   STOP;			// رT16
	.CLKMD.2 =   1;			// ʱ
	MOV A,11010100B
	MOV CLKMD,A 
   ; .CLKMD   =   0B1101_0100;// IHRC/8 -> ILRC/4;
	.CLKMD.4 =   0;          // ر IHRCԴʡЧ
	engint;
    stopsys;				// ͺĵ״̬
	nop;
	nop;
	nop;
	nop;
    CLKMD.4 =   1;			// ʱ
	nop;
	nop;
	nop;
	nop;
	$ CLKMD IHRC/8,EN_IHRC,EN_ILRC
	.CLKMD.2 =   0;          
	nop;
	nop;
	nop;
	nop;
	CALL Wirless_WeakUp;
	$ t16m SYSCLK,/4,bit13;  // T16
L_SystemStop_EXIT:
	RET 
*/
;/*******************************************************************************
;* : Wirless_Sleep
;* : 2.4Gģ˯
;* β:       
;* : 
;* ˵: 
;*******************************************************************************/
/*
Wirless_Sleep:

	CALL HS6200_FlushTx;
	CALL HS6200_FlushRx;
	RegAddr = HS6200_BANK0_CONFIG;
	CALL HS6200_ReadReg;
L_Wirless_Sleep_0:	
	MOV A,0xFC
	AND RegData,A 
	CALL HS6200_WriteReg;
	CALL HS6200_ReadReg;
	T0SN RegData.1
	GOTO L_Wirless_Sleep_0
	RET 
*/
;/*******************************************************************************
;* : Wirless_WeakUp
;* : 2.4Gģ黽
;* β:       
;* : 
;* ˵: 
;*******************************************************************************/
/*
Wirless_WeakUp:

	RegAddr = HS6200_BANK0_CONFIG;
	CALL HS6200_ReadReg;
	RegData |= 0x02;	//Power Up
	CALL HS6200_WriteReg;
	DelayCnt = 50;
	CALL Delay100US;//ӳ>=4.5MS
	RET
*/



;/********************************************************************************/
;/********************************************************************************/
;//=========================================================================
;@ дݴ
;@ : SPIDDR ->ĿĴַ
;@ : Point  ->ָ룬׵ַ
;@ : LEVEL_2_BUF0 ->ݳ
;---------------------------------------------------------------------------
F_Write_More_Data:
	CALL SPI_W_Byte	;//ݵúǰֵSPIDDRΪĴַ
L_Write_More_Data_0:	
	IDXM A,Point
	MOV SPIDDR,A 
	CALL SPI_W_Byte
	Point++;
	DZSN LEVEL_2_BUF0
	GOTO L_Write_More_Data_0
	RET 
;//=========================================================================
;@ ݴ
;@ : SPIDDR ->ĿĴַ
;@ : Point  ->ָ룬׵ַ
;@ : LEVEL_2_BUF0 ->ݳ
;---------------------------------------------------------------------------
F_Read_More_Data:
	CALL SPI_W_Byte	;//ݵúǰֵSPIDDRΪĴַ
L_Read_More_Data_0:
	CLEAR SPIDDR
	CALL SPI_R_Byte
	MOV A,SPIDDR
	IDXM Point,A
	Point++;
	DZSN LEVEL_2_BUF0
	GOTO L_Read_More_Data_0
	RET 
;/**************************************************************************/
SPI_CE_LOW:

    SPI_SS = 0;
    SPIDDR = HS6220_CMD_CE_LOW;
    CALL SPI_W_Byte;
    SPI_SS = 1;
ret 

;/*******************************************************************************
;* : RW1600_SPI_CE_HIGH()
;* : 2.4GģCE_HIGH
;* β:       
;* : 
;* ˵: 
;*******************************************************************************/
SPI_CE_HIGH:

    SPI_SS = 0;
    SPIDDR = HS6220_CMD_CE_HIGH;
    CALL SPI_W_Byte;
    SPI_SS = 1;
RET 
;/*******************************************************************************
;* : Delayus
;* : ӳ
;* β:       
;* : 
;* ˵: 
;*******************************************************************************/
Delay100US:
	MOV A,65
	MOV cnt,A 
L_Delay100US_0:
	DZSN cnt 
	GOTO L_Delay100US_0
	DZSN DelayCnt 
	GOTO Delay100US
RET 
;/*******************************************************************************
;* : SPI_WR_Byte
;* : 
;* : LEVEL_1_BUF0      
;* : 
;* ˵: 
;*******************************************************************************/

SPI_W_Byte:
	SET1 SPI_MOSI_PBC

	MOV A,8
	MOV LEVEL_1_BUF0,A 

L_SPI_W_Byte_0:
	SET0 SPI_CLK 
	T1SN SentBit
	SET0 SPI_MOSI
	T0SN SentBit
	SET1 SPI_MOSI
	SL SPIDDR
//	T0SN SPI_MISO
//	SET1 ReadBit
	SET1 SPI_CLK
	NOP
	NOP
	NOP
	NOP
	
	DZSN LEVEL_1_BUF0
	GOTO L_SPI_W_Byte_0
	SET0 SPI_CLK 
	SET0 SPI_MOSI
ret 

SPI_R_Byte:
	SET0 SPI_MOSI_PBC
//	SET1 SPI_MOSI_PBDIER
	MOV A,8
	MOV LEVEL_1_BUF0,A 

L_SPI_R_Byte_0:
	SL SPIDDR
	SET1 SPI_CLK
	T0SN SPI_MOSI
	SET1 ReadBit
	SET0 SPI_CLK 
	NOP
	NOP
	NOP
	NOP
	DZSN LEVEL_1_BUF0
	GOTO L_SPI_R_Byte_0
ret 

;/*******************************************************************************
;* : HS6200_WriteCmd
;* : 
;* β:       
;* : 
;* ˵: 
;*******************************************************************************/
HS6200_WriteCmd:
	SET0 SPI_SS
	MOV A,RegAddr
	MOV SPIDDR,A 
	CALL  SPI_W_Byte;	   //cmd
	MOV A,RegData
	MOV SPIDDR,A 
	CALL  SPI_W_Byte;	   //cmd
	SET1 SPI_SS
ret 

;/*******************************************************************************
;* : HS6200_wrOperation
;* : 
;* β:       
;* : 
;* ˵: 
;*******************************************************************************/
HS6200_wrOperation:

	SPI_SS = 0;
	SPIDDR = RegAddr;
	CALL SPI_W_Byte;
	RegData = SPIDDR;
	SPI_SS = 1;
ret

;/*******************************************************************************
;* : HS6200_WriteReg
;* : 
;* β:       
;* : 
;* ˵: 
;*******************************************************************************/
HS6200_WriteReg:

	SPI_SS = 0;

	SPIDDR = HS6220_W_REGISTER|RegAddr;
	CALL SPI_W_Byte;//write register addr
	
	SPIDDR = RegData;
	CALL SPI_W_Byte;

	SPI_SS = 1;
ret 
;/*******************************************************************************
;* : HS6200_ReadReg
;* : 
;* β:       
;* : 
;* ˵: 
;*******************************************************************************/
HS6200_ReadReg:

	SPI_SS = 0;

	SPIDDR = RegAddr;//HS6200_RD_REG = 0
	CALL SPI_W_Byte;

	SPIDDR = 0xff;
	CALL SPI_R_Byte;

	RegData = SPIDDR;
	SPI_SS = 1;
RET 

;/*******************************************************************************
;* : HS6200_Bank_Select
;* : 
;* β:       
;* : 
;* ˵: лbank
;*******************************************************************************/
HS6200_bank_Switch:

	;LEVEL_3_BUF0 = RegData;//ѡblank
	MOV A,RegData
	MOV BUF,A
	RegAddr = HS6220_BANK0_STATUS;
	CALL HS6200_ReadReg;
	MOV A,0x01 	;ѡbank1 
	;CEQSN A,LEVEL_3_BUF0
	CEQSN A,BUF
	GOTO L_HS6200_bank_Switch_0
	T0SN RegDataHbit
	GOTO L_HS6200_bank_Switch_Exit
	RegAddr = HS6220_ACTIVATE;
	RegData = HS6220_ACTIVATE_DATA;
	CALL HS6200_WriteCmd;
	GOTO L_HS6200_bank_Switch_Exit
L_HS6200_bank_Switch_0:
	T1SN RegDataHbit
	GOTO L_HS6200_bank_Switch_Exit
	RegAddr = HS6220_ACTIVATE;
	RegData = HS6220_ACTIVATE_DATA;
	CALL HS6200_WriteCmd;
L_HS6200_bank_Switch_Exit:	
	RET 
;/***************************************************************************/
;@ : RW1600_ModeSwitch
;@ 	 : rf_Mode
;@ 	 ע: 
;----------------------------------------------------------------------------
RW1600_ModeSwitch:

	CALL SPI_CE_LOW
	RegAddr = HS6220_BANK0_CONFIG;//0x00
	CALL HS6200_ReadReg;
	
	if(rf_Mode!= 0)   //Rf_PRX_Mode
	RegData &= 0xFE;
	else	  
	RegData |= 0x01;
	CALL HS6200_WriteReg;

    RegAddr =HS6220_BANK0_RF_SETUP;// HS1600_BANK0_RF_SETUP;
	CALL HS6200_ReadReg;
	RegData &= ~0x80;
	RegData |= rf_Mode;
	RegAddr = HS6220_BANK0_RF_SETUP;//RW1600_BANK0_RF_SETUP;
	CALL HS6200_WriteReg; 
		
	CALL SPI_CE_HIGH;
	
	RET 
;/*******************************************************************************
;* : HS6200_Clear_All_Irq
;* : 
;* β:       
;* : 
;* ˵: 
;*******************************************************************************/
HS6200_Clear_All_Irq:

	RegAddr = HS6220_BANK0_STATUS;
	RegData = 0x7f;
	CALL HS6200_WriteReg;
RET 

;/*******************************************************************************
;* : HS6200_Flush_Tx
;* : 
;* β:       
;* : 
;* ˵: 
;*******************************************************************************/
HS6200_FlushTx:

	RegAddr = HS6220_FLUSH_TX;
	CALL HS6200_wrOperation;
RET 
;/*******************************************************************************
;* : HS6200_Flush_Rx
;* : 
;* β:       
;* : 
;* ˵: 
;*******************************************************************************/
HS6200_FlushRx:

	RegAddr = HS6220_FLUSH_RX;
	CALL HS6200_wrOperation;
RET

;/*******************************************************************************
;* : RW1600_SPI_CE_HIGH()
;* : 2.4GģCE_HIGH
;* β:       
;* : 
;* ˵: 
;*******************************************************************************/


;/********************************************************************
;*@ : 
;*@ 	 :  
;*@   ֵ: TX_TD_F(ȫλ)
;*@ 	 ע:  
;*********************************************************************/
RW1600_start_TXsend_data:

	CALL SPI_CE_LOW;

	TX_TD_F = 0;
	/*
	MOV A,HS6200_BANK0_STATUS
	MOV RegAddr,A 
	CALL HS6200_ReadReg;
	T0SN RegData.5
	SET1 TX_TD_F
	*/
	CALL HS6200_Clear_All_Irq; //ж״̬
	CALL HS6200_FlushTx;
	CALL HS6200_FlushRx;
	
	SPI_SS = 0;   //
	SPIDDR = HS6220_W_TX_PAYLOAD;		;//дĴַ
	LEVEL_2_BUF0 = RF_WR_LEN;			;//дݳ
	Point = rf_rwBuf;					;//д׵ַ
	CALL F_Write_More_Data
	SPI_SS = 1;	
	CALL SPI_CE_HIGH;
	DelayCnt = 30;
	CALL Delay100US;
	
	MOV A,HS6220_BANK0_STATUS
	MOV RegAddr,A 
	CALL HS6200_ReadReg;
	T0SN RegData.5
	SET1 TX_TD_F
	
;	CALL SPI_CE_LOW;
	RET 
	/*
	BUF = 5;
L_TXsend_data_0:
	DelayCnt = 2;
	CALL Delay100US;
	MOV A,HS6200_BANK0_STATUS
	MOV RegAddr,A 
	CALL HS6200_ReadReg;
	T1SN RegData.5
	GOTO L_TXsend_data_1
	SET1 TX_TD_F
	RET
L_TXsend_data_1:
	DZSN BUF 
	GOTO L_TXsend_data_0
	RET 
*/
;/*********************************************************
;*@ : 
;*@ 	 :  
;*@   ֵ: RX_DR_F(ȫλ)
;*@ 	 ע: 
;**********************************************************/
RW1600_RecivePack:

	MOV A,HS6220_BANK0_STATUS
	MOV RegAddr,A 
	CALL HS6200_ReadReg;
	SET0 RX_DR_F
	T1SN RegData.6
	GOTO L_RW1600_RecivePack_Exit
	
L_RW1600_RecivePack_0:
	MOV A,HS6220_R_RX_PL_WID
	MOV RegAddr,A 
	CALL HS6200_ReadReg;
	
	MOV A,0x20 
	SUB A,RegData
	T0SN FLAG.1 
	GOTO L_RW1600_RecivePack_3
	
	SET0 SPI_SS
	MOV A,HS6220_R_RX_PAYLOAD	;//ҪȡļĴַ
	MOV SPIDDR,A 
	
	MOV A,RegData
	MOV LEVEL_2_BUF0,A 	;//Ҫȡݳ
	Point = rf_rwBuf;	;//ݴ洢ַ
	CALL F_Read_More_Data	;//öݺ
	
L_RW1600_RecivePack_2:	
	SET1 SPI_SS
L_RW1600_RecivePack_3:
	CALL HS6200_FlushTx;
	CALL HS6200_FlushRx;
    CALL HS6200_Clear_All_Irq;
	SET1 RX_DR_F;	
L_RW1600_RecivePack_Exit:
	RET
	
;/*******************************************************************
;* : RFλ
;********************************************************************/
/*
RF_RST:
	MOV A,Rf_Bank1
	MOV RegData,A 
	CALL HS6200_bank_Switch		;// лΪbank1
	SET0 SPI_SS;
	SPIDDR = HS6200_BANK1_PLL_CTL1 | HS6200_WR_REG; 
	CALL SPI_WR_Byte;//ѡַ
	SPIDDR = 0x00;
	CALL SPI_WR_Byte;
	SPIDDR = 0x5A;
	CALL SPI_WR_Byte;
	SPIDDR = 0x10;
	CALL SPI_WR_Byte;
	SPIDDR = 0x80;
	CALL SPI_WR_Byte;
	SPI_SS = 1;
	
	MOV A,Rf_Bank0
	MOV RegData,A 
	CALL HS6200_bank_Switch		;// лΪbank1
L_WAIT_RST_OK:
	rf_Mode = 0x01;
	call RW1600_ModeSwitch
	RegAddr = 0x27;
	call HS6200_ReadReg
	MOV A,RegData
	AND A,0x01 
	CEQSN A,0x01 
	GOTO L_WAIT_RST_OK
	
	RET 
*/
;/*******************************************************************************
;* : HS6200_Calibration
;* : У׼
;* β:       
;* : 
;* ˵: 
;*******************************************************************************/
Wirless_Init:
	SPI_SS	= 1;
	SPI_CLK = 0;
/*	
	MOV A,Rf_Bank1			;//bank1
	MOV RegData,A 
	CALL HS6200_bank_Switch
	
	SET0 SPI_SS
	MOV A,HS6200_BANK1_LINE
	MOV SPIDDR,A 
	CALL SPI_WR_Byte
	CALL SPI_WR_Byte
	CALL SPI_WR_Byte
	SET1 SPI_SS
	
	MOV A,0x00 
	SUB A,SPIDDR
	T0SN FLAG.0			;//Ϊ0˵RFͨѶ
	GOTO $
*/	
HS6200_CalibrationAndIntialize:
	MOV A,Rf_Bank0			;//bank0
	MOV RegData,A 
	CALL HS6200_bank_Switch
	CLEAR LEVEL_3_BUF0
L_HS6200_CalibrationAndIntialize_0:
	INC LEVEL_3_BUF0
	MOV A,LEVEL_3_BUF0
	CALL rf_table
	MOV BUF,A 
	CEQSN A,0xaa
	GOTO L_HS6200_CalibrationAndIntialize_1
	
	SET1 SPI_SS 
	.delay 16
	SET0 SPI_SS 
	GOTO L_HS6200_CalibrationAndIntialize_0
	
L_HS6200_CalibrationAndIntialize_1:
	MOV A,BUF 
	CEQSN A,0xbb
	GOTO L_HS6200_CalibrationAndIntialize_2
	SET1 SPI_SS 
	MOV A,25
	MOV DelayCnt,A 
	CALL Delay100US
	GOTO L_HS6200_CalibrationAndIntialize_0
	
L_HS6200_CalibrationAndIntialize_2:
	MOV A,BUF 
	CEQSN A,0xCC
	GOTO L_HS6200_CalibrationAndIntialize_3
	CALL SPI_CE_HIGH
	GOTO L_HS6200_CalibrationAndIntialize_0	
	
L_HS6200_CalibrationAndIntialize_3:
	MOV A,BUF 
	CEQSN A,0xDD
	GOTO L_HS6200_CalibrationAndIntialize_4
	CALL SPI_CE_LOW
	GOTO L_HS6200_CalibrationAndIntialize_0

L_HS6200_CalibrationAndIntialize_4:
	MOV A,BUF 
	CEQSN A,0xEE
	GOTO L_HS6200_CalibrationAndIntialize_5
L_HS6200_CalibrationAndIntialize_51:
	//ȴ
	MOV A,10
	MOV DelayCnt,A 
	CALL Delay100US

	MOV A,HS6220_BANK0_RF_SETUP
	MOV RegAddr,A 
	CALL HS6200_ReadReg;
	SET0 RX_DR_F
	T1SN RegData.5
	GOTO L_HS6200_CalibrationAndIntialize_0
	GOTO L_HS6200_CalibrationAndIntialize_51
	
L_HS6200_CalibrationAndIntialize_5:
	MOV A,BUF 
	CEQSN A,0xFF
	GOTO L_HS6200_CalibrationAndIntialize_6
	SET1 SPI_SS 
	GOTO L_HS6200_CalibrationAndIntialize_Exit
	
L_HS6200_CalibrationAndIntialize_6:
	MOV A,BUF 
	MOV SPIDDR,A 
	CALL SPI_W_Byte
	GOTO L_HS6200_CalibrationAndIntialize_0
	
L_HS6200_CalibrationAndIntialize_Exit:
	;MOV A,Rf_Bank0			;//bank1
	;MOV RegData,A 
	;CALL HS6200_bank_Switch
	CALL HS6200_Clear_All_Irq;
	CALL HS6200_FlushTx;
	CALL HS6200_FlushRx;

	CALL SPI_CE_LOW;
	//ʼEnd
	//---------------------------------------------------------
	RET

	
;=========================================================
	.romadr	0x350
//===============================================
//ʼRF
//===============================================
rf_table:
	_pcadd
{
	ret  0xaa; 
	ret  0x3d;   
	ret  0x20; //HS6220_BANK0_FEATURE,SOFT_RST
	ret  0xaa; 

	ret  0x3c;    
	ret  0x00; //HS6220_BANK0_DYNPD //ͨ
//	ret  0x3c;    ret  0x08; //HS6220_BANK0_DYNPD //ͨ
	ret  0xaa; 

	ret  0xdd;  //ce low
	ret  0xaa; 

	ret  0x20;    
	ret  0x8b; //HS6220_BANK0_CONFIG  power up
   	ret  0xbb;  //delay >=3ms
	ret  0xaa; 

	ret  0x23;    
	ret  0xac; //HS6220_BANK0_PMU_CTL  HS6220_PWRDWN = 00
   	ret  0xbb;  //delay >=3ms
	ret  0xaa; 

	ret  0x3d;    
	ret  0x10; //HS6220_BANK0_FEATURE 
	ret  0xaa; 

	ret  0x50;    
	ret  0x53;   //лbank
	ret  0xaa; 

	ret  0x3F;    
	ret  0x20; //HS6220_BANK1_TEST_PKDET 
	ret  0xaa; 

	ret  0x33;    
	ret  0x0c;//ret  0xA0;ret  0x01; //HS6220_BANK1_FAGC_CTRL_1   VCO ֤д0x01,д0x0c
	ret  0xaa; 

//	ret  0x3C;    ret  0xCF;ret  0xB2; //HS6220_BANK1_AGC_CTRL 
//	ret  0xaa;
	ret  0x50;   
	ret  0x53;   //лbank
	ret  0xaa; 

    	ret  0xcc;  //ce high
 //   ret  0xee;  //delay >=100US
   	ret  0xbb;  //delay >=3ms
	ret  0xaa;

	ret  0xdd;  //ce low
	ret  0xaa; 

	ret  0xee;//ȴ
	ret  0xaa; 

	ret  0x26;    
	ret  0x40;   //HS6220_BANK0_RF_SETUP
	ret  0xaa; 

	ret  0x50;    
	ret  0x53;   //лbank
	ret  0xaa; 

	ret  0x23;   
	ret  0x20;
	ret  0x98;
	ret  0x75; //HS6220_BANK1_CAL_CTL 
	ret  0xaa; 

	ret  0x50;    
	ret  0x53;   //лbank
    	ret  0xaa;

	ret  0x3D;   
	ret  0x10;   //HS6220_BANK0_FEATURE
	ret  0xaa; 

	ret  0x20;   
	ret  0xFB;   //HS6220_BANK0_CONFIG
	ret  0xaa; 

	ret  0x21;   
	ret  0x00;   //HS6220_BANK0_EN_AA
	ret  0xaa; 

	ret  0x22;  
	ret  0x03;   //HS6220_BANK0_EN_RXADDR
	ret  0xaa; 

	ret  0x31;    
	ret  RF_WR_LEN;   //HS6220_BANK0_RX_PW_P0 ݳ
	ret  0xaa; 

	ret  0x25;   
	ret  45;   //HS6220_BANK0_RF_CH
	ret  0xaa; 

	ret  0x26;    
	ret  0x47;   //HS6220_BANK0_RF_SETUP
	ret  0xaa; 

	ret  0x3C;   
	ret  0x07;   //HS6220_BANK0_DYNPD
	ret  0xaa; 

	ret  0x2a;    ret  0x46;ret  0x0b;ret  0xaf;ret  0x43;ret  0x98;//HS6220_BANK0_RX_ADDR_P0
    	ret  RF_ADDR0;
	ret  RF_ADDR1;
	ret  RF_ADDR2;
	ret  RF_ADDR3;
	ret  RF_ADDR4;
	ret  0xaa;

	ret  0x30;    ret  0x46;ret  0x0b;ret  0xaf;ret  0x43;ret  0x98;//HS6220_BANK0_TX_ADDR
    	ret  RF_ADDR0;
	ret  RF_ADDR1;
	ret  RF_ADDR2;
	ret  RF_ADDR3;
	ret  RF_ADDR4;
	ret  0xaa; 
   	ret  0xcc;  //ce high
    	ret  0xff;
}
















