//================================================================================
#include	"main.h"
#include	"hs6220.h"
//================================================================================

//================================================================================
//	
//--------------------------------------------------------------------------------
void spi_write_byte(void)
{	//SPI дһBYTE,(úǰҪ u8_spi_data ֵ)
	//3ͨѶ
	p_spi_mosi_ph = 0;
	p_spi_mosi_att = 1;				//output
	.delay 5;
	u8_para = 8;
	while(u8_para)
	{
		p_spi_clk = 0;
		if(b_send_bit)
		{
			p_spi_mosi = 1;
		}
		else
		{
			p_spi_mosi = 0;
		}
		u8_spi_data <<= 1;
		p_spi_clk = 1;
		u8_para--;
	}
	p_spi_mosi = 0;
	p_spi_clk = 0;
	p_spi_mosi_att = 0;				//input pull high
	p_spi_mosi_ph = 1;
}	
//--------------------------------------------------------------------------------
void spi_read_byte(void)
{	//SPI һBYTE,(ݷ u8_spi_data)
	//3ͨѶ
	u8_para = 8;
	while(u8_para)
	{
		p_spi_clk = 1;
		u8_spi_data <<= 1;
		if(p_spi_mosi)
		{
			b_read_bit = 1;
		}
		else
		{
			b_read_bit = 0;
		}
		p_spi_clk = 0;
		u8_para--;
	}
}
//================================================================================
void rf_write_reg(void)
{	// ֱӸĴַдһֵ
	// Ĭдһֵ,Ҫдֵڵúǰ u8_data_num ֵ
	u16_point = &u8_data_buf[0];
	if(u8_data_num <= 1)
	{
		u8_data_num = 1;
	}

	p_spi_csn = 0;
	spi_write_byte();						//write addr
	while(u8_data_num)
	{
		u8_spi_data = *u16_point++;			//write data
		spi_write_byte();
		u8_data_num--;
	}
	p_spi_csn = 1;
}
//--------------------------------------------------------------------------------
void rf_read_reg(void)
{	//	Ĵһֵ
	// Ĭ϶һֵ,Ҫֵڵúǰ u8_data_num ֵ
	u16_point = &u8_data_buf[0];
	if(u8_data_num <= 1)
	{
		u8_data_num = 1;	
	}

	p_spi_csn = 0;
	spi_write_byte();
	while(u8_data_num)
	{
	//	u8_spi_data = 0;
		spi_read_byte();					//read data
		*u16_point = u8_spi_data;
		u16_point++;
		u8_data_num--;
	}
	p_spi_csn = 1;
}
//================================================================================
void rf_write_cmd(void)
{
	p_spi_csn = 0;
	spi_write_byte();
	p_spi_csn = 1;
}
//--------------------------------------------------------------------------------
void rf_clear_irq(void)
{	//жϱ־
	p_spi_csn = 0;
	u8_spi_data = HS6220_BANK0_STATUS + HS6220_W_REGISTER;
	spi_write_byte();
	u8_spi_data = 0x70;
	spi_write_byte();
	p_spi_csn = 1;
}
//--------------------------------------------------------------------------------
void rf_bank_switch(void)
{	//лBANK(úǰҪ b_rf_bank ֵ)
	u8_spi_data = HS6220_BANK0_STATUS;
	rf_read_reg();
	if((b_bank && !b_rf_bank) || (!b_bank && b_rf_bank))
	{
		u8_spi_data = HS6220_ACTIVATE;
		u8_data_buf[0] = HS6220_ACTIVATE_DATA;
		rf_write_reg();
	}
}
//================================================================================
void rf_init(void)
{	//RF ʼ	
reset_rf_int:
//RF λ
	u8_spi_data = HS6220_BANK0_FEATURE + HS6220_W_REGISTER;
	u8_data_buf[0] = SOFT_RST;
	rf_write_reg();
	
//Ĭ3SPI,ʹ4Ҫ
	u8_spi_data = HS6220_BANK0_DYNPD + HS6220_W_REGISTER;
//	u8_data_buf[0] = 8;						//4SPI	
	u8_data_buf[0] = 0;						//3SPI
	rf_write_reg();

	rf_ce_low();
//RF ϵ(RXģʽ)
	u8_spi_data = HS6220_BANK0_CONFIG + HS6220_W_REGISTER;
	u8_data_buf[0] = 0x8B;
	rf_write_reg();

	delay_ms(3);							//ʱ3MS()
//ģʽ
	u8_spi_data = HS6220_BANK0_PMU_CTL + HS6220_W_REGISTER;
	u8_data_buf[0] = 0xA8;
	rf_write_reg();

	delay_ms(2);							//ʱ2MS()
//迪˹˲
	u8_spi_data = HS6220_BANK0_FEATURE + HS6220_W_REGISTER;
	u8_data_buf[0] = 0x10;
	rf_write_reg();

//лBANK1
	b_rf_bank = Rf_Bank1;
	rf_bank_switch();
//TEST_PKDET(üĴ24λ)ĵ5λΪ1
	u8_spi_data = HS6220_BANK1_TEST_PKDET + HS6220_W_REGISTER;
	u8_data_buf[0] = 0x20;
	rf_write_reg();

//FAGC_CTRL_1(üĴ32λ)
//6220Ϊ߿,VCO.,ǿ˱й¶,ֲ֤ù. 
//еĽ취:СתʱVCO,תʱָԭֵ
//ʱ:CE,лBANK1,üĴ(ն300MSղݻḴλRF,ͻָԭֵ)
	u8_spi_data = HS6220_BANK1_FAGC_CTRL_1 + HS6220_W_REGISTER;
	u8_data_buf[0] = 0x01;					//ϵʼֻҪд8λ
	rf_write_reg();

//AGC_CTRL(üĴ32λ)	
	u8_spi_data = HS6220_BANK1_AGC_CTRL + HS6220_W_REGISTER;
	u8_data_buf[0] = 0xCF;
	u8_data_buf[1] = 0xB2;
	u8_data_num = 2;
	rf_write_reg();

//лBANK0	
	b_rf_bank = Rf_Bank0;
	rf_bank_switch();
//巽ʽڲУ׼RF(CE40USĸ弤RFУ׼)	
	rf_ce_high();
	.delay 120;								//60US
	rf_ce_low();							//У׼ʱ,CEΪ
	
	u8_tmp = 35;							//Լ35MS
//CEߵУ׼Ҫ29MS,35MSûжУ׼ɱ־¿ʼʼ
//ȴУ׼	
	while(1)					
	{
		u8_spi_data = HS6220_BANK0_RF_SETUP;
		rf_read_reg();
		if(b_cal_done)
		{
			break;
		}
		delay_ms(1);						//ʱ1MS
		u8_tmp--;
		if(0 == u8_tmp)
		{	//³ʼ
			goto reset_rf_int;
		}
	}
//رУ׼(CAL_EN0,ʵ趨)
	u8_spi_data = HS6220_BANK0_RF_SETUP + HS6220_W_REGISTER;
	u8_data_buf[0] = 0x40;
	rf_write_reg();	

//лBANK1
	b_rf_bank = Rf_Bank1;
	rf_bank_switch();
// CAL_CTL(üĴ32λ)
	u8_spi_data = HS6220_BANK1_CAL_CTL + HS6220_W_REGISTER;
	u8_data_buf[0] = 0x20;
	u8_data_buf[1] = 0x98;
	u8_data_buf[2] = 0x75;
	u8_data_num = 3;
	rf_write_reg();

//лBANK0	
	b_rf_bank = Rf_Bank0;
	rf_bank_switch();
//ýյַ(5BYTE)
	u8_spi_data = HS6220_BANK0_RX_ADDR_P0 + HS6220_W_REGISTER;
	u8_data_buf[0] = D_RF_ADDR0;
	u8_data_buf[1] = D_RF_ADDR1;
	u8_data_buf[2] = D_RF_ADDR2;
	u8_data_buf[3] = D_RF_ADDR3;
	u8_data_buf[4] = D_RF_ADDR4;
	u8_data_num = 5;
	rf_write_reg();	
//÷͵ַ(5BYTE)
	u8_spi_data = HS6220_BANK0_TX_ADDR + HS6220_W_REGISTER;
//	u8_data_buf[0] = D_RF_ADDR0;
//	u8_data_buf[1] = D_RF_ADDR1;
//	u8_data_buf[2] = D_RF_ADDR2;
//	u8_data_buf[3] = D_RF_ADDR3;
//	u8_data_buf[4] = D_RF_ADDR4;
	u8_data_num = 5;
	rf_write_reg();	

//迪˹˲,ʹ̬ܶݰ
	u8_spi_data = HS6220_BANK0_FEATURE + HS6220_W_REGISTER;
	u8_data_buf[0] = 0x10;
	rf_write_reg();	

//ʹRXԶӦ					
	u8_spi_data = HS6220_BANK0_EN_AA + HS6220_W_REGISTER;
	u8_data_buf[0] = 0;						//ֹRXԶӦ
//	u8_data_buf[0] = 0x01;					//ʹRX PIPE0 ԶӦ
	rf_write_reg();

//CONFIG(RX MODE : 0xFB;TX MODE : 0xFA)
//	u8_spi_data = HS6220_BANK0_CONFIG + HS6220_W_REGISTER;
//	u8_data_buf[0] = 0xFA;
//	rf_write_reg();	

//շݳ
	u8_spi_data = HS6220_BANK0_RX_PW_P0 + HS6220_W_REGISTER;
	u8_data_buf[0] = D_RF_DATA_NUM;
	rf_write_reg();	

//ͨ
	u8_spi_data = HS6220_BANK0_RF_CH + HS6220_W_REGISTER;
//	u8_data_buf[0] = D_RF_CHANNEL_L;
	u8_data_buf[0] = u8_rf_ch;
	rf_write_reg();	

//ʹRX PIPE
	u8_spi_data = HS6220_BANK0_EN_RXADDR + HS6220_W_REGISTER;
	u8_data_buf[0] = 0x01;
	rf_write_reg();	

//ʹԶش
	u8_spi_data = HS6220_BANK0_SETUP_RETR + HS6220_W_REGISTER;
	u8_data_buf[0] = 0;							//ֹԶش
//	u8_data_buf[0] = 43;						//1MSԶط3
	rf_write_reg();	

//ù
	u8_spi_data = HS6220_BANK0_RF_SETUP + HS6220_W_REGISTER;
	u8_data_buf[0] = 0x47;
	rf_write_reg();	
//ʹ̬ܶݰ PIPE
	u8_spi_data = HS6220_BANK0_DYNPD + HS6220_W_REGISTER;
	u8_data_buf[0] = 0x07;
	rf_write_reg();	
	
	rf_flush_tx();
	rf_flush_rx();
	rf_clear_irq();
}
//================================================================================
#if	D_HOP_ON
void rf_hop_channal(void)
{
	if(D_RF_CHANNEL_L == u8_rf_ch)
	{
		u8_rf_ch = D_RF_CHANNEL_M;
	}
	else if(D_RF_CHANNEL_M == u8_rf_ch)
	{
		u8_rf_ch = D_RF_CHANNEL_H;
	}
	else// if(D_RF_CHANNEL_H == u8_rf_ch)
	{
		u8_rf_ch = D_RF_CHANNEL_L;
	}
	
//	rf_ce_low();
	u8_spi_data = HS6220_BANK0_RF_CH + HS6220_W_REGISTER;
	u8_data_buf[0] = u8_rf_ch;
	rf_write_reg();
//	rf_ce_high();
}
#endif
//================================================================================
#if D_RF_TX
void rf_power_down(void)
{	// rf 
	//RF ˯ģʽ
	u8_spi_data = HS6220_BANK0_PMU_CTL + HS6220_W_REGISTER;
	u8_data_buf[0] = 0xAD;
	rf_write_reg();
	//ʱ1ms
	delay_ms(1);
	//rf µ(tx mode)
	u8_spi_data = HS6220_BANK0_CONFIG + HS6220_W_REGISTER;
	u8_data_buf[0] = 0xF8;
	rf_write_reg();
	//ʱ1ms
	delay_ms(1);
}
//--------------------------------------------------------------------------------
void rf_power_on(void)
{	// rf ϵ
	//rf ϵ(tx mode)
	u8_spi_data = HS6220_BANK0_CONFIG + HS6220_W_REGISTER;
	u8_data_buf[0] = 0xFA;
	rf_write_reg();
	//ʱ1ms
	delay_ms(1);
	//RF ģʽ
	u8_spi_data = HS6220_BANK0_PMU_CTL + HS6220_W_REGISTER;
	u8_data_buf[0] = 0xAC;
	rf_write_reg();
}
//--------------------------------------------------------------------------------
void rf_tx_send_data(void)
{	//RF TX 
	rf_ce_low();
	rf_flush_tx();
	rf_flush_rx();
	rf_clear_irq();
	
//дݵRF FIFO
	rf_csn_low();
//	u8_spi_data = HS6220_W_TX_PAYLOAD;
	u8_spi_data = HS6220_W_TX_PAYLOAD_NOACK;
	u8_data_num = D_RF_DATA_NUM;
	rf_write_reg();
	rf_csn_high();
	
//TX 	
	rf_ce_high();									//TX 
	.delay 100;										//(50US)巽ʽ
	rf_ce_low();
	delay_ms(1);									//ȴͽ	
}
#endif
//================================================================================
#if D_RF_RX
void rf_rx_receive(void)
{	//
	u8_spi_data = HS6220_BANK0_STATUS;
	rf_read_reg();
	if(b_rx_data)
	{	//rf յ
		u8_reset_int = 0;
		u8_sleep_int = 0;
			
		rf_ce_low();

#if D_HOP_ON
		rf_hop_channal();
#endif

		//ȡ RX ݳ
		u8_spi_data = HS6220_R_RX_PL_WID;
		rf_read_reg();
		if(D_RF_DATA_NUM == u8_spi_data)
		{	//ȡ
			//ȡ RX 
			u8_spi_data = HS6220_R_RX_PAYLOAD;
			u8_data_num = D_RF_DATA_NUM;
			rf_read_reg();
			b_rx_ok = 1;
		}
		
		//յݺ RX ״̬ FIFO, CE ȴһݵ
		rf_flush_tx();
		rf_flush_rx();
		rf_clear_irq();
		rf_ce_high();
	}
}
//--------------------------------------------------------------------------------
void rf_rx_prevent_crash(void)
{	//ն˷
	//40msûյ1ݣRF˯߻һ
	rf_ce_low();
	rf_flush_rx();
	rf_clear_irq();

	u8_spi_data = HS6220_BANK0_PMU_CTL + HS6220_W_REGISTER;
	u8_data_buf[0] = 0xAE;
	rf_write_reg();
	delay_ms(1);										//ʱ1MS(ʱ1MS)
	u8_spi_data = HS6220_BANK0_PMU_CTL + HS6220_W_REGISTER;
	u8_data_buf[0] = 0xAC;
	rf_write_reg();
	delay_ms(1);										//ʱ1MS(ʱ1MS)
	
	rf_ce_high();
}
#endif
//================================================================================