       LIST

;==========================================================================
; Build date : Nov 08 2022
;  HCIDE BL08P122 processor include
; 
;  (c) Copyright 2012-2022 boling Technology, All rights reserved
;==========================================================================

        NOLIST

;==========================================================================
;  This header file defines configurations, registers, and other useful
;  bits of information for the BL08P122 microcontroller.  These names
;  are taken to match the data sheets as closely as possible.
;
;  Note that the processor must be selected before this file is included.
;  The processor may be selected the following ways:
;
;       1. Command line switch:
;       2. LIST directive in the source file
;               LIST   P=BL08P122
;       3. Processor Type entry in the BLIDE full-screen interface
;       4. Setting the processor in the BLIDE Project Dialog
;==========================================================================

;==========================================================================
;
;       Verify Processor
;
;==========================================================================
        IFNDEF __BL08P122
           MESSG "Processor-header file mismatch.  Verify selected processor."
        ENDIF



;==========================================================================
;
;       Register Definitions
;
;==========================================================================

W                EQU  H'0000'
F                EQU  H'0001'

;----- Register Files -----------------------------------------------------

;-----Bank0------------------
INDF            EQU     H'0000'
T0              EQU     H'0001'
PCL             EQU     H'0002'
STATUS			EQU     H'0003'
FSR             EQU     H'0004'


PORTA			EQU		H'0005'
PORTB			EQU		H'0006'
IOCA			EQU		H'0007'
IOCB			EQU		H'0009'
PCLATH			EQU		H'000A'
PDCON			EQU		H'000B'
PHCON			EQU		H'000D'
INTECON			EQU		H'000E'
PIR				EQU		H'000F'
OPTION			EQU		H'0041'
PDCON1			EQU		H'0042'
PHCON1			EQU		H'0043'
TRISA			EQU		H'0045'
TRISB			EQU		H'0046'
T1CR_AUXR		EQU		H'004B'
T1CON			EQU		H'004C'
T1				EQU		H'004D'
T1LOAD			EQU		H'004E'
PWM0P			EQU		H'004F'
T2CON			EQU		H'0050'
TMR2H			EQU		H'0051'
T2				EQU		H'0052'
T2LOAD			EQU		H'0053'
PWM1P			EQU		H'0054'
PWMSET			EQU		H'0055'
ANSELL			EQU		H'0056'
ANSELH			EQU		H'0057'
ADRESL			EQU		H'0058'
ADRESH			EQU		H'0059'
ADCON0			EQU		H'005A'
ADCON1			EQU		H'005B'





;----- STATUS Bits --------------------------------------------------------
RST                    	EQU     H'0007'
RP0                     EQU     H'0005' 
TO                      EQU     H'0004'
PD                      EQU     H'0003'
Z                       EQU     H'0002'
DC                      EQU     H'0001'
C                       EQU     H'0000'

;----- INTECON Bits --------------------------------------------------------
GIE                     EQU     H'0007'
INT0F                   EQU     H'0005'
PBIF                    EQU     H'0004'
T0IF                    EQU     H'0003'
INT0E                   EQU     H'0002'
PBIE                    EQU     H'0001'
T0IE                    EQU     H'0000'

;----- PORTA Bits ----------------------------------------------------------
PORTA7                  EQU     H'0007'
PORTA6                  EQU     H'0006'
PORTA4                  EQU     H'0004'
PORTA3                  EQU     H'0003'
PORTA2                  EQU     H'0002'
PORTA1                  EQU     H'0001'
PORTA0                  EQU     H'0000'

;----- PORTB Bits ----------------------------------------------------------
PORTB7                  EQU     H'0007'
PORTB6                  EQU     H'0006'
PORTB5                  EQU     H'0005'
PORTB3                  EQU     H'0003'
PORTB2                  EQU     H'0002'
PORTB1                  EQU     H'0001'
PORTB0                  EQU     H'0000'

;----- IOCA Bits ----------------------------------------------------------
IOCA7	                EQU     H'0007'
IOCA6	                EQU     H'0006'
IOCA4	                EQU     H'0004'
IOCA3                	EQU     H'0003'
IOCA2	                EQU     H'0002'
IOCA1	                EQU     H'0001'
IOCA0	                EQU     H'0000'

;----- IOCB Bits ----------------------------------------------------------
IOCB7	                EQU     H'0007'
IOCB6	                EQU     H'0006'
IOCB5	                EQU     H'0005'
IOCB3                	EQU     H'0003'
IOCB2	                EQU     H'0002'
IOCB1	                EQU     H'0001'
IOCB0	                EQU     H'0000'

;----- PDCON Bits ----------------------------------------------------------
PDB7                    EQU     H'0007'
PDB6                    EQU     H'0006'
PDB5                    EQU     H'0005'
PDB3                    EQU     H'0003'                    
PDB2                    EQU     H'0002'
PDB1                    EQU     H'0001'
PDB0                    EQU     H'0000'

;----- PHCON Bits ----------------------------------------------------------
PHB7                   EQU     H'0007'   
PHB6                   EQU     H'0006'    
PHB5                   EQU     H'0005'   
PHB3                   EQU     H'0003'  
PHB2                   EQU     H'0002'  
PHB1                   EQU     H'0001'  
PHB0                   EQU     H'0000' 

;----- PIR Bits --------------------------------------------------------
INT1EDG                  EQU     H'0006'
INT1E                    EQU     H'0005'
INT1F                    EQU     H'0004'
ADIE                     EQU     H'0003'
ADIF                     EQU     H'0002'
PAIE                     EQU     H'0001'
PAIF                     EQU     H'0000'  

;----- OPTION Bits --------------------------------------------------------
WDTEN                   EQU     H'0007'
INT0EDG                  EQU     H'0006'
T0CS                    EQU     H'0005'
T0SE                    EQU     H'0004'
PSA                     EQU     H'0003'
PS2                     EQU     H'0002'
PS1                     EQU     H'0001'
PS0                     EQU     H'0000'  

;----- PDCON1 Bits ----------------------------------------------------------
PDA7                   EQU     H'0007'   
PDA6                   EQU     H'0006'    
PDA4                   EQU     H'0004'   
PDA3                   EQU     H'0003'  
PDA2                   EQU     H'0002'  
PDA1                   EQU     H'0001'  
PDA0                   EQU     H'0000'

;----- PHCON1 Bits ----------------------------------------------------------
PHA7                   EQU     H'0007'   
PHA6                   EQU     H'0006'    
PHA4                   EQU     H'0004'   
PHA3                   EQU     H'0003'  
PHA2                   EQU     H'0002'  
PHA1                   EQU     H'0001'  
PHA0                   EQU     H'0000'

;----- TRISA Bits ----------------------------------------------------------
TRISA7                  EQU     H'0007'
TRISA6                  EQU     H'0006'
TRISA4                  EQU     H'0004'
TRISA3                  EQU     H'0003'
TRISA2                  EQU     H'0002'
TRISA1                  EQU     H'0001'
TRISA0                  EQU     H'0000'

;----- TRISB Bits ----------------------------------------------------------
TRISB7                  EQU     H'0007'
TRISB6                  EQU     H'0006'
TRISB5                  EQU     H'0005'
TRISB3                  EQU     H'0003'
TRISB2                  EQU     H'0002'
TRISB1                  EQU     H'0001'
TRISB0                  EQU     H'0000'

;----- T1CR_AUXR Bits ----------------------------------------------------------
T0CK					EQU     H'0007'
T2IE                    EQU     H'0006'
T2IF                    EQU     H'0005'
POR                     EQU     H'0004'
BOR                     EQU     H'0003'
BOREN                   EQU     H'0002'
T1IE                    EQU     H'0001'
T1IF                    EQU     H'0000'

;----- T1CON Bits ----------------------------------------------------------
T1EN                    EQU     H'0007'
PWM0E                   EQU     H'0006'
T0OSCEN                 EQU     H'0005'
T1CK1                   EQU     H'0004'
T1CK0                   EQU     H'0003'
T1PR2                   EQU     H'0002'
T1PR1                   EQU     H'0001'
T1PR0                   EQU     H'0000'

;----- T2CON Bits ----------------------------------------------------------
T2EN                    EQU     H'0007'
PWM1E                   EQU     H'0006'
SCS						EQU     H'0005'
T2CK1                   EQU     H'0004'
T2CK0                   EQU     H'0003'
T2PR2                   EQU     H'0002'
T2PR1                   EQU     H'0001'
T2PR0                   EQU     H'0000'

;----- TMR2H Bits ----------------------------------------------------------
PWMS1                    EQU     H'0007'
PWMS0                    EQU     H'0006'
TIMER2_9				 EQU     H'0005'
TIMER2_8                 EQU     H'0004'
T2LOAD_9                 EQU     H'0003'
T2LOAD_8                 EQU     H'0002'
PWM1_9                   EQU     H'0001'
PWM1_8                   EQU     H'0000'

;----- PWMSET Bits ----------------------------------------------------------
PWMM                    EQU     H'0000'

;----- ANSELL Bits ----------------------------------------------------------
ANSEL7                    EQU     H'0007'
ANSEL6				      EQU     H'0006'
ANSEL4                    EQU     H'0004'
ANSEL3                    EQU     H'0003'
ANSEL2                    EQU     H'0002'
ANSEL1                    EQU     H'0001'
ANSEL0                    EQU     H'0000'

;----- ANSELH Bits ----------------------------------------------------------
ANSEL15                   EQU     H'0007'
ANSEL14				      EQU     H'0006'
ANSEL11                   EQU     H'0003'
ANSEL10                   EQU     H'0002'
ANSEL9                    EQU     H'0001'
ANSEL8                    EQU     H'0000'

;----- ADCON0 Bits ----------------------------------------------------------
CHS3                      EQU     H'0005'
CHS2				      EQU     H'0004'
CHS1                      EQU     H'0003'
CHS0                      EQU     H'0002'
ADON                      EQU     H'0001'
ADEN                      EQU     H'0000'

;----- ADCON1 Bits ----------------------------------------------------------
ADCS2                      EQU     H'0006'
ADCS1                      EQU     H'0005'
ADCS0				       EQU     H'0004'
VHS2                       EQU     H'0003'
VHS1                       EQU     H'0002'
VHS0                       EQU     H'0001'
ADREF                      EQU     H'0000'

;==========================================================================
;
;       RAM Definitions
;
;==========================================================================
       __MAXRAM  H'005b'
      
       __BADRAM  H'0040' 
       __BADRAM  H'0042'-H'0044'
       
       

     
;==========================================================================
;
;       Configuration Bits
;
;   NAME            Address
;   CONFIG            2000h
;
;==========================================================================

; The following is an assignment of address values for all of the
; configuration registers for the purpose of table reads
_CONFIG          EQU  H'2000'



;----- CONFIG Options --------------------------------------------------
_FOSC_LP             EQU  H'3CFF'    ; LP oscillator: Low-power crystal on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN
_LP_OSC              EQU  H'3CFF'    ; LP oscillator: Low-power crystal on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN
_FOSC_XT             EQU  H'3DFF'    ; XT oscillator: Crystal/resonator on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN
_XT_OSC              EQU  H'3DFF'    ; XT oscillator: Crystal/resonator on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN
_FOSC_HS             EQU  H'3FFD'    ; HS oscillator: High-speed crystal/resonator on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN
_HS_OSC              EQU  H'3FFD'    ; HS oscillator: High-speed crystal/resonator on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN
;_FOSC_EC             EQU  H'3FFD'    ; EC: I/O function on RA4/OSC2/CLKOUT pin, CLKIN on RA5/OSC1/CLKIN
;_EC_OSC              EQU  H'3FFB'    ; EC: I/O function on RA4/OSC2/CLKOUT pin, CLKIN on RA5/OSC1/CLKIN
_FOSC_INTRCIO        EQU  H'3FFC'    ; INTOSCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN
_INTRC_OSC_NOCLKOUT  EQU  H'3FFC'    ; INTOSCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN
_INTOSCIO            EQU  H'3FFC'    ; INTOSCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN
;_FOSC_INTRCCLK       EQU  H'3FFD'    ; INTOSC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN
;_INTRC_OSC_CLKOUT    EQU  H'3FFD'    ; INTOSC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN
;_INTOSC              EQU  H'3FFD'    ; INTOSC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN
;_FOSC_EXTRCIO        EQU  H'3FFE'    ; RCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, RC on RA5/OSC1/CLKIN
;_EXTRC_OSC_NOCLKOUT  EQU  H'3FFE'    ; RCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, RC on RA5/OSC1/CLKIN
;_EXTRCIO             EQU  H'3FFE'    ; RCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, RC on RA5/OSC1/CLKIN
;_FOSC_EXTRCCLK       EQU  H'3FFF'    ; RC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, RC on RA5/OSC1/CLKIN
;_EXTRC_OSC_CLKOUT    EQU  H'3FFF'    ; RC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, RC on RA5/OSC1/CLKIN
;_EXTRC               EQU  H'3FFF'    ; RC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, RC on RA5/OSC1/CLKIN

_WDTE_OFF            EQU  H'3FFB'    ; WDT disabled and can be enabled by SWDTEN bit of the WDTCON register
_WDT_OFF             EQU  H'3FFB'    ; WDT disabled and can be enabled by SWDTEN bit of the WDTCON register
_WDTE_ON             EQU  H'3FFF'    ; WDT enabled
_WDT_ON              EQU  H'3FFF'    ; WDT enabled

;_PWRTE_ON            EQU  H'3FEF'    ; PWRT enabled
;_PWRTE_OFF           EQU  H'3FFF'    ; PWRT disabled

;_MCLRE_OFF           EQU  H'3FDF'    ; MCLR pin function is digital input, MCLR internally tied to VDD
;_MCLRE_ON            EQU  H'3FFF'    ; MCLR pin function is MCLR

_CP_ON               EQU  H'3FEF'    ; Program memory code protection is enabled
_CP_OFF              EQU  H'3FFF'    ; Program memory code protection is disabled

;_CPD_ON              EQU  H'3F7F'    ; Data memory code protection is enabled
;_CPD_OFF             EQU  H'3FFF'    ; Data memory code protection is disabled

;_BOREN_OFF           EQU  H'3CFF'    ; BOR disabled
;_BOD_OFF             EQU  H'3CFF'    ; BOR disabled
;_BOR_OFF             EQU  H'3CFF'    ; BOR disabled
;_BOREN_SBODEN        EQU  H'3DFF'    ; BOR controlled by SBOREN bit of the PCON register
;_BOD_SBODEN          EQU  H'3DFF'    ; BOR controlled by SBOREN bit of the PCON register
;_BOR_SBODEN          EQU  H'3DFF'    ; BOR controlled by SBOREN bit of the PCON register
;_BOREN_NSLEEP        EQU  H'3EFF'    ; BOR enabled during operation and disabled in Sleep
;_BOD_NSLEEP          EQU  H'3EFF'    ; BOR enabled during operation and disabled in Sleep
;_BOR_NSLEEP          EQU  H'3EFF'    ; BOR enabled during operation and disabled in Sleep
;_BOREN_ON            EQU  H'3FFF'    ; BOR enabled
;_BOD_ON              EQU  H'3FFF'    ; BOR enabled
;_BOR_ON              EQU  H'3FFF'    ; BOR enabled

;_IESO_OFF            EQU  H'3BFF'    ; Internal External Switchover mode is disabled
;_IESO_ON             EQU  H'3FFF'    ; Internal External Switchover mode is enabled

;_FCMEN_OFF           EQU  H'37FF'    ; Fail-Safe Clock Monitor is disabled
;_FCMEN_ON            EQU  H'3FFF'    ; Fail-Safe Clock Monitor is enabled

;----- DEVID Equates --------------------------------------------------
;_DEVID1          EQU  H'2006'

;----- IDLOC Equates --------------------------------------------------
;_IDLOC0          EQU  H'2000'
;_IDLOC1          EQU  H'2001'
;_IDLOC2          EQU  H'2002'
;_IDLOC3          EQU  H'2003'

       
        LIST